function controlBuildMenus() {
	%resx = getWord($pref::Video::resolution, 0);
	if (%resx == "640") {
		$controlpos = "20 255";
	}
	else if (%resx == "800") {
		$controlpos = "20 375";
	}
	else if (%resx == "1024") {
		$controlpos = "20 543";
	}
	else if (%resx == "1280") {
		$controlpos = "20 799";
	}
	else if (%resx == "1600") {
		$controlpos = "20 975";
	}
 
    $TKBMenuCount = 13;
    $TKBMenuText[0] = "TKBPractice Mod:\nB: Beacons\nR: Repair\nF: Return Flags\n\nA: Admin";
    $TKBMenuText[1] = "Beacon Options Menu:\nT: Teleport\nV: Vehicle";
    $TKBMenuText[2] = "Teleport To Menu:\n1: Beacon 1\n2: Beacon 2\n3: Beacon 3\n4: Beacon 4\n5: Beacon 5\n6: Beacon 6\n7: Beacon 7\n8: Beacon 8\n9: Beacon 9\n0: Beacon 10";
    $TKBMenuText[3] = "Select A Vehicle Menu:\nG: Gravcycle\nS: Shrike\nT: Tank\nB: Bomber\nH: Havok\nM: Mobile Base";
    $TKBMenuText[4] = "Spawn At Beacon Menu:\n1: Beacon 1\n2: Beacon 2\n3: Beacon 3\n4: Beacon 4\n5: Beacon 5\n6: Beacon 6\n7: Beacon 7\n8: Beacon 8\n9: Beacon 9\n0: Beacon 10";
    $TKBMenuText[5] = "Repair Menu:\nB: Base\nT: Turrets\nR: Remote Equipment\nE: Everything";
    $TKBMenuText[6] = "Select Team Menu:\n1: Your team\n2: Enemy Team";
    $TKBMenuText[7] = "Admin Menu:\nM: Mortar Cam\nE: Equipment Files\nB: Beacon Toggle";
    $TKBMenuText[8] = "Mortar Cam Menu:\n1: On\n2: Off";
    $TKBMenuText[9] = "Equipment Files Menu\n1: Load File...\n2: Save File...";
    $TKBMenuText[10] = "Load File Menu:\n1: File 1\n2: File 2\n3: File 3\n4: File 4\n5: File 5";
    $TKBMenuText[11] = "Save File Menu:\n1: File 1\n2: File 2\n3: File 3\n4: File 4\n5: File 5";
    $TKBMenuText[12] = "Beacon Features:\n1: On\n2: Off";
    
    for(%x = 0; %x < $TKBMenuCount; %x++)
    {
           $TKBMenuGroup[%x] = new ShellFieldCtrl() {
			        profile = "GuiChatBackProfile";
			        horizSizing = "left";
			        vertSizing = "top";
			        position = $controlpos;
			        extent = "100 175";
			        minExtent = "2 2";
			        visible = "0";
			        schedule = "";
           };
           
           playgui.add($TKBMenuGroup[%x]);
           
           $TKBMenuGroup[%x].text =  new GuiMLTextCtrl() {
			        profile = "GuiTextObjHudCenterProfile";
			        horizSizing = "center";
			        vertSizing = "center";
			        position = "0 0";
			        extent = "100 175";
			        visible = "1";
           };
           
           $TKBMenuGroup[%x].add($TKBMenuGroup[%x].text);
           
           $TKBMenuGroup[%x].text.setValue($TKBMenuText[%x]);
    }
}

// default this to 1
$controlLastBeacon = 1;
// default this to shrike
$controlVehicleSelected = scoutFlyer;
// default to friendly's team
$controlSelectedTeam = 1;

function controlSetBinds() {

    for(%x = 0; %x < $TKBMenuCount; %x++)
    {
       new actionMap(controlaction @ %x);
       $TKBBinds[%x] = controlaction @ %x;
    }
    
    // Main menu
    $TKBBinds[0].bindCmd(keyboard, "escape", "controlCloseMenus();", "");
    $TKBBinds[0].bindCmd(keyboard, "b", "controlOpenMenu(1);", ""); // beacon menu
    $TKBBinds[0].bindCmd(keyboard, "r", "controlOpenMenu(6);", ""); // select a team menu
    $TKBBinds[0].bindCmd(keyboard, "a", "controlOpenMenu(7);", ""); // admin menu
    $TKBBinds[0].bindCmd(keyboard, "f", "ReturnFlags(3);", "");
    $TKBBinds[0].bindCmd(keyboard, "anykey", "controlCloseMenus();", "");

    // Beacon menu
    $TKBBinds[1].bindCmd(keyboard, "escape", "controlCloseMenus();", "");
    $TKBBinds[1].bindCmd(keyboard, "t", "controlOpenMenu(2);", ""); // teleport menu
	$TKBBinds[1].bindCmd(keyboard, "v", "controlOpenMenu(3);", ""); // vehicle menu
    $TKBBinds[1].bindCmd(keyboard, "anykey", "controlCloseMenus();", "");

    // Teleport to beacon menu
    $TKBBinds[2].bindCmd(keyboard, "escape", "controlCloseMenus();", "");
    $TKBBinds[2].bindCmd(keyboard, "1", "TeleportToBeacon(1);", "");
    $TKBBinds[2].bindCmd(keyboard, "2", "TeleportToBeacon(2);", "");
    $TKBBinds[2].bindCmd(keyboard, "3", "TeleportToBeacon(3);", "");
    $TKBBinds[2].bindCmd(keyboard, "4", "TeleportToBeacon(4);", "");
    $TKBBinds[2].bindCmd(keyboard, "5", "TeleportToBeacon(5);", "");
    $TKBBinds[2].bindCmd(keyboard, "6", "TeleportToBeacon(6);", "");
    $TKBBinds[2].bindCmd(keyboard, "7", "TeleportToBeacon(7);", "");
    $TKBBinds[2].bindCmd(keyboard, "8", "TeleportToBeacon(8);", "");
    $TKBBinds[2].bindCmd(keyboard, "9", "TeleportToBeacon(9);", "");
    $TKBBinds[2].bindCmd(keyboard, "0", "TeleportToBeacon(10);", "");
    $TKBBinds[2].bindCmd(keyboard, "space", "TeleportToBeacon($controlLastBeacon);", "");
    $TKBBinds[2].bindCmd(keyboard, "anykey", "controlCloseMenus();", "");
    
    // Select a vehicle menu
    $TKBBinds[3].bindCmd(keyboard, "escape", "controlCloseMenus();", "");
    $TKBBinds[3].bindCmd(keyboard, "g", "controlOpenNumberMenu(scoutVehicle);", ""); // vehicle beacon teleport
    $TKBBinds[3].bindCmd(keyboard, "s", "controlOpenNumberMenu(scoutFlyer);", ""); // vehicle beacon teleport
    $TKBBinds[3].bindCmd(keyboard, "t", "controlOpenNumberMenu(assaultVehicle);", ""); // vehicle beacon teleport
    $TKBBinds[3].bindCmd(keyboard, "b", "controlOpenNumberMenu(bomberFlyer);", ""); // vehicle beacon teleport
    $TKBBinds[3].bindCmd(keyboard, "h", "controlOpenNumberMenu(HAPCFlyer);", ""); // vehicle beacon teleport
    $TKBBinds[3].bindCmd(keyboard, "m", "controlOpenNumberMenu(mobilebaseVehicle);", ""); // vehicle beacon teleport
    $TKBBinds[3].bindCmd(keyboard, "anykey", "controlCloseMenus();", "");

    // Spawn vehicle at beacon menu
    $TKBBinds[4].bindCmd(keyboard, "escape", "controlCloseMenus();", "");
    $TKBBinds[4].bindCmd(keyboard, "1", "SpawnVehicleAtBeacon(1, $controlVehicleSelected);", "");
    $TKBBinds[4].bindCmd(keyboard, "2", "SpawnVehicleAtBeacon(2, $controlVehicleSelected);", "");
    $TKBBinds[4].bindCmd(keyboard, "3", "SpawnVehicleAtBeacon(3, $controlVehicleSelected);", "");
    $TKBBinds[4].bindCmd(keyboard, "4", "SpawnVehicleAtBeacon(4, $controlVehicleSelected);", "");
    $TKBBinds[4].bindCmd(keyboard, "5", "SpawnVehicleAtBeacon(5, $controlVehicleSelected);", "");
    $TKBBinds[4].bindCmd(keyboard, "6", "SpawnVehicleAtBeacon(6, $controlVehicleSelected);", "");
    $TKBBinds[4].bindCmd(keyboard, "7", "SpawnVehicleAtBeacon(7, $controlVehicleSelected);", "");
    $TKBBinds[4].bindCmd(keyboard, "8", "SpawnVehicleAtBeacon(8, $controlVehicleSelected);", "");
    $TKBBinds[4].bindCmd(keyboard, "9", "SpawnVehicleAtBeacon(9, $controlVehicleSelected);", "");
    $TKBBinds[4].bindCmd(keyboard, "0", "SpawnVehicleAtBeacon(10, $controlVehicleSelected);", "");
    $TKBBinds[4].bindCmd(keyboard, "space", "SpawnVehicleAtBeacon($controlLastBeacon, $controlVehicleSelected);", "");
    $TKBBinds[4].bindCmd(keyboard, "anykey", "controlCloseMenus();", "");
    
    // Repair menu
    $TKBBinds[5].bindCmd(keyboard, "escape", "controlCloseMenus();", "");
    $TKBBinds[5].bindCmd(keyboard, "b", "RepairBase();", "");
    $TKBBinds[5].bindCmd(keyboard, "t", "RepairTurrets();", "");
    $TKBBinds[5].bindCmd(keyboard, "r", "RepairRemoteEquipment();", "");
    $TKBBinds[5].bindCmd(keyboard, "e", "RepairEverything();", "");
    $TKBBinds[5].bindCmd(keyboard, "anykey", "controlCloseMenus();", "");
    
    // Select team menu
    $TKBBinds[6].bindCmd(keyboard, "escape", "controlCloseMenus();", "");
    $TKBBinds[6].bindCmd(keyboard, "1", "controlOpenRepairMenu(1);", ""); // repair menu
    $TKBBinds[6].bindCmd(keyboard, "2", "controlOpenRepairMenu(2);", ""); // repair menu
    $TKBBinds[6].bindCmd(keyboard, "anykey", "controlCloseMenus();", "");
    
    // Admin menu
    $TKBBinds[7].bindCmd(keyboard, "escape", "controlCloseMenus();", "");
    $TKBBinds[7].bindCmd(keyboard, "m", "controlOpenMenu(8);", ""); // mortar cam menu
    $TKBBinds[7].bindCmd(keyboard, "e", "controlOpenMenu(9);", ""); // equipment menu
    $TKBBinds[7].bindCmd(keyboard, "b", "controlOpenMenu(12);", ""); // beacon toggle menu
    $TKBBinds[7].bindCmd(keyboard, "anykey", "controlCloseMenus();", "");
    
    // Mortar cam menu
    $TKBBinds[8].bindCmd(keyboard, "escape", "controlCloseMenus();", "");
    $TKBBinds[8].bindCmd(keyboard, "1", "MortarCam(true);", "");
    $TKBBinds[8].bindCmd(keyboard, "2", "MortarCam(false);", "");
    $TKBBinds[8].bindCmd(keyboard, "anykey", "controlCloseMenus();", "");
    
    // Equipment file menu
    $TKBBinds[9].bindCmd(keyboard, "escape", "controlCloseMenus();", "");
    $TKBBinds[9].bindCmd(keyboard, "1", "controlOpenMenu(10);", ""); // load equipment file menu
    $TKBBinds[9].bindCmd(keyboard, "2", "controlOpenMenu(11);", ""); // save equipment file menu
    $TKBBinds[9].bindCmd(keyboard, "anykey", "controlCloseMenus();", "");
    
    // Load file menu
    $TKBBinds[10].bindCmd(keyboard, "escape", "controlCloseMenus();", "");
    $TKBBinds[10].bindCmd(keyboard, "1", "LoadEquipment(1);", "");
    $TKBBinds[10].bindCmd(keyboard, "2", "LoadEquipment(2);", "");
    $TKBBinds[10].bindCmd(keyboard, "3", "LoadEquipment(3);", "");
    $TKBBinds[10].bindCmd(keyboard, "4", "LoadEquipment(4);", "");
    $TKBBinds[10].bindCmd(keyboard, "5", "LoadEquipment(5);", "");
    $TKBBinds[10].bindCmd(keyboard, "anykey", "controlCloseMenus();", "");
    
    // Save file menu
    $TKBBinds[11].bindCmd(keyboard, "escape", "controlCloseMenus();", "");
    $TKBBinds[11].bindCmd(keyboard, "1", "SaveEquipment(1);", "");
    $TKBBinds[11].bindCmd(keyboard, "2", "SaveEquipment(2);", "");
    $TKBBinds[11].bindCmd(keyboard, "3", "SaveEquipment(3);", "");
    $TKBBinds[11].bindCmd(keyboard, "4", "SaveEquipment(4);", "");
    $TKBBinds[11].bindCmd(keyboard, "5", "SaveEquipment(5);", "");
    $TKBBinds[11].bindCmd(keyboard, "anykey", "controlCloseMenus();", "");
    
    // Beacon feature menu
    $TKBBinds[12].bindCmd(keyboard, "escape", "controlCloseMenus();", "");
    $TKBBinds[12].bindCmd(keyboard, "1", "BeaconToggle(true);", "");
    $TKBBinds[12].bindCmd(keyboard, "2", "BeaconToggle(false);", "");
    $TKBBinds[12].bindCmd(keyboard, "anykey", "controlCloseMenus();", "");
}

function controlOpenMainMenu()
{
    controlOpenMenu(0);
}

function controlOpenMenu(%val) {
	controlCloseMenus();
	$TKBMenuGroup[%val].setVisible("1");
	$TKBBinds[%val].push();
}

function controlOpenNumberMenu(%blockName) {
    // save it for later use
    $controlVehicleSelected = %blockName;
	controlCloseMenus();
	$TKBMenuGroup[4].setVisible("1");
	$TKBBinds[4].push();
}

function controlOpenRepairMenu(%team) {
    // save it for later use
    $controlSelectedTeam = %team;
	controlCloseMenus();
	$TKBMenuGroup[5].setVisible("1");
	$TKBBinds[5].push();
}

function controlCloseMenus() {
    for(%x = 0; %x < $TKBMenuCount; %x++)
    {
	   $TKBMenuGroup[%x].setVisible("0");
       $TKBBinds[%x].pop();
    }
}

function controlSetHudPosition() {
    for(%x = 0; %x < $TKBMenuCount; %x++)
    {
	   $TKBMenuGroup[%x].position = $controlpos;
    }
}

package controlBind {
	function OptionsDlg::onWake( %this ) {
		if (!$controlBind) {
			$RemapName[$RemapCount] = "TKBPractice Mod";
			$RemapCmd[$RemapCount] = "controlOpenMainMenu";
			$RemapCount++;
			$controlBind = true;
		}
		parent::onWake( %this );
	}

	function PlayGui::onWake(%this) {
		parent::onWake(%this);
		controlBuildMenus();
		controlSetBinds();
		schedule(2000, 0, controlSetHudPosition);
	}
};

activatePackage(controlBind);

// NEW CODE - LETHAL_E
function TeleportToBeacon(%beacon)
{
   // Teleports client to position marked by %beacon
   CommandToServer('TeleportToBeacon', %beacon);
   controlCloseMenus();
}

function SpawnVehicleAtBeacon(%beacon, %blockName)
{
   // Spawns a vehicle at the beacon
   // scoutFlyer = Shrike
   // ScoutVehicle = grav cycle
   // AssaultVehicle = tank
   // BomberFlyer = bomber
   // HAPCFlyer = transport
   // MobileBaseVehicle = mobile base
   $controlLastBeacon = %beacon;
   CommandToServer('SpawnVehicleAtBeacon', %beacon, %blockName);
   controlCloseMenus();
}

function RepairBase()
{
         // Sends command to repair base
         CommandToServer('RepairBase', $controlSelectedTeam);
         controlCloseMenus();
}

function RepairTurrets()
{
         // sends command to repair turrets
         CommandToServer('RepairTurrets', $controlSelectedTeam);
         controlCloseMenus();
}

function RepairRemoteEquipment()
{
         // sends command to repair remotes
         CommandToServer('RepairRemoteEquipment', $controlSelectedTeam);
         controlCloseMenus();
}

function RepairEverything()
{
         // sends commands to repair everything
         CommandToServer('RepairBase', $controlSelectedTeam);
         CommandToServer('RepairTurrets', $controlSelectedTeam);
         CommandToServer('RepairRemoteEquipment', $controlSelectedTeam);
         controlCloseMenus();
}

function clientcmdValidateScript()
{
         // sends command *back* to server
         // telling it that we do infact have the
         // script installed
         echo("Got validation attempt... responding...");
         CommandToServer('ValidateScript');
}

function MortarCam(%val)
{
         // if player has super-admin he can change the mortar
         // cam settings
         CommandToServer('MortarCam', %val);
         controlCloseMenus();
}

function LoadEquipment(%num)
{
         // loads all deployed objects from a script file
         CommandToServer('LoadEquipment', %num);
         controlCloseMenus();
}

function SaveEquipment(%num)
{
         // saves all deployed objects into a script file
         CommandToServer('SaveEquipment', %num);
         controlCloseMenus();
}

function ReturnFlags(%num)
{
         // returns flags to starting positions
         // %num == 3 means that the menu key was pressed to return *all* flags
         if(%num == 3)
         {
                 CommandToServer('ReturnFlags', 1);
                 CommandToServer('ReturnFlags', 2);
                 controlCloseMenus();
         }
         else
             CommandToServer('ReturnFlags', %num);
}

function BeaconToggle(%val)
{
         // turns the beacon features on/off
         CommandToServer('BeaconToggle', %val);
         controlCloseMenus();
}
