//QFireMIssions
//{NQP!}Qing
//netquickposse.com/
//Build 25 - released 11/3/02

//props to Lethal_E for the mortarcam idea


//INDEX
//# DEFINITIONS
//# INITIALIZATION
//# ON CALLBACK
//# ON KEY
//# UTILITY FUNCTIONS
//# GUI FUNCTIONS
//# CORE FUNCTIONS
//# PACKAGES
//# GUI DEFINITIONS
//# DATABLOCK DEFINITIONS
//# FINALIZATION

//Schedule of Variables
//$fmBuildVersion : 			current vers
//$fmFlightTime : 			-1 = initial, increments as mortar flies
//$fmTeam[1 or 2] : 			tourney mode team names
//$fmGroup[%weaptype] : 	Is this still used? looks like it...
//$fmWeapText[%weaptype] :	text
//$fmVisibleDistance : 		custom setting, when setting high vis, determines vis range
//$fmAudible:					toggle, audible clock ticker
//$fmAudSched : 				the scheduler
//$fmPrintText : 				response message when obj is destroyed
//$fmProjectileCam : 		toggle, ProjectileCam
//$fmDestroyTime : 			simtime from last ondestroy msg
//$fmOldPrintTxt : 			prev obj ondestroy txt
//$Zoomon : 					base var, zoom active/not
//$QAutoPointing : 			autopoints-qedit.cs toggle, inverse of $fmActive
//$fmActive: 					fm toggle
//$MissionName : 				map file namebase
//$fmClient : 					the host client
//$fmClientTeam : 			the host client team
//$fmFileSearch : 			current fm datafile search path prefs/fm/map/team/weap/etc
//$fmIsHost : 				client is hosting server, can access server & client functions
//$fmFireMissionCounter : 	# of current fm's on display
//$fmFirePosName : 			name of current firepos, blank if none
//$fmFontColor : 				color for bottomprinting
//$fmFirePosId : 				object id of current firepos
//$fmFireMissionTarget[#]:	array, target id
//$fmFireMissionID : 		waypoint id
//$fmFireMissionName : 		waypoint name
//$fmToBeDeleted[#] : 		array, existing fm waypoints just b4 deleting them
//$fmShowElev : 				toggle, data hud
//$fmHudFadeOut : 			alpha value of hud text as fading out, 255 -> 0
//$fmHudFontAlpha : 			^ as written to hud, adjusted
//$fmDblBeac :		 			alt target display is enabled
//$fmGuiFireMissionTime : 	travel time for last fired mortar
//$fmVectorPoint : 			3d location along eye vector, at x range, for next waypoint creation
//$fmTrajectory : 			hi/lo
//$fmGuiFireMissionName : 	'smart' name, inserted into fmname gui before user accepts or changes it
//$fmMarkerWaypoint[x] : 	array, bullseye 'triangle' hud marker
//$fmMarkerWaypointCounter	index of ^
//$fmAidArray : 				array, bullseye objects
//$fmAidCounter : 			index of ^
//$QSettingAll : 				???
//$fmFireMissionFileData[x]:	array, lines read from data file
//$fireMissionName[x] : 	temp data read from file
//$firePosition : 			temp data read from file
//$FirePosName : 				temp data read from file
//$FireMissionTarget[x] : 	temp data read from file
//$fmNewTargetRange : 		range as entered into the gui
//$fmLastHit : 				object type of last shot target hit
//$fmDistance : 				distance fired from last shot
//$fmInstalled : 				script has been loaded
//$fmDelDsoFile[x] : 		temp array of blank data files, before deleting them
//$fmDelDsoFileCounter : 	count of blank data files before deleting them
//$fmTanker:					0/1 player is controlling a tank gun?

//Schedule of Objects & Classes
//fmdestroySound : 			audio profile for destroyed object feedback
//fmVisualAid : 				bullseye
//fmFireMissions : 			read/write file obj
//Cleanup : 					read/write file obj
//MortarMarker : 				static mortar object



///////////////
//# DEFINITIONS

$fmBuildVersion = 24;
$fmFlightTime = -1;
$fmhudFadeOut = 0;
$fmTeam1 = "Storm";
$fmTeam2 = "Inferno";
$fmGroup[Mortar] = 1;
$fmGroup[GrenadeLauncher] = 1;
$fmGroup[DirectFire] = 1;
$fmWeapText[Mortar] = "MORTAR";
$fmWeapText[GrenadeLauncher] = "GL";
$fmWeapText[DirectFire] = "DIRECT";
$fmFontColor = "<color:00FFFF>";
$fmKeylist = "12345qwertyasdfzxcvbn";
schedule(5000, 0, fmRemap);
schedule(5000, 0, buildTargetNameGui);
if($pref::Qing::fmMenuXOffset $= "")
	$pref::Qing::fmMenuXOffset = "0";
if($pref::Qing::fmMenuYOffset $= "")
	$pref::Qing::fmMenuYOffset = "0";
if($pref::Qing::fmHudXOffset $= "")
	$pref::Qing::fmHudXOffset = "0";
if($pref::Qing::fmHudYOffset $= "")
	$pref::Qing::fmHudYOffset = "0";
	
if(!$fmVisibleDistance)
	$FmVisibleDistance = "1000";	//you can set this as high as your vid card can handle
if(!$fmInit)
	schedule(4000, 0, fmInit);







///////////////////
//# INITIALIZATION
function fmInit()
{
	addMessageCallBack('MsgLoadInfo', fmOnMissionChange);
	addMessageCallBack('MsgClientJoinTeam', fmOnJoinTeam);
	addMessageCallback('MsgClientJoin', fmJoinServer);
	addMessageCallback('msgDepInvDes', fmOnDestroyed);
	addMessageCallback('msgDepSensorDes', fmOnDestroyed);
	addMessageCallback('msgDepTurDes', fmOnDestroyed);
	addMessageCallback('msgGenDes', fmOnDestroyed);
	addMessageCallback('msgTurretDes', fmOnDestroyed);
	addMessageCallback('msgSensorDes', fmOnDestroyed);
	addMessageCallback('msgVSDes', fmOnDestroyed);
	addMessageCallback('msgSolarDes', fmOnDestroyed);
	addMessageCallback('msgSentryDes', fmOnDestroyed);
	addMessageCallback('msgInvDes', fmOnDestroyed);
	addMessageCallback('MsgLegitKill', 	fmKillToneCallback);
	addMessageCallback('MsgHeadshotKill', 	fmKillToneCallback);
	new AudioProfile(fmDestroySound)
		{
		filename    = "fx/weapons/spinfusor_impact_UW.wav";
		description = "audioGui";
		preload = true;
		};
	if(isfile("scripts/autoexec/qing/qfmaddon.cs"))
		exec("scripts/autoexec/qing/qfmaddon.cs");
	$fmInit = true;
}

function fmRemap()
{
	if($fmRemap) return;
	$RemapName[$RemapCount]   ="Q FireMissions MENU";
	$RemapCmd[$RemapCount] = 		"fmBuildMenu";
	$RemapName[$RemapCount++] ="Q Next Firing Position";
	$RemapCmd[$RemapCount] = 		"fmNextFiringPosition";
	$RemapName[$RemapCount++] ="Q Elevation +";
	$RemapCmd[$RemapCount] = 		"fmUp";
	$RemapName[$RemapCount++] ="Q Elevation -";
	$RemapCmd[$RemapCount] = 		"fmDown";
	$RemapName[$RemapCount++] ="Q Azimuth Right";
	$RemapCmd[$RemapCount] = 		"fmRight";
	$RemapName[$RemapCount++] ="Q Azimuth Left";
	$RemapCmd[$RemapCount] = 		"fmLeft";
	$RemapName[$RemapCount++] ="Q Keyboard Fire";
	$RemapCmd[$RemapCount] = 		"fmOnFireKey";
	$RemapName[$RemapCount++] ="Q>Create FM Group";
	$RemapCmd[$RemapCount] = 		"fmOnNewGroupKey";
	$RemapName[$RemapCount++] ="Q>Create Fire Mission";
	$RemapCmd[$RemapCount] = 		"fmOnFireMissionKey";	
	$RemapName[$RemapCount++] ="Q>Mark Target";
	$RemapCmd[$RemapCount] = 		"fmMarkPos";
	$RemapName[$RemapCount++] ="Q>Clear Markers";
	$RemapCmd[$RemapCount] = 		"fmOnClearMarkersKey";
	$RemapName[$RemapCount++] ="Q>Show Vector Data";
	$RemapCmd[$RemapCount] = 		"fmElev";
	$RemapName[$RemapCount++] ="Q>Bright Beacons";
	$RemapCmd[$RemapCount] = 		"fmOnBrightNavKey";
	$RemapName[$RemapCount++] ="Q>High Visibility";
	$RemapCmd[$RemapCount] = 		"fmNewSky";
	$RemapName[$RemapCount++] ="Q>Toggle ProjectileCam";
	$RemapCmd[$RemapCount] = 		"fmOnProjectileCamKey";
	$RemapName[$RemapCount++] ="Q>Toggle Dual Targets";
	$RemapCmd[$RemapCount] = 		"fmOnBeacToggleKey";
	$RemapName[$RemapCount++] ="Q>Erase Group";
	$RemapCmd[$RemapCount] = 		"fmOnClearFireMissionsKey";
	$RemapName[$RemapCount++] ="Q>Disable Move";
	$RemapCmd[$RemapCount] = 		"fmOnNoMoveKey";
	$RemapName[$RemapCount++] ="Q>Toggle Timer Tone";
	$RemapCmd[$RemapCount] = 		"fmOnAudTimerKey";
	$RemapName[$RemapCount++] ="Q>Fire Missions OFF";
	$RemapCmd[$RemapCount] = 		"fmTurnOff";
	$RemapCount++;
	$fmRemap = true;
}





///////////////
//# ON CALLBACK
function fmJoinServer(%msgType, %msgString, %clientName, %clientId, %targetId, %isAI, %isAdmin, %isSuperAdmin, %isSmurf, %guid)
{
	if(strstr(%msgString, "Welcome to Tribes2") != -1)
		{
		$fmClient = %clientid;
		echo("FMCLIENT: " @ %clientid);
		$fmhudFadeOut = 0;
		$fmShowElev = false;
		}
}

function fmOnJoinTeam(%msgType, %msgString, %clientName, %teamName, %clientId, %teamId)
{
	if(%clientid == $fmclient && %clientid != 0)
		{
		$fmClientTeam = %teamid;
		echo("FMCLIENTTEAM: " @ %teamid);
		if($fmActive)
			{
			echo("You joined team " @ %teamid @ ", loading firemission");
			fmNextFiringPosition();
			}
		if($fmShowElev)
			$fmClient.player.DevInvincible = 1;
		}
}

function fmOnDestroyed(%typetag, %msg)
{
	switch$(detag(%typetag))
		{
		case MsgDepTurDes:		$fmPrinttxt ="DEPLOYED TURRRET DESTROYED";
										$fmDepTur++;
		case MsgDepInvDes:		$fmPrinttxt ="REMOTE INVENTORY DESTROYED";
										$fmRemote++;
		case MsgDepSensorDes:	$fmPrinttxt ="DEPLOYED SENSOR DESTROYED";
										$fmDepSensor++;
		case msgGenDes:			$fmPrinttxt ="GENERATOR DESTROYED";
										$fmGen++;
		case msgTurretDes:		$fmPrinttxt ="BASE TURRET DESTROYED";
										$fmTurret++;
		case msgSensorDes:		$fmPrinttxt ="SENSOR DESTROYED";
										$fmSensor++;
		case msgVSDes:				$fmPrinttxt ="VEHICLE STATION DESTROYED";
										$fmVpad++;
		case msgSolarDes:			$fmPrinttxt ="SOLAR PANEL DESTROYED";
										$fmSolar++;
		case msgSentryDes:		$fmPrinttxt ="SENTRY TURRET DESTROYED";
										$fmTurret++;
		case msgInvDes:			$fmPrinttxt ="INVENTORY STATION DESTROYED";
										$fmStation++;
		default:						$fmPrinttxt ="OBJECT DESTROYED";
										$fmMisc++;
		}
	$fmBlownUp++;
	if(getsimtime() - $fmDestroyTime < 100)
		clientCmdBottomPrint(	$fmFontColor @ "<font:Univers Condensed:16>" @ $fmPrintTxt @ "\n" @ $fmOldPrintTxt, 1.5, 2);
	else
		fmBottomPrint($fmPrintTxt @
							"\n   TURRET: <color:ffffff>" @ $fmTurret + $fmDepTur @ $fmFontColor @
							"   INV: <color:ffffff>" @ $fmStation + $fmRemote @ $fmFontColor @
							"   SENSOR: <color:ffffff>" @ $fmSensor + $fmDepSensor @ $fmFontColor @
							"   GEN: <color:ffffff>" @ $fmGen + $fmSolar @ $fmFontColor @
							"   VPAD: <color:ffffff>" @ $fmVpad/1 @ $fmFontColor @
							"  =  <color:ffffff>" @ $fmBlownUp @ $fmFontColor @ 
							"\n PLAYER KILLS: <color:ffffff>" @ $fmKillz/1, 8, 3);
	fmMiscTextField.setvalue($fmPrintTxt);
	fmMiscTextField2.setvalue($fmPrintTxt);
	alxPlay(fmDestroySound, 0, 0, 0);
	$fmDestroyTime = getsimtime();
	$fmOldPrintTxt = $fmPrintTxt;
}

function fmOnMissionChange(%msgType, %msgString, %bitmapName, %mapName, %missionType)
{
	if($fmActive)
		{
		fmReadFireMissions();
		$QAutoPointing = false;
		fmclearvisualaids();
		MortarImage.stateTimeoutValue[4] = 2.0;
		}
	$fmTurret = 0;
	$fmDepTur = 0;
	$fmStation = 0;
	$fmRemote = 0;
	$fmSensor = 0;
	$fmDepSensor = 0;
	$fmGen = 0;
	$fmSolar = 0;
	$fmVpad = 0;
	$fmBlownUp = 0;
	$fmKillz = 0;
}


///////////////
//# ON KEY

function fmAddToMenu(%name, %function, %text, %key)
{
	if(!isobject(%name))
		new ActionMap(%name);
	if(%key !$= "")
		{
		echo("Binding " @ %key @ " to " @ %function @ " on map " @ %name @ " pos " @ ($fmMenuLinesCounter-1) * 14);
		%name.bindcmd(keyboard, %key, %function, "");
		%obj = new GuiMLTextCtrl(fmMenuHudText @ $fmMenuLinesCounter++) 
			{
			profile = "fmMenuProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "0 " @ ($fmMenuLinesCounter-1) * 14;
			extent = "400 14";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
			};
		%obj2 = new GuiMLTextCtrl(fmMenuHudTextShadow) 
			{
			profile = "fmMenuProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "1 " @ 1 + ($fmMenuLinesCounter-1) * 14;
			extent = "400 18";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
			};
		%obj.setvalue (                   %key @ "<lmargin:20>" @ %text);
		%obj2.setvalue("<color:000000>" @ %key @ "<lmargin:20>" @ %text);
		fmMenuHudShell.add(%obj2);
		fmMenuHudShell.add(%obj);
		}
	else
		{
		%name.bindcmd(keyboard, strstr($fmKeyList[$fmKeyCount++], 1), %function, "");
		echo("Binding " @ strstr($fmKeyList[$fmKeyCount], 1) @ " to " @ %function @ " on map " @ %name @ " pos " @ ($fmMenuLinesCounter-1) * 14);
		}
}

function fmOnNoMoveKey(%make)
{
	if(!%make) return;
	$fmDisableMove = !$fmDisableMove;
	if($FmDisableMove)
		{
		fmBottomPrint("DISABLE MOVE");
		$fmClient.player.disablemove(true);
		}
	else
		{
		fmBottomPrint("ENABLE MOVE");
		$fmClient.player.disablemove(false);
		}
}

function fmMarkPos(%make)
{
	if(!%make) return;
	%obj = $fmClient.getcontrolObject();
   %eyetrans = %obj.getEyeTransform();
   %eyeVec = %obj.geteyevector();
   %eyePos = posFromTransform(%eyeTrans);
   %endPos = VectorAdd(%eyePos, VectorScale(%eyeVec,2000));
   %mask =	$TypeMasks::TerrainObjectType |
				$TypeMasks::InteriorObjectType |
				$TypeMasks::ForceFieldObjectType |
				$TypeMasks::StaticObjectType |
				$TypeMasks::MoveableObjectType |
				$TypeMasks::DamagableItemObjectType|
				$TypeMasks::PlayerObjectType      |
				$TypeMasks::VehicleObjectType     |
				$TypeMasks::StaticShapeObjectType |
				$TypeMasks::TurretObjectType      |
				$TypeMasks::ItemObjectType;
	%mask = $TypeMasks::TerrainObjectType | $TypeMasks::InteriorObjectType | $TypeMasks::StaticShapeObjectType | $TypeMasks::ForceFieldObjectType;
   %hit = ContainerRayCast(%eyePos, %endPos, %mask, %obj);
	if(%hit)
		{
		%targ = getword(%hit, 1) SPC getword(%hit, 2) SPC getword(%hit, 3) - 0.1;
	   $fmClient.fmBeac[$fmBeacCounter++] = new BeaconObject()
	   	{
	      dataBlock = "BomberBeacon";
	      beaconType = "vehicle";
	      position = %targ;
	      };
		$fmClient.fmBeac[$fmBeacCounter].team = $fmClientTeam;
		$fmClient.fmBeac[$fmBeacCounter].sourceobect = $fmClient.player;
		$fmClient.fmbeac[$fmBeacCounter].setTarget($fmClient.team);
		fmbottomprint("MARKING LOCATION WITH BEACON");
		}
}

function fmOnClearMarkersKey(%make)
{
	if(!%make) return;
	for(%i = 1; %i <= $fmBeacCounter; %i++)
		if(isobject($fmClient.fmBeac[%i]))
			$fmClient.fmBeac[%i].delete();
	$fmBeacCounter = 0;
	fmbottomprint("CLEARING BEACON MARKERS");
}


function fmOnBrightNavKey(%make)
{
	if(!%make) return;
	$fmBrightNavHud = !$fmBrightNavHud;
	if($fmBrightNavHud)
		{
		fmbottomprint("<color:FFFFFF>BRIGHT" @ $fmFontColor @ " NAV HUD");
		playGui.enemyBeaconLineBeginColor = "1 0 0 0.9";
		playGui.enemyBeaconLineEndColor = "1 0 0 1";
		playGui.vehicleBeaconLineBeginColor = "1 0 0 0.9";
		playGui.vehicleBeaconLineEndColor = "1 0 0 1";
		playGui.friendBeaconLineBeginColor = "0 0 1 0.9";
		playGui.friendBeaconLineEndColor = "0 0 1 1";
		playGui.beaconLineWidth = "0.1";
		navhud.opacity = "1";
		navhud.minMarkerScale = "1";
		navhud.markerScaleDistance = "10000";
		navhud.renderEdgeMarkers = "0";
		reticlehud.opacity = "1";
		}
	else
		{
		fmbottomprint("NORMAL NAV HUD");
		playGui.enemyBeaconLineBeginColor = "0.000000 1.000000 0.000000 0.200000";
		playGui.enemyBeaconLineEndColor = "0.000000 1.000000 0.000000 0.800000";
		playGui.vehicleBeaconLineBeginColor = "1.000000 0.000000 0.000000 0.200000";
		playGui.vehicleBeaconLineEndColor = "1.000000 0.000000 0.000000 0.800000";
		playGui.friendBeaconLineBeginColor = "1.000000 1.000000 0.000000 0.200000";
		playGui.friendBeaconLineEndColor = "1.000000 1.000000 0.000000 0.800000";
		playGui.beaconLineWidth = "2.5";
		navhud.opacity = "0.5";
		navhud.minMarkerScale = "0.5";
		navhud.markerScaleDistance = "1000";
		navhud.renderEdgeMarkers = "1";
		reticlehud.opacity = "0.5";
		}
}

function fmOnAudTimerKey(%make)
{
	if(!%make) return;
	$fmAudible = ! $fmAudible;
	if($fmAudible)
		$fmAudSched = schedule(0, 0, fmAudLoop);
	else
		cancel($fmAudSched);
}

function fmOnProjectileCamKey(%make)
{
	if(!%make) return;
	$fmProjectileCam = !$fmProjectileCam;
	if($fmProjectileCam)
		{
		messageall('Msg', "\c2ProjectileCam ON.");
		AssaultMortarTurretBarrel.projectile = fmTankMortar;
		mortarimage.projectile = fmMortar;
		}
	else
		{
		messageall('Msg', "\c2ProjectileCam OFF.");
		AssaultMortarTurretBarrel.projectile = AssaultMortar;
		mortarimage.projectile = mortarshot;
		}
}
	
function fmOnFireKey(%make)
{
	mousefire(%make);
}

function fmUp(%make)
{
	$mvPitchUpSpeed = %make ? fmPitchSpeed() : 0;
}

function fmDown(%make)
{
	$mvPitchDownSpeed = %make ? fmPitchSpeed() : 0;}

function fmLeft(%make)
{
	$mvYawLeftSpeed = %make ? fmPanSpeed() : 0;
}

function fmRight(%make)
{
	$mvYawRightSpeed = %make ? fmPanSpeed() : 0;
}

function fmOnFireMissionKey(%make)
{
	if(!%make) return;
	if($fmClient.player.position $= "")
		{
		fmHostError();
		return;
		}
	if($fmFireMissionCounter > 15)
		{
		fmBottomprint("WAYPOINT LIMIT REACHED (15 targets + 1 firing position)", 4, 1);
		return;
		}
	if(isobject($fmFirePosID))
		fmNewTargetGui();
	else
		{
		fmBottomPrint("CREATE A NEW FIRE MISSION GROUP FIRST");
		echo("CREATE A NEW FIRE MISSION GROUP FIRST");
		}
}

function fmOnClearFireMissionsKey(%make)
{
	if(!%make) return;
	if($fmClient.player.position $= "")
		fmHostError();
	else
		MessageBoxYesNo("CLEAR WAYPOINTS", "Clear all waypoints?", "fmClearWaypoints(1);	fmWipeFile($fmFileName);", "donothing();");
}

function fmOnNewGroupKey(%make)
{
	if(!%make) return;
	if($fmClient.player.position $= "")
		{
		fmHostError();
		return;
		}
	if(isobject($fmFirePosID))	//fire position exists, overwrite or create new?
		buildNewOrReplaceGui();
	else
		fmNewFirePosGui();		//does not exist, create new
}

function fmElev(%make)
{
	if(!%make) return;
	if($fmShowElev)
		{
		$fmShowElev = false;
		$fmHudFadeOut = 255;//cue to fade out the hud
		messageclient($fmClient, 'Msg', "\c2Elevation Display OFF");
		}
	else
		{
		$fmShowElev = true;
		$fmHudFadeOut = 0;
		if($Tcinitialized)
			{
			fmHudProfile.fontcolor = "128 128 0 255";
			fmHudProfile2.fontcolor = "0 0 0 255";
			$fmHudFontAlpha = 255;
			$fmHudFadeout = 0;
			fmStatusHud.delete();
			MakeTriconAdmin($fmClient);
			$fmClient.isTriconAdmin = true;
			TC2InitTrainingMode();
			InitBoostMod();
			InitGiveAllMod();
			tc2QGiveAll($fmClient);
			TC2InitTrainingMode();
			$fmClient.player.DevInvincible = 1;
			$fmClient.player.use("Mortar");
			if(!$fmProjectileCam)
				fmOnProjectileCamKey(1);
			if(!$fmBrightNavHud)
				fmOnBrightNavKey(1);
			}
		messageclient($fmClient, 'Msg', "\c2Elevation Display ON");
		fmStatusCreate();
		fmHudUpdate();
		}
}

function fmOnBeacToggleKey(%make)
{
	if(!%make) return;
	$fmBeacCycle++;
	if($fmBeacCycle > 3)
		$fmBeacCycle = 1;
	switch($fmBeacCycle)
		{
		case 1:	$fmDblBeac = 0;
					playGui.showAlternateTarget = 1;
					fmbottomprint("HIGH TRAJECTORY TARGETS");

		case 2:	$fmDblBeac = 1;
					fmDblBeac();
					fmBottomPrint("HIGH & LOW TRAJECTORY TARGETS");
		case 3:	$fmDblBeac = 0;
					playGui.showAlternateTarget = 0;
					fmBottomPrint("LOW TRAJECTORY TARGETS");
		}
}
	

function fmDblBeac()
{
	if(!$fmDblBeac) return;
	playGui.showAlternateTarget = !playGui.showAlternateTarget;
	cancel($fmDblBeacScheduler);
	%rate = 15;
	$fmDblBeacScheduler = schedule(%rate, 0, fmDblBeac);
}

function fmTurnOn(%make)
{
	if(!%make) return;
	$fmActive = true;
	addMessageHudLine("\c2Running QFireMissions, Build " @ $fmBuildVersion @ " by {NQP!}Qing");
	addMessageHudLine("\c2Check for updates at qing.netquickposse.com");
	$QAutoPointing = false;
	fmReadFireMissions();
	fmBottomPrint("QFIREMISSIONS -ON-");
}

function fmTurnOff(%make)
{
	fmc();
	if(!%make) return;
	$fmActive = false;
	$QAutoPointing = true;
	fmClearWaypoints(true);
	fmBottomPrint("QFIREMISSIONS -OFF-");
}








///////////////////
//# UTILITY FUNCTIONS

function fmKillToneCallback(%msgType, %msgString, %victimname, %vgen, %vposs, %killername, %kgen, %kposs, %damageType) 
{
	%killername = detag(%killername);
	if(%killername $= $PlayerList[$fmClient].name)
		{
		alxPlay(BountyBellSound, 0, 0, 0);
		$fmKillz++;
		if($fmActive)
			fmbottomprint(
							"PLAYER DESTROYED: <color:ffffff>" @ %killername @ $fmFontColor @
							"\n   TURRET: <color:ffffff>" @ $fmTurret + $fmDepTur @ $fmFontColor @
							"   INV: <color:ffffff>" @ $fmStation + $fmRemote @ $fmFontColor @
							"   SENSOR: <color:ffffff>" @ $fmSensor + $fmDepSensor @ $fmFontColor @
							"   GEN: <color:ffffff>" @ $fmGen + $fmSolar @ $fmFontColor @
							"   VPAD: <color:ffffff>" @ $fmVpad/1 @ $fmFontColor @
							"  =  <color:ffffff>" @ $fmBlownUp @ $fmFontColor @ 
							"\n PLAYER KILLS: <color:ffffff>" @ $fmKillz/1, 8, 3);

		}
}

function fmC()
{
	fmKeyMap.pop();
	movemap.push();
	if(isobject(fmMenuHudShell))
		fmMenuHudShell.delete();
}

function fmAudLoop()
{
	if(!$fmAudible) return;
	cancel($fmAudSched);
	$fmAudSched = schedule(1000, 0, fmAudLoop);
	alxPlay(sButtonDown,0,0,0);
}

function fmPanSpeed()
{
	if($ZoomOn)
		%speed = $pref::player::currentFOV/50000;
	else
		%speed = $pref::player::DefaultFOV/50000;
	if(%speed < 0.0001)
		%speed = 0.0001;
	%speed = -%speed;
	return %speed;
}

function fmPitchSpeed()
{
	if($ZoomOn)
		%speed = $pref::player::currentFOV/100000;
	else
		%speed = $pref::player::DefaultFOV/100000;
	if(%speed < 0.0001)
		%speed = 0.0001;
	%speed = -%speed;
	return %speed;
}

function fmNewTargetGui()
{
	buildTargetRangeGui();
}

function fmBottomprint(%msg, %time, %lines)
{
	%adjtime = %time ? %time : 1.5;
	%adjlines = %lines ? %lines : 1;
	clientCmdBottomPrint($fmFontColor @ "<font:Univers Condensed:16>" @ %msg, %adjtime, %adjlines);
}

function doNothing()
{
}

function fmHostError()
{
	fmBottomprint("PLAYER VECTOR DATA NOT AVAILABLE\nYOU MUST BE IN 'HOST' MODE AND SPAWNED\nTO CREATE A FIRE MISSION", 3,3);
}

function fmClearFirePosName()
{
	$fmFirePosName = "";
}

function fmNewSky(%make)
{
	if(!%make) return;
	messageall('Msg', "One moment...");
	schedule(500, 0, fmNewSky2);
}

function fmNewSky2()
{
	if(isobject(sky))
		sky.delete();
	new Sky(Sky) {
		position = "0 0 0";
		rotation = "1 0 0 0";
		scale = "1 1 1";
		cloudHeightPer[0] = "0";
		cloudHeightPer[1] = "0";
		cloudHeightPer[2] = "0";
		cloudSpeed1 = "0";
		cloudSpeed2 = "0";
		cloudSpeed3 = "0";
		visibleDistance = $fmVisibleDistance;
		useSkyTextures = "0";
		SkySolidColor = "0 0 0 0";
		fogDistance = $fmVisibleDistance * 0.95;
		fogColor = "0 0 0";
		fogVolume1 = "0 0 0";
		fogVolume2 = "0 0 0";
		fogVolume3 = "0 0 0";
		windVelocity = "0 0 0";
		materialList = "sky_desert_brown.dml";
		windEffectPrecipitation = "0";
		fogVolumeColor1 = "0 0 0 0";
		fogVolumeColor2 = "0 0 0 0";
		fogVolumeColor3 = "0 0 0 0";
		cloudSpeed0 = "0.000000 0.000000";
		};
	messageall('Msg', ".........................finished.");
}

function fmWeapon()
{
	%weapon = $fmCurrentWeap;
	if($fmTanker)
		return "TANK";
	switch$(%weapon)
		{
		case "Mortar": 			%result = "MORTAR";
		case "GrenadeLauncher":	%result = "GRENADELAUNCHER";
		case "":						%result = "";
		default:						%result = "DIRECTFIRE";
		}
	return %result;
}

function fmListWaypoints()
{
	for(%i = 0; %i < 16; %i++)
		if($fmFireMissionId[%i])
			echo(%i SPC $fmFireMissionID[%i] SPC $fmFireMissionName[%i] SPC $fmFireMissionTarget[%i]);
}

function editZ(%position, %amt)
{
	%trans = %position;
	%qposx = getword(%trans,0);
	%qposy = getword(%trans,1);
	%qposz = getword(%trans,2) + %amt;
	%adjust = %qposx SPC %qposy SPC %qposz;
	return (%adjust);
}

function getElev()
{
	if(!isobject($fmClient.player))
		return "ELEVATION: HELL!!!!";
	%elev = 100 * getword($fmClient.player.geteyevector(), 2);
	%trans = $fmClient.player.gettransform();
	%qposx = getword(%trans,0);
	%qposy = getword(%trans,1);
	%qposz = getword(%trans,2);
	%rot = getword(%trans, 6);
	return "(" @ $fmFireMissionCounter @ ") ELEVATION: " @ %elev @ "%" TAB "AZIMUTH: " @ %rot TAB "X: " @ %qposx TAB "Y: " @ %qposy TAB "Z: " @ %qposz;
}

function fmdeleteDSO()
{
	%path = "prefs/firemissions/*.dso";
	echo("deleteDSO Search path = " @ %path);
//find and index all the files
   for(%file = findFirstFile(%path); %file !$= ""; %file = findNextFile(%path))
   	{
   	echo("deleteDSO: Found file " @ %file);
		$fmDelDsoFile[$fmDelDsoFileCounter++] = %file;
		error(%file @ ": " @ isfile(%file));
		}

//run through the index and delete the files
	for(%i=1; %i <= $fmDelDsoFileCounter; %i++)
		{
		echo("DELETEFILE:" @ $fmDelDsoFile[%i]);
		deletefile($fmDelDsoFile[%i]);
		}
	$fmDelDsoFileCounter = "";
}

///////////////
//# GUI FUNCTIONS
function QOnRangeEntered()
{
	fmNewTargetNameGui($fmNewTargetRange);
	Canvas.popDialog(fmTargetRangeGui);
}

function fmNewTargetNameGui(%range)
{
	if($fmClient.player.position $= "")
		{
		fmHostError();
		return;
		}
	%player = $fmClient.player;
  	%eyeVec = %player.getEyeVector();
   %eyeTrans = %player.getEyeTransform();
   %eyePos = posFromTransform(%eyeTrans);
	$fmVectorPoint = VectorAdd(%eyePos, VectorScale(%eyeVec, %range));
	if($fmFlightTime <10)
		$fmFlightTime = "0" @ $fmFlightTime;
	switch$($fmTrajectory)
		{
		case "HIGH TRAJECTORY": %traj = "HI";
		case "LOW TRAJECTORY" : %traj = "LO";
		default               : %traj = "";
		}
	if($fmLastHit $= "Farm")
		$fmGuiFireMissionName = $fmLastHit;
	else
		$fmGuiFireMissionName = $fmLastHit SPC %traj @ " :" @ $fmFlightTime;
	if(isobject(fmTargetNameGui))
		Canvas.pushDialog(fmTargetNameGui);
	else
		{
		buildTargetNameGui();
		Canvas.pushDialog(fmTargetNameGui);
		}
}

function fmOnTargetName()
{
	if(strlen($fmGuiFireMissionName) == 0)
		return;
	if($fmFireMissionCounter > 15)
		{
		fmBottomPrint("WAYPOINT LIMIT REACHED", 4, 1);
		return;
		}
	$fmFireMissionCounter++;
	%target = createClientTarget(-1, $fmVectorPoint);
	%target.createWaypoint($fmGuiFireMissionName);
	$ClientWaypoints.add(%target);
	$fmFireMissionTarget[$fmFireMissionCounter] = $fmVectorPoint;
	$fmFireMissionName[$fmFireMissionCounter] = $fmGuiFireMissionName;
	$fmFireMissionID[$fmFireMissionCounter] = %target;
   fmWriteFireMission($fmVectorPoint, $fmGuiFireMissionName);
   echo("Fire Mission: " @ $fmGuiFireMissionName TAB $fmVectorPoint TAB %target TAB $fmFireMissionCounter);
	fmbottomprint("FIRE MISSION CREATED - '" @ $fmGuiFireMissionName @ "'", 3, 1);
	if($fmIsHost)
		fmAddVisualAid($fmLastHitPos, $fmGuiFireMissionName);
}

function clearTargetNameGui()
{
	$fmGuiFireMissionName = "";
	Canvas.popDialog(fmTargetNameGui);
}


function fmNewFirePosGui()
{
	fmWipeFile($fmFileName);
	fmClearwaypoints();
	$fmFirePosName = "";
	buildFirePosGui();
	$fmFirePosition = editz($fmClient.player.position, 0.25);
	Canvas.pushDialog(fmFirePosGui);
}

function fmMoreFirePosGui()
{
	fmClearwaypoints();
	$fmFirePosName = "";
	buildFirePosGui();
	$fmFirePosition = editz($fmClient.player.position, 0.25);
	Canvas.pushDialog(fmFirePosGui);
}

function fmOnFirePosgui()
{
	if($fmFirePosName $= "")
     	return;
	if(isobject($fmFirePosID))
		{
		$fmFirePosID.delete();
		fmClearWaypoints();
		}
	%name = $fmFirePosName;
	%target = createClientTarget(-1, $fmFirePosition);
	%target.createWaypoint(%name);
	$fmFireMissionCounter = 0;
	$ClientWaypoints.add(%target);
	$fmFireMissionTarget[0] = $fmFirePosition;
	$fmFireMissionName[0] = %name;
	$fmFireMissionID[0] = %target;
	$fmFirePosID = %target;
	if($fmIsHost)
		fmclearvisualaids();
	fmWriteFirePos($fmFirePosition, %name);
	fmBottomPrint("NEW FIRE POSITION ESTABLISHED - '" @ %name @ "'", 3, 1);
	if($QSettingAll)
		{
		$QSettingAll = false;
		fmOnFireMissionKey(1);
		}
}









////////////////
//# CORE FUNCTIONS

function fmBuildMenu()
{
	fmMenuCreate();
//	movemap.pop();
	fmKeyMap.push();
	fmKeyMap.bindcmd(keyboard, "escape", "fmc();", "");
	fmKeyMap.bindcmd(keyboard, "j", "fmc();", "");
if($fmActive)
	fmAddToMenu(fmKeyMap, "fmTurnOff(1);fmc();", 					"TURN OFF", 									"O");
else
	fmAddToMenu(fmKeyMap, "fmTurnOn(1);fmc();", 						"TURN ON", 										"O");
	$fmMenuLinesCounter++;
	fmAddToMenu(fmKeyMap, "fmNextFiringPosition(1);fmc();", 		"SELECT NEXT FIRING POSITION", 			"Q");
	fmAddToMenu(fmKeyMap, "fmOnNewGroupKey(1);fmc();",				"CREATE NEW FIRING POSITION",				"G");
if(isobject($fmFirePosID))
	fmAddToMenu(fmKeyMap, "fmOnFireMissionKey(1);fmc();", 		"CREATE NEW FIRING TARGET",		"N");
	$fmMenuLinesCounter++;
	fmAddToMenu(fmKeyMap, "fmMarkPos(1);fmc();",						"CREATE BEACON MARKER AT CROSSHAIR",	"M");
if(isobject($fmFirePosID))
	fmAddToMenu(fmKeyMap, "fmOnClearFireMissionsKey(1);fmc();",	"ERASE CURRENT FIRE MISSION GROUP",		"Z");
if($fmBeacCounter)
	fmAddToMenu(fmKeyMap, "fmOnClearMarkersKey(1);fmc();",		"ERASE BEACON MARKERS",						"E");
	fmAddToMenu(fmKeyMap, "fmNewSky(1);fmc();",						"SET HIGH VISIBILITY",						"V");
	$fmMenuLinesCounter++;
if($fmProjectileCam)
	fmAddToMenu(fmKeyMap, "fmOnProjectileCamKey(1);fmc();",		"TURN PROJECTILECAM OFF",					"C");
else
	fmAddToMenu(fmKeyMap, "fmOnProjectileCamKey(1);fmc();",		"TURN PROJECTILECAM ON",					"C");
if($fmShowElev)
	fmAddToMenu(fmKeyMap, "fmElev(1);fmc();",							"TURN ELEVATION HUD OFF",					"H");
else
	fmAddToMenu(fmKeyMap, "fmElev(1);fmc();",							"TURN ELEVATION HUD ON",					"H");
switch($fmBeacCycle)
{
case 1:
	fmAddToMenu(fmKeyMap, "fmOnBeacToggleKey(1);fmc();", 			"SET BEACON VIEW MODE TO DUAL ARC",		"B");
case 2:
	fmAddToMenu(fmKeyMap, "fmOnBeacToggleKey(1);fmc();", 			"SET BEACON VIEW MODE TO LOW ARC", 		"B");
case 3:
	fmAddToMenu(fmKeyMap, "fmOnBeacToggleKey(1);fmc();", 			"SET BEACON VIEW MODE TO HI ARC", 		"B");
}
if($fmBrightNavHud)
	fmAddToMenu(fmKeyMap, "fmOnBrightNavKey(1);fmc();", 			"TURN BRIGHT NAVHUD OFF",					"A");
else
	fmAddToMenu(fmKeyMap, "fmOnBrightNavKey(1);fmc();", 			"TURN BRIGHT NAVHUD ON",					"A");
if($fmDisableMove)
	fmAddToMenu(fmKeyMap, "fmOnNoMoveKey(1);fmc();",				"ENABLE MOVEMENT",							"D");
else
	fmAddToMenu(fmKeyMap, "fmOnNoMoveKey(1);fmc();",				"DISABLE MOVEMENT",							"D");
if($fmAudible)
	fmAddToMenu(fmKeyMap, "fmOnAudTimerKey(1);fmc();",				"TURN TIMER TONE OFF",						"T");
else
	fmAddToMenu(fmKeyMap, "fmOnAudTimerKey(1);fmc();",				"TURN TIMER TONE ON",						"T");
}

function fmMenuCreate()
{
	if(isObject(fmMenuHudShell))
		fmMenuHudShell.delete();
	$fmMenuLinesCounter = "";
	$fmMenuHudObj = new ShellFieldCtrl(fmMenuHudShell) 
		{
		profile = "";
		horizSizing = "center";
		vertSizing = "top";
		position = 100 + $pref::Qing::fmMenuXOffset SPC 100 + $pref::Qing::fmMenuYOffset;
		extent = "400 400";
		minExtent = "16 18";
		visible = "1";
		helpTag = "0";
		};
	PlayGui.add($fmMenuHudObj);
}

function fmNextFiringPosition(%make)
{
	if(!%make) return;
	if(!$fmActive)
		{
		$fmActive = true;
		addMessageHudLine("\c2Running QFireMissions, Build " @ $fmBuildVersion @ " by {NQP!}Qing");
		}
	%mission = $MissionName;
	%team = $fmClientTeam;
	%weapon = fmWeapon();
	%currentfileset = $fmGroup[fmWeapon()];
	%fileSearch = "prefs/firemissions/" @ %mission @ "/" @ $fmTeam[%team] @ "/" @ %weapon @ "/*.cs";
	$fmFileSearch = %filesearch;
	%filename = fmNextFile(%filesearch);
	if(!isfile(%filename))
		{
		fmClearWaypoints();
		fmBottomPrint("NO FIRE MISSION GROUP AVAILABLE");
		$fmFirePosName = "NONE";
		return;
		}

	$fmFileName = %filename;
	if(isfile(%filename))
		fmReadFireMissions();
	else
		{
		fmReadFireMissions();
		fmBottomPrint("LOADING " @ $fmWeapText[fmWeapon()] @ " FIRE MISSION GROUP  - '" @ $fmFirePosName @ "'");
		}
	if($fmIsHost)
		fmclearvisualaids();
}

function fmCreateNewGroup()
{
	$fmGroup[fmWeapon()] = "";
	if($fmClient.player.position $= "")
		fmHostError();
	else
		fmMoreFirePosGui();
}

function fmRebuild()
{
   if(isObject($ClientWaypoints))
      $ClientWaypoints.delete();
   $ClientWaypoints = new SimGroup();
   ServerConnection.add($ClientWaypoints);
   CommanderMapGui.firstWake = true;
   CommanderTree.currentWaypointID = 0;
}

function fmClearWaypoints(%annc)
{
	cdecho("CLEARED WP");
	%count = $clientwaypoints.getcount();
	if(isobject($fmFirePosid))
		$fmFirePosId.delete();
	for(%waypoints = 0; %waypoints < %count; %waypoints++)
		{
		for(%i = 0; %i <= $fmFireMissionCounter; %i++)
			{
			%wp = $clientwaypoints.getobject(%waypoints);
			%fm = $fmfiremissionid[%i];
			%fp = $fmfireposid;
			if(%wp == %fm)
				$fmToBeDeleted[%z++] = %wp;
			}
		}
	for(%i = 1; %i <= %z; %i++)
		{
		cdecho(%i);
		$fmToBeDeleted[%i].delete();
		cdecho("deleting " @ $fmtobedeleted[%i]);
		}
	CommanderMapGui.firstWake = true;
	CommanderTree.currentWaypointID = 0;
	for(%i = 0; %i <= 16; %i++)
		{
		$fmFireMissionTarget[%i] = "";
		$fmFireMissionID[%i] ="";
		$fmFireMissionName[%i] = "";
		}
	$fmFireMissionCounter = 0;
	$fmFirePosID = "";
	if(%annc)
		fmBottomPrint("ALL FIRE MISSIONS CLEARED", 3, 1);
}

function fmNextFile(%filesearch)
{
	%fileset = $fmGroup[fmWeapon()];
	%mission = $MissionName;
	%team = $fmClientTeam;
	%weapon = fmWeapon();
	%file = findnextfile(%filesearch);
	$fmFileSearch = %filesearch;
	if(%file $= "")
		{
		%file = findnextfile(%filesearch);
		if(%file $= "")
			return;
		}
	$fmGroup[fmWeapon()] = %file;
	return %file;
}

function fmAddVisualAid(%pos, %name)
{
	if(!$fmIsHost)
		return;
	$fmAidArray[$fmAidCounter++] = new TSStatic(fmVisualAid)
		{
		position= editz(%pos, 0.3);
		scale="3.5 3.5 3.5";
		shapename = "reticle_bomber.dts";
		};
	$fmMarkerWaypoint[$fmMarkerWaypointCounter++] = new WayPoint()
		{
		position = editz(%pos, 0.3);
		rotation = "1 0 0 0";
		scale = "1 1 1";
		dataBlock = "WayPointMarker";
		lockCount = "0";
		homingCount = "0";
		name = "(" @ %name @ ")";
		team = $fmClientTeam;
		};
}

function fmClearVisualAids()
{
	for(%i = 1; %i <= 100; %i++)
		{
		if(isobject($fmAidArray[%i]))
			$fmAidArray[%i].delete();
		if(isobject($fmMarkerWaypoint[%i]))
			$fmMarkerWaypoint[%i].delete();
		$fmAidArray[%i] = "";
		$fmMarkerWaypoint[%i] = "";
		}
	$fmAidCounter = "";
	$fmMarkerWaypointCounter = "";
}

function fmWipeFile(%file)
{
   new fileobject(fireMissions);
   fireMissions.openforwrite(%file);
	fireMissions.writeline("//Fire Mission Group Deleted");
	fireMissions.close();
	fireMissions.delete();
}

function fmMarkerDelete(%marker)
{
	if(isobject(%marker))
		%marker.delete();
}

function fmWriteFirePos(%fmFirePosition, %name)
{
	$fmFileName = %name;
	%mission = $MissionName;
	%team = $fmClientteam;
	%weapon = fmWeapon();
	$fmFileName = "prefs/firemissions/" @ %mission @ "/" @ $fmTeam[%team] @ "/" @ %weapon @ "/" @ %name @ ".fm.cs";
   new fileobject(fireMissions);
   fireMissions.openforwrite($fmFileName);
	fireMissions.writeline("$FirePosName = \"" @ %name @ "\";");
	fireMissions.writeline("$FirePosition = \"" @ %fmFirePosition @ "\";");
	fireMissions.writeline("$fmTempCounter = 0;");
	fireMissions.close();
	fireMissions.delete();
}

function fmWriteFireMission(%pos, %name)
{
	fmRebuild();
	for(%i = 0; %i < 1000; %i++)
		$FireMissionFileData[%i] = "";
	new fileobject(fireMissions);
   fireMissions.openforread($fmFileName);
	while (!fireMissions.iseof())
		$FireMissionFileData[%counter++] = fireMissions.readline();
	fireMissions.close();
	fireMissions.delete();

	new fileobject(fireMissions);
	fireMissions.openforwrite($fmFileName);
	for(%i = 1; $FireMissionFileData[%i] !$= ""; %i++)
		fireMissions.writeline($FireMissionFileData[%i]);
	$fmFireMissionCounter = ((%i-2)/2);
	fireMissions.writeline("$FireMissionName[$fmTempCounter++] = \"" @ %name @ "\";");
	fireMissions.writeline("$FireMissionTarget[$fmTempCounter] = \"" @ %pos @ "\";");
	fireMissions.close();
	fireMissions.delete();
	fmReadFireMissions();
}


function fmReadFireMissions(%from)
{
	fmClearWaypoints();
	$firePosName = "";
	if(!$fmActive)
		{
		$fmActive = true;
		addMessageHudLine("\c2Running QFireMissions, Build " @ $fmBuildVersion @ " by {NQP!}Qing");
		}
   $fmFireMissionCounter = 0;
	%mission = $MissionName;
	%team = $fmClientteam;
	%weapon = fmWeapon();
	for(%i = 1; %i < 1000; %i++)
		{
		$FireMissionTarget[%i] = "";
		$FireMissionName[%i] = "";
		}
	if(isfile($fmFileName))
		exec($fmFileName);
	else
		{
		if(!%from)
			fmbottomprint("NO FIRE MISSIONS DEFINED", 5,1);
		return;
		}
	if($firePosName $= "")
		{
		for(%i = 0; %i < 20; %i++)
			{
			%file = fmNextFile($fmFileSearch);
			if(%file !$= "")
				{
				exec(%file);
				if($firePosName !$= "")
					{
					$fmFileName = %file;
					schedule(0, 0, fmReadFireMissions, %from);
					return;
					}
				}
			}
		fmbottomprint("NO FIRE MISSIONS DEFINED", 5,1);
		return;
		}
	$fmFirePosName = $FirePosName;
	$fmFirePosition = $FirePosition;
	fmLoadedFirePos();
	for(%i = 1; $fireMissionName[%i] !$= ""; %i++)
		{
		%target = createClientTarget(-1, $FireMissionTarget[%i]);
		%target.createWaypoint($FireMissionName[%i]);
		$ClientWaypoints.add(%target);
		$fmFireMissionTarget[%i] = $FireMissionTarget[%i];
		$fmFireMissionName[%i] = $FireMissionName[%i];
		$fmFireMissionID[%i] = %target;
	   $fmFireMissionCounter = %i + 1;
	   }
	fmBottomPrint("LOADING " @ $fmWeapText[fmWeapon()] @ " FIRE MISSION GROUP  - '" @ $fmFirePosName @ "'");
}

function fmLoadedFirePos()
{
	if($fmFirePosName $= "")
     	return;
	if(isobject($fmFirePosID))
		$fmFirePosID.delete();
	fmClearWaypoints();
	%name = $fmFirePosName;
	%target = createClientTarget(-1, $fmFirePosition);
	%target.createWaypoint(%name);
	$ClientWaypoints.add(%target);
	$fmFireMissionTarget[%i] = $fmFirePosition;
	$fmFireMissionName[%i] = %name;
	$fmFireMissionID[%i] = %target;
   $fmFirePosID = %target;
	if($QSettingAll)
		{
		$QSettingAll = false;
		fmOnFireMissionKey(1);
		}
}










//////////
//# PACKAGES
package QFireMissions
{

	function clientCmdShowVehicleGauges(%vehType, %node)
	{
		parent::clientCmdShowVehicleGauges(%vehType, %node);
		if(%vehType $= "Assault" && %node ==1)
			$fmTanker = 1;
		else
			$fmTanker = 0;
	}


	function clientCmdVehicleDismount()
	{
		parent::clientCmdVehicleDismount();
		$fmTanker = 0;
	}


	function PlayGui::onSleep(%this) 
	{
		$fmIsHost = isobject(ServerGroup) ? 1 : 0;
		$fmLastDblBeacStatus = $fmDblBeac;
		$fmLastAltTargStatus = playgui.showAlternateTarget;
		$fmDblBeac = 0;
		playGui.showAlternateTarget = 0;
		parent::onSleep(%this);
	}

	function PlayGui::onWake(%this) 
	{
		$fmIsHost = isobject(ServerGroup) ? 1 : 0;
		$fmDblBeac = $fmLastDblBeacStatus;
		if($fmDblBeac)
			fmDblBeac();
		playgui.showAlternateTarget = $fmLastAltTargStatus;
		parent::onWake(%this);
	}

	function Observer::onTrigger(%data,%obj,%trigger,%state)
	{
	   if (%state == 0) return;
	   if (!Game.ObserverOnTrigger(%data, %obj, %trigger, %state)) return;
	   if (%trigger >= 4) return;	//trigger types:   0:fire 1:altTrigger 2:jump 3:jet 4:throw
	   %client = %obj.getControllingClient();
	   if (%client == 0) return;
	   switch$ (%obj.mode)
	   {
	      case "justJoined":
	         if (isDemo())
	            clearCenterPrint(%client);

	         //press FIRE
	         if (%trigger == 0)
		         {
	            // clear intro message
	            clearBottomPrint( %client );
            
	            //spawn the player
				   commandToClient(%client, 'setHudMode', 'Standard');
	            Game.assignClientTeam(%client);
	            Game.spawnPlayer( %client, $MatchStarted );
            
	            if( $MatchStarted )
						{
	               %client.camera.setFlyMode();
	               %client.setControlObject( %client.player );
	            	}
	            else
	            	{   
	               %client.camera.getDataBlock().setMode( %client.camera, "pre-game", %client.player );
	               %client.setControlObject( %client.camera );
	            	}
		         }
         
	         //press JET
	         else if (%trigger == 3)
	   	      {
	            //cycle throw the static observer spawn points
	            %markerObj = Game.pickObserverSpawn(%client, true);
	            %transform = %markerObj.getTransform();
	            %obj.setTransform(%transform);
	            %obj.setFlyMode();
	      	   }

	         //press JUMP
	         else if (%trigger == 2)
	         	{
	            //switch the observer mode to observing clients
	            if (isObject(%client.observeFlyClient))
	               serverCmdObserveClient(%client, %client.observeFlyClient);
	            else
	               serverCmdObserveClient(%client, -1);

	            displayObserverHud(%client, %client.observeClient);
	            messageClient(%client.observeClient, 'Observer', '\c1%1 is now observing you.', %client.name);  
		         }
      
	      case "playerDeath":
	         // Attached to a dead player - spawn regardless of trigger type
	         if(!%client.waitRespawn && getSimTime() > %client.suicideRespawnTime)
		         {
				   commandToClient(%client, 'setHudMode', 'Standard');
	            Game.spawnPlayer( %client, true );
	            %client.camera.setFlyMode();
	            %client.setControlObject(%client.player);
	   	      }
      
	      case "PreviewMode":
	         if (%trigger == 0)
		         {
				   commandToClient(%client, 'setHudMode', 'Standard');
	            if( %client.lastTeam )
	               Game.clientJoinTeam( %client, %client.lastTeam );
	            else
		            {   
	               Game.assignClientTeam( %client, true );
	               Game.spawnPlayer( %client, false );
	      	      }
	            %client.camera.setFlyMode();
	            %client.setControlObject( %client.player );
	         	}

	      case "toggleCameraFly":
	      // this is the default camera mode

	      case "observerFly":
	         // Free-flying observer camera
         
	         if (%trigger == 0)
	         {
	            if( !$Host::TournamentMode && $MatchStarted )
	            {
	               // reset observer params
	               clearBottomPrint(%client);
					   commandToClient(%client, 'setHudMode', 'Standard');
               
	               if( %client.lastTeam !$= "" && %client.lastTeam != 0 && Game.numTeams > 1)
	               {   
	                  Game.clientJoinTeam( %client, %client.lastTeam, $MatchStarted ); 
	                  %client.camera.setFlyMode();
	                  %client.setControlObject( %client.player );
	               }
	               else
	               {   
                  
	                  Game.assignClientTeam( %client );
                  
	                  // Spawn the player:
	                  Game.spawnPlayer( %client, true );
	                  %client.camera.setFlyMode();
	                  %client.setControlObject( %client.player );
	                  ClearBottomPrint( %client );
	               }
	            }
	            else if( !$Host::TournamentMode )
	            {
               
	               clearBottomPrint(%client);
	               Game.assignClientTeam( %client );
                  
	               // Spawn the player:
	               Game.spawnPlayer( %client, false );
	               %client.camera.getDataBlock().setMode( %client.camera, "pre-game", %client.player );
	               %client.setControlObject( %client.camera );
	            }
	         }   
	         //press JET
	         else if (%trigger == 3)
	         {
	            %markerObj = Game.pickObserverSpawn(%client, true);
	            %transform = %markerObj.getTransform();
	            %obj.setTransform(%transform);
	            %obj.setFlyMode();
	         }

	         //press JUMP
	         else if (%trigger == 2)
	         {
	            //switch the observer mode to observing clients
	            if (isObject(%client.observeFlyClient))
	               serverCmdObserveClient(%client, %client.observeFlyClient);
	            else
	               serverCmdObserveClient(%client, -1);
            
	            observerFollowUpdate( %client, %client.observeClient, false );
	            displayObserverHud(%client, %client.observeClient);
	            messageClient(%client.observeClient, 'Observer', '\c1%1 is now observing you.', %client.name);  
	         }
	      case "observerStatic":
	         %next = (%trigger == 3 ? true : false);
	         %markerObj = Game.pickObserverSpawn(%client, %next);
	         %transform = %markerObj.getTransform();
	         %obj.setTransform(%transform);
	         %obj.setFlyMode();
	      case "observerStaticNoNext":
	      case "observerTimeout":
	         if (%trigger == 0)
		         {
	            clearBottomPrint(%client);
				   commandToClient(%client, 'setHudMode', 'Standard');
	            if( %client.lastTeam )
	               Game.clientJoinTeam( %client, %client.lastTeam, true ); 
	            else
		            {   
	               Game.assignClientTeam( %client );
	               Game.spawnPlayer( %client, true );
		            }
	            %client.camera.setFlyMode();
	            %client.setControlObject(%client.player);
		         }   
	         else if (%trigger == 3)
		         {
	            %markerObj = Game.pickObserverSpawn(%client, true);
	            %transform = %markerObj.getTransform();
	            %obj.setTransform(%transform);
	            %obj.setFlyMode();
		         }
	         else if (%trigger == 2)
		         {
	            if (isObject(%client.observeFlyClient))
	               serverCmdObserveClient(%client, %client.observeFlyClient);
	            else
	               serverCmdObserveClient(%client, -1);
	            observerFollowUpdate( %client, %client.observeClient, false );
	            displayObserverHud(%client, %client.observeClient);
	            messageClient(%client.observeClient, 'Observer', '\c1%1 is now observing you.', %client.name);  
		         }
	      case "observerFollow":
	         if(%obj.getDataBlock().getClassName() !$= "Player")
		         {
	               if(%trigger == 3)
		               {
	                  %client.camera.setFlyMode();
	                  %client.setControlObject(%client.player);
	   	            }
	      	   }
	         else
	         	{
	             if (%trigger == 0)
	            	 {
	                 %nextClient = findNextObserveClient(%client);
	                 %prevObsClient = %client.observeClient;
	                 if (%nextClient > 0 && %nextClient != %client.observeClient)
	                   {
	                      observerFollowUpdate( %client, %nextClient, true );
               
	                      //set the new object
	                      %transform = %nextClient.player.getTransform();
	                      if( !%nextClient.isMounted() )
	                      {
	                           %obj.setOrbitMode(%nextClient.player, %transform, 0.5, 4.5, 4.5);
	                           %client.observeClient = %nextClient;
	                      } 
	                      else
	                      {
	                           %mount = %nextClient.player.getObjectMount();
	                           if( %mount.getDataBlock().observeParameters $= "" )
	                              %params = %transform;
	                           else
	                              %params = %mount.getDataBlock().observeParameters;
            
	                           %obj.setOrbitMode(%mount, %mount.getTransform(), getWord( %params, 0 ), getWord( %params, 1 ), getWord( %params, 2 ));
	                           %client.observeClient = %nextClient;
	                      }  // else
	                   } // %nextClient > 0 &&
                   
	                //send the message(s)
	                displayObserverHud(%client, %nextClient);
	                messageClient(%nextClient, 'Observer', '\c1%1 is now observing you.', %client.name);
	                messageClient(%prevObsClient, 'ObserverEnd', '\c1%1 is no longer observing you.', %client.name);
	             }  // trigger == 0
	             //press JET - cycle to prev client
	             else if (%trigger == 3)
	             {
	                  %prevClient = findPrevObserveClient(%client);
	                  %prevObsClient = %client.observeClient;
	                  if (%prevClient > 0 && %prevClient != %client.observeClient)
	                  {
	                     // update the observer list for this client
	                     observerFollowUpdate( %client, %prevClient, true );
               
	                     //set the new object
	                     %transform = %prevClient.player.getTransform();
	                     if( !%prevClient.isMounted() )
	                     {
	                        %obj.setOrbitMode(%prevClient.player, %transform, 0.5, 4.5, 4.5);
	                        %client.observeClient = %prevClient;
	                     } // !%prevClient
	                     else
	                     {
	                        %mount = %prevClient.player.getObjectMount();
	                        if( %mount.getDataBlock().observeParameters $= "" )
	                            %params = %transform;
	                        else
	                            %params = %mount.getDataBlock().observeParameters;
            
	                        %obj.setOrbitMode(%mount, %mount.getTransform(), getWord( %params, 0 ), getWord( %params, 1 ), getWord( %params, 2 ));
	                        %client.observeClient = %prevClient;
	                     } // else

	                     //send the message(s)
	                     displayObserverHud(%client, %prevClient);
	                     messageClient(%prevClient, 'Observer', '\c1%1 is now observing you.', %client.name);
	                     messageClient(%prevObsClient, 'ObserverEnd', '\c1%1 is no longer observing you.', %client.name);
	                  }  // %prevclient > 0
	             }  // trigger ==
	             //press JUMP
	             else if (%trigger == 2)
	             {
	                  if(%obj.getDataBlock().getClassName() $= "Player")
	                  {
	                      // update the observer list for this client
	                      observerFollowUpdate( %client, -1, false );
            
	                      //toggle back to observer fly mode
	                      %obj.mode = "observerFly";
	                      %obj.setFlyMode();
	                      updateObserverFlyHud(%client);
	                      messageClient(%client.observeClient, 'ObserverEnd', '\c1%1 is no longer observing you.', %client.name);
	                  } // if
	             }  // else if trigger == 2
	         }
	      case "pre-game":
	         if(!$Host::TournamentMode || $CountdownStarted)
	            return;

	         if(%client.notReady)
	         {
	            %client.notReady = "";
	            MessageAll( 0, '\c1%1 is READY.', %client.name );
	            if(%client.notReadyCount < 3)
	               centerprint( %client, "\nWaiting for match start (FIRE if not ready)", 0, 3);
	            else 
	               centerprint( %client, "\nWaiting for match start", 0, 3);
	         }
	         else
	   	      {
	            %client.notReadyCount++;
	            if(%client.notReadyCount < 4)
		            {
	               %client.notReady = true;
	               MessageAll( 0, '\c1%1 is not READY.', %client.name );
	               centerprint( %client, "\nPress FIRE when ready.", 0, 3 );
		            }
	            return;
	      	   }
	         CheckTourneyMatchStart();
	   }
	}

	function clientCmdSetWeaponsHudActive(%slot) 
	{
		parent::clientCmdSetWeaponsHudActive(%slot);
		$fmTanker = 0;
		%weap = $WeaponNames[%slot];
		if(%weap $= "")
			return;
		$fmCurrentWeap = %weap;
		cdecho("WEAP:" @ %weap SPC "fmweapon():" @ fmweapon());
		if($fmActive)
			{
			if(fmWeapon() !$= $fmPrevWeap && fmWeapon() !$= "")
				{
				if(isfile($fmGroup[fmWeapon()]))
					{
					$fmFileName = $fmGroup[fmWeapon()];
					fmReadFireMissions();
					}
				else
					{
					$fmFileSearch = %filesearch;
					$fmFileName = fmNextFile(%filesearch);
					fmNextFiringPosition();
					}
				}
			}
		$fmPrevWeap = fmWeapon();
	}

	function quit()
	{
		%search = "prefs/firemissions/*.fm.cs";
		fmdeleteDSO();
	   for(%file = findFirstFile(%search); %file !$= ""; %file = findNextFile(%search))
			{
			new fileobject(Cleanup);
			Cleanup.openForRead(%file);
			%data = Cleanup.readline();
			if(%data $= "//Fire Mission Group Deleted")
				{
				$ToBeDeleted[%counter++] = %file;
				$ToBeDeleted[%counter++] = %file @ ".dso";
				}
			Cleanup.close();
			Cleanup.delete();
			}
		echo("FireMissions is deleting unused firemission files");
		for(%i = 1; %i <= %counter; %i++)
			if(isfile($ToBeDeleted[%i]))
				deletefile($ToBeDeleted[%i]);
		parent::quit();
	}

	function StaticShapeData::damageObject(%data, %targetObject, %sourceObject, %position, %amount, %damageType)
	{
		parent::damageObject(%data, %targetObject, %sourceObject, %position, %amount, %damageType);
		if(%sourceObject.client == $fmClient)
			{
			if(%targetobject.getdatablock().classname $= "FlagIntStand")
				{
				$fmLastHit = "HOF";
				}
			else
				{
				if(gettaggedstring(%data.getname().targetTypeTag) !$= "")
				$fmLastHit = gettaggedstring(%data.getname().targetTypeTag);
				if($fmLastHit $= "Vehicle Station")
					$fmLastHit = "VPad";
				}
			}
	}

	function RadiusExplosion(%explosionSource, %position, %radius, %damage, %impulse, %sourceObject, %damageType)
	{
		InitContainerRadiusSearch(%position, %radius, $TypeMasks::PlayerObjectType      |
   	                                              $TypeMasks::VehicleObjectType     |
      	                                           $TypeMasks::StaticShapeObjectType |
         	                                        $TypeMasks::TurretObjectType      |
            	                                     $TypeMasks::ItemObjectType);
	   %numTargets = 0;
   	while ((%targetObject = containerSearchNext()) != 0)
			{
			%dist = containerSearchCurrRadDamageDist();
			if (%dist <= %radius)
				if(%targetobject.getdatablock().shapefile $= "flag.dts")
					$fmLastHit = "HOF";
			}
		if(isobject(%sourceobject.client.fmMarker))
			%sourceobject.client.fmMarker.delete();
		%distance = VectorDist(%sourceobject.client.fmfirepos, %position);
		%fireAlt = getword(%sourceobject.client.fmfirepos, 2);
		%impactalt = getword(%position, 2);
		%elevchange = mfloor((%impactalt - %firealt) * 10) /10;
		if(%elevchange > 0)
			%elevchange = "+" @ %elevchange;
		%flighttime = mfloor((getsimtime() - $fmCLient.fmFireTime)/100) /10;
		$tempflight = %flighttime;
		if(%sourceobject.client == $fmclient)
			{
			$fmIsHost = true;
			$fmDistance = %distance;
			$fmLastHitPos = %position;
			$fmFlightTime = %flighttime;
			}
		if($fmProjectileCam)
			{
			%sourceobject.client.fmMarker = new TSStatic(mortarMarker)
				{
				position= %position;
				scale="1 1 1";
				shapename = %explosionsource.getdatablock().getname().projectileShapeName;
				};
			%advance = ($timeAdvance ? $timeAdvance : 20) / 10;
			schedule(60000 * %advance, 0, fmMarkerdelete, %sourceObject.client.fmmarker);
			messageclient(%sourceobject.client, 'Msg', "\c2IMPACT!  " @ mfloor(%distance * 10)/10 @ "m; " @ %flighttime @ " secs; " @ %elevchange @ "m alt");
			}
		parent::RadiusExplosion(%explosionSource, %position, %radius, %damage, %impulse, %sourceObject, %damageType);
	}

	function ProjectileData::onExplode(%data, %proj, %pos, %mod)
	{
	   if (%data.hasDamageRadius)
   	   RadiusExplosion(%proj, %pos, %data.damageRadius, %data.indirectDamage, %data.kickBackStrength, %proj.sourceObject, %data.radiusDamageType);
		if($fmProjectileCam && %proj.sourceObject.client.getcontrolobject() == %proj.sourceobject.client.camera)
			if(%proj == %proj.sourceobject.client.fmCamFollowing)
				{
				%proj.sourceobject.client.camera.getDataBlock().mode = "observerStatic";
				%proj.sourceobject.client.camera.setTransform(%proj.sourceobject.client.camera.gettransform());
	         %proj.sourceobject.client.setControlObject(%proj.sourceobject.client.camera);
	       	%proj.sourceobject.client.camera.setFlyMode();
	       	}
	}

	function loadMission( %missionName, %missionType, %firstMission )
	{
		fmDataBlocks();
		if($fmProjectileCam)
			messageall('Msg', "\c2ProjectileCam on.");
		parent::loadMission( %missionName, %missionType, %firstMission );
		$fmTanker = 0;
	}
		

	function ShapeBaseImageData::onFire(%data, %obj, %slot)
	{
		if(nameToId("AssaultMortarTurretBarrel") !$= %data)
			{
			parent::onfire(%data, %obj, %slot);
			return;
			}
		if(isobject(fmMiscTextField))
			{
			fmMiscTextField.setvalue("");
			fmMiscTextField2.setvalue("");
			}
		if(%obj.turreteer.client == $fmClient)
			{
			$fmLastHit = "Farm";
			$fmFlightTime = "";
			}
		if(isobject(%obj.turreteer.client.fmMarker))
			%obj.turreteer.client.fmmarker.delete();
		%obj.turreteer.client.fmFireTime = getsimtime();
		%obj.turreteer.client.fmFirePos = %obj.getmuzzlepoint;
		%p = parent::onFire(%data, %obj, %slot);
		AIGrenadeThrown(%p);
		if($fmProjectileCam)
			{
			%elev = 100 * getword(%obj.getmuzzlevector(0), 2);
			%trans = %obj.getmuzzlepoint(0);
			%t0 = getword(%trans, 0);
			%t1 = getword(%trans, 1);
			%t2 = getword(%trans, 2);
			%t3 = getword(%trans, 3);
			%t4 = getword(%trans, 4);
			%t5 = getword(%trans, 5);
			%rot = getword(%trans, 6);
			%camtrans = %t0 SPC %t1 SPC %t2 SPC %t3 SPC "-0.3" SPC %t5 SPC %rot;
			messageclient(%obj.turreteer.client, 'Msg', "\c2FIRE!  Elev: " @  %elev @ "%   Azim: " @ %rot);
			%obj.turreteer.client.fmCamFollowing = %p;
			%obj.turreteer.client.setControlObject(%obj.turreteer.client.camera);
			%obj.turreteer.client.camera.mode = "observerFollow";
			%obj.turreteer.client.camera.setOrbitMode(%p, %camtrans, 0, 15, 4.5);
			%obj.turreteer.client.camera.settransform(%camtrans);
			}
	}


	function MortarImage::onFire(%data,%obj,%slot)
	{
		if(isobject(fmMiscTextField))
			{
			fmMiscTextField.setvalue("");
			fmMiscTextField2.setvalue("");
			}
		if(%obj.client == $fmClient)
			{
			$fmLastHit = "Farm";
			$fmFlightTime = "";
			}
		if(isobject(%obj.client.fmMarker))
			%obj.client.fmmarker.delete();
		%obj.client.fmFireTime = getsimtime();
		%obj.client.fmFirePos = %obj.client.player.position;
		%p = ShapeBaseImageData::onFire(%data, %obj, %slot);
		AIGrenadeThrown(%p);
		if($fmProjectileCam)
			{
			%data.projectile = fmMortar;
			%elev = 100 * getword(%obj.client.player.geteyevector(), 2);
			%trans = $fmClient.player.gettransform();
			%t0 = getword(%trans, 0);
			%t1 = getword(%trans, 1);
			%t2 = getword(%trans, 2);
			%t3 = getword(%trans, 3);
			%t4 = getword(%trans, 4);
			%t5 = getword(%trans, 5);
			%rot = getword(%trans, 6);
			%camtrans = %t0 SPC %t1 SPC %t2 SPC %t3 SPC "-0.3" SPC %t5 SPC %rot;
			messageclient(%obj.client, 'Msg', "\c2FIRE!  Elev: " @  %elev @ "%   Azim: " @ %rot);
			%obj.client.fmCamFollowing = %p;
			%obj.client.setControlObject(%obj.client.camera);
			%obj.client.camera.mode = "observerFollow";
			%obj.client.camera.setOrbitMode(%p, %camtrans, 0, 15, 4.5);
			%obj.client.camera.settransform(%camtrans);
			}
	}

	function GrenadeLauncherImage::onFire(%data,%obj,%slot)
	{
		if(isobject(fmMiscTextField))
			{
			fmMiscTextField.setvalue("");
			fmMiscTextField2.setvalue("");
			}
		if(%obj.client == $fmClient)
			{
			$fmLastHit = "Farm";
			$fmFlightTime = "";
			}
		if(isobject(%obj.client.fmMarker))
			%obj.client.fmmarker.delete();
		%obj.client.fmFireTime = getsimtime();
		%obj.client.fmFirePos = %obj.client.player.position;
		AIGrenadeThrown(%p);
		%p = ShapeBaseImageData::onFire(%data, %obj, %slot);
		if($fmProjectileCam)
			{
			%elev = 100 * getword(%obj.client.player.geteyevector(), 2);
			%trans = $fmClient.player.gettransform();
			%t0 = getword(%trans, 0);
			%t1 = getword(%trans, 1);
			%t2 = getword(%trans, 2);
			%t3 = getword(%trans, 3);
			%t4 = getword(%trans, 4);
			%t5 = getword(%trans, 5);
			%rot = getword(%trans, 6);
			%camtrans = %t0 SPC %t1 SPC %t2 SPC %t3 SPC "-0.3" SPC %t5 SPC %rot;
			messageclient(%obj.client, 'Msg', "\c2FIRE!  Elev: " @  %elev @ "%   Azim: " @ %rot);
			%obj.client.fmCamFollowing = %p;
			%obj.client.setControlObject(%obj.client.camera);
			%obj.client.camera.mode = "observerFollow";
			%obj.client.camera.setOrbitMode(%p, %camtrans, 0, 15, 4.5);
			%obj.client.camera.settransform(%camtrans);
			}
	}

	function DiscImage::onFire(%data,%obj,%slot)
	{
		if(isobject(fmMiscTextField))
			{
			fmMiscTextField.setvalue("");
			fmMiscTextField2.setvalue("");
			}
		if(%obj.client == $fmClient)
			{
			$fmLastHit = "Farm";
			$fmFlightTime = "";
			}
		if(isobject(%obj.client.fmMarker))
			%obj.client.fmmarker.delete();
		%obj.client.fmFireTime = getsimtime();
		%obj.client.fmFirePos = %obj.client.player.position;
		AIGrenadeThrown(%p);
		%p = ShapeBaseImageData::onFire(%data, %obj, %slot);
		if($fmProjectileCam)
			{
			%elev = 100 * getword(%obj.client.player.geteyevector(), 2);
			%trans = $fmClient.player.gettransform();
			%t0 = getword(%trans, 0);
			%t1 = getword(%trans, 1);
			%t2 = getword(%trans, 2);
			%t3 = getword(%trans, 3);
			%t4 = getword(%trans, 4);
			%t5 = getword(%trans, 5);
			%rot = getword(%trans, 6);
			%camtrans = %t0 SPC %t1 SPC %t2 SPC %t3 SPC "-0.3" SPC %t5 SPC %rot;
			messageclient(%obj.client, 'Msg', "\c2FIRE!  Elev: " @  %elev @ "%   Azim: " @ %rot);
			%obj.client.fmCamFollowing = %p;
			%obj.client.setControlObject(%obj.client.camera);
			%obj.client.camera.mode = "observerFollow";
			%obj.client.camera.setOrbitMode(%p, %camtrans, 0, 15, 4.5);
			%obj.client.camera.settransform(%camtrans);
			}
	}


};







/////////////////
//# GUI DEFINITIONS
new GuiControlProfile (fmMenuProfile) 
{
	fontType = "Univers Condensed";
	fontSize = 16;
	fontColor = "128 128 0"; 
	autoSizeWidth = true;
	autoSizeHeight = true;
};

function buildTargetRangeGui()
{
$fmNewTargetRange = $fmDistance;
if(isobject(fmTargetRangeGui)) fmTargetRangeGui.delete();
new GuiControl(fmTargetRangeGui)
	{
	profile = "DlgBackProfile";
	horizSizing = "width";
	vertSizing = "height";
	position = "0 0";
	extent = "640 480";
	minExtent = "8 8";
	visible = "1";
	helpTag = "0";
	new ShellPaneCtrl()
		{
		profile = "ShellDlgPaneProfile";
		horizSizing = "center";
		vertSizing = "center";
		position = "40 142";
		extent = "345 172";
		minExtent = "48 92";
		visible = "1";
		helpTag = "0";
		text = "FIRE MISSION";
		noTitleBar = "0";
		new GuiTextCtrl()
			{
			profile = "ShellMediumTextProfile";
			horizSizing = "center";
			vertSizing = "bottom";
			position = "54 42";
			extent = "345 300";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			text = "Enter RANGE to TARGET.";
			};
		new ShellTextEditCtrl()
			{
			profile = "NewTextEditProfile";
			horizSizing = "center";
			vertSizing = "bottom";
			position = "102 68";
			extent = "102 76";
			minExtent = "32 38";
			visible = "1";
			variable = "$fmNewTargetRange";
         altCommand = "QOnRangeEntered();";
			helpTag = "0";
			historySize = "0";
			maxLength = "1000";
			password = "0";
         accelerator = "return";
			glowOffset = "9 9";
			};
		new ShellBitmapButton()
			{
			profile = "ShellButtonProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "35 117";
			extent = "120 38";
			minExtent = "32 38";
			visible = "1";
			command = "Canvas.popDialog(fmTargetRangeGui);";
         accelerator = "escape";
			helpTag = "0";
			text = "CANCEL";
			simpleStyle = "0";
			};
		new ShellBitmapButton()
			{
			profile = "ShellButtonProfile";
			horizSizing = "right";
			vertSizing = "top";
			position = "190 117";
			extent = "120 38";
			minExtent = "32 38";
			visible = "1";
			command = "QOnRangeEntered();";
			helpTag = "0";
         accelerator = "return";
			text = "OK";
			simpleStyle = "0";
			};
		};
	};
Canvas.pushDialog( fmTargetRangeGui );
}

function buildTargetNameGui()
{
if(isobject(fmTargetNameGui)) fmTargetNameGui.delete();
new GuiControl(fmTargetNameGui)
	{
	profile = "DlgBackProfile";
	horizSizing = "width";
	vertSizing = "height";
	position = "0 0";
	extent = "640 480";
	minExtent = "8 8";
	visible = "1";
	helpTag = "0";
	new ShellPaneCtrl()
		{
		profile = "ShellDlgPaneProfile";
		horizSizing = "center";
		vertSizing = "center";
		position = "147 142";
		extent = "345 172";
		minExtent = "48 92";
		visible = "1";
		helpTag = "0";
		text = "FIRE MISSION";
		noTitleBar = "0";
		new GuiTextCtrl()
			{
			profile = "ShellMediumTextProfile";
			horizSizing = "center";
			vertSizing = "bottom";
			position = "54 42";
			extent = "236 20";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			text = "Please enter Waypoint Name";
			};
		new ShellTextEditCtrl()
			{
			profile = "NewTextEditProfile";
			horizSizing = "center";
			vertSizing = "bottom";
			position = "10 68";
			extent = "138 38";
			minExtent = "32 38";
			visible = "1";
			variable = "$fmGuiFireMissionName";
         altCommand = "Canvas.popDialog(fmTargetNameGui);";
			helpTag = "0";
			historySize = "0";
			maxLength = "64";
			password = "0";
			glowOffset = "9 9";
			};
		new ShellBitmapButton()
			{
			profile = "ShellButtonProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "35 117";
			extent = "120 38";
			minExtent = "32 38";
			visible = "1";
			command = "clearTargetNameGui();";
         accelerator = "escape";
			helpTag = "0";
			text = "CANCEL";
			simpleStyle = "0";
			};
		new ShellBitmapButton()
			{
			profile = "ShellButtonProfile";
			horizSizing = "right";
			vertSizing = "top";
			position = "190 117";
			extent = "120 38";
			minExtent = "32 38";
			visible = "1";
			command = "Canvas.popDialog(fmTargetNameGui);";
			helpTag = "0";
         accelerator = "enter";
			text = "OK";
			simpleStyle = "0";
			};
		};
	};
}
function fmTargetNameGui::onSleep(%this)
{
	fmOnTargetName();
}

function buildFirePosGui()
{
if(isobject(fmFirePosGui)) fmFirePosGui.delete();
$fmFirePosName = $fmClient.namebase @ " ";
new GuiControl(fmFirePosGui)
	{
	profile = "DlgBackProfile";
	horizSizing = "width";
	vertSizing = "height";
	position = "0 0";
	extent = "640 480";
	minExtent = "8 8";
	visible = "1";
	helpTag = "0";
	new ShellPaneCtrl()
		{
		profile = "ShellDlgPaneProfile";
		horizSizing = "center";
		vertSizing = "center";
		position = "147 142";
		extent = "345 172";
		minExtent = "48 92";
		visible = "1";
		helpTag = "0";
		text = "FIRE MISSION";
		noTitleBar = "0";
		new GuiTextCtrl()
			{
			profile = "ShellMediumTextProfile";
			horizSizing = "center";
			vertSizing = "bottom";
			position = "54 42";
			extent = "236 20";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			text = "Please enter a name for this firing position";
			};
		new ShellTextEditCtrl()
			{
			profile = "NewTextEditProfile";
			horizSizing = "center";
			vertSizing = "bottom";
			position = "78 68";
			extent = "190 38";
			minExtent = "32 38";
			visible = "1";
			variable = "$fmFirePosName";
         altCommand = "Canvas.popDialog(fmFirePosGui);";
			helpTag = "0";
			historySize = "0";
			maxLength = "64";
			password = "0";
			glowOffset = "9 9";
			};
		new ShellBitmapButton()
			{
			profile = "ShellButtonProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "35 117";
			extent = "120 38";
			minExtent = "32 38";
			visible = "1";
			command = "fmClearFirePosName(); Canvas.popDialog(fmFirePosGui);";
         accelerator = "escape";
			helpTag = "0";
			text = "CANCEL";
			simpleStyle = "0";
			};
		new ShellBitmapButton()
			{
			profile = "ShellButtonProfile";
			horizSizing = "right";
			vertSizing = "top";
			position = "190 117";
			extent = "120 38";
			minExtent = "32 38";
			visible = "1";
			command = "Canvas.popDialog(fmFirePosGui);";
			helpTag = "0";
			text = "OK";
			simpleStyle = "0";
			};
		};
	};
}
function fmFirePosGui::onSleep(%this)
{
	fmOnFirePosGui();
}

function buildNewOrReplaceGui()
{
if(isobject(NewOrReplaceGui))	NewOrReplaceGui.delete();
new GuiControl(NewOrReplaceGui)
	{
	profile = "DlgBackProfile";
	horizSizing = "width";
	vertSizing = "height";
	position = "0 0";
	extent = "640 480";
	minExtent = "8 8";
	visible = "1";
	helpTag = "0";
	new ShellPaneCtrl()
		{
		profile = "ShellDlgPaneProfile";
		horizSizing = "center";
		vertSizing = "center";
		position = "40 142";
		extent = "405 172";
		minExtent = "48 92";
		visible = "1";
		helpTag = "0";
		text = "NEW FIRE MISSION SET";
		noTitleBar = "0";
		new GuiTextCtrl()
			{
			profile = "ShellMediumTextProfile";
			horizSizing = "center";
			vertSizing = "bottom";
			position = "54 42";
			extent = "345 300";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			text = "Create a new Fire Mission Group?";
			};
		new ShellBitmapButton()
			{
			profile = "ShellButtonProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "18 117";
			extent = "120 38";
			minExtent = "32 38";
			visible = "1";
			command = "fmCreateNewGroup(); Canvas.popDialog(NewOrReplaceGui);";
			helpTag = "0";
         accelerator = "return";
			text = "NEW GROUP";
			simpleStyle = "0";
			};
		new ShellBitmapButton()
			{
			profile = "ShellButtonProfile";
			horizSizing = "right";
			vertSizing = "top";
			position = "144 117";
			extent = "120 38";
			minExtent = "32 38";
			visible = "1";
			command = "fmNewFirePosGui(); Canvas.popDialog(NewOrReplaceGui);";
			helpTag = "0";
			text = "REPLACE GROUP";
			simpleStyle = "0";
			};
		new ShellBitmapButton()
			{
			profile = "ShellButtonProfile";
			horizSizing = "right";
			vertSizing = "top";
			position = "265 117";
			extent = "120 38";
			minExtent = "32 38";
			visible = "1";
			command = "Canvas.popDialog(NewOrReplaceGui);";
			helpTag = "0";
         accelerator = "escape";
			text = "CANCEL";
			simpleStyle = "0";
			};
		};
	};
Canvas.pushDialog(NewOrReplaceGui);
}

new GuiControlProfile ("fmHudProfile") 
{
   opaque = false;
   fillColor = "0 0 0 100";
	fontType = "Univers Condensed";
	fontSize = 16;
	fontColor = "128 128 0 255"; 
	autoSizeWidth = false;
	autoSizeHeight = false;
};

new GuiControlProfile ("fmHudProfile2") 
{
   opaque = false;
   fillColor = "0 0 0 100";
	fontType = "Univers Condensed";
	fontSize = 16;
	fontColor = "0 0 0 255"; 
	autoSizeWidth = false;
	autoSizeHeight = false;
};

function fmStatusCreate()
{
	if(isObject(fmStatusHud))
		fmStatusHud.delete();
	$fmHudXPos = $pref::Qing::fmHudXOffset + (getword($pref::Video::resolution, 0) * 0.07);
	$fmHudYPos = $pref::Qing::fmHudYOffset + (getword($Pref::video::resolution, 1) * 0.6);
	$fmHudPos = $fmHudXPos SPC $fmHudYPos;
	$fmHudObj = new ShellFieldCtrl(fmStatusHud) 
		{
		profile = "fmShadowProfile";
		horizSizing = "center";
		vertSizing = "top";
		position = $fmHudPos;
		extent = "300 300";
		minExtent = "16 18";
		visible = "1";
		helpTag = "0";
		new GuiMLTextCtrl(fmCounterTextField2) 
			{
			profile = "fmHudProfile2";
			horizSizing = "center";
			vertSizing = "top";
			position = "5 5";
			extent = getword($pref::Video::resolution, 0) - $fmHudXPos @ " 800";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "0";
			allowColorChars = "1";
			maxChars = "-1";
			};
		new GuiMLTextCtrl(fmCounterTextField) 
			{
			profile = "fmHudProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "4 4";
			extent = getword($pref::Video::resolution, 0) - $fmHudXPos @ " 800";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "0";
			allowColorChars = "1";
			maxChars = "-1";
			};
		new GuiMLTextCtrl(fmElevTextField2) 
			{
			profile = "fmHudProfile2";
			horizSizing = "center";
			vertSizing = "top";
			position = "5 17";
			extent = getword($pref::Video::resolution, 0) - $fmHudXPos @ " 800";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "0";
			allowColorChars = "1";
			maxChars = "-1";
			};
		new GuiMLTextCtrl(fmElevTextField) 
			{
			profile = "fmHudProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "4 16";
			extent = getword($pref::Video::resolution, 0) - $fmHudXPos @ " 800";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "0";
			allowColorChars = "1";
			maxChars = "-1";
			};
		new GuiMLTextCtrl(fmAzimTextField2) 
			{
			profile = "fmHudProfile2";
			horizSizing = "center";
			vertSizing = "top";
			position = "5 29";
			extent = getword($pref::Video::resolution, 0) - $fmHudXPos @ " 800";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
			};
		new GuiMLTextCtrl(fmAzimTextField) 
			{
			profile = "fmHudProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "4 28";
			extent = getword($pref::Video::resolution, 0) - $fmHudXPos @ " 800";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
			};
		new GuiMLTextCtrl(fmPosTextField2) 
			{
			profile = "fmHudProfile2";
			horizSizing = "center";
			vertSizing = "top";
			position = "5 41";
			extent = getword($pref::Video::resolution, 0) - $fmHudXPos @ " 800";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
			};
		new GuiMLTextCtrl(fmPosTextField) 
			{
			profile = "fmHudProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "4 40";
			extent = getword($pref::Video::resolution, 0) - $fmHudXPos @ " 800";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
			};
		new GuiMLTextCtrl(fmGroupField2)
			{
			profile = "fmHudProfile2";
			horizSizing = "center";
			vertSizing = "top";
			position = "5 53";
			extent = getword($pref::Video::resolution, 0) - $fmHudXPos @ " 800";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
			};
		new GuiMLTextCtrl(fmGroupField) 
			{
			profile = "fmHudProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "4 52";
			extent = getword($pref::Video::resolution, 0) - $fmHudXPos @ " 800";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
			};
		new GuiMLTextCtrl(fmFileNameField2) 
			{
			profile = "fmHudProfile2";
			horizSizing = "center";
			vertSizing = "top";
			position = "5 65";
			extent = getword($pref::Video::resolution, 0) - $fmHudXPos @ " 800";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
			};
		new GuiMLTextCtrl(fmFileNameField) 
			{
			profile = "fmHudProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "4 64";
			extent = getword($pref::Video::resolution, 0) - $fmHudXPos @ " 800";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
			};
		new GuiMLTextCtrl(fmWeapTypeField2) 
			{
			profile = "fmHudProfile2";
			horizSizing = "center";
			vertSizing = "top";
			position = "5 77";
			extent = getword($pref::Video::resolution, 0) - $fmHudXPos @ " 800";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
			};
		new GuiMLTextCtrl(fmWeapTypeField) 
			{
			profile = "fmHudProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "4 76";
			extent = getword($pref::Video::resolution, 0) - $fmHudXPos @ " 800";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
			};
		new GuiMLTextCtrl(fmFireTimeField2) 
			{
			profile = "fmHudProfile2";
			horizSizing = "center";
			vertSizing = "top";
			position = "5 89";
			extent = getword($pref::Video::resolution, 0) - $fmHudXPos @ " 800";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
			};
		new GuiMLTextCtrl(fmFireTimeField) 
			{
			profile = "fmHudProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "4 88";
			extent = getword($pref::Video::resolution, 0) - $fmHudXPos @ " 800";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
			};
		new GuiMLTextCtrl(fmMiscTextField2) 
			{
			profile = "fmHudProfile2";
			horizSizing = "center";
			vertSizing = "top";
			position = "5 101";
			extent = getword($pref::Video::resolution, 0) - $fmHudXPos @ " 800";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
			};
		new GuiMLTextCtrl(fmMiscTextField) 
			{
			profile = "fmHudProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "4 100";
			extent = getword($pref::Video::resolution, 0) - $fmHudXPos @ " 800";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			lineSpacing = "2";
			allowColorChars = "1";
			maxChars = "-1";
			};
		};
	PlayGui.add($fmHudObj);
}

function fmHudUpdate()
{
	if(!isobject(fmStatusHud)) return;
	if($fmHudFadeOut > 0)
		{
		if($fmHudFadeOut < 4)
			{
			fmHudProfile.fontcolor = "128 128 0 255";
			fmHudProfile2.fontcolor = "0 0 0 255";
			$fmHudFontAlpha = 255;
			$fmHudFadeout = 0;
			fmStatusHud.delete();
			return;
			}
		fmHudProfile.fontColor = "128 128 0 " @ $fmHudFadeout;
		fmHudProfile2.fontColor = "0 0 0 " @ $fmHudFadeout;
		$fmHudFontAlpha = $fmHudFadeOut;
		$fmHudFadeOut-= 3;
		fmStatusCreate();
		}
	else
		$fmhudFadeOut = 0;
	$fmHudXPos = getword($pref::Video::resolution, 0) * 0.07;
	$fmHudYPos = getword($Pref::video::resolution, 1) * 0.6;
	$fmHudPos = $fmHudXPos SPC $fmHudYPos;
	if(isobject($fmClient.player))
		{
		%elev = 100 * getword($fmClient.player.geteyevector(), 2);
		%trans = $fmClient.player.gettransform();
		}
	%qposx = getword(%trans,0);
	%qposy = getword(%trans,1);
	%qposz = getword(%trans,2);
	%rot = getword(%trans, 6);

//FIELD 1
	%fmcount = $fmFireMissionCounter ? $fmFireMissionCounter -1 : 0;
	fmCounterTextField.setvalue("FM COUNT: " @ %fmcount @ " of 15");
	fmCounterTExtField2.setvalue("FM COUNT: " @ %fmcount @ " of 15");

//FIELD 2
	if($fmIsHost)
		{
		if(%elev > 70)
			$fmTrajectory = "HIGH TRAJECTORY";
		else
			{
			if(%elev < 66)
				$fmTrajectory = "LOW TRAJECTORY";
			else $fmTrajectory = "LONG RANGE";
			}
		if(fmWeapon() $= "DirectFire")
			%t = "DIRECT FIRE";
		fmElevTextField.setvalue("ELEVATION: " @ %elev @ "%  " @ $fmTrajectory);
		fmElevTextField2.setvalue("ELEVATION: " @ %elev @ "%  " @ $fmTrajectory);
		}
	else
		{
		fmElevTextField.setvalue("");
		fmElevTextField2.setvalue("");
		}

//FIELD 3
	if($fmIsHost)
		{
		fmAzimTextField.setvalue("AZIMUTH: " @ %rot);
		fmAzimTextField2.setvalue("AZIMUTH: " @ %rot);
		}
	else
		{
		fmAzimTextField.setvalue("");
		fmAzimTextField2.setvalue("");
		}

//FIELD 4
	if($fmIsHost)
		{
		fmPosTextField.setvalue("POSITION: X: " @ %qposx SPC "Y: " @ %qposy SPC "Z: " @ %qposz);
		fmPosTextField2.setvalue("POSITION: X: " @ %qposx SPC "Y: " @ %qposy SPC "Z: " @ %qposz);
		}
	else
		{
		fmPosTextField.setvalue("");
		fmPosTextField2.setvalue("");
		}

//FIELD 5
	%group = ($fmFirePosName $= "" ? "NONE" : $fmFirePosName);
	fmGroupField.setvalue("GROUP: " @ %group);
	fmGroupField2.setvalue("GROUP: " @ %group);

//FIELD 6
	if($fmFileName !$= "")
		{
		fmFileNameField.setvalue("FILENAME: " @ getsubstr($fmFileName, 19,strlen($fmFileName) - 25));
		fmFileNameField2.setvalue("FILENAME: " @ getsubstr($fmFileName, 19,strlen($fmFileName) - 25));
		}
	else
		{
		fmFileNameField.setvalue("FILENAME: N/A");
		fmFileNameField2.setvalue("FILENAME: N/A");
		}

//FIELD 7
	fmWeapTypeField.setvalue("WEAPON CLASS:" @ fmWeapon());
	fmWeapTypeField2.setvalue("WEAPON CLASS:" @ fmWeapon());

//FIELD 8
	if($fmIsHost)
		{
		if(!$fmFlightTime)
			{
			%val = mfloor((getsimtime() - $fmCLient.fmFireTime)/100) /10;
			if(strstr(%val, ".") == -1)
				%val = %val @ ".0";
			%val2 = mfloor(VectorDist($fmClient.fmfirepos, $fmClient.fmCamFollowing.position) *10) / 10;
			if(strstr(%val2, ".") == -1)
				%val2 = %val2 @ ".0";
			fmFireTimeField.setvalue("ELAPSED TIME: " @ %val @ "   DISTANCE: " @ %val2);
			fmFireTimeField2.setvalue("ELAPSED TIME: " @ %val @ "   DISTANCE: " @ %val2);
			}
		else
			{
			%val =$fmFlightTime;
			if($fmFLightTime == -1)
				%val = 0;
			if(strstr(%val, ".") == -1)
				%val = %val @ ".0";
			%val2 = mfloor($fmDistance *10) / 10;
			if(strstr(%val2, ".") == -1)
				%val2 = %val2 @ ".0";
			fmFireTimeField.setvalue("ELAPSED TIME: " @ %val @ "  ( " @ $fmLastHit @ " )   RANGE: " @ %val2);
			fmFireTimeField2.setvalue("ELAPSED TIME: " @ %val @ "  ( " @ $fmLastHit @ " )   RANGE: " @ %val2);
			}
		}
	else
		{
		fmFireTimeField.setvalue("");
		fmFireTimeField2.setvalue("");
		}

//FIELD 9

//END
	%advance = ($timeAdvance ? $timeAdvance : 20) / 10;
	schedule(10 * %advance, 0, fmHudUpdate);
}





///////////////////////
//# DATABLOCK DEFINITIONS
function fmDatablocks()
{
	datablock ExplosionData(fmMortarExplosion) : MortarExplosion
		{
   	shakeCamera = 			false;
   	camShakeFreq = 		"0 0 0";
   	camShakeAmp = 			"0 0 0";
   	camShakeDuration = 	0;
   	camShakeRadius = 		0;
		};
	datablock GrenadeProjectileData(fmMortar) : MortarShot
		{
		explosion= "fmMortarExplosion";
		baseEmitter = "GrenadeSmokeEmitter";
		bubbleEmitter = "";
		};

	datablock GrenadeProjectileData(fmTankMortar) : AssaultMortar
		{
		explosion= "fmMortarExplosion";
		baseEmitter = "GrenadeSmokeEmitter";
		bubbleEmitter = "";
		};

}



////////////////
//# FINALIZATION
activatepackage(Qfiremissions);
$fmInstalled = getsimtime();
error("QFireMissions Loaded.");
