//
// fluxVoice.cs
//
// Version:	0.92 [-pLabs- edition]
//
// Date:		12/15/01
// Author:		Flux
// Tweaker:             Smokescreen
//
// This script enables pitch shifting of voice files
//
// Pitchshifting range is constrained by the server-side script
// getValidVoicePitch so the adjustPitch function is used to
// expand back out the pitchshift range before playing.
//
// Unfortunately, this means that players without this script
// will only hear your voice pitchshifted within the constrained
// range set in getValidVoicePitch (ie. .875 - 1.125).
//
// Other players with the fluxVoice script installed will hear
// your voice in it's "correct" pitch with a range of .625 - 1.375.
//
// It also enables you to select any voice you want.

deactivatePackage(fluxVoice);
package fluxVoice{

// create GUI slider
function initializeFluxVoice()
{
	new ShellSliderCtrl(GMW_VoicePitchSlider) {
		profile = "ShellSliderProfile";
		horizSizing = "right";
		vertSizing = "bottom";
		position = "104 215";
		extent = "130 24";
		minExtent = "12 24";
		visible = "1";
		hideCursor = "0";
		bypassHideCursor = "0";
		variable = "value";
		altCommand = "setFluxVoicePitchSlider();";
		helpTag = "0";
		range = "0.000000 2.000000";
		ticks = "1000";
		value = "0.261905";
		usePlusMinus = "1";
	};
					
	new GuiTextCtrl(GMW_VoicePitchLabel) {
		profile = "ShellTextRightProfile";
		horizSizing = "right";
		vertSizing = "bottom";
//		position = "34 188";
		position = "34 218";
		extent = "64 22";
		minExtent = "8 8";
		visible = "1";
		hideCursor = "0";
		bypassHideCursor = "0";
		helpTag = "0";
		text = "Voice Pitch:";
		maxLength = "255";
	};
	

	%obj = GM_WarriorPane.getObject(2);
	
	%obj.add(GMW_VoicePitchLabel);
	%obj.add(GMW_VoicePitchSlider);
	
	
	//GM_WarriorPane.add(GMW_VoicePitchLabel);
	//GM_WarriorPane.add(GMW_VoicePitchSlider);
	

	// Mix and match
	$MaleVoiceName[$MaleVoiceCount] = "Bot";
	$MaleVoiceCount++;
	$MaleVoiceName[$MaleVoiceCount] = "Heroine";
	$MaleVoiceCount++;
	$MaleVoiceName[$MaleVoiceCount] = "Professional";
	$MaleVoiceCount++;
	$MaleVoiceName[$MaleVoiceCount] = "Cadet";
	$MaleVoiceCount++;
	$MaleVoiceName[$MaleVoiceCount] = "Veteran";
	$MaleVoiceCount++;
	$MaleVoiceName[$MaleVoiceCount] = "Amazon";
	$MaleVoiceCount++;
	$MaleVoiceName[$MaleVoiceCount] = "Warrior";
	$MaleVoiceCount++;
	$MaleVoiceName[$MaleVoiceCount] = "Monster";
	$MaleVoiceCount++;
	$MaleVoiceName[$MaleVoiceCount] = "Predator";
	$MaleVoiceCount++;

	$FemaleVoiceName[$FemaleVoiceCount] = "Bot";
	$FemaleVoiceCount++;
	$FemaleVoiceName[$FemaleVoiceCount] = "Hero";
	$FemaleVoiceCount++;
	$FemaleVoiceName[$FemaleVoiceCount] = "Iceman";
	$FemaleVoiceCount++;
	$FemaleVoiceName[$FemaleVoiceCount] = "Rogue";
	$FemaleVoiceCount++;
	$FemaleVoiceName[$FemaleVoiceCount] = "Hardcase";
	$FemaleVoiceCount++;
	$FemaleVoiceName[$FemaleVoiceCount] = "Psycho";
	$FemaleVoiceCount++;
	$FemaleVoiceName[$FemaleVoiceCount] = "Warrior";
	$FemaleVoiceCount++;
	$FemaleVoiceName[$FemaleVoiceCount] = "Monster";
	$FemaleVoiceCount++;
	$FemaleVoiceName[$FemaleVoiceCount] = "Predator";
	$FemaleVoiceCount++;
	
	$DermVoiceName[$DermVoiceCount] = "Bot";
	$DermVoiceCount++;
        $DermVoiceName[$DermVoiceCount] = "Hero";
        $DermVoiceCount++;
        $DermVoiceName[$DermVoiceCount] = "Iceman";
        $DermVoiceCount++;
        $DermVoiceName[$DermVoiceCount] = "Rogue";
        $DermVoiceCount++;
        $DermVoiceName[$DermVoiceCount] = "Hardcase";
        $DermVoiceCount++;
        $DermVoiceName[$DermVoiceCount] = "Psycho";
        $DermVoiceCount++;
        $DermVoiceName[$DermVoiceCount] = "Heroine";
        $DermVoiceCount++;
        $DermVoiceName[$DermVoiceCount] = "Professional";
        $DermVoiceCount++;
        $DermVoiceName[$DermVoiceCount] = "Cadet";
        $DermVoiceCount++;
        $DermVoiceName[$DermVoiceCount] = "Veteran";
        $DermVoiceCount++;
        $DermVoiceName[$DermVoiceCount] = "Amazon";
        $DermVoiceCount++;

}



//return adjusted pitch
function adjustPitch(%pitch){
	%weight = 3;
	
	%pitch = 1.0 + ((%pitch-1)*%weight);
	
	return %pitch;
}

function clientCmdChatMessage(%sender, %voice, %pitch, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10)
{
	%pitch = adjustPitch(%pitch);
	
	parent::clientCmdChatMessage(%sender, %voice, %pitch, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10);
}

// set voice pitch slider when opening WarriorPanel
function GMW_WarriorPopup::onSelect( %this, %id, %text )
{
		
	parent::onSelect( %this, %id, %text );
	
	// set voicepitch slider
	%voicePitch = getField( $pref::Player[%id], 4)+1;
	GMW_VoicePitchSlider.setValue(%voicePitch);	

        // Select the voice:
	GMW_VoicePopup.setSelected( $Pref::GMW_VoicePopupprev );
	
	
}


//------------------------------------------------------------------------------
function GMW_VoicePopup::onSelect( %this, %id, %text )
{
        $Pref::GMW_VoicePopupprev = %id;
        %id++;
	switch ( GMW_RaceGenderPopup.getSelected() )
	{
		case 0: 
                   %base = "Male";
                   if (%id > 5) {
                     %id -= 5;
                     %base = "Bot";
                     if (%id > 1) {
                       %id -= 1;
                       %base = "Fem";
                       if (%id > 5) {
                         %id -= 5;
                         %base = "Derm";
                       }
                     }
                   }
		case 1: 
                   %base = "Fem";
                   if (%id > 5) {
                     %id -= 5;
                     %base = "Bot";
                     if (%id > 1) {
                       %id -= 1;
                       %base = "Male";
                       if (%id > 5) {
                         %id -= 5;
                         %base = "Derm";
                       }
                     }
                   }
		case 2: 
                   %base = "Derm";
                   if (%id > 3) {
                     %id -= 3;
                     %base = "Bot";
                     if (%id > 1) {
                       %id -= 1;
                       %base = "Male";
                       if (%id > 5) {
                         %id -= 5;
                         %base = "Fem";
                       }
                     }
                   }
	}
	$pref::Player[$pref::Player::Current] = setField( $pref::Player[$pref::Player::Current], 3, %base @ %id );
}

//callback command from voice slider
function setFluxVoicePitchSlider()
{
	// Update the player pref:
	$pref::Player[$pref::Player::Current] = setField( $pref::Player[$pref::Player::Current], 4, GMW_VoicePitchSlider.getValue()-1);
}

function GMW_VoicePopup::test( %this )
{

	//GMW_VoiceTestBtn.setActive( false );
	%id = %this.getSelected() + 1;
	switch ( GMW_RaceGenderPopup.getSelected() )
	{
		case 0: 
                   %base = "Male";
                   if (%id > 5) {
                     %id -= 5;
                     %base = "Bot";
                     if (%id > 1) {
                       %id -= 1;
                       %base = "Fem";
                       if (%id > 5) {
                         %id -= 5;
                         %base = "Derm";
                       }
                     }
                   }
		case 1: 
                   %base = "Fem";
                   if (%id > 5) {
                     %id -= 5;
                     %base = "Bot";
                     if (%id > 1) {
                       %id -= 1;
                       %base = "Male";
                       if (%id > 5) {
                         %id -= 5;
                         %base = "Derm";
                       }
                     }
                   }
		case 2: 
                   %base = "Derm";
                   if (%id > 3) {
                     %id -= 3;
                     %base = "Bot";
                     if (%id > 1) {
                       %id -= 1;
                       %base = "Male";
                       if (%id > 5) {
                         %id -= 5;
                         %base = "Fem";
                       }
                     }
                   }

	}
        %serch = "audio/voice/" @ %base @ %id @ "/*.wav";
        %q = getRandom(1,140);
        for(%x=0;%x<%q;%x++) %wav = findNextFile(%serch);

	if (%wav $= "") %wav = findFirstFile(%serch);
        %wav = getSubStr( %wav, 6, strlen(%wav) - 6 );

  	%handle = alxCreateSource( AudioGui, %wav );

   	//read slider pitch
   	%pitchSliderVal = GMW_VoicePitchSlider.getValue()-1;
   
   	//convert slider pitch into server valid pitch
   	%pitch = getValidVoicePitch(%id, %pitchSliderVal);
   
	//adjust valid pitch to wider range
	%pitch = adjustPitch(%pitch);
   
	//preview the voice
	if (%pitch != 1.0)
	  alxSourcef(%handle, "AL_PITCH", %pitch);

	alxStop( $testTone );
	$testTone = alxPlay( %handle );

	//%delay = alxGetWaveLen( %wav );
	//schedule( %delay, 0, "restoreVoiceTestButton" );

}

function DispatchLaunchMode()
{
	initializeFluxVoice();
	parent::DispatchLaunchMode();
}

};

activatePackage(fluxVoice);


