echo("FightingWarmup");

// AI vars

$AI_Names[0] = "GotM*lk?";
$AI_Names[1] = "Slacker";
$AI_Names[2] = "Bob";
$AI_Names[3] = "Cornboy!";
$AI_Names[4] = "SymLink";
$AI_Names[5] = "Skeet";
$AI_Names[6] = "Jett";
$AI_Names[7] = "Sne/\\keR";
$AI_Names[8] = "DiamondBack";
$AI_Names[9] = "Nailz";
$AI_Names[10] = "Hak|Hakuryu";
$AI_Names[11] = "UberBob";
$AI_Names[12] = "Ski to Die";
$AI_Names[13] = "Sebirt";
$AI_Names[14] = "Thulsa Doom";
$AI_Names[15] = "MotoMan";

$armors[0] = "larmor";
$armors[1] = "marmor";
$armors[2] = "harmor";

$weapons[0] = "blaster";
$weapons[1] = "plasmagun";
$weapons[2] = "disclauncher";
$weapons[3] = "grenadelauncher";
$weapons[4] = "mortar";
$weapons[5] = "laserrifle";

$percentage[0] = 0.06;
$percentage[1] = 0.05;
$percentage[2] = 0.03;
$percentage[3] = 0.02;
$percentage[4] = 0.03;
$percentage[5] = 0.01;

$NW[0] = "disclauncher";
$NW[1] = "grenadelauncher";
$NWA[0] = "discammo";
$NWA[1] = "grenadeammo";

// player vars

$plasmaammo = 0;
$discammo = 1;
$grenadeammo = 2;
$mortarammo = 3;
$chaingunammo = 4;
$grenade = 5;
$mine = 6;

$repairkits = 0;
$deaths = 0;

// game vars

$ItemMax[larmor, SensorJammerPack] = 0;
$ItemMax[larmor, MotionSensorPack] = 0;
$ItemMax[larmor, PulseSensorPack] = 0;
$ItemMax[larmor, DeployableSensorJammerPack] = 0;
$ItemMax[larmor, CameraPack] = 0;
$ItemMax[larmor, TurretPack] = 0;
$ItemMax[larmor, DeployableInvPack] = 0;
$ItemMax[larmor, DeployableAmmoPack] = 0;

$ItemMax[marmor, SensorJammerPack] = 0;
$ItemMax[marmor, MotionSensorPack] = 0;
$ItemMax[marmor, PulseSensorPack] = 0;
$ItemMax[marmor, DeployableSensorJammerPack] = 0;
$ItemMax[marmor, CameraPack] = 0;
$ItemMax[marmor, TurretPack] = 0;
$ItemMax[marmor, DeployableInvPack] = 0;
$ItemMax[marmor, DeployableAmmoPack] = 0;

$ItemMax[harmor, SensorJammerPack] = 0;
$ItemMax[harmor, MotionSensorPack] = 0;
$ItemMax[harmor, PulseSensorPack] = 0;
$ItemMax[harmor, DeployableSensorJammerPack] = 0;
$ItemMax[harmor, CameraPack] = 0;
$ItemMax[harmor, TurretPack] = 0;
$ItemMax[harmor, DeployableInvPack] = 0;
$ItemMax[harmor, DeployableAmmoPack] = 0;

$larmorBonus = 0;
$marmorBonus = 10;
$harmorBonus = 15;
$npackBonus = 15;
$epackBonus = 0;
$rpackBonus = 5;
$spackBonus = 5;
$apackBonus = 5;
$deathBonus = -10;
$ruBonus = -5;
$TimeBonus = 100;
$lbotBonus = 2;
$mbotBonus = 4;
$hbotBonus = 6;

// Code

function ObjectiveScreen() {
	Training::displayBitmap(0);
	Team::setObjective(0, 1, "<f1><jc>UTTC Warmup Practice.\n");
	Team::setObjective(0, 2, "\n");
	Team::setObjective(0, 3, "<f1>Follow the waypoints to the individual towers, and destroy all bots in your way.\n");
	Team::setObjective(0, 4, "<f1>     -You must land in the towers to start the next sequence, and that sequence cannot be started unless you destroy all of a previous towers bots.\n");
	Team::setObjective(0, 5, "<f1>     -You can only use the inventory station once, supplies such as ammo appear in towers and platforms along the way.\n");
	Team::setObjective(0, 6, "<f1>     -When you die, you respawn in your current armor/pack/weapon configuration.\n");
	Team::setObjective(0, 7, "\n");
	Team::setObjective(0, 8, "\n");
	Team::setObjective(0, 9, "<f1>Your performance is judged by kills and other items.\n");
	Team::setObjective(0, 10, "<f1>Also, depending on the armor and equipment you use, a difficulty bonus is awarded.\n");
	Team::setObjective(0, 11, "<f1>The bonuses are as follows :\n");
	Team::setObjective(0, 12, "<f1>Armors\n");
	Team::setObjective(0, 13, "     Light Armor = " @ $larmorBonus @ "%\n");
	Team::setObjective(0, 14, "     Medium Armor = " @ $marmorBonus @ "%\n");
	Team::setObjective(0, 15, "     Heavy Armor = " @ $harmorBonus @ "%\n");
	Team::setObjective(0, 16, "<f1>Packs\n");
	Team::setObjective(0, 17, "     No Pack = " @ $npackBonus @ "%\n");
	Team::setObjective(0, 18, "     Energy Pack = " @ $epackBonus @ "%\n");
	Team::setObjective(0, 19, "     Repair Pack = " @ $rpackBonus @ "%\n");
	Team::setObjective(0, 20, "     Shield Pack = " @ $spackBonus @ "%\n");
	Team::setObjective(0, 21, "     Ammo Pack = " @ $apackBonus @ "%\n");
	Team::setObjective(0, 22, "<f1>Other Bonuses\n");
	Team::setObjective(0, 23, "     Time Spent = " @ $TimeBonus @ " per minute left below 30 minutes.\n");
	Team::setObjective(0, 24, "     Light bot kill = " @ $lbotBonus @ "\n");
	Team::setObjective(0, 25, "     Medium bot kill = " @ $mbotBonus @ "\n");
	Team::setObjective(0, 26, "     Heavy bot kill = " @ $hbotBonus @ "\n");
	Team::setObjective(0, 27, "<f1>Penalties\n");
	Team::setObjective(0, 28, "     Deaths = " @ $deathBonus @ "\n");
	Team::setObjective(0, 29, "     RepairKits Used = " @ $ruBonus @ "\n");
	Team::setObjective(0, 30, "\n");
	Team::setObjective(0, 31, "<f1><jc>by James C. Vetsch aka Hak|Hakuryu of the Hakkenden");
	Team::setObjective(0, 32, "<f1><jc>http://planetstarsiege.com/balance");
}

function missionSummary() {   
   	Training::displayBitmap(0);
 	Team::setObjective(0, 1, "<f5><jc>Map by James C. Vetsch aka Hak|Hakuryu");
   	Team::setObjective(0, 2, "<f1><jc>visit www.planetstarsiege.com/balance for other maps");
  	Team::setObjective(0, 3, "\n");
   	Team::setObjective(0, 4, "<f5><jl>Mission Information:");
   	Team::setObjective(0, 5, "<f1><t>   -Mission Name: UTTC Warmup 1");
   	Team::setObjective(0, 6, "\n");
   	Team::setObjective(0, 7, "<f5><j1>Mission Summary:");
   	Team::setObjective(0, 8, "\n");
	Team::setObjective(0, 9, "<f1>     Points");
	Team::setObjective(0, 10, "Time taken : " @ $CourseMinutes @ " minutes and " @ $CourseSeconds @ " seconds.");
   	Team::setObjective(0, 11, "Light Bots Killed = " @ $lbotsKilled);
   	Team::setObjective(0, 12, "Medium Bots Killed = " @ $mbotsKilled);
   	Team::setObjective(0, 13, "Heavy Bots Killed = " @ $hbotsKilled);
   	Team::setObjective(0, 14, "     Total Points = " @ $Points);
   	Team::setObjective(0, 15, "\n");
   	Team::setObjective(0, 16, "<f1>     Negative Points");
   	Team::setObjective(0, 17, "Deaths = " @ $Deaths);
   	Team::setObjective(0, 18, "RepairKits Used = " @ $repairkits);
   	Team::setObjective(0, 19, "     Total Negative Points = " @ $NegPoints);
   	Team::setObjective(0, 20, "\n");
   	Team::setObjective(0, 21, "<f1>     Difficulty Bonus");
	Team::setObjective(0, 22, "Armor bonus = " @ $Armor @ " - " @ $aBonus @ "%");
   	Team::setObjective(0, 23, "Pack bonus = " @ $Pack @ " - " @ $pBonus @ "%");
	Team::setObjective(0, 24, "\n");
	Team::setObjective(0, 25, "     TOTAL POINTS = " @ $TotalPoints);
	Team::setObjective(0, 26, "\n");
	Team::setObjective(0, 27, "\n");
	Team::setObjective(0, 28, "\n");
	Team::setObjective(0, 29, "\n");
	Team::setObjective(0, 30, "\n");
	Team::setObjective(0, 31, "\n");
	Team::setObjective(0, 32, "\n");
}

function Mission::Init() {
	%group = nameToID("MissionGroup/Teams/Team0/Towers/Markers");
	if(%group != -1) {
		echo("Markers found");
		for(%i=0;(%obj = group::getObject(%group,%i)) != -1;%i++) {
			%pos = GameBase::getPosition(%obj);
			$Markers[%i,0] = getword(%pos,0);
			$Markers[%i,1] = getword(%pos,1);
		}
	}
	ObjectiveScreen();
	$CountFlag = 0;
}

function Game::initialMissionDrop(%clientId)
{
	GameBase::setTeam(2049, 0);
  	Client::setGuiMode(2049, $GuiModePlay);
	Game::playerSpawn(2049, false);
  	schedule("bottomprint(" @ %clientId @ ", \"<f1><jc>UTTC Warm Up Mission 1 - Dueling.\", 5);", 0);
  	schedule("messageAll(0, \"~wshell_click.wav\");", 0);
  	schedule("bottomprint(" @ %clientId @ ", \"<f1><jc>You can only use the inventory station once, and not all items are available!\", 5);", 5);
  	schedule("messageAll(0, \"~wshell_click.wav\");", 5);
  	schedule("bottomprint(" @ %clientId @ ", \"<f1><jc>Move to and land in each tower to start the next sequence.\", 5);", 10);
  	schedule("messageAll(0, \"~wshell_click.wav\");", 10);
  	schedule("bottomprint(" @ %clientId @ ", \"<f1><jc>Ammo can be found on dead bots, or in towers or platforms along the way.\", 5);", 15);
  	schedule("messageAll(0, \"~wshell_click.wav\");", 15);
  	schedule("bottomprint(" @ %clientId @ ", \"<f1><jc>Bring up The Objectives screen for a gameplay description.\", 5);", 20);
  	schedule("messageAll(0, \"~wshell_click.wav\");", 20);   
	$Towers = 0;
	$lbotsKilled=0;
	$mbotsKilled=0;
	$hbotsKilled=0;
	$InvFlag=0;
	$CourseStartTime = getSimTime(); 
}

function EndCourse() {
	%time =getSimTime() - $CourseStartTime;
	if(%time < 0)
		%time *= -1;
	$CourseMinutes=Time::getMinutes(%time);
	if($CourseMinutes < 30) 
		$CourseMinutesToScore = 30 - $CourseMinutes;
	else
		$CourseMinutesToScore = 0;
	$CourseSeconds=%time - $CourseMinutes * 60;
	$Points = ($lbotsKilled * lbotBonus) + ($mbotsKilled * $mbotBonus) + ($hbotsKilled * $hbotBonus) + ($CourseMinutesToScore * $TimeBonus);
	$NegPoints = ($Deaths * $deathBonus) + ($repairkits * $ruBonus);
	$SubTotal = $Points + $NegPoints;
	%armor = Player::getArmor(2049);
	if(%armor == larmor)
		$aBonus = $larmorBonus;
	else if(%armor == marmor)
		$aBonus = $marmorBonus;
	else
		$aBonus = $harmorBonus;
	$aBonusTotal = ($aBonus * 0.01) * $SubTotal;
	%pack = Player::getMountedItem(2049,$BackPackSlot);
	if(%pack == -1)
		$pBonus = $nPackBonus;
	else if(%pack == energypack)
		$pBonus = $ePackBonus;
	else if(%pack == repairpack)
		$pBonus = $rPackBonus;
	else if(%pack == shieldpack)
		$pBonus = $sPackBonus;
	else
		$pBonus = $aPackBonus;
	$pBonusTotal = ($pBonus * 0.01) * $SubTotal;
	$TotalPoints = $SubTotal + $aBonusTotal + $pBonusTotal;
	Training::MissionComplete(2049);
}

function Training::missionComplete(%cl) {
  
  schedule("Client::setGuiMode(" @ %cl @ ", " @ $GuiModeObjectives @ ");", 3);
  missionSummary();
  remoteEval(2049, TrainingEndMission);
}

function remoteTrainingEndMission() {
   schedule("EndGame();", 16);
}

function Game::playerSpawned(%pl, %clientId, %armor) {						  
	Player::setItemCount(2049,$Pack,1);
	Player::setItemCount(2049,repairkit,1);
	Player::setItemCount(2049,mineammo,$ItemMax[%armor,mineammo]);
	Player::setItemCount(2049,grenade,$ItemMax[%armor,grenade]);
	Player::mountItem(2049,$Pack,$BackPackSlot);
	Player::setArmor(2049,$Armor);
	setNextWP($Towers);
	if($blas) {
		Player::setItemCount(2049,blaster,1);
	}
	if($lase) {
		Player::setItemCount(2049,laserrifle,1);
	}
	if($plas) {
		Player::setItemCount(2049,plasmagun,1);
		Player::setItemCount(2049,plasmaammo,$ItemMax[$Armor,plasmaammo]);
	}
	if($disc) {
		Player::setItemCount(2049,disclauncher,1);
		Player::setItemCount(2049,discammo,$ItemMax[$Armor,discammo]);
	}
	if($gren) {
		Player::setItemCount(2049,grenadelauncher,1);
		Player::setItemCount(2049,grenadeammo,$ItemMax[$Armor,grenadeammo]);
	}
	if($mort) {
		Player::setItemCount(2049,mortar,1);
		Player::setItemCount(2049,mortarammo,$ItemMax[$Armor,mortarammo]);
	}
	if($chai) {
		Player::setItemCount(2049,chaingun,1);
		Player::setItemCount(2049,bulletammo,$ItemMax[$Armor,bulletammo]);
	}
} 

function getCounts() {
	$Pack = Player::getMountedItem(2049,$BackpackSlot);
	$Armor = Player::getArmor(2049);
	// current weapons
	$blas = Player::getItemCount(2049,blaster);
	$lase = Player::getItemCount(2049,laserrifle);
	$plas = Player::getItemCount(2049,plasmagun);
	$disc = Player::getItemCount(2049,disclauncher);
	$gren = Player::getItemCount(2049,grenadelauncher);
	$mort = Player::getItemCount(2049,mortar);
	$chai = Player::getItemCount(2049,chaingun);
	$CountFlag = 1;
}

function setNextWP(%num) {
	if(%num != 0)
		issueCommand(2049, 2049, 0, "Waypoint set to next tower.~wgoway", $Markers[%num,0], $Markers[%num,1]);
}

function GroupTrigger::onContact(%this,%object) {
	%type = getObjectType(%object);
	if(%type == "Player") {
		%name = object::getName(%this); 
		if(%name=="Tower1Trig" && $Towers==0) {
			CreateAITargets(1,4);
			$BotsLeft = 4;
			getCounts();
			setNextWP(1);
		}
		if(%name=="Tower2Trig" && $Towers==1) {
			if(CheckBotsLeft()) {
				CreateAITargets(2,4);
				$BotsLeft = 4;
				setNextWP(2);
			}
			else
				return;
		}
		if(%name=="Tower3Trig" && $Towers==2) {
			if(CheckBotsLeft()) {
				CreateAITargets(3,4);
				$BotsLeft = 4;
				setNextWP(3);
			}
			else
				return;
		}
		if(%name=="Tower4Trig" && $Towers==3) {
			if(CheckBotsLeft()) {
				CreateAITargets(4,4);
				$BotsLeft = 4;
				setNextWP(4);
			}
			else
				return;
		}
		if(%name=="Tower5Trig" && $Towers==4) {
			if(CheckBotsLeft()) {
				CreateAITargets(5,5);
				$BotsLeft = 5;
				setNextWP(5);
			}
			else
				return;
		}
		if(%name=="Tower6Trig" && $Towers==5) {
			if(CheckBotsLeft()) {
				CreateAITargets(6,5);
				$BotsLeft = 5;
				setNextWP(6);
			}
			else
				return;
		}
		if(%name=="Tower7Trig" && $Towers==6) {
			if(CheckBotsLeft()) {
				CreateAITargets(7,6);
				$BotsLeft = 6;
				setNextWP(7);
			}
			else
				return;
		}
		if(%name=="Tower8Trig" && $Towers==7) {
			if(CheckBotsLeft())
				EndCourse();
			else
				return;
		}
	}
}

function CheckBotsLeft() {
	if($BotsLeft) {
		Bottomprint(2049,"You still have " @ $BotsLeft @ " bots to kill from the last tower.",5);
		return false;
	}
	return true;
}	

function CreateAITargets(%tower,%num) {
	%group = "MissionGroup\\Teams\\Team0\\Towers\\Tower" @ %tower;
	//must have more names than %num
	%sname = floor(getrandom() * (15-%num));
	for(%i=0;%i<%num;%i++) {
		$names[%i] = %sname + %i;
	}	
	for(%k=0;%k < %num;%k++) {
		%AIname = $AI_Names[$names[%k]];
		%armor = floor(getRandom()*3);
		if(%armor==0)
			%weapon = floor(getrandom()*6);
		else if(%armor==1)
			%weapon = floor(getrandom()*4);
		else
			%weapon = floor(getrandom()*5);
		if(%weapon == 4 && %armor==0)
			%weapon = 5;
		createAI(%AIname, %group @ "\\guard" @ %k, $armors[%armor], %AIname);
        	%aiId = AI::getId(%AIname);
		%aiObj = client::getOwnedObject(%aiId);	
         	GameBase::setTeam(%aiId, 1);
		AI::SetVar( %AIname, triggerPct, $percentage[%weapon]);
         	AI::setVar( %AIname,  iq,  60 );
         	AI::setVar( %AIname,  attackMode, 1);
		AI::setVar( %AIname,  pathType, 0);
         	AI::DirectiveTarget(%AIname, 2049);
		player::setItemCount(%aiId,$weapons[%weapon],1);
		player::mountItem(%aiId,$weapons[%weapon],0);
		%aiObj.normalWeapon = $weapons[%weapon];
		if(%weapon==1)
			player::setItemCount(%aiId,plasmaammo,40);
		if(%weapon==2)
			player::setItemCount(%aiId,discammo,30);
		if(%weapon==3)
			player::setItemCount(%aiId,grenadeammo,30);
		if(%weapon==4)
			player::setItemCount(%aiId,mortarammo,30);
		if(%weapon < 2 || %weapon > 4) {
			%n = floor(getrandom()*2);
			Player::setItemCount(%aiId,$NW[%n],1);
			Player::setItemCount(%aiId,$NWA[%n],30);
			%aiObj.flyingWeapon = $NW[%n];
		}
		else {
			%aiObj.flyingWeapon = %aiObj.normalWeapon;
		}
		%aiObj.lastFlightTime = getsimtime()-7;
	}
	$Towers = %tower;
}

// hacks for flying, when ai hits ground and is damaged, set flying = 0
// doesn't always get damaged for hitting ground, and no terrain::oncollision so...
// lastflighttime used, seems to work right, no double flights with bots in the hemisphere so far
// but problem with switching back to normal weapon, if no damage....

function AI::onTargetLOSAcquired(%aiName, %idNum) {
	echo("target aquired");
	%aiId = AI::getId(%aiName);
	%aiObj = client::getOwnedObject(%aiId);
	%armor = player::getArmor(%aiObj);
	if(%armor == "larmor")
		%add = 0;
	if(%armor == "marmor")
		%add = 150;
	if(%armor == "harmor")
		%add = 300;
	%now = getsimtime();
	%timeDif = %now - %aiObj.lastFlightTime;
	if(%timeDif < 0)
		%timeDif *= -1;
	//%aiObj.flying != 1 && 
	%aiObj.targetLock = 1;
	if(%timeDif >= 5) {
		if(%aiObj.normalWeapon != %aiObj.flyingWeapon)
			player::mountItem(%aiId,%aiObj.flyingWeapon,0);
		%jump = Vector::getFromRot(Gamebase::getRotation(%aiId), 50, 400 + %add);
		Player::applyImpulse(%aiId, %jump);
		%aiObj.flying = 1;
		%aiObj.lastFlightTime = getsimtime();
	}
	else
		player::mountItem(%aiId,%aiObj.normalWeapon,0);
	schedule("CheckForRandomJump(" @ %aiId @ "," @ %aiObj @ "," @ %add @ ");",7);
	
}

function CheckForRandomJump(%aiID,%aiObj,%add) {
	if(player::isDead(%aiObj))
		return;
	echo("tl = " @ %aiobj.targetlock @ " , flying = " @ %aiObj.flying);
	%now = getsimtime();
	%timeDif = %now - %aiObj.lastFlightTime;
	if(%timeDif < 0)
		%timeDif *= -1;
	// && %aiObj.flying == 0
	if(%aiObj.targetLock) {
		if(%timeDif >=5) {
			%length = floor(getRandom() * 80);
			if(%length < 30)
				%length = 30;
			%zheight = floor(getRandom() * 500);
			if(%zheight < 200)
				%zheight = 200;
			if(%aiObj.normalWeapon != %aiObj.flyingWeapon)
				player::mountItem(%aiId,%aiObj.flyingWeapon,0);
			%jump = Vector::getFromRot(Gamebase::getRotation(%aiId), %length, %zheight + %add);
			Player::applyImpulse(%aiId, %jump);
			%aiObj.flying = 1;
			%aiObj.lastFlightTime = getsimtime();	
		}
		else
			player::mountItem(%aiId,%aiObj.normalWeapon,0);
		%time = floor(getrandom()*12);
		if(%time < 7)
			%time = 7;
		schedule("CheckForRandomJump(" @ %aiId @ "," @ %aiObj @ "," @ %add @ ");",%time);	
	}
}

function AI::onTargetLOSLost(%aiName, %idNum) {
	echo("target lost");
	%aiId = AI::getId(%aiName);
	%aiObj = client::getOwnedObject(%aiId);
	%aiObj.targetLock = 0;
}

function AI::onTargetLOSRegained(%aiName, %idNum) {
	echo("target regained");
	%aiId = AI::getId(%aiName);
	%aiObj = client::getOwnedObject(%aiId);
	%armor = player::getArmor(%aiObj);
	if(%armor == "larmor")
		%add = 0;
	if(%armor == "marmor")
		%add = 200;
	if(%armor == "harmor")
		%add = 400;
	%now = getsimtime();
	%timeDif = %now - %aiObj.lastFlightTime;
	if(%timeDif < 0)
		%timeDif *= -1;
	//%aiObj.flying != 1 && 
	%aiObj.targetLock = 1;
	if(%timeDif >=5) {
		if(%aiObj.normalWeapon != %aiObj.flyingWeapon)
			player::mountItem(%aiId,%aiObj.flyingWeapon,0);
		%jump = Vector::getFromRot(Gamebase::getRotation(%aiId), 50, 400 + %add);
		Player::applyImpulse(%aiId, %jump);
		%aiObj.flying = 1;
		%aiObj.lastFlightTime = getsimtime();
	}
	else
		player::mountItem(%aiId,%aiObj.normalWeapon,0);
	schedule("CheckForRandomJump(" @ %aiId @ "," @ %aiObj @ "," @ %add @ ");",7);
}

function AI::setWeapons(%aiName) {	
	echo("bypassed setWeapons");
}

function AI::setupAI(%key, %team){
	echo("bypassed setupAI");
}

function AI::onDroneKilled(%aiName)
{
   	$BotsLeft -= 1;
	if($BotsLeft)
		Client::sendMessage(2049,0,"You killed " @ %aiName @ ". Only " @ $BotsLeft @ " bots left.");
	else
		Client::sendMessage(2049,0,"You killed " @ %aiName @ ". Proceed to the next tower.");
	if(%aiName == "Hak|Hakuryu")
		Client::sendMessage(2049,0,"Good luck in a real game! :\)");
}

function RepairKit::onUse(%player,%item)
{
	Player::decItemCount(%player,%item);
	GameBase::repairDamage(%player,0.2);
	$repairkits +=1;
}

function Game::pickRandomSpawn(%team)
{
	$deaths +=1;
   	%group = nameToID("MissionGroup/Teams/team0/Towers/Tower" @ $Towers @ "/droppoints");
   	echo("group = " @ %group);
	%count = Group::objectCount(%group);
  	if(!%count)
      	return -1;
  	%spawnIdx = floor(getRandom() * (%count - 0.1));
  	%value = %count;
	for(%i = %spawnIdx; %i < %value; %i++) {
		%set = newObject("set",SimSet);
		%obj = Group::getObject(%group, %i);
		if(containerBoxFillSet(%set,$SimPlayerObjectType|$VehicleObjectType,GameBase::getPosition(%obj),2,2,4,0) == 0) {
			deleteObject(%set);
			return %obj;		
		}
		if(%i == %count - 1) {
			%i = -1;
			%value = %spawnIdx;
		}
		deleteObject(%set);
	}
   return false;
}

function Player::onDamage(%this,%type,%value,%pos,%vec,%mom,%vertPos,%quadrant,%object)
{
	if($CountFlag == 0)
		getCounts();
	if (Player::isExposed(%this)) {
      	%damagedClient = Player::getClient(%this);
     	 %shooterClient = %object;
	
	if(%type == $LandingDamageType && Player::isAIControlled(%this)) {
		%this.flying = 0;
		echo("falling damage");
		if(%this.normalWeapon != %this.flyingWeapon) {
			player::mountItem(%this,%this.normalWeapon,0);
		}
		return;
	}
	Player::applyImpulse(%this,%mom);
	if($teamplay && %damagedClient != %shooterClient && Client::getTeam(%damagedClient) == Client::getTeam(%shooterClient) ) {
		if (%shooterClient != -1) {
			%curTime = getSimTime();
			if ((%curTime - %this.DamageTime > 3.5 || %this.LastHarm != %shooterClient) && %damagedClient != %shooterClient && $Server::TeamDamageScale > 0) {
				if(%type != $MineDamageType) {
					Client::sendMessage(%shooterClient,0,"You just harmed Teammate " @ Client::getName(%damagedClient) @ "!");
					Client::sendMessage(%damagedClient,0,"You took Friendly Fire from " @ Client::getName(%shooterClient) @ "!");
				}
				else {
					Client::sendMessage(%shooterClient,0,"You just harmed Teammate " @ Client::getName(%damagedClient) @ " with your mine!");
					Client::sendMessage(%damagedClient,0,"You just stepped on Teamate " @ Client::getName(%shooterClient) @ "'s mine!");
				}
				%this.LastHarm = %shooterClient;
				%this.DamageStamp = %curTime;
			}
		}
		%friendFire = $Server::TeamDamageScale;
	}
	else if(%type == $ImpactDamageType && Client::getTeam(%object.clLastMount) == Client::getTeam(%damagedClient)) 
		%friendFire = $Server::TeamDamageScale;
	else  
		%friendFire = 1.0;	

	if (!Player::isDead(%this)) {
		%armor = Player::getArmor(%this);
		//More damage applyed to head shots
		if(%vertPos == "head" && %type == $LaserDamageType) {
			if(%armor == "harmor") { 
				if(%quadrant == "middle_back" || %quadrant == "middle_front" || %quadrant == "middle_middle") {
					%value += (%value * 0.3);
				}
			}
			else {
				%value += (%value * 0.3);
			}
		}
		//If Shield Pack is on
		if (%type != -1 && %this.shieldStrength) {
			%energy = GameBase::getEnergy(%this);
			%strength = %this.shieldStrength;
			if (%type == $ShrapnelDamageType || %type == $MortarDamageType)
				%strength *= 0.75;
			%absorb = %energy * %strength;
			if (%value < %absorb) {
				GameBase::setEnergy(%this,%energy - ((%value / %strength)*%friendFire));
				%thisPos = getBoxCenter(%this);
				%offsetZ =((getWord(%pos,2))-(getWord(%thisPos,2)));
				GameBase::activateShield(%this,%vec,%offsetZ);
				%value = 0;
			}
			else {
				GameBase::setEnergy(%this,0);
				%value = %value - %absorb;
			}
		}
  		if (%value) {
			%value = $DamageScale[%armor, %type] * %value * %friendFire;
            		%dlevel = GameBase::getDamageLevel(%this) + %value;
            		%spillOver = %dlevel - %armor.maxDamage;
			GameBase::setDamageLevel(%this,%dlevel);
			%flash = Player::getDamageFlash(%this) + %value * 2;
			if (%flash > 0.75) 
				%flash = 0.75;
			Player::setDamageFlash(%this,%flash);
			//If player not dead then play a random hurt sound
			if(!Player::isDead(%this)) { 
				if(%damagedClient.lastDamage < getSimTime()) {
					%sound = radnomItems(3,injure1,injure2,injure3);
					playVoice(%damagedClient,%sound);
					%damagedClient.lastdamage = getSimTime() + 1.5;
				}
			}
			else {
				if(Player::isAIControlled(%this)) {
					%armor = player::getArmor(%this);
					echo("ai player killed, armor = " @ %armor);
					if(%armor==larmor)
						$lbotsKilled +=1;
					else if(%armor==marmor)
						$mbotsKilled +=1;
					else
						$hbotsKilled +=1;
				}
               			if(%spillOver > 0.5 && (%type== $ExplosionDamageType || %type == $ShrapnelDamageType || %type== $MortarDamageType|| %type == $MissileDamageType)) {
		 			Player::trigger(%this, $WeaponSlot, false);
					%weaponType = Player::getMountedItem(%this,$WeaponSlot);
					if(%weaponType != -1)
						Player::dropItem(%this,%weaponType);
                			Player::blowUp(%this);
				}
				else {
					if ((%value > 0.40 && (%type== $ExplosionDamageType || %type == $ShrapnelDamageType || %type== $MortarDamageType || %type == $MissileDamageType )) || (Player::getLastContactCount(%this) > 6) ) {
					  	if(%quadrant == "front_left" || %quadrant == "front_right") 
							%curDie = $PlayerAnim::DieBlownBack;
						else
							%curDie = $PlayerAnim::DieForward;
					}
					else if( Player::isCrouching(%this) ) 
						%curDie = $PlayerAnim::Crouching;							
					else if(%vertPos=="head") {
						if(%quadrant == "front_left" ||	%quadrant == "front_right"	) 
							%curDie = radnomItems(2, $PlayerAnim::DieHead, $PlayerAnim::DieBack);
						  else 
							%curDie = radnomItems(2, $PlayerAnim::DieHead, $PlayerAnim::DieForward);
					}
					else if (%vertPos == "torso") {
						if(%quadrant == "front_left" ) 
							%curDie = radnomItems(3, $PlayerAnim::DieLeftSide, $PlayerAnim::DieChest, $PlayerAnim::DieForwardKneel);
						else if(%quadrant == "front_right") 
							%curDie = radnomItems(3, $PlayerAnim::DieChest, $PlayerAnim::DieRightSide, $PlayerAnim::DieSpin);
						else if(%quadrant == "back_left" ) 
							%curDie = radnomItems(4, $PlayerAnim::DieLeftSide, $PlayerAnim::DieGrabBack, $PlayerAnim::DieForward, $PlayerAnim::DieForwardKneel);
						else if(%quadrant == "back_right") 
							%curDie = radnomItems(4, $PlayerAnim::DieGrabBack, $PlayerAnim::DieRightSide, $PlayerAnim::DieForward, $PlayerAnim::DieForwardKneel);
					}
					else if (%vertPos == "legs") {
						if(%quadrant == "front_left" ||	%quadrant == "back_left") 
							%curDie = $PlayerAnim::DieLegLeft;
						if(%quadrant == "front_right" ||	%quadrant == "back_right") 
							%curDie = $PlayerAnim::DieLegRight;
					}
					Player::setAnimation(%this, %curDie);
				}
				if(%type == $ImpactDamageType && %object.clLastMount != "")  
					%shooterClient = %object.clLastMount;
				Client::onKilled(%damagedClient,%shooterClient, %type);
			}
		}
	}
}
}

// hack to allow 1 station use
// $InvFlag is set upon buying any weapon

function Station::onCollision(%this, %object)
{
	if($InvFlag) {
		bottomprint(2049,"You have already used this station, and cannot use it again.",5);
		return;
	}
	if(%this.target == ""){
		dbecho(3, "STATION: Collision (" @ %this @ "," @ %object @ ")");
		%obj = getObjectType(%object);
		if (%obj == "Player" && isPlayerBusy(%object) == 0) {
  		 	%client = Player::getClient(%object);
 			if(GameBase::getTeam(%object) == GameBase::getTeam(%this) || GameBase::getTeam(%this) == -1) {
				if (GameBase::getDamageState(%this) == "Enabled") {
					if (GameBase::isPowered(%this)) { 
						if(%this.enterTime == "")
							%this.enterTime = getSimTime();
						GameBase::setActive(%this,true);
					}
					else 
						Client::sendMessage(%client,0,"Unit is not powered");
				}
				else 
					Client::sendMessage(%client,0,"Unit is disabled");
			}
			else if(Station::getTarget(%this) == %object)
   	   {
				%curTime = getSimTime();
				if(%curTime - %object.stationDeniedStamp > 3.5 && GameBase::getDamageState(%this) == "Enabled") {
					Client::clearItemShopping(%client);
					Station::onDeactivate(%this);
					Station::onEndSequence(%this,1);
					if(Client::getGuiMode(%client) != 1)
						Client::setGuiMode(%client,1);
					%object.stationDeniedStamp = %curTime;
					Client::sendMessage(%client,0,"--ACCESS DENIED-- Wrong Team ~waccess_denied.wav");
				}
			}
		}
	}
}

function buyItem(%client,%item)
{
	%player = Client::getOwnedObject(%client);
	%armor = Player::getArmor(%client);
	if (($ServerCheats || Client::isItemShoppingOn(%client,%item) || $TestCheats || %client.spawn) && 
			($ItemMax[%armor, %item] || %item.className == Armor || %item.className == Vehicle || $TestCheats)) {
		if (%item.className == Armor) {
			// Assign armor by requested type & gender 
			%buyarmor = $ArmorType[Client::getGender(%client), %item];
			if(%armor != %buyarmor || Player::getItemCount(%client,%item) == 0)	{
				teamEnergyBuySell(%player,$ArmorName[%armor].price);
				if(checkResources(%player,%item,1)) {
					teamEnergyBuySell(%player,$ArmorName[%buyarmor].price * -1);
					Player::setArmor(%client,%buyarmor);
					checkMax(%client,%buyarmor);
					armorChange(%client);
     				Player::setItemCount(%client, $ArmorName[%armor], 0);  
     				Player::setItemCount(%client, %item, 1);  
					if (Player::getMountedItem(%client,$BackpackSlot) == ammopack) 
						fillAmmoPack(%client);	
					return 1;
				}

				teamEnergyBuySell(%player,$ArmorName[%armor].price * -1);
			}
		}
		else if (%item.className == Backpack) {
			if($TeamItemMax[%item] != "") {						
				if($TeamItemCount[GameBase::getTeam(%client) @ %item] >= $TeamItemMax[%item])
			 	  return 0;
			 }

			// Only one backpack per armor.
			%pack = Player::getMountedItem(%client,$BackpackSlot);
			if (%pack != -1) {
				if(%pack == ammopack) 
					checkMax(%client,%armor);
				else if(%pack == EnergyPack) {
					if(Player::getItemCount(%client,"LaserRifle") > 0) {
						Client::sendMessage(%client,0,"Sold Energy Pack - Auto Selling Laser Rifle");
						remoteSellItem(%client,22);						
					}
				}	
				teamEnergyBuySell(%player,%pack.price);
				Player::decItemCount(%client,%pack);
			}			   
			if (checkResources(%player,%item,1) || $testCheats) {
				teamEnergyBuySell(%player,%item.price * -1);
				Player::incItemCount(%client,%item);
				Player::useItem(%client,%item);									 
				if(%item == ammopack) 
					fillAmmoPack(%client);
				return 1;
			}
			else if(%pack != -1) {
				teamEnergyBuySell(%player,%pack.price * -1);
				Player::incItemCount(%client,%pack);
				Player::useItem(%client,%pack);									 
				if(%pack == ammopack) 
					fillAmmoPack(%client);
			}				 
		}
		else if(%item.className == Weapon) {
			$InvFlag=1;
			if(checkResources(%player,%item,1)) {
				if(%item == LaserRifle && Player::getItemCount(%client,"EnergyPack") == 0) {
					buyItem(%client,"EnergyPack");
					Client::sendMessage(%client,0,"Bought Laser Rifle - Auto buying Energy Pack");
				}
				Player::incItemCount(%client,%item);
				teamEnergyBuySell(%player,(%item.price * -1));
				%ammoItem =  %item.imageType.ammoType; 
				if(%ammoItem != "") {
					%delta = checkResources(%player,%ammoItem,$ItemMax[%armor, %ammoItem]);
					if(%delta || $testCheats) {
						teamEnergyBuySell(%player,(%ammoItem.price * -1 * %delta));
						Player::incItemCount(%client,%ammoitem,%delta);
					}
				}
				return 1;
			}
		}
	 	else if(%item.className == Vehicle) {
		   if($TeamItemCount[GameBase::getTeam(%client) @ %item] < $TeamItemMax[%item]) {
				%shouldBuy = VehicleStation::checkBuying(%client,%item);
				if(%shouldBuy == 1) {
					teamEnergyBuySell(%player,(%item.price * -1));
					return 1;
				}			
 				else if(%shouldBuy == 2)
					return 1;
			}
		}
		else {
			if($TeamItemMax[%item] != "") {						
				if($TeamItemCount[GameBase::getTeam(%client) @ %item] >= $TeamItemMax[%item])
			 	  return 0;
			 }
		    %delta = checkResources(%player,%item,$ItemMax[%armor, %item]);
			 if(%delta || $testCheats) {
				teamEnergyBuySell(%player,(%item.price * -1 * %delta));
				Player::incItemCount(%client,%item,%delta);
				return 1;
			}
		}
		
 	}
	return 0;
}