//===============================================================
// By Mental Trousers
//
// This script is part of a server side map that implements team
// sensitive teleports governed by 2 switches. Both switched must
// be controlled by the same team, otherwise the teleports will
// not work at all.
//
// The only thing that needs to be changed to adapt this to a
// different map is the strings that set the value for both
// %positionIn and %rotation. These values are the location of
// the teleport exit and the orientation of the of the player when
// he emerges. These values are copy and pasted from the target
// DropPointMarker position and rotation.
//
//===============================================================


function GroupTrigger::onEnter(%this, %object)
{
	echo ("Teleport triggered - "@%this@", "@%object);

	%client = Player::getClient(%object);
	%team=Client::getTeam (%client);

	if ($teleportSwitch1==%team && $teleportSwitch2==%team)
		{
		if(%this.num == "t1" && %team==0)
			{
			//change %positionIn and %rotation
			%positionIn = "474.09 405.448 184.338";
			%positionOut = "";
			%rotation="0 -0 0.58013";
			}
		else if(%this.num == "t2" && %team==0)
			{
			//change %positionIn and %rotation
			%positionIn = "469.651 402.799 184.339";
			%positionOut = "";
			%rotation="0 -0 0.58013";
			}
		else if(%this.num == "t3" && %team==1)
			{
			//change %positionIn and %rotation
			%positionIn = "-355.324 -174.5 184.338";
			%positionOut = "";
			%rotation="0 -0 -2.55981";
			}
		else if(%this.num == "t4" && %team==1)
			{
			//change %positionIn and %rotation
			%positionIn = "-350.888 -171.843 184.339";
			%positionOut = "";
			%rotation="0 -0 -2.55981";
			}
		else
			return;

		if(%this.in)
			{
			GameBase::setPosition(%client, %positionIn);
			GameBase::setRotation(%client, %rotation);
			%flash = 0.3;
			Player::setDamageFlash(%client, %flash);
			Client::sendmessage(%client,0,"You have teleported to the ENEMY craft!~wtransporter.wav");
			}
		else if(%this.out)
			{
			GameBase::setPosition(%client, %positionOut);
			GameBase::setRotation(%client, %rotation);
			%flash = 0.3;
			Player::setDamageFlash(%client, %flash);
			Client::sendmessage(%client,0,"You have teleported to the ENEMY craft!~wtransporter.wav");
			}
		}
}

function TowerSwitch::onCollision(%this, %object)
{
   if(getObjectType(%object) != "Player")
      return;

   if(Player::isDead(%object))
      return;

   %playerClient = Player::getClient(%object);
   %touchClientName = Client::getName(%playerClient);
   %playerTeam = GameBase::getTeam(%object);
	%group = GetGroup(%this);
   Group::iterateRecursive(%group, GameBase::setTeam, %playerTeam);

	if (%this.objectiveName=="TeleportControl 1")
		{
		%thisTeam=$teleportSwitch1;
		$teleportSwitch1=%playerTeam;
		}
	else if (%this.objectiveName=="TeleportControl 2")
		{
		%thisTeam=$teleportSwitch2;
		$teleportSwitch2=%playerTeam;
		}

	echo ($teleportSwitch1@","@$teleportSwitch2@", "@%playerTeam);

   if(%thisTeam == -1)
		{
		MessageAllExcept(%playerClient, 0, %touchClientName @ " reprogrammed " @ %this.objectiveName @ " for the " @ getTeamName(%playerTeam) @ " team!~wCapturedTower.wav");
		Client::sendMessage(%playerClient, 0, "You took control of " @ %this.objectiveName @ " for the " @ getTeamName(%playerTeam) @ " team!~wCapturedTower.wav");
		}
	else if (%thisTeam!=%playerTeam)
		{
		MessageAllExcept(%playerClient, 0, %touchClientName @ " Overid " @ %this.objectiveName @ " from the " @ getTeamName(%oldTeam) @ " team!~wCapturedTower.wav");
		Client::sendMessage(%playerClient, 0, "You commandeered " @ %this.objectiveName @ " from the " @ getTeamName(%oldTeam) @ " team!~wCapturedTower.wav");
		}
}

$teleportSwitch1=0;
$teleportSwitch2=1;