//Minefield.cs

function GroupTrigger::onEnter(%this, %object)
{
	%type=getObjectType(%object);
	if (%type=="Player")
		{
		GKExplosion::Detonate(%object);

		%clientId=player::getClient (%object);

		player::blowup(%clientId);
		MessageAllExcept(%clientID, 0, client::getName (%clientId) @ " stood on something lethal");
		Client::sendMessage(%clientID, 0, "You stood on something lethal");
		Player::kill(%clientId);
		}
}


MineData GKExplosion
{
	className = "Mine";
    shapeFile = "breath";
    shadowDetailMask = 1;
    explosionId = mortarExp;
	explosionRadius = 3;
	damageValue = 0;
	damageType = -3;
	kickBackStrength = 0;
	triggerRadius = 0;
	maxDamage = 0.0001;
	destroyDamage = 2.0;
	damageLevel = {1.0, 1.0};
	mass = 0;
	drag = 100.0;
};

GrenadeData GKEffect
{
	explosionTag       = mortarExp;
	collideWithOwner   = True;
	ownerGraceMS       = 250;
	collisionRadius    = 0;
	mass               = 0.0;
	elasticity         = 0.0;

	damageClass        = 1;
	damageValue        = 0;
	damageType         = -3;

	explosionRadius    = 0;
	kickBackStrength   = 0;
	maxLevelFlightDist = 375;
	totalTime          = 0.1;
	liveTime           = 0.1;
	projSpecialTime    = 0.01;

	inheritedVelocityScale = 0.0;
};

function GKExplosion::Detonate(%this)
{
	%cl = %this.deployer;
	%player = client::getownedobject(%cl);
	%vel = "0 0 0";
	if (!%player)
		return;
	%pos1 = gamebase::getposition(%this);
	%rot = (gamebase::getrotation(%this));
	%dir = (Vector::getfromrot(%rot));
	%trans1 = (%rot @ " " @ %dir @ " " @ %rot);

	%padd = "0 0 2.0";%pos = Vector::add(%pos1, %padd);
	%trans = "0 0 0 0 0 0 0 0 0 " @ %pos;
	schedule ("Projectile::spawnProjectile(GKEffect, \"" @ %trans @ "\", \"" @ %player @ "\", \"" @ %vel @ "\");",0.1);
}
