// #autoload
// #name = YogiStatsTracker
// #version = .9
// #date = January 21, 2002
// #author = Andrew Weiland
// #warrior = Yogi
// #email = yogi@tribalwar.com
// #description = Capture stats from Demos.
// #category = Yogi's Scripts
// #status = beta
// #acknowledgements = Grinder, Debig3, Writer, Halide, Shoddy, Diogenes
// #include = support/player_support.cs


exec("scripts/damageTypes.cs");

$YogiDebug=true;

if(!isObject(Stats))
{
    new ScriptObject(Stats)
    {
        class = Stats;
    };
}

function Stats::numPlayers(%this) {
         return $YogiPlayerNum;
}

function Stats::getStatByName(%this, %name, %stat) {
         %index = YogiGetPlayerIndex(%name);

         return %this.getStatByIndex(%index, %stat);
}

function Stats::getStatByIndex(%this, %index, %stat) {
         %val = "%stat = $YogiPlayerList[" @ %index @ "]." @ %stat @ ";";
         echo(%val);
         eval(%val);
         return %stat;
}

function Stats::getStatByID(%this, %id, %stat) {
         for (%x=0; %x < $YogiPlayerNum; %x++) {
             if ($YogiPlayerList[%x].clientid==%id) {
                return %this.getStatByIndex(%x, %stat);
             }
         }
        return 0;
}

function Stats::getPlayerByIndex(%this, %index) {
         return $YogiPlayerList[%index];
}

function Stats::reset() {
         YogiCleanUpStats();
}

function Stats::startTracking() {
         echo("Starting to track");
         YogiStartTracking();
}

function Stats::sortByName() {
         YogiSortNames();
}

function Stats::sortByTeam() {
         YogiSortByTeam();
}

function Stats::getDemoRecorderName() {
         return YogiFindPlayerMe();
}

// -----------------------------------------------------------------------------

// A really bad sorting algorithm
function YogiSortByTeam() {
        for (%i = 0; %i < $YogiPlayerNum; %i++) {
            %min = %i;

            for (%j = %i + 1; %j < $YogiPlayerNum; %j++) {

                if ($YogiPlayerList[%j].team < $YogiPlayerList[%min].team) {
                    %min = %j;
                }

            }
            %temp = $YogiPlayerList[%min];
            $YogiPlayerList[%min] = $YogiPlayerList[%i];
	        $YogiPlayerList[%i] = %temp;
        }
}

// -----------------------------------------------------------------------------

function YogiSortNames() {
         for (%d=1; %d <= 2; %d++) {
             for (%i = 0; %i < $YogiPlayerNum; %i++) {
                 %min = %i;

                 for (%j = %i + 1; %j < $YogiPlayerNum; %j++) {
                     if ($YogiPlayerList[%j].team==%d && $YogiPlayerList[%min].team == %d) {
                        if (stricmp($YogiPlayerList[%j].name, $YogiPlayerList[%min].name) == -1) {
                           %min = %j;
                        }
                     }
                 }
                 %temp = $YogiPlayerList[%min];
                 $YogiPlayerList[%min] = $YogiPlayerList[%i];
	             $YogiPlayerList[%i] = %temp;
              }
          }
}



//package YogiStatsTracker {

function YogiStartTracking() {
         YogiCleanUpStats();
         $YogiDemoPlayer="";
         YogiAddCallbacks();
}

// Create a new player object
function YogiAddPlayer(%name) {
         %team = PlayerList.getTeamByName(%name);
         %guid = PlayerList.getGUIDByName(%name);
         %clientid = PlayerList.getIdByName(%name);
         if ($YogiDebug) echo("--------------> Client ID: " @ %clientid);
         $YogiPlayerList[$YogiPlayerNum] =  new ScriptObject() {
             class = "YogiPlayer";
             name = %name;
             team = %team;
             clientId = %clientid;
             
             points=0;
             kills=0;
             grabs=0;
             pickups=0;
             drops=0;
             caps=0;
             returns=0;
             deaths=0;
             carrierkills=0;
             carriertks=0;
             suicides=0;
             killself=0;
             tks=0;
             guid=%guid;
             assists=0;
             standoffreturns=0;
             assist=false;
             HoldingFlag = 0;
	         turretkills=0;
	         vehkills=0;
             score=0;
             cgkills=0;
             cgdeaths=0;
             plaskills=0;
             plasdeaths=0;
             disckills=0;
             discdeaths=0;
             lancekills=0;
             lancedeaths=0;
             rocketkills=0;
             rocketdeaths=0;
             laserkills=0;
             laserdeaths=0;
             headshots=0;
             mortarkills=0;
             mortardeaths=0;
             grenadekills=0;
             grenadedeaths=0;
             vehiclekills=0;
             vehicledeaths=0;
             turretkills=0;
             turretdeaths=0;
             crashes=0;
             minekills=0;
             minedeaths=0;
             
             // Classic stuff
             gensdestroyed=0;
             gensrepaired=0;
             turretsdestroyed=0;
             turretsrepaired=0;
             invsdestroyed=0;
             invsrepaired=0;
             depturretsdestroyed=0;
             depturretsrepaired=0;
             sensorsdestroyed=0;
             sensorsrepaired=0;
             depsensorsdestroyed=0;
             depsensorsrepaired=0;
             teleportersdestroyed=0;
             teleportersrepaired=0;
             vstationsdestroyed=0;
             vstationsrepaired=0;
             solarsdestroyed=0;
             solarsrepaired=0;
             sentriesdestroyed=0;
             sentriesrepaired=0;
             depinvsdestroyed=0;
             depinvsrepaired=0;
             sentriesdestroyed=0;
             sentriesrepaired=0;
             
             // TR 2 stuff going here.
             catches=0;
             goals=0;
             saves=0;
             interceptions=0;
             hotpotato=0;
             assists=0;
             

         };
         %newGuy = $YogiPlayerList[$YogiPlayerNum];

         if ($YogiDebug) {
            echo("I just created a new player with name " @ %name);
            echo("This person has index " @ %guid);
         }

         $YogiStatsMap =	$MissionName;

         $YogiStatsteam1 = objectiveHud.teamName[1].getValue();
         $YogiStatsteam2 = objectiveHud.teamName[2].getValue();
         $YogiPlayerNum++;
}

// -----------------------------------------------------------------------------

function YogiFindPlayerMe() {
    %i = 0;
	%p = PlayerList.findByIndex(%i);
	while (%p !$= $PLAYER_ERROR) {
       %name = StripMLControlChars(%p.name);
       if (strstr(%name, $YogiPref::StatTracker::Me) !=-1) {
          if (strstr(%name, $YogiPref::StatTracker::PlayerTag) != -1) {
             if ($YogiDebug) echo("I found: " @ %p.name);
             return %p.name;
          }
       }

		%i++;
		%p = PlayerList.findByIndex(%i);
	}
    return $PLAYER_ERROR;
}

// -----------------------------------------------------------------------------

// Get the index of the player in my playerlist object
function YogiGetPlayerIndex(%name) {
         %index=-1;
         for (%x=0; %x < $YogiPlayerNum; %x++) {
             if ($YogiPlayerList[%x].name $= %name) {
                return %x;
             }
         }
         if (%index==-1) {
            YogiAddPlayer(%name);
         }
         return $YogiPlayerNum-1;
}

// -----------------------------------------------------------------------------

function YogiGetPlayerIndexById(%clientId) {
         for (%x=0; %x < $YogiPlayerNum; %x++) {
             if ($YogiPlayerList[%x].clientId == %clientId) {
                return %x;
             }
         }
         return -1;
}


function YogiVehicleKill(%msgType, %msgString, %victimname, %vgen, %vposs, %killername, %kgen, %kposs, %damageType) {

         %killer = detag(%killername);
         %deadguy = detag(%victimname);

         %index = YogiGetPlayerIndex(%killer);
         $YogiPlayerList[%index].vehiclekills++;

         %index2 = YogiGetPlayerIndex(%deadguy);
         $YogiPlayerList[%index2].vehicledeaths++;

}


// Handles real kills (not suicides or turrets, etc)
function YogiKill(%msgType, %msgString, %victimname, %vgen, %vposs, %killername, %kgen, %kposs, %damageType) {
//         listPlayers();

         %killer = detag(%killername);
         %deadguy = detag(%victimname);

         %index = YogiGetPlayerIndex(%killer);
         $YogiPlayerList[%index].kills++;
         if ($YogiDebug) echo(%killername @ " kills++");

         %index2 = YogiGetPlayerIndex(%deadguy);
         $YogiPlayerList[%index2].deaths++;
         if ($YogiDebug) echo(%victimname @ " deaths++");
         if ($YogiDebug) echo(%msgString);
         if ($YogiDebug) echo("Damage Type: " @ %damageType);
         if ($YogiDebug) echo("DamageType::Plasma " @ $DamageType::Plasma);
         

         if (%damageType == $DamageType::Plasma) {
            $YogiPlayerList[%index].plaskills++;
            $YogiPlayerList[%index2].plasdeaths++;
         }
         else if (%damageType == $DamageType::Bullet) {
            $YogiPlayerList[%index].cgkills++;
            $YogiPlayerList[%index2].cgdeaths++;
         }
         else if (%damageType == $DamageType::Disc) {
            $YogiPlayerList[%index].disckills++;
            $YogiPlayerList[%index2].discdeaths++;
         }
         else if (%damageType == $DamageType::Grenade) {
            $YogiPlayerList[%index].grenadekills++;
            $YogiPlayerList[%index2].grenadedeaths++;
         }
         else if (%damageType == $DamageType::Laser) {
            $YogiPlayerList[%index].laserkills++;
            $YogiPlayerList[%index2].laserdeaths++;
         }
         else if (%damageType == $DamageType::Mortar) {
            $YogiPlayerList[%index].mortarkills++;
            $YogiPlayerList[%index2].mortardeaths++;
         }
         else if (%damageType == $DamageType::Missile) {
            $YogiPlayerList[%index].missilekills++;
            $YogiPlayerList[%index2].missiledeaths++;
         }
         else if (%damageType == $DamageType::ShockLance) {
            $YogiPlayerList[%index].lancekills++;
            $YogiPlayerList[%index2].lancedeaths++;
         }
         else if (%damageType == $DamageType::Plasma) {
            $YogiPlayerList[%index].plaskills++;
            $YogiPlayerList[%index2].plasdeaths++;
         }
         else if (%damageType == $DamageType::Mine) {
            $YogiPlayerList[%index].minekills++;
            $YogiPlayerList[%index2].minedeaths++;
         }


	 if ($YogiPlayerList[%index2].HoldingFlag > 0)
	         $YogiPlayerList[%index].carrierkills++;
}

// -----------------------------------------------------------------------------

function YogiHeadShot(%msgType, %msgString, %player) {
         %guy = detag(%player);
         if (%guy==0 && $YogiDemoPlayer$="") {
            %find=YogiFindPlayerMe();
            if (%find $= $PLAYER_ERROR)
               return;
            else
                $YogiDemoPlayer=%find;
                if ($YogiDebug) echo("The person who recorded the demo is: " @ $YogiDemoPlayer);
         }

         if(StrStr(%msgString, "a successful") != -1) {
              %index = YogiGetPlayerIndex($YogiDemoPlayer);
         }
         else {
              %index = YogiGetPlayerIndex(%guy);
         }
         if ($YogiDebug) echo(%guy @ " headshots++");
         $YogiPlayerList[%index].headshots++;
}

// -----------------------------------------------------------------------------

// TK!!! VOTE TO KICK!@#$%@
function YogiTeamKill(%msgType, %msgString, %victimname, %vgen, %vposs, %killername, %kgen, %kposs, %damageType) {
         %killer = detag(%killername);
         %index = YogiGetPlayerIndex(%killer);
         $YogiPlayerList[%index].tks++;

         %killee = detag(%victimname);
         %index2 = YogiGetPlayerIndex(%killee);
         if ($YogiPlayerList[%index2].HoldingFlag > 0)
	         $YogiPlayerList[%index].carriertks++;

         if ($YogiDebug) echo(%killer @ "tk++");
}

// -----------------------------------------------------------------------------

// bloops you killed yourself
function YogiKillSelf(%msgType, %msgString, %victimname) {

         %idiot = detag(%victimname);
         %index = YogiGetPlayerIndex(%idiot);
         $YogiPlayerList[%index].killself++;
         
         if ($YogiDebug) echo(%idiot @ "killself++");
}

function YogiSuicide(%msgType, %msgString, %victimname) {

         %dead = detag(%victimname);
         %index = YogiGetPlayerIndex(%dead);
         $YogiPlayerList[%index].suicides++;
         if ($YogiDebug) echo(%dead @ "suicides++");
}

// -----------------------------------------------------------------------------

function YogiCTurretKill(%msgType, %msgString, %victimname, %vgen, %vposs, %killername, %kgen, %kposs, %damageType) {
//         listPlayers();

         %killer = detag(%killername);
         %deadguy = detag(%victimname);

         %index = YogiGetPlayerIndex(%killer);
         %index2 = YogiGetPlayerIndex(%deadguy);

	 if (%index == %index2) // suicide
	        $YogiPlayerList[%index].killself++;
	 else {
       $YogiPlayerList[%index2].deaths++;
       if ($YogiPlayerList[%index].team == $YogiPlayerList[%index2].team) { // TK
          if (%damageType == 21 || %damageType == 22 || %damageType == 15) {
       }
       else {
            $YogiPlayerList[%index].tks++;
            if ($YogiPlayerList[%index2].HoldingFlag > 0)
               $YogiPlayerList[%index].carriertks++;
			}
		}
		else if (%damageType == 21 || %damageType == 22 || %damageType == 15) {
			$YogiPlayerList[%index].turretkills++;
			if ($YogiDebug) echo("Turret kill for " @ %killer);
		}
		else { // otherwise, normal kill from bombing or shrike blaster or tank guns or ..
			if ($YogiDebug) echo("Vehicle turret kill for " @ %killer @ ", damageType = " @ %damageType);
		        $YogiPlayerList[%index].kills++;
			if ($YogiPlayerList[%index2].HoldingFlag > 0)
				$YogiPlayerList[%index].carrierkills++;
		}
	}
}

// -----------------------------------------------------------------------------

// Cap, yay!!
function YogiFlagCap(%msgType, %msgString, %capper) {
         %capman = detag(%capper);
         if ($YogiDebug) echo("He capped: " @ %capper);
         if (%capman==0 && $YogiDemoPlayer$="") {
            %find=YogiFindPlayerMe();
            if (%find $= $PLAYER_ERROR)
               return;
            else
                $YogiDemoPlayer=%find;
                if ($YogiDebug) echo("The person who recorded the demo is: " @ $YogiDemoPlayer);
         }

         if(StrStr(%msgString, "You captured the") != -1) {
              %index = YogiGetPlayerIndex($YogiDemoPlayer);
         }
         else {
              %index = YogiGetPlayerIndex(%capman);
         }
         $YogiPlayerList[%index].caps++;
         $YogiPlayerList[%index].HoldingFlag = 0;
         if ($YogiDebug) echo("--------> " @ %index @ ":" @ $YogiPlayerList[%index].name @ " now has " @ $YogiPlayerList[%index].caps @ " caps.");

         //Assist Code By Diogenes
         $YogiPlayerList[%index].assists--;

         for (%x=0; %x < $YogiPlayerNum; %x++) {
             if($YogiPlayerList[%index].team $= $YogiPlayerList[%x].team && $YogiPlayerList[%x].assist) {
                    $YogiPlayerList[%x].assists++;
                    $YogiPlayerList[%x].assist = false;
             }
         }

         // Set them both for sanity's sake
         setFlagHome(1);
         setFlagHome(2);

}

// -----------------------------------------------------------------------------

// Just a grab
function YogiFlagGrab(%msgType, %msgString, %grabber) {
         %grabguy = detag(%grabber);

         // Workaround for Dynamix bad coding :(
         if (%grabguy==0 && $YogiDemoPlayer$="") {
            %find=YogiFindPlayerMe();
            if (%find $= $PLAYER_ERROR)
               return;
            else
                $YogiDemoPlayer=%find;
                if ($YogiDebug) echo("The person who recorded the demo is: " @ $YogiDemoPlayer);
         }

         // Determine who took the flag
         if(StrStr(%msgString, "You took the") != -1) {
              %index = YogiGetPlayerIndex($YogiDemoPlayer);
         }
         else {
              %index = YogiGetPlayerIndex(%grabguy);
         }

         // Determine if this is a grab or a pickup
         %oteam = ($YogiPlayerList[%index].team==1) ? 2 : 1;

         if (!isFlagAtHome(%oteam)) {
            if ($YogiDebug) echo("****** THIS IS A PICKUP CAUSE " @ $YogiStatsFlag[%team]);
            $YogiPlayerList[%index].pickups++;
         }
         else {
              $YogiPlayerList[%index].grabs++;
         }

         setFlagAway(%oteam);
         //Assist Code By Diogenes
         $YogiPlayerList[%index].assist = true;
         $YogiPlayerList[%index].HoldingFlag = 1;
}

// -----------------------------------------------------------------------------

// You are a hero, you made a return
function YogiFlagReturned(%msgType, %msgString, %returner, %teamName, %team, %a3, %a4) {
         %returnman = detag(%returner);

          if (%returnman==0 && $YogiDemoPlayer$="") {
            %find=YogiFindPlayerMe();
            if (%find $= $PLAYER_ERROR)
               return;
            else
                $YogiDemoPlayer=%find;
                if ($YogiDebug) echo("The person who recorded the demo is: " @ $YogiDemoPlayer);
         }

         if(StrStr(%msgString, "You returned your flag") != -1) {
              %index = YogiGetPlayerIndex($YogiDemoPlayer);
         }
         else {
              if (%returnman$="0") return;
              %index = YogiGetPlayerIndex(%returnman);
         }


         $YogiPlayerList[%index].returns++;
         // Standoff Return
         if (!isFlagAtHome(1) && !isFlagAtHome(2)) $YogiPlayerList[%index].standoffreturns++;
         setFlagHome(%team);

         //Assist Code By Diogenes
         for (%x=0; %x < $YogiPlayerNum; %x++) {
             if($YogiPlayerList[%index].team !$= $YogiPlayerList[%x].team && $YogiPlayerList[%x].assist) {
                   $YogiPlayerList[%x].assist = false;
             }
         }
         if ($YogiDebug) echo(%find SPC "returns++");
}

// -----------------------------------------------------------------------------

function YogiFlagDrop(%msgType, %msgString, %dropper) {
         %dropguy = detag(%dropper);

         // Workaround for Dynamix bad coding :(
         if (%dropguy==0 && $YogiDemoPlayer$="") {
            %find=YogiFindPlayerMe();
            if (%find $= $PLAYER_ERROR)
               return;
            else
                $YogiDemoPlayer=%find;
                if ($YogiDebug) echo("The person who recorded the demo is: " @ $YogiDemoPlayer);
         }

         // Determine who dropped it
         if(StrStr(%msgString, "You dropped the") != -1) {
              %index = YogiGetPlayerIndex($YogiDemoPlayer);
         }
         else {
              %index = YogiGetPlayerIndex(%dropguy);
         }
         $YogiPlayerList[%index].drops++;
         $YogiPlayerList[%index].HoldingFlag = 0;
                  if ($YogiDebug) echo(%killer SPC "drops++");
}

// -----------------------------------------------------------------------------

// For Misc deaths
function YogiDeath(%msgType, %msgString, %deadguy) {

         %deadman = detag(%deadguy);
         %index = YogiGetPlayerIndex(%deadman);
         $YogiPlayerList[%index].deaths++;
         if ($YogiDebug) echo(%deadman @ "deaths++");
}

// -----------------------------------------------------------------------------

function YogiVehicleDestroy(%msgType, %msgString, %killername) {

	if (%killer $= "A turret") {
	}
	else {
		%killer = detag(%killername);
		%index = YogiGetPlayerIndex(%killer);
		$YogiPlayerList[%index].vehkills++;
		if ($YogiDebug) echo("Vehicle killed by " @ %killer);
	}
}

// -----------------------------------------------------------------------------

function YogiVehicleDestroyMe() {
	%index = YogiGetPlayerIndex($YogiDemoPlayer);
	$YogiPlayerList[%index].vehkills++;
	if ($YogiDebug) echo("Recorder killed vehicle.");
}

// -----------------------------------------------------------------------------

function YogiRepaired(%msgType, %msgString, %person, %objtag) {

         %repairman = detag(%person);
         echo("Repair Message: " @ %msgType);
         echo("With Message: " @ %msgString);
         echo("And Person: " @ %person);
         
         %index = YogiGetPlayerIndex(%repairman);
         %msg = detag(%msgType);
         switch$(%msg) {
             case "msgGenRepaired" : $YogiPlayerList[%index].gensrepaired++;
             case "msgSensorRepaired" : $YogiPlayerList[%index].sensorsrepaired++;
             case "msgStationRepaired" : $YogiPlayerList[%index].invsrepaired++;
             case "msgTurretRepaired" : $YogiPlayerList[%index].turretsrepaired++;
             case "msgvstationRepaired" : $YogiPlayerList[%index].vstationsrepaired++;
             case "msgTeleporterRepaired" : $YogiPlayerList[%index].teleportersrepaired++;
             case "msgsolarRepaired" : $YogiPlayerList[%index].solarsrepaired++;
             case "msgsentryTurretRepaired" : $YogiPlayerList[%index].sentriesrepaired++;
             case "msgdepTurretRepaired" : $YogiPlayerList[%index].depturretsrepaired++;
             case "msgdepInvRepaired" : $YogiPlayerList[%index].invsrepaired++;
             case "msgGenRep" : $YogiPlayerList[%index].gensrepaired++;
             case "msgIStationRep" : $YogiPlayerList[%index].invsrepaired++;
             case "msgSensorRep" : $YogiPlayerList[%index].sensorsrepaired++;
             case "msgTurretRep" : $YogiPlayerList[%index].turretsrepaired++;
             case "msgVStationRep" : $YogiPlayerList[%index].vstationsrepaired++;
             case "msgsolarRep" : $YogiPlayerList[%index].solarsrepaired++;
             case "msgSentryRep" : $YogiPlayerList[%index].sentriesrepaired++;
             case "msgDepTurretRep" : $YogiPlayerList[%index].depturretsrepaired++;
             case "msgDepInvRep" : $YogiPlayerList[%index].depinvsrepaired++;
         }

}

// -----------------------------------------------------------------------------

function YogiRepairMe(%msgType, %msgString) {
//         echo("Repair Message: " @ %msgType);
//         echo("With Message: " @ %msgString);
         if ($YogiDemoPlayer$="") {
            %find=YogiFindPlayerMe();
            if (%find $= $PLAYER_ERROR)
               return;
            else
                $YogiDemoPlayer=%find;
         }
         YogiRepaired(%msgType, %msgString, $YogiDemoPlayer);

}

// -----------------------------------------------------------------------------

function YogiDestroyed(%msgType, %msgString, %person, %objtag) {

         echo("Destroy Message: " @ %msgType);
         echo("With Message: " @ %msgString);
         echo("And Person: " @ %person);
         %msg = detag(%msgType);
         %killer = detag(%person);
         %index = YogiGetPlayerIndex(%killer);
         echo(%person SPC %index);
         switch$(%msg) {
            case "msgGenDes" : $YogiPlayerList[%index].gensdestroyed++;
            case "msgSensorDes" : $YogiPlayerList[%index].sensorsdestroyed++;
            case "msgTurretDes" : $YogiPlayerList[%index].turretsdestroyed++;
            case "msgInvDes" : $YogiPlayerList[%index].invsdestroyed++;
            case "msgVSDes" : $YogiPlayerList[%index].vstationsdestroyed++;
            case "msgMPBTeleDes" : $YogiPlayerList[%index].teleportersdestroyed++;
            case "msgSolarDes" : $YogiPlayerList[%index].solarsdestroyed++;
            case "msgSentryDes" : $YogiPlayerList[%index].sentriesdestroyed++;
            case "msgDepSensorDes" : $YogiPlayerList[%index].depsensorsdestroyed++;
            case "msgDepTurDes" : $YogiPlayerList[%index].depturretsdestroyed++;
            case "msgDepInvDes" : $YogiPlayerList[%index].depinvsdestroyed++;
            case "msgGenDestroyed" : $YogiPlayerList[%index].gensdestroyed++;
            case "msgSensorDestroyed" : $YogiPlayerList[%index].sensorsdestroyed++;
            case "msgTurDestroyed" : $YogiPlayerList[%index].turretsdestroyed++;
            case "msgInvDestroyed" : $YogiPlayerList[%index].invsdestroyed++;
            case "msgVehStationDestroyed" : $YogiPlayerList[%index].vstationsdestroyed++;
            case "msgTeleporterDestroyed" : $YogiPlayerList[%index].teleportersdestroyed++;
            case "msgSolarDestroyed" : $YogiPlayerList[%index].solarsdestroyed++;
            case "msgSentryDestroyed" : $YogiPlayerList[%index].sentriesdestroyed++;
            case "msgDepInvDestroyed" : $YogiPlayerList[%index].depinvsdestroyed++;
         }
}

// -----------------------------------------------------------------------------

function YogiDestroyMe(%msgType, %msgString) {
//         echo("Destroy Message: " @ %msgType);
//         echo("With Message: " @ %msgString);
         if ($YogiDemoPlayer$="") {
            %find=YogiFindPlayerMe();
            if (%find $= $PLAYER_ERROR)
               return;
            else
                $YogiDemoPlayer=%find;
         }
         YogiDestroyed(%msgType, %msgString, $YogiDemoPlayer);

}

// -----------------------------------------------------------------------------

function YogiCleanUpStats() {
         for (%x=0; %x < $YogiPlayerNum; %x++) {
             if (isObject($YogiPlayerList[%x])) {
                $YogiPlayerList[%x].delete();
             }
         }
         for (%x=1; %x <=2; %x++) {
             $YogiStatsFlag[%x] = true;
         }

         $YogiPlayerNum=0;
}

// -----------------------------------------------------------------------------

function YogiPossibleTeamChange(%msgType, %msgString, %changer, %ignore1, %ignore2, %newteam) {
         %name = detag(%changer);

         %index=-1;
         for (%x=0; %x < $YogiPlayerNum; %x++) {
             if ($YogiPlayerList[%x].name $= %name) {
                %index = %x;
             }
         }

	 if (%index >= 0) {
		if ($YogiPlayerList[%index].team != %newteam)
			$YogiPlayerList[%index].team = %newteam;
	 }
}

// -----------------------------------------------------------------------------

function isFlagAtHome(%team) {
         return $YogiStatsFlag[%team];
}

// -----------------------------------------------------------------------------

function setFlagHome(%team) {
         if ($YogiDebug) echo("************************ FLAG " @ %team @ " IS NOW HOME ******************");
         $YogiStatsFlag[%team] = true;
}

// -----------------------------------------------------------------------------

function setFlagAway(%team) {
         if ($YogiDebug) echo("************************ FLAG " @ %team @ " IS NOW AWAY ******************");
         $YogiStatsFlag[%team] = false;
}

// -----------------------------------------------------------------------------

function YogiTeamScore(%msgType, %msgString, %a1, %a2, %a3, %a4, %a5, %a6) {
         %teamNum = detag(%a1);
         %score = detag(%a2);

         if(%score $= "")
		       %score = 0;

         Stats.teamScore[%teamNum] = %score;
}

function YogiSystemClock(%msgType, %msgString, %timelimit, %timeleft, %a3, %a4, %a5, %a6) {

         %timeleft = detag(%timeleft);
         %timelimit = detag(%timelimit);
         if ($YogiDebug) {
            echo("Time left:" SPC %timeleft / (60 * 1000));
            echo("Time limit:" SPC %timelimit);
         }
         Stats.timeLeft = %timeleft / (60 * 1000);
         Stats.timeLimit = %timelimit;
         

}

function YogiPlayerScore() {
         echo("*");
         echo("*");
         echo("*");
         echo("Player Score");
         echo("*");
         echo("*");
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TR 2 Functions
// Waiting for TR2 update to finish these

function YogiTR2FlagTaken(%msg, %msgString, %name) {
         %index = YogiGetPlayerIndex(detag(%name));
         
         %str = detag(%msgString);
         if (strstr("intercepted", %msgString) != -1) {
            $YogiPlayerList[%index].interceptions++;
         }
         else if (strstr("caught", %msgString) != -1) {
              $YogiPlayerList[%index].catches++;
         }

}

function YogiTR2FlagDropped() {

}

function YogiTR2Knockdown(%msg, %msgString, %down, %dgender, %dpos, %killer, %kgender, %kpos, %damageType) {
         if (%damageType==$DamageType::Default) return;

}

function YogiTR2GoalScorer() {

}

function YogiTR2GoalAssist() {

}

function YogiTR2HotPotato(%msg, %msgString, %victim) {
         %index = YogiGetPlayerIndex(detag(%victime));
         $YogiPlayerList[%index].hotpotato++;
}




// -----------------------------------------------------------------------------

// Add callbacks for all the stuff that we want to track
function YogiAddCallBacks() {

    // Kills
    addMessageCallBack('msgExplosionKill', YogiKill);
    addMessageCallBack('msgSuicide', YogiSuicide);
    addMessageCallBack('msgVehicleSpawnKill', YogiKill);
    addMessageCallBack('msgVehicleCrash', YogiKill);
    addMessageCallBack('msgVehicleKill', YogiVehicleKill);
    addMessageCallBack('msgTurretSelfKill', YogiKillSelf);
    addMessageCallBack('msgCTurretKill', YogiCTurretKill);
    addMessageCallBack('msgSelfKill', YogiKillSelf);
    addMessageCallBack('msgTeamKill', YogiTeamKill);
    addMessageCallBack('msgLavaKill', YogiKill);
    addMessageCallBack('msgLightningKill', YogiKill);
    addMessageCallBack('MsgRogueMineKill', YogiKill);
    addMessageCallBack('MsgLegitKill', YogiKill);
    addMessageCallBack('msgHeadShot', YogiHeadShot);

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    // Classic/CTF stuff
	addMessageCallback('MsgCTFFlagCapped', YogiFlagCap);
    addMessageCallback('MsgGameOver', YogiMissionEnd);
    addMessageCallBack('MsgCTFFlagTaken', YogiFlagGrab);
    addMessageCallBack('MsgCTFFlagReturned', YogiFlagReturned);
    addMessageCallBack('MsgCTFFlagDropped', YogiFlagDrop);
	addMessageCallBack('msgVehicleDestroy', YogiVehicleDestroy);
	addMessageCallBack('msgVehicleScore', YogiVehicleDestroyMe);
	addMessageCallBack('MsgClientJoinTeam', YogiPossibleTeamChange);
    addMessageCallBack('MsgTeamScoreIs', YogiTeamScore);

    // Repair messages
    addMessageCallBack('msgGenRepaired', YogiRepaired);
    addMessageCallBack('msgSensorRepaired', YogiRepaired);
    addMessageCallBack('msgStationRepaired', YogiRepaired);
    addMessageCallBack('msgTurretRepaired', YogiRepaired);
    addMessageCallBack('msgvstationRepaired', YogiRepaired);
    addMessageCallBack('msgTeleporterRepaired', YogiRepaired);
    addMessageCallBack('msgsolarRepaired', YogiRepaired);
    addMessageCallBack('msgsentryTurretRepaired', YogiRepaired);
    addMessageCallBack('msgdepTurretRepaired', YogiRepaired);
    addMessageCallBack('msgdepInvRepaired', YogiRepaired);
    addMessageCallBack('msgGenRep', YogiRepairMe);
    addMessageCallBack('msgIStationRep', YogiRepairMe);
    addMessageCallBack('msgSensorRep', YogiRepairMe);
    addMessageCallBack('msgTurretRep', YogiRepairMe);
    addMessageCallBack('msgVStationRep', YogiRepairMe);
    addMessageCallBack('msgsolarRep', YogiRepairme);
    addMessageCallBack('msgSentryRep', YogiRepairMe);
    addMessageCallBack('msgDepTurretRep', YogiRepairMe);
    addMessageCallBack('msgDepInvRep', YogiRepairMe);
    
    //Destroy Messages
    addMessageCallBack('msgGenDes', YogiDestroyMe);
    addMessageCallBack('msgSensorDes', YogiDestroyMe);
    addMessageCallBack('msgTurretDes', YogiDestroyMe);
    addMessageCallBack('msgInvDes', YogiDestroyMe);
    addMessageCallBack('msgVSDes', YogiDestroyMe);
    addMessageCallBack('msgMPBTeleDes', YogiDestroyMe);
    addMessageCallBack('msgSolarDes', YogiDestroyMe);
    addMessageCallBack('msgSentryDes', YogiDestroyMe);
    addMessageCallBack('msgDepSensorDes', YogiDestroyMe);
    addMessageCallBack('msgDepTurDes', YogiDestroyMe);
    addMessageCallBack('msgDepInvDes', YogiDestroyMe);
    addMessageCallBack('msgGenDestroyed', YogiDestroyed);
    addMessageCallBack('msgSensorDestroyed', YogiDestroyed);
    addMessageCallBack('msgTurDestroyed', YogiDestroyed);
    addMessageCallBack('msgInvDestroyed', YogiDestroyed);
    addMessageCallBack('msgVehStationDestroyed', YogiDestroyed);
    addMessageCallBack('msgTeleporterDestroyed', YogiDestroyed);
    addMessageCallBack('msgSolarDestroyed', YogiDestroyed);
    addMessageCallBack('msgSentryDestroyed', YogiDestroyed);
    addMessageCallBack('msgDepInvDestroyed', YogiDestroyed);
    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    
    
    
    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    // TR2 Stuff
    addMessageCallBack('MsgTR2FlagTaken', YogiTR2FlagTaken);
    addMessageCallBack('MsgTR2FlagDropped', YogiTR2FlagDropped);
    addMessageCallBack('msgTR2Knockdown', YogiTR2Knockdown);
    addMessageCallBack('MsgTR2GoalScorer', YogiTR2GoalScorer);
    addMessageCallBack('MsgGrid', YogiTR2Knockdown);
    addMessageCallBack('MsgTR2GoalAssist', YogiTR2GoalAssist);
    addMessageCallBack('msgHotPotato', YogiTR2HotPotato);
    

    ////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////
    // Other Stuff
    addMessageCallback('MsgTeamScoreIs', YogiTeamScore);
    addMessageCallback('MsgSystemClock', YogiSystemClock);
    addMessageCallback('MsgPlayerScore', YogiPlayerScore);


//	addMessageCallBack('msgSuicide', YogiKillSelf);
//	addMessageCallBack('msgVehicleKill', YogiKill);
//	addMessageCallBack('msgCTurretKill', YogiCTurretKill);
//	addMessageCallBack('msgSelfKill', YogiKillSelf);
//	addMessageCallBack('MsgHeadshotKill', YogiKill);


//	addMessageCallBack('msgCarKill', YogiKillCarrier);
//	addMessageCallBack('msgExplosionKill', YogiDeath);
//	addMessageCallBack('msgVehicleSpawnKill', YogiDeath);
//	addMessageCallBack('msgVehicleCrash', YogiDeath);
//	addMessageCallBack('msgTurretKill', YogiDeath);
//	addMessageCallBack('msgOOBKill', YogiDeath);
//	addMessageCallBack('msgCampKill', YogiKill);
//	addMessageCallBack('msgTeamKill', YogiTeamKill);
//	addMessageCallBack('msgLavaKill', YogiDeath);
//	addMessageCallBack('msgLightningKill', YogiDeath);
//	addMessageCallBack('MsgRogueMineKill', YogiDeath);

    //addMessageCallback( 'MsgMissionEnd', YogiWriteHTML);


}
//}; // End package

//activatePackage(YogiStatsTracker);

if(isFile("prefs/YogiPrefs.cs") && !$YogiPrefsLoaded) {
		exec("prefs/YogiPrefs.cs");
		$YogiPrefsLoaded = true;
}
