// #autoload
// #name = Yogi MatchStats
// #version = 4.0 BETA 2
// #date = January 21, 2003
// #author = Andrew Weiland
// #warrior = Yogi
// #email = yogi@tribalwar.com
// #description = Capture match stats from Demos.
// #category = Yogi's Scripts
// #status = alpha
// #acknowledgements = Grinder, Debig3, Writer, Halide, Shoddy, Diogenes
// #include = support/player_support.cs
// #include = support/team_tracker.cs
// #include = support/mission_callbacks.cs
// #include = support/file_tools.cs
// #readme = scripts/autoexec/yogi/readme/yogimatchstats.txt
// #config = YMSOptions
exec("scripts/damageTypes.cs");

$YogiWriteOut=false;
$YogiDemoPlayer="";
package YogiMatchStats {

// -----------------------------------------------------------------------------

function playDemo(%file) {
         echo("++++++++++++++++++++++++++++++++++++++++++++++++++");
         echo("++++++++++++++++++++++++++++++++++++++++++++++++++");
         echo("++++++++++++++++++++++++++++++++++++++++++++++++++");
         GlobalActionMap.bindCmd(keyboard, "F5", "", "YMSStatsDialog();");
         $YogiWriteOut=false;
         $YogiDemoPlayer="";
         YogiAddCallBacks();
         return parent::playDemo(%file);
}

// -----------------------------------------------------------------------------

function YMSStatsDialog() {
         $globalActionMapOnly=false;
         GlobalActionMap.unbind(keyboard, space);
         canvas.pushDialog(YogiStatsOptions);
}

// -----------------------------------------------------------------------------

function YMSStatsDialogClose() {
         GlobalActionMap.bindCmd(keyboard, "space", "", "toggleDemoPause();");
         $globalActionMapOnly=true;
         canvas.popDialog(YogiStatsOptions);
}

// -----------------------------------------------------------------------------

function YMSStartTracking() {
         GlobalActionMap.bindCmd(keyboard, "space", "", "toggleDemoPause();");
         $globalActionMapOnly=true;
         $YogiWriteOut=true;
         canvas.popDialog(YogiStatsOptions);
         Stats.reset();
         Stats.startTracking();
         echo("Mission type: " @ MissionCallback.getMissionType());
}

// -----------------------------------------------------------------------------

function demoPlaybackComplete() {
         // Dump the data
         YMSWriteHTML();
       //  if ($YogiPref::MatchStats::WriteOut) YogiWriteHTML();
         Stats.reset();
         GlobalActionMap.unbind(keyboard, F5);
         YogiRemoveCallbacks();
       //  $YogiPlayDemo=false;
         $YogiWriteOut=false;
         parent::demoPlaybackComplete();
}

// -----------------------------------------------------------------------------

function YMSWriteHTML() {
        if (!$YogiWriteOut) return;
        if ($YogiPlayerNum==0) return;
        %map = $YogiStatsmap;
        %reason = $YogiPref::MatchStats::Reason;
        %otag = $YogiPref::MatchStats::OTag;
        %date = $YogiPref::MatchStats::Date;
        %tag = $YogiPref::StatTracker::PlayerTag;
        //YogiUpdateTeamPoints(1);
        //YogiUpdateTeamPoints(2);
        // What team was I on now?
        %fteam = Stats.getStatByName(Stats.getDemoRecorderName(), "team");
        %fteam = (%fteam==1) ? 1 : 2;
        %oteam = (%fteam==1) ? 2 : 1;

        // Team Scores
        %fscore = Stats.teamScore[%fteam];
        %oscore = Stats.teamScore[%oteam];
        %fpoints = $YogiTeamPoints[%fteam];
        %opoints = $YogiTeamPoints[%oteam];

        // Team Names
        %team1= $YogiStatsteam1;
        %team2= $YogiStatsteam2;

        // Time Played
        %length = Stats.timeLimit - Stats.timeLeft;
        %mins = mFloor(%length);
        %secs = (%length - %mins) * 60;
        %secs = getSubStr(%secs, 0, 2);
        if (%secs<10) %secs="0" @ %secs;
        %length = %mins @ ":" @ %secs;
        
        //
        // %length = Stats.timeLimit SPC Stats.timeLeft;
        //


        Stats.sortByTeam();
        Stats.sortByName();

         // Find an open filename
         %searchnum=1;
         %filename = "matchstats/" @ %map @ %searchnum @ ".html";
         while (isFile(%filename)) {
                  %searchnum++;
                  %filename = "matchstats/" @ %map @ %searchnum @ ".html";
         }


         %outfile = new FileObject();
         %outfile.openForWrite(%filename);
         %headerfile = new FileObject();
         %headerfile.openForRead("matchstats/templates/header.tmpl");
         %header = %headerfile.getContents("matchstats/templates/header.tmpl");
         %headerfile.close();
         %headerfile.delete();
         %header = strreplace(%header, "%cssfile", $YogiPref::MatchStats::Css);
         %outfile.write(%filename, %header);


         %toptable = new FileObject();
         %toptable.openForRead("matchstats/templates/toptable.tmpl");
         %top = %toptable.getContents("matchstats/templates/toptable.tmpl");
         %toptable.close();
         %toptable.delete();

         %top = strreplace(%top, "%date", %date);
         %top = strreplace(%top, "%ladder", %reason);
         %top = strreplace(%top, "%opponent", %otag);
         %top = strreplace(%top, "%map", %map);
         %top = strreplace(%top, "%ftag", %tag);
         %top = strreplace(%top, "%otag", %otag);
         %top = strreplace(%top, "%fscore", %fscore);
         %top = strreplace(%top, "%oscore", %oscore);
         %top = strreplace(%top, "%fpoints", %fpoints);
         %top = strreplace(%top, "%opoints", %opoints);
         %top = strreplace(%top, "%length", %length);
         %top = strreplace(%top, "%gametype", $YogiPref::MatchStats::GameType);


         %outfile.append(%filename, %top);

         %theader = new FileObject();
         %theader.openForRead("matchstats/templates/flagheader.tmpl");
         %head = %theader.getContents("matchstats/templates/flagheader.tmpl");
         %theader.close();
         %theader.delete();

         %tfooter = new FileObject();
         %tfooter.openForRead("matchstats/templates/flagfooter.tmpl");
         %footer = %tfooter.getContents("matchstats/templates/flagfooter.tmpl");
         %tfooter.close();
         %tfooter.delete();


         %fbodyfile = new FileObject();
         %fbodyfile.openForRead("matchstats/templates/flagbody.tmpl");
         %fbody = %fbodyfile.getContents("matchstats/templates/flagbody.tmpl");
         %fbodyfile.close();
         %fbodyfile.delete();

         %classes[0]="light";
         %classes[1]="dark";
         %cls=0;

         //----- Team Tables -----
         %outfile.append(%filename, %head);
         for (%y=1; %y<=2; %y++) {
             if (%y==1) %cteam = %fteam;
             else %cteam = %oteam;

             //if (%y==1) {
             //   %theader2 = strreplace(%theader, "%team", %team1);
             //}
             //else {
             //     %theader2 = strreplace(%theader, "%team", %team2);
             //}

             %grabs=0;
             %caps=0;
             %returns=0;
             %assists=0;
             %drops=0;
             %standoffreturns=0;
             %pickups=0;

             for (%x=0; %x < $YogiPlayerNum; %x++) {
                 %class= %classes[%cls];
                 %cls = (%cls==0) ? 1 : 0;

                 //%guy = $YogiPlayerList[%x];
                 %guy = Stats.getPlayerByIndex(%x);
                 if (%guy.team !$= $PLAYER_ERROR && %guy.team == %y) {
                    %work = %fbody;
                    %work = strreplace(%work, "%class", %class);
                    %name = StripMLControlChars(%guy.name);
                    %work = strreplace(%work, "%name", %name);
                    %work = strreplace(%work, "%grabs", %guy.grabs);
                    %work = strreplace(%work, "%caps", %guy.caps);
                    %work = strreplace(%work, "%returns", %guy.returns);
                    %work = strreplace(%work, "%assists", %guy.assists);
                    %work = strreplace(%work, "%pickups", %guy.pickups);
                    %work = strreplace(%work, "%standoffs", %guy.standoffreturns);
                    %work = strreplace(%work, "%drops", %guy.drops);
                    //%tbody = %tbody @ %work;
                    %outfile.append(%filename, %work);
                    %grabs+=%guy.grabs;
                    %caps+=%guy.caps;
                    %returns+=%guy.returns;
                    %assists+=%guy.assists;
                    %pickups+= %guy.pickups;
                    %drops+=%guy.drops;
                    %standoffreturns+=%guy.standoffreturns;
                 }
             }
             %work = %fbody;
             %class="totals";
             %name = "Total";

             %work = strreplace(%work, "%class", %class);
             %work = strreplace(%work, "%name", %name);
             %work = strreplace(%work, "%grabs", %grabs);
             %work = strreplace(%work, "%caps", %caps);
             %work = strreplace(%work, "%returns", %returns);
             %work = strreplace(%work, "%assists", %assists);
             %work = strreplace(%work, "%pickups", %pickups);
             %work = strreplace(%work, "%standoffs", %standoffreturns);
             %work = strreplace(%work, "%drops", %drops);
             %outfile.append(%filename, %work);

//             %tscore = $YogiTeamScores[%y];
    //         %theader2 = strreplace(%theader2, "%tscore", %tscore);

             // Header
  //           %outfile.append(%filename, %theader2);
             // Table body
//             %outfile.append(%filename, %tbody);
             // Totals
//             %outfile.append(%filename, %work);
             // Table footer

         }
         %outfile.append(%filename, %footer);


         // Kills and Deaths Stats
         %headerfile = new FileObject();
         %headerfile.openForRead("matchstats/templates/killsheader.tmpl");
         %header = %headerfile.getContents("matchstats/templates/killsheader.tmpl");
         %headerfile.close();
         %headerfile.delete();

         %footerfile = new FileObject();
         %footerfile.openForRead("matchstats/templates/killsfooter.tmpl");
         %footer = %footerfile.getContents("matchstats/templates/killsfooter.tmpl");
         %footerfile.close();
         %footerfile.delete();

         %bodyfile = new FileObject();
         %bodyfile.openForRead("matchstats/templates/killsbody.tmpl");
         %fbody = %bodyfile.getContents("matchstats/templates/killsbody.tmpl");
         %bodyfile.close();
         %bodyfile.delete();

         %outfile.append(%filename, %header);
         %classes[0]="smalllight";
         %classes[1]="smalldark";
         %cls=0;

         for (%y=1; %y<=2; %y++) {
             if (%y==1) %cteam = %fteam;
             else %cteam = %oteam;

             %score=0;
             %kills=0;
             %deaths=0;
             %cgkills=0;
             %cgdeaths=0;
             %plaskills=0;
             %plasdeaths=0;
             %disckills=0;
             %discdeaths=0;
             %lancekills=0;
             %lancedeaths=0;
             %rocketkills=0;
             %rocketdeaths=0;
             %laserkills=0;
             %laserdeaths=0;
             %mortarkills=0;
             %mortardeaths=0;
             %grenadekills=0;
             %grenadedeaths=0;
             %turretkills=0;
             %turretdeaths=0;
             %vehiclekills=0;
             %vehicledeaths=0;
             %suicides=0;
             %tks=0;
             %carriertks=0;
             %carrierkills=0;
             %points=0;
             %minekills=0;
             %minedeaths=0;

             for (%x=0; %x < $YogiPlayerNum; %x++) {
                 %class= %classes[%cls];
                 %cls = (%cls==0) ? 1 : 0;

                 %guy = $YogiPlayerList[%x];
                 if (%guy.team !$= $PLAYER_ERROR && %guy.team == %y) {
                    %effic = %guy.kills/(%guy.kills+%guy.deaths);
                    %effic = mFormatFloat(%effic, "%.2f");
                    %work = %fbody;
                    
                    %work = strreplace(%work, "%class", %class);
                    %name = StripMLControlChars(%guy.name);
                    %work = strreplace(%work, "%name", %name);
                    %work = strreplace(%work, "%score", %guy.points);
                    %work = strreplace(%work, "%kills", %guy.kills);
                    %work = strreplace(%work, "%deaths", %guy.deaths);
                    %work = strreplace(%work, "%efficiency", %effic);
                    %work = strreplace(%work, "%cgkills", %guy.cgkills);
                    %work = strreplace(%work, "%cgdeaths", %guy.cgdeaths);
                    %work = strreplace(%work, "%plaskills", %guy.plaskills);
                    %work = strreplace(%work, "%plasdeaths", %guy.plasdeaths);
                    %work = strreplace(%work, "%disckills", %guy.disckills);
                    %work = strreplace(%work, "%discdeaths", %guy.discdeaths);
                    %work = strreplace(%work, "%lancekills", %guy.lancekills);
                    %work = strreplace(%work, "%lancedeaths", %guy.lancedeaths);
                    %work = strreplace(%work, "%rocketkills", %guy.rocketkills);
                    %work = strreplace(%work, "%rocketdeaths", %guy.rocketdeaths);
                    %work = strreplace(%work, "%laserkills", %guy.laserkills);
                    %work = strreplace(%work, "%laserdeaths", %guy.laserdeaths);
                    %work = strreplace(%work, "%mortarkills", %guy.mortarkills);
                    %work = strreplace(%work, "%mortardeaths", %guy.mortardeaths);
                    %work = strreplace(%work, "%grenadekills", %guy.grenadekills);
                    %work = strreplace(%work, "%grenadedeaths", %guy.grenadedeaths);
                    %work = strreplace(%work, "%turretkills", %guy.turretkills);
                    %work = strreplace(%work, "%turretdeaths", %guy.turretdeaths);
                    %work = strreplace(%work, "%vehiclekills", %guy.vehiclekills);
                    %work = strreplace(%work, "%vehicledeaths", %guy.vehicledeaths);
                    %work = strreplace(%work, "%suicides", %guy.suicides);
                    %work = strreplace(%work, "%tks", %guy.tks);
                    %work = strreplace(%work, "%carriertks", %guy.carriertks);
                    %work = strreplace(%work, "%carrierkills", %guy.carrierkills);
                    %work = strreplace(%work, "%minekills", %guy.minekills);
                    %work = strreplace(%work, "%minedeaths", %guy.minedeaths);
                    //%tbody = %tbody @ %work;
                    %outfile.append(%filename, %work);

                    %score+=%guy.score;
                    %kills+=%guy.kills;
                    %deaths+=%guy.deaths;
                    %cgkills+=%guy.cgkills;
                    %cgdeaths+=%guy.cgdeaths;
                    %plaskills+=%guy.plaskills;
                    %plasdeaths+=%guy.plasdeaths;
                    %disckills+=%guy.disckills;
                    %discdeaths+=%guy.discdeaths;
                    %lancekills+=%guy.lancekills;
                    %lancedeaths+=%guy.lancedeaths;
                    %rocketkills+=%guy.rocketkills;
                    %rocketdeaths+=%guy.rocketdeaths;
                    %laserkills+=%guy.laserkills;
                    %laserdeaths+=%guy.laserdeaths;
                    %mortarkills+=%guy.mortarkills;
                    %mortardeaths+=%guy.mortardeaths;
                    %grenadekills+=%guy.grenadekills;
                    %grenadedeaths+=%guy.grenadedeaths;
                    %turretkills+=%guy.turretkills;
                    %turretdeaths+=%guy.turretdeaths;
                    %vehiclekills+=%guy.vehiclekills;
                    %vehicledeaths+=%guy.vehicledeaths;
                    %suicides+=%guy.suicides;
                    %tks+=%guy.tks;
                    %carriertks+=%guy.carriertks;
                    %carrierkills+=%guy.carrierkills;
                    %points+=%guy.points;
                    %minekills+=%guy.minekills;
                    %minedeaths+=%guy.minedeaths;

                 }
             }
             %work = %fbody;
             %class="smalltotals";
             %name = "Total";

             %efficiency = %kills/(%kills+%deaths);
             %efficiency = mFormatFloat(%efficiency, "%.2f");
             %work = strreplace(%work, "%class", %class);
             %work = strreplace(%work, "%name", %name);

             //%work = strreplace(%work, "%score", %score);
             %work = strreplace(%work, "%kills", %kills);
             %work = strreplace(%work, "%deaths", %deaths);
             %work = strreplace(%work, "%efficiency", %efficiency);
             %work = strreplace(%work, "%cgkills", %cgkills);
             %work = strreplace(%work, "%cgdeaths", %cgdeaths);
             %work = strreplace(%work, "%plaskills", %plaskills);
             %work = strreplace(%work, "%plasdeaths", %plasdeaths);
             %work = strreplace(%work, "%disckills", %disckills);
             %work = strreplace(%work, "%discdeaths", %discdeaths);
             %work = strreplace(%work, "%lancekills", %lancekills);
             %work = strreplace(%work, "%lancedeaths", %lancedeaths);
             %work = strreplace(%work, "%rocketkills", %rocketkills);
             %work = strreplace(%work, "%rocketdeaths", %rocketdeaths);
             %work = strreplace(%work, "%laserkills", %laserkills);
             %work = strreplace(%work, "%laserdeaths", %laserdeaths);
             %work = strreplace(%work, "%mortarkills", %mortarkills);
             %work = strreplace(%work, "%mortardeaths", %mortardeaths);
             %work = strreplace(%work, "%grenadekills", %grenadekills);
             %work = strreplace(%work, "%grenadedeaths", %grenadedeaths);
             %work = strreplace(%work, "%turretkills", %turretkills);
             %work = strreplace(%work, "%turretdeaths", %turretdeaths);
             %work = strreplace(%work, "%vehiclekills", %vehiclekills);
             %work = strreplace(%work, "%vehicledeaths", %vehicledeaths);
             %work = strreplace(%work, "%suicides", %suicides);
             %work = strreplace(%work, "%tks", %tks);
             %work = strreplace(%work, "%carriertks", %carriertks);
             %work = strreplace(%work, "%carrierkills", %carrierkills);
             %work = strreplace(%work, "%score", %points);
             %work = strreplace(%work, "%minekills", %minekills);
             %work = strreplace(%work, "%minedeaths", %minedeaths);

             %outfile.append(%filename, %work);

         }

         %outfile.append(%filename, %footer);




         %footerfile = new FileObject();
         %footerfile.openForRead("matchstats/templates/footer.tmpl");
         %outfile.append(%filename, %footerfile.getContents("matchstats/templates/footer.tmpl"));

         %footerfile.close();
         %footerfile.delete();

         %outfile.close();
         %outfile.delete();

}

// -----------------------------------------------------------------------------

function YMSStatsGo() {
         canvas.popDialog(YogiStats);
         $YogiPlayDemo=true;
         StartSelectedDemo();
}

// -----------------------------------------------------------------------------
// This is from Halide's
function quit() {
		// If not saved already (can be done from another script)
        if (!$YogiPrefsSaved) {
			export("$YogiPref::*", "prefs/YogiPrefs.cs", false);
			// Set the pref that says so
			$YogiPrefsSaved = true;
        }
		parent::quit();
}

// -----------------------------------------------------------------------------

function YMSOptions::OnWake(%this) {
         YMSCssList.clear();
         %x=0;
         %select=0;
         %file = findFirstFile("matchstats/css/*.css");
         while (%file !$="") {
             %file = strreplace(%file, "/", " ");
             %file = getWord(%file, 2);
             YMSCssList.add(%file, %x);
             if (%file $= $YogiPref::MatchStats::Css) %selected=%x;
             %x++;

             %file = findNextFile("matchstats/css/*.css");
         }
         YMSCssList.setSelected(%selected);


}

function YogiMissionEndStats() {
         YMSWriteHTML();
}

// -----------------------------------------------------------------------------

// Some other call backs for other stats that aren't player specific
function DispatchLaunchMode() {
         parent::DispatchLaunchMode();
         addMessageCallback('MsgGameOver', YogiMissionEndStats);

}


function YMSCssList::onSelect(%this, %id, %text) {
         $YogiPref::MatchStats::Css = %text;
}

function YogiStatsGameType::onSelect(%this, %id, %text) {
         $YogiPref::MatchStats::GameType = %text;
}

function YogiStatsOptions::onWake(%this) {
         YogiStatsGameType.clear();
         %types = 3;
         %gt[0]="CTF";
         %gt[1]="Classic CTF";
         %gt[2]="TR 2";
         %selected=0;
         for (%x=0; %x<%types; %x++) {
             YogiStatsGameType.add(%gt[%x], %x);
             if (%gt[%x]$=$YogiPref::MatchStats::GameType) %selected=%x;
         }
         YogiStatsGameType.setSelected(%selected);

}


};

if(isFile("prefs/YogiPrefs.cs") && !$YogiPrefsLoaded) {
		exec("prefs/YogiPrefs.cs");
		$YogiPrefsLoaded = true;
}

activatePackage(YogiMatchStats);

//--- OBJECT WRITE BEGIN ---
new GuiControl(YogiStatsOptions) {
	profile = "GuiDefaultProfile";
	horizSizing = "right";
	vertSizing = "bottom";
	position = "0 0";
	extent = "640 480";
	minExtent = "8 8";
	visible = "1";
	hideCursor = "0";
	bypassHideCursor = "0";
	helpTag = "0";

	new ShellPaneCtrl(YogiStatsWindow) {
		profile = "ShellWindowProfile";
		horizSizing = "right";
		vertSizing = "bottom";
		position = "94 95";
		extent = "458 339";
		minExtent = "48 92";
		visible = "1";
		hideCursor = "0";
		bypassHideCursor = "0";
		helpTag = "0";
		text = "MATCH STATS OPTIONS";
		longTextBuffer = "0";
		maxLength = "255";
		noTitleBar = "0";

		new GuiTextCtrl() {
			profile = "CenterPrintTextProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "60 54";
			extent = "191 22";
			minExtent = "8 8";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";
			text = "Demo Recorder\'s Name:";
			longTextBuffer = "0";
			maxLength = "255";
		};
		new GuiTextCtrl() {
			profile = "CenterPrintTextProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "60 89";
			extent = "176 22";
			minExtent = "8 8";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";
			text = "Demo Recorder\'s Tag:";
			longTextBuffer = "0";
			maxLength = "255";
		};
		new ShellTextEditCtrl(YogiStatsName) {
			profile = "NewTextEditProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "250 45";
			extent = "159 38";
			minExtent = "32 38";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			variable = "$YogiPref::StatTracker::Me";
			helpTag = "0";
			longTextBuffer = "0";
			maxLength = "255";
			historySize = "0";
			password = "0";
			IRCName = "0";
			tabComplete = "0";
			deniedSound = "InputDeniedSound";
			glowOffset = "9 9";
		};
		new ShellTextEditCtrl(YogiStatsTag) {
			profile = "NewTextEditProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "250 81";
			extent = "159 38";
			minExtent = "32 38";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			variable = "$YogiPref::StatTracker::PlayerTag";
			helpTag = "0";
			longTextBuffer = "0";
			maxLength = "255";
			historySize = "0";
			password = "0";
			IRCName = "0";
			tabComplete = "0";
			deniedSound = "InputDeniedSound";
			glowOffset = "9 9";
		};
		new ShellBitmapButton() {
			profile = "ShellButtonProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "66 277";
			extent = "140 38";
			minExtent = "32 38";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			command = "YMSStartTracking();";
			helpTag = "0";
			text = "GO!";
			simpleStyle = "0";
		};
		new ShellBitmapButton() {
			profile = "ShellButtonProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "243 274";
			extent = "140 38";
			minExtent = "32 38";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			command = "YMSStatsDialogClose();";
			helpTag = "0";
			text = "Cancel";
			simpleStyle = "0";
		};
		new GuiTextCtrl() {
			profile = "CenterPrintTextProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "60 124";
			extent = "176 22";
			minExtent = "8 8";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";
			text = "Opponent\'s Tag:";
			longTextBuffer = "0";
			maxLength = "255";
		};
		new GuiTextCtrl() {
			profile = "CenterPrintTextProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "61 161";
			extent = "176 22";
			minExtent = "8 8";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";
			text = "Date:";
			longTextBuffer = "0";
			maxLength = "255";
		};
		new GuiTextCtrl() {
			profile = "CenterPrintTextProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "60 195";
			extent = "176 22";
			minExtent = "8 8";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";
			text = "Reason:";
			longTextBuffer = "0";
			maxLength = "255";
		};
		new ShellTextEditCtrl(YogiStatsOTag) {
			profile = "NewTextEditProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "250 117";
			extent = "159 38";
			minExtent = "32 38";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			variable = "$YogiPref::MatchStats::OTag";
			helpTag = "0";
			longTextBuffer = "0";
			maxLength = "255";
			historySize = "0";
			password = "0";
			IRCName = "0";
			tabComplete = "0";
			deniedSound = "InputDeniedSound";
			glowOffset = "9 9";
		};
		new ShellTextEditCtrl(YogiStatsDate) {
			profile = "NewTextEditProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "250 153";
			extent = "159 38";
			minExtent = "32 38";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			variable = "$YogiPref::MatchStats::Date";
			helpTag = "0";
			longTextBuffer = "0";
			maxLength = "255";
			historySize = "0";
			password = "0";
			IRCName = "0";
			tabComplete = "0";
			deniedSound = "InputDeniedSound";
			glowOffset = "9 9";
		};
		new ShellTextEditCtrl(YogiStatsReason) {
			profile = "NewTextEditProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "250 189";
			extent = "159 38";
			minExtent = "32 38";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			variable = "$YogiPref::MatchStats::Reason";
			helpTag = "0";
			longTextBuffer = "0";
			maxLength = "255";
			historySize = "0";
			password = "0";
			IRCName = "0";
			tabComplete = "0";
			deniedSound = "InputDeniedSound";
			glowOffset = "9 9";
		};
		new GuiTextCtrl() {
			profile = "CenterPrintTextProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "60 226";
			extent = "176 22";
			minExtent = "8 8";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";
			text = "Game Type:";
			longTextBuffer = "0";
			maxLength = "255";
		};
		new ShellPopupMenu(YogiStatsGameType) {
			profile = "ShellPopupProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "250 225";
			extent = "159 38";
			minExtent = "49 36";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";
			longTextBuffer = "0";
			maxLength = "255";
			maxPopupHeight = "200";
			buttonBitmap = "gui/shll_pulldown";
			rolloverBarBitmap = "gui/shll_pulldownbar_rol";
			selectedBarBitmap = "gui/shll_pulldownbar_act";
			noButtonStyle = "0";
		};
	};
};
//--- OBJECT WRITE END ---
//--- OBJECT WRITE BEGIN ---
new GuiControl(YMSOptions) {
	profile = "GuiDefaultProfile";
	horizSizing = "right";
	vertSizing = "bottom";
	position = "0 0";
	extent = "640 480";
	minExtent = "8 8";
	visible = "1";
	hideCursor = "0";
	bypassHideCursor = "0";
	helpTag = "0";

	new ShellPaneCtrl() {
		profile = "ShellWindowProfile";
		horizSizing = "right";
		vertSizing = "bottom";
		position = "129 126";
		extent = "370 200";
		minExtent = "48 92";
		visible = "1";
		hideCursor = "0";
		bypassHideCursor = "0";
		helpTag = "0";
		text = "MATCH STATS OPTIONS";
		longTextBuffer = "0";
		maxLength = "255";
		noTitleBar = "0";

		new ShellPopupMenu(YMSCssList) {
			profile = "ShellPopupProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "139 58";
			extent = "185 36";
			minExtent = "49 36";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";
			longTextBuffer = "0";
			maxLength = "255";
			maxPopupHeight = "200";
			buttonBitmap = "gui/shll_pulldown";
			rolloverBarBitmap = "gui/shll_pulldownbar_rol";
			selectedBarBitmap = "gui/shll_pulldownbar_act";
			noButtonStyle = "0";


		};
		new GuiTextCtrl() {
			profile = "GuiChatHudProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "59 67";
			extent = "53 20";
			minExtent = "8 8";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";
			text = "CSS File:";
			longTextBuffer = "0";
			maxLength = "255";
		};
	};
};
//--- OBJECT WRITE END ---






if(isFile("prefs/YogiPrefs.cs") && !$YogiPrefsLoaded) {
		exec("prefs/YogiPrefs.cs");
		$YogiPrefsLoaded = true;
}
