<?php

# parse_pascalstr function - from user comments on php.net
# by: Ian Redden (iredden@redden.on.ca)

function parse_pascalstr($bytes_parsed, $parse_str) { 
	$parse_info = unpack("x$bytes_parsed/Cstr_len", $parse_str);
	$str_len = $parse_info["str_len"]; 
	$bytes_parsed = $bytes_parsed + 1; 
	$parse_info = unpack("x$bytes_parsed/A".$str_len."str", $parse_str); 
	$str = $parse_info["str"]; 
	$bytes_parsed = $bytes_parsed + strlen($str); 
	return array($str, $bytes_parsed); 
}

function parse_long_pascalstr($bytes_parsed, $parse_str) {
	$parse_info = unpack("x$bytes_parsed/vstr_len", $parse_str);
	$str_len = $parse_info["str_len"]; 
	$bytes_parsed = $bytes_parsed + 2;
	$parse_info = unpack("x$bytes_parsed/A".$str_len."str", $parse_str); 
	$str = $parse_info["str"]; 
	$bytes_parsed = $bytes_parsed + strlen($str); 
	return array($str, $bytes_parsed); 
}

function query_tribes2($ip, $port) {
	$tqSocket = fsockopen("udp://$ip", $port);
	$tqSocket2 = fsockopen("udp://$ip", $port);

	if ($tqSocket && $tqSocket2) {
		$binary = pack("CCL", 14, 2, 1234);
		$binary2 = pack("CCL", 18, 2, 1234);
	
		socket_set_blocking($tqSocket, 0);
		socket_set_blocking($tqSocket2, 0);
		socket_set_timeout($tqSocket, 2);
		socket_set_timeout($tqSocket2, 2);

		$start = time();	

		fputs($tqSocket, $binary, 6);
		fputs($tqSocket2, $binary2, 6);

		while ((time() - $start <= 2) && (($rawdata == "") || ($rawdata2 == ""))) {
       		if ($rawdata == "") $rawdata = fread ($tqSocket,2048);
   	   		if ($rawdata2 == "") $rawdata2 = fread ($tqSocket2,2048);
   	   	}
      	
		if (($rawdata == "") || ($rawdata2 == "")) return false;

		# Not really relevant information at the beginning
   	   	$cbyte = 6;
      	
       	$queryversion = parse_pascalstr($cbyte, $rawdata);
   	   	$cbyte = $queryversion[1];
      	$queryversion = $queryversion[0];
      	
		if ($queryversion == "VER5") {		
      		$build = unpack("x$cbyte/Lnet/Lnetmin/Lbuild", $rawdata);
       		$cbyte += 12;
   	   		$netversion = $build["net"];
      			$netversionmin = $build["netmin"];
      			$build = $build["build"];
      	}
      	else {
       		$verinfo = unpack("x$cbyte/Lnet/Lbuild", $rawdata);
   	   		$cbyte += 8;
      		$netversion = $verinfo["net"];
      		$build = $verinfo["build"];
      	}
      	
       	$name = parse_pascalstr($cbyte, $rawdata);
   	   	$cbyte = $name[1];
   		$name = $name[0];
     	
   		# Done with the first query (basic info)
   		# Onto the second (hideously ugly) part
     	
   		#ignore the silly irrelevant info at the start :)
   		$cbyte = 6;
     		
   		$mod = parse_pascalstr($cbyte, $rawdata2);
   		$cbyte = $mod[1];
   		$mod = $mod[0];

   		$maptype = parse_pascalstr($cbyte, $rawdata2);
   		$cbyte = $maptype[1];
   		$maptype = $maptype[0];

   		$map = parse_pascalstr($cbyte, $rawdata2);
   		$cbyte = $map[1];
   		$map = $map[0];
     	
   		$status = unpack("x$cbyte/C4/vcpu", $rawdata2);
   		$cbyte += 6;
   		$players = $status[2];
   		$maxplayers = $status[3];
   		$bots = $status[4];
   		$cpu = $status["cpu"];
   		$status = $status[1];
     	
		if ($status & 1) $dedicated = "Yes";
		else $dedicated = "No";
		if ($status & 2) $password = "Yes";
		else $password = "No";
		if ($status & 4) $linux = "Linux";
		else $linux = "Win32";
		if ($status & 8) $tournament = "Yes";
		else $tournament = "No";
		if ($status & 16) {
			$noalias = "Yes";
			$alias_allowed = "No";
		}
		else {
			$noalias = "No";
			$alias_allowed = "Yes";
		}
		if (($status & 64) && ($queryversion == "VER3")) $tournament = "Yes";
		else $tournament = "No";		
		if (($status & 128) && ($queryversion == "VER3")) {
			$noalias = "Yes";
			$alias_allowed = "No";
		}
		else {
			$noalias = "No";
			$alias_allowed = "Yes";
		}

   		$serverinfo = parse_pascalstr($cbyte, $rawdata2);
   		$cbyte = $serverinfo[1];
   		$serverinfo = $serverinfo[0];
     	
   		$content = parse_long_pascalstr($cbyte, $rawdata2);
   		$cbyte = $content[1];
   		$content = $content[0];

		$tokens1 = explode("\x0A", $content . "\x0A\x09");
	
		$numteams = $tokens1[0];
		$teamname[0] = "Unassigned";
		$teamsize[0] = 0;
		$teamscore[0] = 0;
		$teamnum["Unassigned"] = 0;
		for ($i = 1; $i <= $numteams; $i++) {
			$tokens2 = explode("\x09", $tokens1[$i]);
			$teamname[$i] = $tokens2[0];
			$teamscore[$i] = $tokens2[1];
			$teamsize[$i] = 0;
			$teamnum[$tokens2[0]] = $i;
		}
	
		$entries = $tokens1[$numteams+1];
	
		for ($i = 0; $i < $entries; $i++) {
			$tokens2 = explode("\x09", $tokens1[$i + $numteams + 2]);
			$playername[$i] = $tokens2[0];
			$playerteam[$i] = $tokens2[1];
			$playerscore[$i] = $tokens2[2];
		
			if (strrchr($playername[$i], "\x08") != false) $playerflags[$i] = "Registered";
			if (strrchr($playername[$i], "\x0C") != false) $playerflags[$i] = $playerflags[$i] . "Alias";
			if (strrchr($playername[$i], "\x0E") != false) $playerflags[$i] = $playerflags[$i] . "Bot";
		
			$playername[$i] = str_replace("\x10", "", $playername[$i]);
			$playername[$i] = str_replace("\x11", "", $playername[$i]);

			$playername[$i] = str_replace("\x08", "", $playername[$i]);
			$playername[$i] = str_replace("\x0C", "", $playername[$i]);
			$playername[$i] = str_replace("\x0E", "", $playername[$i]);
			$playername[$i] = str_replace("\x0B", "", $playername[$i]);
		
			$teamplayers[$teamnum[$playerteam[$i]]][$teamsize[$teamnum[$playerteam[$i]]]] = $i;
			$teamsize[$teamnum[$playerteam[$i]]]++;
		}

   		fclose ($tqSocket);
   		fclose ($tqSocket2);

		$return = array (
			"name" => $name,
			"netversion" => $netversion,
			"netversionmin" => $netversionmin,
			"build" => $build,
			"queryversion" => $queryversion,
			"mod" => $mod,
			"maptype" => $maptype,
			"map" => $map,
			"status" => $status,
			"players" => $players,
			"maxplayers" => $maxplayers,
			"bots" => $bots,
			"cpu" => $cpu,
			"info" => $serverinfo,
			"playername" => $playername,
			"playerflags" => $playerflags,
			"playerteam" => $playerteam,
			"playerscore" => $playerscore,
			"teamname" => $teamname,
			"teamscore" => $teamscore,
			"teamsize" => $teamsize,
			"numteams" => $numteams,
			"playerentries" => $entries,
			"dedicated" => $dedicated,
			"password" => $password,
			"linux" => $linux,
			"tournament" => $tournament,
			"noalias" => $noalias,
			"teamplayers" => $teamplayers,
			"alias_allowed" => $alias_allowed
		);

		return $return;
	}
	else {
		return false;
	}
}

?>