// #autoload
// #name = Task Beep
// #version = 1.0
// #date = April 30, 2001
// #author = Jason "VeKToR" Gill
// #warrior = VeKToR++
// #email = vektor@linux.ca
// #web = http://scripts.tribalwar.com/vektor
// #description = Makes a beeping sound whenever a task is issued
// #status = release

// Oh, and |eX|Silver did some stuff too. Like sending me .wav files and stuff.

package TaskBeep {

	function PlayGui::onWake(%this) {
		%xpos = (getword($pref::Video::resolution, 0) / 2) - (100 / 2);
		TaskBeepPopupDlg.position = %xpos @ " 370";
		TaskBeepPopupDlg.extent = "100 20";
		playgui.add($TogglePopup);		
		parent::onWake(%this);
	}

	function PlayGui::onSleep(%this) {
		playgui.remove($TogglePopup);
		parent::onSleep(%this);
	}

	function clientCmdTaskInfo(%client, %aiObjtive, %team, %description)
	{
		if ($TaskBeep_active) 
			alxPlay(alxCreateSource(AudioChat, "taskbeep.wav"));

		parent::clientCmdTaskInfo(%client, %aiObjtive, %team, %description);
	}

};
activatePackage(TaskBeep);

$TaskBeep_active = true;

function ToggleTaskBeep(%val) {
	echo("Called!");
	if (%val) {
		echo(%val);
		$TaskBeep_active = !$TaskBeep_active;
		
		// Popup the funky thingy
		// I even blatantly ripped the hud position mostly from PJ's thingy. I need to learn this more :P
		if ($TaskbeepSchedule) 
			cancel($TaskBeepSchedule);
			
		if ($TaskBeep_active)
			TaskBeepPopupText.setText("<just:center><color:2cacb5>TaskBeep is<color:ffffff> on");
		else
			TaskBeepPopupText.setText("<just:center><color:2cacb5>TaskBeep is<color:ffffff> off");

		TaskBeepPopupDlg.setVisible(true);
		$taskBeepSchedule = schedule(2500, 0, "removeTaskBeepPopup");
	}
}

function removeTaskBeepPopup() {
	TaskBeepPopupDlg.setVisible(false);
	TaskBeepPopupText.setText("");
}

$RemapName[$RemapCount] = "Toggle TaskBeep";
$RemapCmd[$RemapCount] = "ToggleTaskBeep";
$RemapCount++;

// Blatantly modified version of PJ's kill popup thingy because I'm GUI inept :|
new GuiControlProfile ("GuiTaskBeepPopupText")
{
	fontType = "Univers";
	fontSize = 14;
	fontColor = "169 215 250";
   fontColors[6] = "255 255 255";
   fontColors[7] = "255 255 255";
   fontColors[8] = "255 255 255"; 
   fontColors[9] = "255 255 255";   
};

new GuiControlProfile ("GuiTaskBeepPopupFrame")
{
   bitmapbase = "gui/hud_new_window";
};

$TogglePopup = new ShellFieldCtrl(TaskBeepPopupDlg) {
	profile = "GuiTaskBeepPopupFrame";
	horizSizing = "center";
	vertSizing = "top";
	position = "300 342";
	extent = "180 50";
	minExtent = "8 8";
	visible = "0";
	helpTag = "0";
	
	new GuiMLTextCtrl(TaskBeepPopupText) {
		profile = "GuiTaskBeepPopupText";
		horizSizing = "center";
		vertSizing = "top";
		position = "0 0";
		extent = "176 34";
		minExtent = "8 8";
		visible = "1";
		helpTag = "0";
		lineSpacing = "0";
		allowColorChars = "0";
		maxChars = "-1";
	};
};
