unit WPopOutFntCBox;
//--------------------------------------------------------------------
//--------------------------------------------------------------------
//--
//--  WAISS TWPOPOUTFNTCBOX
//--  PopOut Font Combo Box Component
//--  Version 1.0 Beta
//--
//--  This component is released as PromotionWare. You are givin the right to use it,
//--  however you may not distribute the Code in a altered state.
//--
//--  This Component will be part of the WAISS Level 2 Component Program - Check
//--  our web site http://www.waiss.com for more information - coming soon
//--
//--
//--   TWPopPutFntCbox is a Corel draw type font combo box that pops out a
//--  window with a preview of the curent font when the list portion of the
//--  box is droped down. The Preview updates itself to the correct font
//--  when the mouse or the selection is moved over a font name in the drop
//--  down portion of the box. The Text to show in the pop up box can either
//--  be set at dsign time or run time or can automaticlly be the selected
//--  text from a TCustomEdit Component attache to the AttachedEdit Property.
//--  The component also has a MoveUsedToTop Property, that when enabled will
//--  move the selected font to the top of the list and will draw a double line
//--  to indicate where the seperation between the regular fonts and the MRU
//--  Fonts are. All other asspects of the component are highly configurable.
//--
//--  WAISS Systems - http://www.waiss.com
//--
//--  Limited Technical Support is available at support@waiss.com or aisssoft@aol.com

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, POFCBox;

type
  TWPopOutFntCBox = class(TCustomComboBox)
  private
    { Private declarations }
    Pform:TPForm;
    fPopWidth,fPopHeight:Integer;
    fFontName:String;
    fMoveUsed:Boolean;
    NumUsed:integer;
    DDown:Boolean;
    fOnClick:TNotifyEvent;
    fCustEdit:TCustomEdit;

    Procedure CNCOmmand( Var Message: TWMCommand ); message CN_COMMAND;
    Procedure SetPopHeight(High:integer);
    Procedure SetPopWidth(Wide:Integer);
    Procedure SetFontName(FntNme:String);
    
  protected
    { Protected declarations }
    fText:String;
  public
    { Public declarations }
   constructor Create(AOwner: TComponent); override;
   destructor  Destroy; override;

   procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
  published
    { Published declarations }
   // Procedure OnEnter;Override;
   Property OnChange;
   Property OnClick;
   Property OnDblClick;
   Property OnDragDrop;
   Property OnDragOver;
   Property OnDropDown;
   Property OnEndDrag;
   Property OnExit;
   //Property OnEnter;
   Property OnKeyDown;
   Property OnKeyPress;
   Property OnKeyUp;
   Property OnStartDrag;

   Property Color;
   Property Ctl3D;
   Property Cursor;
   Property DragCursor;
   Property DragMode;
   Property DropDownCount;
   Property Enabled;
   Property Font;
   Property Height;
   Property HelpContext;
   Property Hint;
   Property ImeMode;
   Property ImeName;
   Property Left;
   Property ParentColor;
   Property ParentCtl3D;
   Property ParentFont;
   Property ParentShowHint;
   Property PopUpMenu;
   Property ShowHint;
   Property TabOrder;
   Property TabStop;
   Property Visible;
   //Property Click:TNotifyEvent read fOnClick write fOnClick;
   Property MoveUsedToTop:Boolean Read fMoveUsed Write fMoveUsed;
     Procedure SetPText(ntext:String);
   Property PreviewText:String Read fText Write SetPText;
   Property PopUpWidth:Integer Read fPopWidth Write SetPopWidth default 300;
   Property PopUpHeight:Integer Read fPopHeight Write SetPopHeight default 50;
   Property FontName:String Read fFontName Write SetFontName;
   Property AttachedEdit:TCustomEdit Read fCustEdit Write fCustEdit;

   Procedure DropDown; override;
  Procedure Click; override;
   Procedure DrawItem( Index: Integer;
  Rect: TRect; State: TOwnerDrawState);Override;


  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('WAISS', [TWPopOutFntCBox]);
end;
//------------------------------------------------------------------------------
procedure TWPopOutFntCBox.CMMouseEnter(var Message: TMessage);
Var pnt:TPoint;
Begin
  inherited;


end;
//------------------------------------------------------------------------------
procedure TWPopOutFntCBox.CMMouseLeave(var Message: TMessage);
begin
inherited;
 //pform.Hide;
end;
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
Procedure TWPopOutFntCBox.setPText(ntext:String);
Begin
fText := ntext;
PForm.Panel1.Caption := fText;
end;
//------------------------------------------------------------------------------
Procedure TWPopOutFntCBox.DrawItem( Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
begin
With self.Canvas Do
 Begin
 FillREct(Rect);
 Textout(4,REct.Top,self.Items[index]);
 if odFocused in state then
 Begin
  Pform.Panel1.Font.Name :=self.Items[index];
  If PreViewText = '' then
  Pform.Panel1.Caption := 'AaBbYyZz';
  end;
  if (fMoveUsed) and (index = numused) then
  begin
   MoveTo(0,Rect.Bottom - 3);
   LineTo(width,Rect.Bottom - 3);
   MoveTo(0,Rect.Bottom-1);
   LineTo(width,Rect.Bottom-1);
   end;

  end;
end;
//------------------------------------------------------------------------------
Procedure TWPopOutFntCBox.DropDown;
var pnt:TPoint;
Begin
ddown := True;
If Assigned(fCustEdit) then
begin
  If fCustEdit.SelLength >0 then
  PreviewText := fCustEdit.SelText
  else
  PreViewText := 'AaBbYyZz';
end;

If Items.Count = 0 then
 Begin
 Items.Assign(Screen.Fonts);
 fFontName := FontName;
 End;
inherited Dropdown;
pnt.x := (Self.Left )+ Self.width;
pnt.y := (Self.Top )+ Self.height ;
pnt := Parent.ClientToScreen(pnt);
Pform.Top := pnt.y;
Pform.Left := pnt.x;

If Pform.Left+Pform.Width > Screen.Width then
Begin
   pnt.x := (Self.Left );

    pnt := Parent.ClientToScreen(pnt);
   //Pform.Top := pnt.y;
   Pform.Left := pnt.x - PForm.Width;
end;
If Pform.Top+Pform.Height > Screen.Height then
Begin
   pnt.y := (Self.Top );

    pnt := Parent.ClientToScreen(pnt);
   //Pform.Top := pnt.y;
   Pform.Top := pnt.y - PForm.Height;
end;

//ShowMessage(inttostr(Pform.Width));
ShowWindow( Pform.handle, SW_SHOWNA );

End;
//------------------------------------------------------------------------------
Procedure TWPopOutFntCBox.Click;
var ind:integer;
begin

 If ddown = false then
 Begin
 FontName := Items[ItemIndex];
 inherited click;
 End;

//Itemindex := 0;
//fFontName := Items[ItemIndex];

//Inherited Click;
End;
//------------------------------------------------------------------------------
constructor TWPopOutFntCBox.Create(AOwner: TComponent);
var i:integer;

begin

inherited Create(AOwner);
PForm := TPForm.create(nil);
Pform.Height := 0;
Pform.Width := 0;
Pform.Visible := True;
ShowWindow(Pform.Handle,SW_HIDE );
fPopWidth := 300;
fPopHeight := 75;
Pform.Height := 75;
Pform.Width := 300;
fFontName := 'MS Sans Serif';
Text := 'MS Sans Serif';
//Itemindex := Items.IndexOf('MS Sans Serif');
Style := csOwnerDrawFixed;
Pform.Color := ClWhite;
//PreViewText := 'ABCabcXYZ123.?';
fMoveUsed := True;
NumUsed := -1;
ddown := False;
end;
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
destructor TWPopOutFntCBox.Destroy;
begin
PForm.Free;
inherited destroy;
end;
//------------------------------------------------------------------------------

procedure TWPopOutFntCBox.CNCommand(var Message: TWMCommand);
Var ind:integer;
begin
  If Message.NotifyCode =  CBN_CLOSEUP Then
  Begin
  ddown := False;
    If (fMoveUsed = true) and (Itemindex <> 0) then
    Begin
      ind := itemindex;
      if itemindex = -1 then exit;
      Items.Move(Itemindex,0);
      Itemindex := 0;
      If ind > NumUsed then
      inc(Numused);
    End;

    ShowWindow(Pform.Handle,SW_HIDE ) ;
    Text := fFontName;
    FontName := Text;
    inherited click;
    end

  Else
    inherited;
end;
//------------------------------------------------------------------------------
Procedure TWPopOutFntCBox.SetPopHeight(High:integer);
Begin
fPopHeight := high;
Pform.Height := high;
End;
//------------------------------------------------------------------------------
Procedure TWPopOutFntCBox.SetPopWidth(wide:integer);
Begin
fPopWidth := wide;
PForm.Width := wide;
End;
//------------------------------------------------------------------------------
Procedure TWPopOutFntCBox.SetFontName(FntNme:String);
Begin
fFontName := FntNme;


If Items.Count = 0 then
 Items.Assign(Screen.Fonts);

Itemindex := items.IndexOf(fntnme);
PForm.Panel1.Font.Name := FntNme;


end;
end.
