unit OutlookBtn;

(*

  NEW PROPERTYS
   Autor Daniel Ramirez Jaime
   email: rdaniel2000@hotmail.com
   http://www.cwinsystems.8k.com

   Property StyleBorder2000  Border like Outlook 2000
   Property Color            Color for Button OutLook
   Property ColorChecked     Color for Text
   Property DownArrow        Arrow for Title
   Property DropDownMenu     PopupMenu
   Property FontActiveColor  Color for active Text

   This Works in Delphi 3,4 and 5

   -------------------------------------------------------------------------
  TOutlookButton - freeware button component for Inprise Delphi 2,3, and 4

  by Jury Gerasimov
  jury@gera.irk.ru
  http://gera.irk.ru

This is a button that can have different looks:
	- as Outlook Bar button
	- as Microsoft Office toolbar button
	- as fully transparent button

The TOutlookButton component was developed for the Chameleon Clock. This is a 
digital desktop clock that changes its skin using Winamp skins and digit styles.
Its features include MP3 alarms, time synchronization with Internet Time 
Servers, random change of skins, and more. If you like TOutlookButton component
- please support the author and download Chameleon Clock from
http://gera.irk.ru/cham

*)

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, StdCtrls, ExtCtrls, menus, Dialogs;

type
  BStyle = (btnsNone,btnsNormal,btnsMSOffice,btnsOutlook, btnsCorel);
  FStyle = (fsNone,fsDialog,fsItem,fsTitle,fsItemGroup);

  TOutlookBtn = class(TGraphicControl)
  private
    FBitmap : TBitmap;
    fMouseOver : Boolean;
    Pushed : boolean;
    SB2 : boolean;
    fDownArrow : boolean;
    fStyle : BStyle;
    ffStyle : fStyle;
    BRect,ItemRect : Trect;
    fcolor:TColor;
    fColorChecked:TColor;
    fChecked : boolean;
    TDown : boolean;
    TDownButton : boolean;
    fCaption : string;
    fFontActiveColor:TColor;
    FDropdownMenu: TPopupMenu;
    procedure SetChecked(Value : boolean);
    procedure SetDownArrow(Value : boolean);
    procedure SetDown(Value : boolean);
    procedure SetDownButton(Value : boolean);
    procedure SetBitmap(Value : TBitmap);
    procedure SetCaption(Value : string);
    procedure SetColor(Value : TColor);
    procedure SetFontActiveColor(Value : TColor);
    procedure SetColorChecked(Value : TColor);
    procedure SetDropdownMenu (Value: TPopupMenu);
    procedure WMLButtonDown(var msg: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure WMLButtonUp(var msg: TWMLButtonUp); message WM_LBUTTONUP;
    function OnGlyphP(X, Y: integer): boolean;
    procedure mouseleave(var msg : tmessage); message cm_mouseleave;
    procedure mousein(var msg : tmessage); message cm_mouseenter;
    procedure SetStyleStyle(value:Bstyle);
    procedure SetFormatStyle(value:fstyle);
  protected
    procedure Paint; override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Click; override;
  published
    procedure DrawTransparentBitmap (ahdc: HDC; Image: TBitmap; xStart, yStart: Word; TrCol : Tcolor);
    property Bitmap : TBitmap read FBitmap write SetBitmap;
    Property OnClick;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property Visible;
    property PopUpMenu;
    Property Hint;
    Property ShowHint;
    property Checked : boolean read fChecked write SetChecked;
    Property Style : BStyle read fStyle write SetStyleStyle;
    Property FormatStyle : fStyle read ffStyle write SetFormatStyle;
    Property Caption : string read fCaption write SetCaption;
    Property Font;
    Property StyleBorder2000 :Boolean read SB2 write SB2;
    Property Color: TColor read fColor write SetColor;
    Property FontActiveColor: TColor read fFontActiveColor write SetFontActiveColor;
    Property ColorChecked: TColor read fColorChecked write SetColorChecked;
    Property DownArrow: Boolean read fDownArrow write SetDownArrow;
    Property DropdownMenu: TPopupMenu read FDropdownMenu write SetDropdownMenu;
    Property DownButton:Boolean read TDownButton write SetDownButton;
    Property Down:Boolean read TDown write SetDown;
  end;

procedure Register;

implementation
{$R *.dcr}

constructor TOutlookBtn.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Width := 30;
  Height := 30;
  FBitmap := TBitmap.Create;
  ControlStyle := ControlStyle - [csOpaque];
  Pushed := false;
  Font.name := 'Tahoma';
  Font.size := 8;
  fStyle := btnsNormal;
  ffStyle:= fsNone;
  fCaption := Name;
  SB2:=True;
  Checked:=False;
  fcolor:=clBtnFace;
  fcolorChecked:=clBtnFace;
  fFontActiveColor:=clBtnText;
end;

destructor TOutlookBtn.Destroy;
begin
  FBitmap.Free;
  inherited Destroy;
end;

procedure TOutlookBtn.SetChecked(Value : boolean);
begin
  if fChecked <> value then
  begin
    fChecked := value;
    invalidate;
  end;
end;

procedure TOutlookBtn.SetDownArrow(Value : boolean);
begin
  if fDownArrow <> value then
  begin
    fDownArrow := value;
    invalidate;
  end;
end;

procedure TOutlookBtn.SetDown(Value : boolean);
begin
  if tDown <> value then
  begin
    tDown := value;
    invalidate;
  end;
end;

procedure TOutlookBtn.SetDownButton(Value : boolean);
begin
  if tDownButton <> value then
  begin
    tDownButton := value;
    Pushed:=tDownButton;
    invalidate;
  end;
end;


procedure TOutlookBtn.SetColor(Value : TColor);
begin
  fColor := value;
  invalidate;
end;

procedure TOutlookBtn.SetFontActiveColor(Value : TColor);
begin
  fFontActiveColor := value;
  invalidate;
end;

procedure TOutlookBtn.SetColorChecked(Value : TColor);
begin
  fColorChecked := value;
  invalidate;
end;

procedure TOutlookBtn.SetBitmap(Value : TBitmap);
begin
  FBitmap.Assign(Value);
  invalidate;
end;

{this routine come from unit XparBmp of Michael Vincze (vincze@ti.com), I think it can be
optimized more. Will find time to check it again}
procedure TOutlookBtn.DrawTransparentBitmap (ahdc: HDC; Image: TBitmap; xStart, yStart: Word; TrCol : Tcolor);
var
  TransparentColor: TColor;
  cColor          : TColorRef;
  bmAndBack,
  bmAndObject,
  bmAndMem,
  bmSave,
  bmBackOld,
  bmObjectOld,
  bmMemOld,
  bmSaveOld       : HBitmap;
  hdcMem,
  hdcBack,
  hdcObject,
  hdcTemp,
  hdcSave         : HDC;
  ptSize          : TPoint;
begin
TransparentColor := TrCol;
TransparentColor := TransparentColor or $02000000;

hdcTemp := CreateCompatibleDC (ahdc);
SelectObject (hdcTemp, Image.Handle); { select the Bitmap }
ptSize.x := Image.Width;
ptSize.y := Image.Height;
DPtoLP (hdcTemp, ptSize, 1);  { convert from device logical points }
hdcBack   := CreateCompatibleDC(ahdc);
hdcObject := CreateCompatibleDC(ahdc);
hdcMem    := CreateCompatibleDC(ahdc);
hdcSave   := CreateCompatibleDC(ahdc);

bmAndBack   := CreateBitmap (ptSize.x, ptSize.y, 1, 1, nil);
bmAndObject := CreateBitmap (ptSize.x, ptSize.y, 1, 1, nil);

bmAndMem    := CreateCompatibleBitmap (ahdc, ptSize.x, ptSize.y);
bmSave      := CreateCompatibleBitmap (ahdc, ptSize.x, ptSize.y);

bmBackOld   := SelectObject (hdcBack, bmAndBack);
bmObjectOld := SelectObject (hdcObject, bmAndObject);
bmMemOld    := SelectObject (hdcMem, bmAndMem);
bmSaveOld   := SelectObject (hdcSave, bmSave);

SetMapMode (hdcTemp, GetMapMode (ahdc));
BitBlt (hdcSave, 0, 0, ptSize.x, ptSize.y, hdcTemp, 0, 0, SRCCOPY);
cColor := SetBkColor (hdcTemp, TransparentColor);
BitBlt (hdcObject, 0, 0, ptSize.x, ptSize.y, hdcTemp, 0, 0, SRCCOPY);

SetBkColor (hdcTemp, cColor);
BitBlt (hdcBack, 0, 0, ptSize.x, ptSize.y, hdcObject, 0, 0, NOTSRCCOPY);

BitBlt (hdcMem, 0, 0, ptSize.x, ptSize.y, ahdc, xStart, yStart, SRCCOPY);
BitBlt (hdcMem, 0, 0, ptSize.x, ptSize.y, hdcObject, 0, 0, SRCAND);
BitBlt (hdcTemp, 0, 0, ptSize.x, ptSize.y, hdcBack, 0, 0, SRCAND);
BitBlt (hdcMem, 0, 0, ptSize.x, ptSize.y, hdcTemp, 0, 0, SRCPAINT);
BitBlt (ahdc, xStart, yStart, ptSize.x, ptSize.y, hdcMem, 0, 0, SRCCOPY);
BitBlt (hdcTemp, 0, 0, ptSize.x, ptSize.y, hdcSave, 0, 0, SRCCOPY);
DeleteObject (SelectObject (hdcBack, bmBackOld));
DeleteObject (SelectObject (hdcObject, bmObjectOld));
DeleteObject (SelectObject (hdcMem, bmMemOld));
DeleteObject (SelectObject (hdcSave, bmSaveOld));
DeleteDC (hdcMem);
DeleteDC (hdcBack);
DeleteDC (hdcObject);
DeleteDC (hdcSave);
DeleteDC (hdcTemp);
end;

procedure TOutlookBtn.setStylestyle(value:Bstyle);
begin
if fStyle <> value then
 begin
  fStyle := value;
  Invalidate;
 end;
end;

procedure TOutlookBtn.SetFormatStyle(value:fstyle);
begin
if ffStyle <> value then
 begin
  ffStyle := value;
  Cursor:=crDefault;
  Case ffStyle of
  fsDialog:
    Begin
      DownArrow:=False;
      SB2:=True;
      Width:=86; Height:=67;
      Style:=btnsOutlook;
      Color:=clWhite;
      ColorChecked:=clGray;
      Font.name := 'Tahoma';
      Font.size := 8;
      Font.Color:= clBlack;
      Font.Style:=[];
      fFontActiveColor:=clWhite;
      Checked:=False;
      Down:=True;
    End;
  fsItem:
    Begin
      DownArrow:=False;
      SB2:=True;
      Width:=78; Height:=64;
      Style:=btnsOutlook;
      Color:=clWhite;
      ColorChecked:=clGray;
      Font.name := 'Tahoma';
      Font.size := 8;
      Font.Color:= clBlack;
      Font.Style:=[];
      fFontActiveColor:=clWhite;
      Down:=False;
      Checked:=False;
    End;
  fsTitle:
    Begin
      DownArrow:=True;
      SB2:=True;
//      Width:=66;
      Height:=21;
      Style:=btnsOutlook;
      Color:=clWhite;
      ColorChecked:=clGray;
      Font.Name:='Tahoma';
      Font.Style:=[fsBold];
      Font.Size:=12;
      Font.Color:=clBlack;
      fFontActiveColor:=clWhite;
      Down:=False;
      Checked:=False;
    End;
fsItemGroup:
    Begin
      DownArrow:=False;
      SB2:=True;
      Height:=22;
      Style:=btnsCorel;
      Cursor:=crHandPoint;
      Color:=clbtnFace;
      ColorChecked:=clbtnFace;
      Font.name := 'Tahoma';
      Font.size := 8;
      Font.Color:= clBlack;
      Font.Style:=[];
      fFontActiveColor:=clBlack;
      Down:=False;
      Checked:=False;
    End;
   End;
  Invalidate;
 end;
end;


procedure TOutlookBtn.SetCaption(Value : string);
begin
if FCaption <> value then
 begin
  FCaption := value;
  Invalidate;
 end;
end;

procedure TOutlookBtn.SetDropdownMenu (Value: TPopupMenu);
begin
  if FDropdownMenu <> Value then begin
    FDropdownMenu := Value;
    if Assigned(Value) then
      Value.FreeNotification (Self);
    if FDownArrow then
       Invalidate;
  end;
end;


procedure TOutlookBtn.Paint;
var
  ARect: TRect;
  Tmp : TBitmap;
  x,y,d : integer;
  text : array[0..40] of char;
  Fontheight : integer;

  Procedure Frame3DE(AR:TRect);
  Begin
   AR.Right:=   AR.Right-1;
   AR.Bottom:=   AR.Bottom-1;
   Canvas.Pen.Color:=clBtnHighlight;
   Canvas.MoveTo(AR.Right,AR.Top);
   Canvas.LineTo(AR.Left-1,AR.Top);
   Canvas.MoveTo(AR.Left,AR.Bottom);
   Canvas.LineTo(AR.Left,AR.Top);

   Canvas.Pen.Color:=cl3DLight;
   Canvas.MoveTo(AR.Right,AR.Top+1);
   Canvas.LineTo(AR.Left,AR.Top+1);
   Canvas.MoveTo(AR.Left+1,AR.Bottom);
   Canvas.LineTo(AR.Left+1,AR.Top);

   Canvas.Pen.Color:={cl3DDkShadow;}clBlack;
   Canvas.MoveTo(AR.Right,AR.Bottom);
   Canvas.LineTo(AR.Left-1,AR.Bottom);
   Canvas.MoveTo(AR.Right,AR.Bottom);
   Canvas.LineTo(AR.Right,AR.Top-1);

   Canvas.Pen.Color:=clBtnShadow;
   Canvas.MoveTo(AR.Right-1,AR.Bottom-1);
   Canvas.LineTo(AR.Left,AR.Bottom-1);
   Canvas.MoveTo(AR.Right-1,AR.Bottom-1);
   Canvas.LineTo(AR.Right-1,AR.Top);
   End;

  Procedure Frame3DP(AR:TRect);
  Begin
   AR.Right:=   AR.Right-1;
   AR.Bottom:=   AR.Bottom-1;
   Canvas.Pen.Color:=cl3DDkShadow;
   Canvas.MoveTo(AR.Right,AR.Top);
   Canvas.LineTo(AR.Left-1,AR.Top);
   Canvas.MoveTo(AR.Left,AR.Bottom);
   Canvas.LineTo(AR.Left,AR.Top);

   Canvas.Pen.Color:=clBtnShadow;
   Canvas.MoveTo(AR.Right,AR.Top+1);
   Canvas.LineTo(AR.Left,AR.Top+1);
   Canvas.MoveTo(AR.Left+1,AR.Bottom);
   Canvas.LineTo(AR.Left+1,AR.Top);

   Canvas.Pen.Color:=clBtnHighlight;
   Canvas.MoveTo(AR.Right,AR.Bottom);
   Canvas.LineTo(AR.Left-1,AR.Bottom);
   Canvas.MoveTo(AR.Right,AR.Bottom);
   Canvas.LineTo(AR.Right,AR.Top-1);

   Canvas.Pen.Color:=cl3DLight;
   Canvas.MoveTo(AR.Right-1,AR.Bottom-1);
   Canvas.LineTo(AR.Left,AR.Bottom-1);
   Canvas.MoveTo(AR.Right-1,AR.Bottom-1);
   Canvas.LineTo(AR.Right-1,AR.Top);
   End;


begin
ARect := Rect(0,0,Width,Height);
if fMouseOver and (fStyle = btnsOutlook) then
begin
  canvas.brush.color := fColor;
  canvas.FillRect(ARect);
end;
Canvas.font := font;
if fMouseOver and (fStyle = btnsOutlook) then
  Canvas.font.color := fFontActiveColor;

if (fStyle = btnsCorel) then
  Begin
  canvas.brush.color := fColor;
  canvas.FillRect(ARect);
  End;

FontHeight := Canvas.TextHeight('W');
if not FBitmap.empty then
  begin
  x := (width - FBitmap.width) div 2;
  if caption <> '' then
    y := ((Height - FBitmap.Height- FontHeight) div 2)
  else
   y := ((Height - FBitmap.Height) div 2);
     BRect := rect(x, y, x + FBitmap.width, y + FBitmap.height);
     Tmp := TBitmap.Create;
     Tmp.Height := FBitmap.Height;
     Tmp.Width := FBitmap.Width;
     Tmp.Canvas.CopyRect(ARect, FBitmap.Canvas, ARect);

     If ffStyle in [fsItem,fsTitle] then
        d:=0 else d:=1;

     if pushed then
      DrawTransparentBitmap( Canvas.Handle, Tmp, x +d, y+d, FBitmap.TransparentColor )
     else
      DrawTransparentBitmap( Canvas.Handle, Tmp, x, y, FBitmap.TransparentColor );
     Tmp.Free;
  end;


  if caption <> '' then
  with Canvas do
  begin
   if fChecked then
   begin
    Brush.Style := bsSolid;
    Brush.Color :=fColor;
    Font.Color := clBtnText;
   end
   else
     Brush.Style := bsClear;
   with ARect do
    begin
     if FBitmap.empty then
       Top := ((Bottom + Top) - FontHeight) shr 1
     else
       top := Brect. bottom+3;
      Bottom := Top + FontHeight;

     if ffStyle in [fsDialog, fsNone] then
      if pushed then
        begin
         top := top + 1;
         left := 2;
        end;
    end;
    StrPCopy(Text, Caption);
    if FDownArrow then
    Begin
    Arect.Left:=Arect.Left+4;
    DrawText(Handle, Text, StrLen(Text), ARect, (DT_EXPANDTABS or DT_Left));
    End
    else
    DrawText(Handle, Text, StrLen(Text), ARect, (DT_EXPANDTABS or DT_center));

    if FDownArrow then
    with Canvas do
     begin
      Y:=Arect.Top+(FontHeight div 2 )+(FontHeight div 4);
      Pen.Color := Font.Color;
      Brush.Color := Font.Color;
      X:=Arect.Right-15;
      Polygon ([Point(X+4, Y), Point(X+8, Y), Point(X+6, Y+2)]);
     End;

   end;

 If ffStyle in [fsItem] then
  Begin
   if caption <> '' then
      y := ((Height - 36- FontHeight) div 2)
      else
      y := ((Height - 36) div 2);
   x := (width - 36) div 2;
   ItemRect := rect(x, y, x + 36, y + 36);
   ARect := rect(x, y, x + 36, y + 36);
//   ARect:=ItemRect;
  End
  Else
 ARect := getclientrect;
 case fStyle of
 btnsNormal : BEGIN
            if pushed then
               Begin
               if Not SB2 then
                  frame3d(canvas, ARect ,clBtnShadow,clBtnHighlight, 1)
                  else
                  DrawEdge (Canvas.Handle, ARect,BDR_SUNKENINNER  ,BF_RECT);
               end
            else
               Begin
               if Not SB2 then
                  frame3d(canvas, ARect ,clBtnHighlight,clBtnShadow, 1)
                  else
                  DrawEdge (Canvas.Handle, ARect,BDR_RAISEDOUTER  ,BF_RECT);
               End;
            END;
 btnsMSOffice, btnsOutlook :  Begin
         if pushed then
             Begin
               if Not SB2 then
              frame3d(canvas, ARect ,clBtnShadow,clBtnHighlight, 1)
              else
              DrawEdge (Canvas.Handle, ARect,BDR_SUNKENINNER  ,BF_RECT);
            End
         else
          if fMouseOver then
            Begin
            if Not SB2 then
              frame3d(canvas, ARect ,clBtnHighlight,clBtnShadow, 1)
              else
              DrawEdge (Canvas.Handle, ARect,BDR_RAISEDOUTER  ,BF_RECT);
            End;
         end;
 btnsCorel :  Begin
            if pushed then
               Frame3dP(ARect)
               else
               if fMouseOver then
                  Frame3dE(ARect)
                  else
                  DrawEdge (Canvas.Handle, ARect,BDR_RAISEDINNER	  ,BF_RECT);
            end;
 end; { case}
end;


function TOutlookBtn.OnGlyphP(X, Y: integer): boolean;
begin
  Result := PtInRect({ClientRect} BRect, Point(X, Y)) and
            (FBitmap.Canvas.Pixels[X, Y] <> FBitmap.TransparentColor);
end;

procedure TOutlookBtn.MouseMove(Shift: TShiftState; X, Y: Integer);

begin
  fMouseOver := (fStyle = btnsNormal) or (fStyle = btnsMSOffice)
                or (fStyle = btnsOutlook) or  OnGlyphP(X, Y);
  Inherited MouseMove(Shift, X, Y);
end;

procedure TOutlookBtn.mouseleave(var msg : tmessage);
var  rc : Trect;    p:tpoint;
BEGIN
//  GetCursorPos(p);
//  fMouseOver :=  PtInRect(itemRect, ScreenToClient(p));
  fMouseOver := false;
  rc := getclientrect;
//  rc:=itemrect;
  if (fStyle = btnsMSOffice) or (fStyle = btnsOutlook) or (fStyle = btnsCorel) then
    INVALIDATE;
END;

procedure TOutlookBtn.mousein(var msg : tmessage);
var  rc : Trect;    p:tpoint;
BEGIN
//  GetCursorPos(p);
//  fMouseOver := not PtInRect(itemRect, ScreenToClient(p));
  fMouseOver := true;
  rc := getclientrect;
//    rc:=itemrect;
  if (fStyle = btnsMSOffice) or (fStyle = btnsOutlook) or (fStyle = btnsCorel)then
       INVALIDATE;
END;

procedure TOutlookBtn.WMLButtonDown;
begin
 inherited;
  if Not tDown then
    Pushed := True;

  if pushed then
     invalidate;
end;

procedure TOutlookBtn.WMLButtonUp;
var
 p : TPoint;
begin
 inherited;

 GetCursorPos(p);
 fMouseOver := PtInRect(BoundsRect, ScreenToClient(p));
 if Not tDown then
    Pushed := false;
 if Pushed = false then
   invalidate;
end;

procedure TOutlookBtn.Click;
var
  PopupPoint: TPoint;
  ARect:TRect;
begin
  if (DropdownMenu = nil)then
      inherited Click;
  if DropdownMenu<>Nil then
    Begin
     PopupPoint := Point(0, 0);
     DropdownMenu.Alignment := paLeft;
     PopupPoint := ClientToScreen(PopupPoint);
     DropdownMenu.PopupComponent := Self;
     DropdownMenu.Popup (PopupPoint.X, PopupPoint.Y+Height);
    End;
End;

procedure Register;
begin
  RegisterComponents('Additional', [TOutlookBtn]);
end;

end.
