unit OLItemsProp;

interface

uses  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
     StdCtrls, DsgnIntf;

  type
    TOLItemsProperty = class (TClassProperty)
    public
      function GetAttributes: TpropertyAttributes; override;
      procedure Edit; override;
    end;

implementation

uses Outlook,OLItemForm;

{ TOLItemsProperty }

Var
ItemForm : TItemForm;

procedure TOLItemsProperty.Edit;
var OLItems : TOutlookItems;
begin
  ItemForm := TItemForm.Create(Application);
  try
    OLItems := TOutlookItems(GetOrdValue);
    ItemsInForm.AssignContent(OLItems);
    IF ItemForm.ShowModal = mrOk then
    begin
      OLItems.AssignContent(ItemsInForm);
      Designer.Modified;
      (GetComponent(0) as TOutlook).RefreshDisplay;
    end;
  finally
    ItemForm.free;
  end;

end;

function TOLItemsProperty.GetAttributes: TpropertyAttributes;
begin
  result := inherited GetAttributes + [paDialog] - [paSubProperties];
end;


end.
