unit OLItemForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, StdCtrls,Outlook, ExtDlgs;

type
  TItemForm = class(TForm)
    Edit1: TEdit;
    Label1: TLabel;
    SpeedButton1: TSpeedButton;
    ListBox1: TListBox;
    Edit2: TEdit;
    Label2: TLabel;
    SpeedButton2: TSpeedButton;
    ListBox2: TListBox;
    Button1: TButton;
    Panel1: TPanel;
    Image1: TImage;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    OpenPictureDialog1: TOpenPictureDialog;
    DefIcon: TImage;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ListBox2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton8Click(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ItemForm: TItemForm;
  ItemsInForm : TOutlookItems;

implementation


{$R *.DFM}



procedure TItemForm.FormShow(Sender: TObject);
var a: integer;
begin
  ListBox1.Clear;
  ListBox2.Clear;
  With ItemsInForm do
  begin
    For a := 1 to Counts[0] do
    begin
      ListBox1.Items.add(Headers[a]);
    end;
    If ListBox1.Items.Count = 0 then exit;
    ListBox1.ItemIndex := 0;
    ListBox2.Items.Clear;
    For a := 1 to Counts[1] do
    begin
      ListBox2.Items.Add(Items[1,a]);
    end;
    If ListBox2.Items.Count = 0 then exit;
    ListBox2.ItemIndex := 0;
    Image1.Picture.Assign(Images[ListBox1.ItemIndex+1,ListBox2.ItemIndex+1]);
    Image1.Repaint;
  end;
end;

procedure TItemForm.FormCreate(Sender: TObject);
begin
  ItemsInForm := TOutlookItems.Create(nil);
end;

procedure TItemForm.ListBox1Click(Sender: TObject);
var a: integer;
begin
  If ListBox1.ItemIndex = -1 then exit;
  ListBox2.Items.Clear;
  With ItemsInForm do
  begin
    For a := 1 to Counts[ListBox1.ItemIndex+1] do
    begin
      ListBox2.Items.Add(Items[ListBox1.ItemIndex+1,a]);
    end;
    If ListBox2.Items.Count = 0 then exit;
    ListBox2.ItemIndex := 0;
    Image1.Picture.Assign(Images[ListBox1.ItemIndex+1,ListBox2.ItemIndex+1]);
    Image1.Repaint;
  end;
end;

procedure TItemForm.SpeedButton1Click(Sender: TObject);
begin
  With ItemsInForm do
  begin
    ListBox1.Items.Add(Edit1.Text);
    ListBox1.ItemIndex := ListBox1.Items.Count-1;
    Headers[ListBox1.Items.Count] := Edit1.Text;
    ListBox2.Items.Clear;
    Image1.Picture := Nil;
    Image1.Repaint;
  end;
end;

procedure TItemForm.SpeedButton2Click(Sender: TObject);
var Pict : TPicture;
begin
  If ListBox1.ItemIndex = -1 then exit;
  With ItemsInForm do
  begin
    ListBox2.Items.Add(Edit2.text);
    ListBox2.ItemIndex := ListBox2.Items.Count -1;
    Items[ListBox1.ItemIndex+1,ListBox2.Items.Count] := Edit2.Text;
    Pict := Images[ListBox1.ItemIndex+1,ListBox2.ItemIndex+1];
    Pict.Assign(DefIcon.Picture);
    Image1.Picture.Assign(Images[ListBox1.ItemIndex+1,ListBox2.ItemIndex+1]);
    Image1.Repaint;
  end;
end;

procedure TItemForm.Button1Click(Sender: TObject);
var Pict : TPicture;
begin
  If ListBox2.ItemIndex = -1 then exit;
  With ItemsInForm do
  begin
    if OpenPictureDialog1.Execute then
    begin
      Pict := Images[ListBox1.ItemIndex+1,ListBox2.ItemIndex+1];
      if Pict <> nil then Pict.LoadFromFile(OpenPictureDialog1.FileName);
      Image1.Picture.Assign(Images[ListBox1.ItemIndex+1,ListBox2.ItemIndex+1]);
      Image1.Repaint;
    end;
  end;
end;

procedure TItemForm.ListBox2Click(Sender: TObject);
begin
  If ListBox2.ItemIndex = -1 then exit;
  With ItemsInForm do
  begin
    Image1.Picture.Assign(Images[ListBox1.ItemIndex+1,ListBox2.ItemIndex+1]);
    Image1.Repaint;
  end;
end;

procedure TItemForm.SpeedButton3Click(Sender: TObject);
var idx,a : integer;
begin
  idx := Listbox1.ItemIndex;
  If Idx = -1 then exit;
  ListBox1.Items.Delete(idx);
  ItemsInForm.DeleteHeader(idx+1);

  ListBox2.Items.Clear;
  if ListBox1.Items.count = 0 then exit;

  ListBox1.ItemIndex := 0;
  With ItemsInForm do
  begin
    For a := 1 to Counts[ListBox1.ItemIndex+1] do
    begin
      ListBox2.Items.Add(Items[ListBox1.ItemIndex+1,a]);
    end;
    If ListBox2.Items.Count = 0 then exit;
    ListBox2.ItemIndex := 0;
    Image1.Picture.Assign(Images[ListBox1.ItemIndex+1,ListBox2.ItemIndex+1]);
    Image1.Repaint;
  end;

end;

procedure TItemForm.SpeedButton6Click(Sender: TObject);
var idx1,idx2 : integer;
begin
  idx1 := Listbox1.ItemIndex;
  idx2 := Listbox2.ItemIndex;
  If Idx2 = -1 then exit;
  ListBox2.Items.Delete(idx2);
  ItemsInForm.DeleteItem(idx1+1,idx2+1);
  Image1.Picture.Assign(nil);
  If ListBox2.Items.Count = 0 then exit;
  ListBox2.ItemIndex := 0;

  With ItemsInForm do
  begin
    Image1.Picture.Assign(Images[ListBox1.ItemIndex+1,ListBox2.ItemIndex+1]);
    Image1.Repaint;
  end;

end;

procedure TItemForm.SpeedButton5Click(Sender: TObject);
var idx : integer;
begin
  idx := Listbox1.ItemIndex;
  If idx < 1 then exit;
  ListBox1.Items.Exchange(idx,idx-1);
  ItemsInForm.ExchangeHeader(idx+1,idx);
  ListBox1.ItemIndex := ListBox1.ItemIndex -1;
end;

procedure TItemForm.SpeedButton4Click(Sender: TObject);
var idx : integer;
begin
  idx := Listbox1.ItemIndex;
  If idx = ListbOX1.Items.count-1 then exit;
  ListBox1.Items.Exchange(idx,idx+1);
  ItemsInForm.ExchangeHeader(idx+2,idx+1);
  ListBox1.ItemIndex := ListBox1.ItemIndex +1;
end;

procedure TItemForm.SpeedButton8Click(Sender: TObject);
var idx1,idx2 : integer;
begin
  idx1 := Listbox1.ItemIndex;
  idx2 := Listbox2.ItemIndex;
  If idx2 < 1 then exit;
  ListBox2.Items.Exchange(idx2,idx2-1);
  ItemsInForm.ExchangeItem(idx1+1,idx2+1,idx2);
  ListBox2.ItemIndex := ListBox2.ItemIndex -1;
end;

procedure TItemForm.SpeedButton7Click(Sender: TObject);
var idx1,idx2 : integer;
begin
  idx1 := Listbox1.ItemIndex;
  idx2 := Listbox2.ItemIndex;
  If idx2 = ListbOX2.Items.count-1 then exit;
  ListBox2.Items.Exchange(idx2,idx2+1);
  ItemsInForm.ExchangeItem(idx1+1,idx2+2,idx2+1);
  ListBox2.ItemIndex := ListBox2.ItemIndex +1;
end;

end.
