unit unit_form_watch_value;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  Tform_watch_value = class(TForm)
    button_ok: TButton;
    button_cancel: TButton;
    panel_watch: TPanel;
    edit_watch_value: TEdit;
    label_watch: TLabel;
    label_watch_value: TLabel;
    label_expression: TLabel;
    procedure button_okClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    FWatch : string;
    FWatchValue : string;

    procedure SetWatch ( value : string );
    procedure SetWatchValue ( value : string );
  public
    { Public declarations }
    property Watch : string read FWatch write SetWatch;
    property WatchValue : string read FWatchValue write SetWatchValue;
  end;

var
  form_watch_value: Tform_watch_value;

implementation

{$R *.DFM}

procedure Tform_watch_value.button_okClick(Sender: TObject);
begin
  FWatchValue := edit_watch_value.text;
end;

procedure Tform_watch_value.SetWatch ( value : String );
begin
  FWatch := value;

  label_expression.caption := value;
end;

procedure Tform_watch_value.SetWatchValue ( value : String );
begin
  FWatchValue := value;

  edit_watch_value.Text := value;
end;

procedure Tform_watch_value.FormShow(Sender: TObject);
begin
  edit_watch_value.SelectAll;
  edit_watch_value.SetFocus;
end;

end.
