unit unit_form_tab_host;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, extctrls, PageControlDock;

type
  Tform_tab_host = class(TForm)
    pagecontrol_dock: TPageControlDock;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure pagecontrol_dockUnDock(Sender: TObject; Client: TControl;
      NewTarget: TWinControl; var Allow: Boolean);
    procedure pagecontrol_dockGetSiteInfo(Sender: TObject;
      DockClient: TControl; var InfluenceRect: TRect; MousePos: TPoint;
      var CanDock: Boolean);
    procedure pagecontrol_dockDockOver(Sender: TObject;
      Source: TDragDockObject; X, Y: Integer; State: TDragState;
      var Accept: Boolean);
    procedure pagecontrol_dockDockDrop(Sender: TObject;
      Source: TDragDockObject; X, Y: Integer);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    procedure UpdateCaption(Exclude: TControl);
    function ComputeDockingRect(var DockRect: TRect; MousePos: TPoint): TAlign;

   { Private declarations }
  public
    { Public declarations }

    function SubFormNames : string;
  end;

var
  form_tab_host: Tform_tab_host;

implementation

{$R *.DFM}

uses unit_form_dock, unit_form_main;

function Tform_tab_host.ComputeDockingRect(var DockRect: TRect; MousePos: TPoint): TAlign;
var
  DockTopRect,
  DockLeftRect,
  DockBottomRect,
  DockRightRect,
  DockCenterRect: TRect;
begin
  Result := alNone;
  //divide form up into docking "Zones"
  DockLeftRect.TopLeft := Point(0, 0);
  DockLeftRect.BottomRight := Point(ClientWidth div 5, ClientHeight);

  DockTopRect.TopLeft := Point(ClientWidth div 5, 0);
  DockTopRect.BottomRight := Point(ClientWidth div 5 * 4, ClientHeight div 5);

  DockRightRect.TopLeft := Point(ClientWidth div 5 * 4, 0);
  DockRightRect.BottomRight := Point(ClientWidth, ClientHeight);

  DockBottomRect.TopLeft := Point(ClientWidth div 5, ClientHeight div 5 * 4);
  DockBottomRect.BottomRight := Point(ClientWidth div 5 * 4, ClientHeight);

  DockCenterRect.TopLeft := Point(ClientWidth div 5, ClientHeight div 5);
  DockCenterRect.BottomRight := Point(ClientWidth div 5 * 4, ClientHeight div 5 * 4);

  //Find out where the mouse cursor is, to decide where to draw dock preview.
  if PtInRect(DockLeftRect, MousePos) then
    begin
      Result := alLeft;
      DockRect := DockLeftRect;
      DockRect.Right := ClientWidth div 2;
    end
  else
    if PtInRect(DockTopRect, MousePos) then
      begin
        Result := alTop;
        DockRect := DockTopRect;
        DockRect.Left := 0;
        DockRect.Right := ClientWidth;
        DockRect.Bottom := ClientHeight div 2;
      end
    else
      if PtInRect(DockRightRect, MousePos) then
        begin
          Result := alRight;
          DockRect := DockRightRect;
          DockRect.Left := ClientWidth div 2;
        end
      else
        if PtInRect(DockBottomRect, MousePos) then
          begin
            Result := alBottom;
            DockRect := DockBottomRect;
            DockRect.Left := 0;
            DockRect.Right := ClientWidth;
            DockRect.Top := ClientHeight div 2;
         end
        else
          if PtInRect(DockCenterRect, MousePos) then
          begin
            Result := alClient;
            DockRect := DockCenterRect;
          end;


  if Result = alNone then Exit;

  //DockRect is in screen coordinates.
  DockRect.TopLeft := ClientToScreen(DockRect.TopLeft);
  DockRect.BottomRight := ClientToScreen(DockRect.BottomRight);
end;


procedure Tform_tab_host.FormClose(Sender: TObject;
  var Action: TCloseAction);
var
  ARect: TRect;
begin
  //if docked to a panel, tell the panel to hide itself. If there are other
  //visible dock clients on the panel, it ShowDockPanel won't allow it to
  //be hidden

  if pagecontrol_dock.DockClientCount = 1 then
  begin
    with pagecontrol_dock.DockClients[0] do
    begin
      ARect.TopLeft := ClientToScreen(Point(0, 0));
      ARect.BottomRight := ClientToScreen(Point(UndockWidth, UndockHeight));
      if (Self.HostDockSite is TPanel) then
        ManualDock(Self.HostDockSite, nil, alClient)
      else
        ManualFloat(ARect);
    end;
    Action := caFree;
  end else
    Action := caHide;

  if (HostDockSite is TPanel) then
    form_main.ShowDockPanel(HostDockSite as TPanel, False, nil);

end;

procedure Tform_tab_host.pagecontrol_dockUnDock(Sender: TObject;
  Client: TControl; NewTarget: TWinControl; var Allow: Boolean);
begin

  //only 2 dock clients means the host must be destroyed and
  //the remaining window undocked to its old position and size.
  if (pagecontrol_dock.DockClientCount = 2) and (NewTarget <> pagecontrol_dock) then
    PostMessage(Self.Handle, WM_CLOSE, 0, 0);

  UpdateCaption( CLient );
end;

procedure Tform_tab_host.pagecontrol_dockGetSiteInfo(Sender: TObject;
  DockClient: TControl; var InfluenceRect: TRect; MousePos: TPoint;
  var CanDock: Boolean);
var
  i : integer;
  DockType : TAlign;
  ARect : TRect;
begin
  DockType := ComputeDockingRect(ARect, Point(MousePos.X, MousePos.Y));

  if ( DockClient is Tform_dock ) then
    CanDock := true
  else
    CanDock := False;
end;

procedure Tform_tab_host.pagecontrol_dockDockOver(Sender: TObject;
  Source: TDragDockObject; X, Y: Integer; State: TDragState;
  var Accept: Boolean);
var
  i : integer;
  ARect: TRect;
  DockType : TAlign;
begin
  DockType := ComputeDockingRect(ARect, Point(X, Y));

  if ( Source.Control is Tform_dock ) then
  begin
    if ( Source.Control.HostDockSite = pagecontrol_dock ) and ( DockType = alClient ) then
    begin
      Accept := False;
      exit;
    end;

    Accept := true
  end
  else
    Accept := False;

  //Draw dock preview depending on where the cursor is relative to our client area
  if (Accept) and ( DockType <> alNone) and
    ( HostDockSite <> nil ) then
    Source.DockRect := ARect;

end;

function Tform_tab_host.SubFormNames : string;
var
  I: Integer;
begin
  Result := '';
  for I := 0 to pagecontrol_dock.DockClientCount-1 do
    if pagecontrol_dock.DockClients[I].Visible  then
    begin
      if ( Result <> '' ) then
      begin
        Result:=Result+',';
      end;

      Result := Result + Tform_dock(pagecontrol_dock.DockClients[I]).Name;
    end;
end;

procedure Tform_tab_host.UpdateCaption(Exclude: TControl);
var
  I: Integer;
begin
  //if a dockable form is undocking, it will pass itself in as Exclude
  //because even it hasn't actually been taken out of the DockClient array
  //at this point.
  Caption := '';
  for I := 0 to pagecontrol_dock.DockClientCount-1 do
    if pagecontrol_dock.DockClients[I].Visible and (pagecontrol_dock.DockClients[I] <> Exclude) then
    begin
      if ( Caption <> '' ) then
      begin
        Caption := Caption +', ';
      end;

      Caption := Caption + Tform_dock(pagecontrol_dock.DockClients[I]).Caption;
    end;
end;

procedure Tform_tab_host.pagecontrol_dockDockDrop(Sender: TObject;
  Source: TDragDockObject; X, Y: Integer);
begin
  UpdateCaption( nil );
end;



procedure Tform_tab_host.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CanClose := pagecontrol_dock.DockClientCount = 1;
end;

end.
