unit unit_form_preferences;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Outlook, ExtCtrls, StdCtrls, ComCtrls, ColorGrd, SynEdit,
  SynEditHighlighter, DcjTribes2Syn, RogerColorGrid, WPopOutFntCBox,
  SVFontCombos, TBX;

type
  Tform_preferences = class(TForm)
    outlook_preferences: TOutlook;
    pagecontrol_preferences: TPageControl;
    tabsheet_editor: TTabSheet;
    tabsheet_general: TTabSheet;
    button_cancel: TButton;
    button_ok: TButton;
    label_editor_preferences: TLabel;
    bevel_editor_preferences: TBevel;
    bevel_directory_preferences: TBevel;
    label_directory_preferences: TLabel;
    edit_tribes_directory: TEdit;
    label_tribes_directory: TLabel;
    button_tribes_directory_browse: TButton;
    tabsheet_debugger: TTabSheet;
    label_debugger_preferences: TLabel;
    bevel_debugger_preferences: TBevel;
    label_server_address: TLabel;
    edit_server_address: TEdit;
    label_server_port: TLabel;
    edit_server_port: TEdit;
    label_server_debug_password: TLabel;
    edit_server_debug_password: TEdit;
    label_start_debuffer: TLabel;
    label_dbgsetparameters: TLabel;
    label_description: TLabel;
    bevel_debugger_description: TBevel;
    label_tribes_directory_description: TLabel;
    checkbox_auto_indent: TCheckBox;
    checkbox_insert_mode: TCheckBox;
    checkbox_use_tab_character: TCheckBox;
    checkbox_smart_tab: TCheckBox;
    checkbox_cursor_beyond_eof: TCheckBox;
    checkbox_show_scroll_hint: TCheckBox;
    checkbox_trim_trailing_spaces: TCheckBox;
    bevel_editor_colors: TBevel;
    label_editor_colors: TLabel;
    groupbox_attributes: TGroupBox;
    checkbox_bold: TCheckBox;
    checkbox_italic: TCheckBox;
    checkbox_underline: TCheckBox;
    listbox_attributes: TListBox;
    synedit_demo: TSynEdit;
    checkbox_show_line_numbers: TCheckBox;
    syntribes2syn_preferences: TSynTribes2Syn;
    label_debugger_description: TLabel;
    bevel_debugger_client_description: TBevel;
    checkbox_strikeout: TCheckBox;
    colorgrid_colors: TRogerColorGrid;
    label_tab_stops: TLabel;
    edit_tab_stops: TEdit;
    label_environment_preferences: TLabel;
    bevel_environment_preferences: TBevel;
    checkbox_auto_save_project: TCheckBox;
    checkbox_function_browser: TCheckBox;
    label_editor_font: TLabel;
    label_font_size: TLabel;
    combobox_editor_font: TWPopOutFntCBox;
    combobox_font_size: TFontSizeComboBox;
    label_printing_preferences: TLabel;
    bevel_printing_preferences: TBevel;
    checkbox_print_line_numbers: TCheckBox;
    checkbox_print_hightlight: TCheckBox;
    checkbox_print_colors: TCheckBox;
    label_printer_font: TLabel;
    combobox_printer_font: TWPopOutFntCBox;
    label_printer_font_size: TLabel;
    combobox_printer_font_size: TFontSizeComboBox;
    checkbox_assoiciate: TCheckBox;
    checkbox_cursor_beyond_eol: TCheckBox;
    comobobox_interface_style: TComboBox;
    label_interface_style: TLabel;
    checkbox_xp_styles: TCheckBox;
    procedure outlook_preferencesItemClick(Sender: TObject; Item: String);
    procedure button_tribes_directory_browseClick(Sender: TObject);
    procedure checkbox_show_line_numbersClick(Sender: TObject);
    procedure checkbox_insert_modeClick(Sender: TObject);
    procedure checkbox_use_tab_characterClick(Sender: TObject);
    procedure checkbox_smart_tabClick(Sender: TObject);
    procedure checkbox_cursor_beyond_eofClick(Sender: TObject);
    procedure checkbox_show_scroll_hintClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure listbox_attributesClick(Sender: TObject);
    procedure synedit_demoStatusChange(Sender: TObject;
      Changes: TSynStatusChanges);
    procedure colorgrid_colorsColorChange(Sender: TObject);
    procedure FontStyleClick(Sender: TObject);
    procedure checkbox_auto_indentClick(Sender: TObject);
    procedure checkbox_trim_trailing_spacesClick(Sender: TObject);
    procedure button_okClick(Sender: TObject);
    procedure combobox_editor_fontChange(Sender: TObject);
    procedure combobox_font_sizeChange(Sender: TObject);
    procedure combobox_printer_fontChange(Sender: TObject);
    procedure checkbox_cursor_beyond_eolClick(Sender: TObject);
  private
    { Private declarations }
    FTabStopsValue : integer;
    FFontSizeValue : integer;
    FPrinterFontSizeValue : integer;
    FUIStyle : string;
    FXPStyle : boolean;

    DontChangeColors  : boolean;
  public
    { Public declarations }

    property XPStyle : boolean read FXPStyle write FXPStyle;
    property UIStyle : string read FUIStyle write FUIStyle;
    property TabStopsValue : integer read FTabStopsValue write FTabStopsValue;
    property FontSizeValue : integer read FFontSizeValue write FFontSizeValue;
    property PrinterFontSizeValue : integer read FPrinterFontSizeValue write FPrinterFontSizeValue;
  end;


implementation

uses unit_form_folder_select;

{$R *.DFM}

procedure Tform_preferences.outlook_preferencesItemClick(Sender: TObject;
  Item: String);
begin
  pagecontrol_preferences.ActivePageIndex:=outlook_preferences.itemindex;
end;

procedure Tform_preferences.button_tribes_directory_browseClick(
  Sender: TObject);
begin
  { tell the browse folder form what directory we want to start at }
  form_folder_select.Directory:=edit_tribes_directory.text;

  if ( form_folder_select.ShowModal = mrOk ) then
  begin
    { set edit to what user specified }
    edit_tribes_directory.text:=form_folder_select.Directory;
  end;
end;

procedure Tform_preferences.checkbox_show_line_numbersClick(
  Sender: TObject);
begin
  synedit_demo.gutter.ShowLineNumbers := checkbox_show_line_numbers.checked;
end;

procedure Tform_preferences.checkbox_insert_modeClick(Sender: TObject);
begin
  synedit_demo.InsertMode := checkbox_insert_mode.checked;
end;

procedure Tform_preferences.checkbox_use_tab_characterClick(
  Sender: TObject);
begin
  synedit_demo.SetOptionFlag(eoTabsToSpaces, not checkbox_use_tab_character.checked)
end;

procedure Tform_preferences.checkbox_smart_tabClick(Sender: TObject);
begin
  synedit_demo.SetOptionFlag(eoSmartTabs, checkbox_smart_tab.checked);
end;

procedure Tform_preferences.checkbox_cursor_beyond_eofClick(
  Sender: TObject);
begin
  synedit_demo.SetOptionFlag(eoScrollPastEof, checkbox_cursor_beyond_eof.checked);
end;

procedure Tform_preferences.checkbox_show_scroll_hintClick(Sender: TObject);
begin
  synedit_demo.SetOptionFlag(eoShowScrollHint, checkbox_show_scroll_hint.checked);
end;

procedure Tform_preferences.FormShow(Sender: TObject);
var
  i : integer;
begin
  synedit_demo.Font.Name := combobox_editor_font.FontName;
  combobox_font_size.FontName := combobox_editor_font.FontName;
  combobox_printer_font_size.FontName := combobox_printer_font.FontName;
  checkbox_xp_styles.checked := XPStyle;

  try
    synedit_demo.Font.Size := StrToInt(combobox_font_size.Text)
  except
  end;

  pagecontrol_preferences.ActivePageIndex:=0;
  outlook_preferences.ActiveTab:=1;

  DontChangeColors := false;

  { get the highlighter attributes }
  listbox_attributes.Items.Clear;
  for i := 0 to synedit_demo.Highlighter.AttrCount - 1 do
    listbox_attributes.Items.Add(synedit_demo.Highlighter.Attribute[i].Name);

  { set to first and update grid an text attributes }
  listbox_attributes.Itemindex:=0;
  listbox_attributesClick(Self);

  { get ui styles }
  TBXGetThemes(comobobox_interface_style.items);

  if ( comobobox_interface_style.items.indexof(FUIStyle) <> -1 ) then
    comobobox_interface_style.itemindex := comobobox_interface_style.items.indexof(FUIStyle)
  else if ( comobobox_interface_style.items.count > 0 ) then
    comobobox_interface_style.itemindex := 0;
end;

procedure Tform_preferences.listbox_attributesClick(Sender: TObject);
var
  Attr: TSynHighlighterAttributes;
begin
  Attr := TSynHighlighterAttributes.Create('');
  DontChangeColors := True;
  try

    Attr.Assign(synedit_demo.Highlighter.Attribute[listbox_attributes.ItemIndex]);
    colorgrid_colors.ForeColor := Attr.Foreground;
    colorgrid_colors.BackColor := Attr.Background;
    checkbox_bold.Checked := (fsBold in Attr.Style);
    checkbox_italic.Checked := (fsItalic in Attr.Style);
    checkbox_underline.Checked := (fsUnderline in Attr.Style);
    checkbox_strikeout.Checked := (fsStrikeOut in Attr.Style);
  finally
    DontChangeColors := False;
    Attr.Free;
  end;
end;

procedure Tform_preferences.synedit_demoStatusChange(Sender: TObject;
  Changes: TSynStatusChanges);
var
  p: TPoint;
  Token: string;
  Attri: TSynHighlighterAttributes;
begin
    if Changes * [scCaretX, scCaretY] <> [] then
    begin
      if not synedit_demo.GetHighlighterAttriAtRowCol(synedit_demo.CaretXY, Token, Attri) then
        Attri := synedit_demo.Highlighter.WhitespaceAttribute;
      if Assigned(Attri) then begin
        listbox_attributes.ItemIndex := listbox_attributes.Items.IndexOf(Attri.Name);
        listbox_attributesClick(Self);
      end;
    end;
end;

procedure Tform_preferences.colorgrid_colorsColorChange(Sender: TObject);
begin
  if ( not DontChangeColors ) then
  begin
    { foreground }
    synedit_demo.Highlighter.Attribute[listbox_attributes.ItemIndex].Foreground :=
    colorgrid_colors.ForeColor;
    { background }
    synedit_demo.Highlighter.Attribute[listbox_attributes.ItemIndex].Background :=
    colorgrid_colors.BackColor;
  end;
end;

procedure Tform_preferences.FontStyleClick(Sender: TObject);
var
  Style: TFontStyles;
begin
  Style := [];
  if checkbox_bold.Checked then
    Include(Style, fsBold);
  if checkbox_italic.Checked then
    Include(Style, fsItalic);
  if checkbox_underline.Checked then
    Include(Style, fsUnderline);
  if checkbox_strikeout.Checked then
    Include(Style, fsStrikeOut);
  synedit_demo.Highlighter.Attribute[listbox_attributes.ItemIndex].Style := Style;
end;

procedure Tform_preferences.checkbox_auto_indentClick(Sender: TObject);
begin
  synedit_demo.SetOptionFlag(eoAutoIndent, checkbox_auto_indent.checked)
end;

procedure Tform_preferences.checkbox_trim_trailing_spacesClick(
  Sender: TObject);
begin
  synedit_demo.SetOptionFlag(eoTrimTrailingSpaces, checkbox_trim_trailing_spaces.checked);
end;

procedure Tform_preferences.button_okClick(Sender: TObject);
begin
  try
    FTabStopsValue := StrToInt(edit_tab_stops.text);
  except
    MessageDlg('Invalid Tab stop',
     mtError, [mbOk], 0);
    exit;
  end;

  try
    FFontSizeValue := StrToInt(combobox_font_size.text);
  except
    MessageDlg('Invalid Editor Font Size',
     mtError, [mbOk], 0);
    exit;
  end;

  try
    FPrinterFontSizeValue := StrToInt(combobox_printer_font_size.text);
  except
    MessageDlg('Invalid Printer Font Size',
     mtError, [mbOk], 0);
    exit;
  end;

  FUIStyle := comobobox_interface_style.text;
  FXPStyle := checkbox_xp_styles.checked;

  ModalResult := mrOk;
end;

procedure Tform_preferences.combobox_editor_fontChange(Sender: TObject);
begin
  synedit_demo.Font.Name := combobox_editor_font.FontName;
  combobox_font_size.FontName := combobox_editor_font.FontName;
end;

procedure Tform_preferences.combobox_font_sizeChange(Sender: TObject);
begin
  try
    synedit_demo.Font.Size := StrToInt(combobox_font_size.Text)
  except
  end;
end;

procedure Tform_preferences.combobox_printer_fontChange(Sender: TObject);
begin
  combobox_printer_font_size.FontName := combobox_printer_font.FontName;
end;

procedure Tform_preferences.checkbox_cursor_beyond_eolClick(
  Sender: TObject);
begin
    synedit_demo.SetOptionFlag(eoScrollPastEol, checkbox_cursor_beyond_eol.checked);
end;

end.
