unit unit_form_new_project;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, FileCtrl;

type
  Tform_new_project = class(TForm)
    panel_new_project: TPanel;
    button_ok: TButton;
    button_cancel: TButton;
    label_project_name: TLabel;
    edit_project_name: TEdit;
    edit_project_directory: TEdit;
    button_project_directory_browse: TButton;
    label_base_directory: TLabel;
    label_base_directory_description: TLabel;
    procedure FormShow(Sender: TObject);
    procedure button_okClick(Sender: TObject);
    procedure button_project_directory_browseClick(Sender: TObject);
  private
    { Private declarations }
    FNewProject : boolean;

    procedure SetNewProject ( value : boolean );
  public
    { Public declarations }

    property NewProject : Boolean read FNewProject write SetNewProject;
  end;


implementation

uses unit_form_folder_select, unit_form_main;

{$R *.DFM}

procedure Tform_new_project.FormShow(Sender: TObject);
begin
  edit_project_name.SetFocus;
end;

procedure Tform_new_project.SetNewProject ( value : boolean );
begin
  if ( value ) then
  begin
    caption := 'New Project';
    edit_project_name.text := '';
    edit_project_directory.text := '';
  end
  else
    caption := 'Project Details';
end;

procedure Tform_new_project.button_okClick(Sender: TObject);
begin
  { check name }
  if ( edit_project_name.text = '' ) then
  begin
    MessageDlg('Project Name cannot be blank.',mtError, [mbOk], 0);
    exit;
  end;

  { check base path }
  if ( not DirectoryExists(edit_project_directory.text) ) then
  begin
    MessageDlg('Cannot find specified base directory.',mtError, [mbOk], 0);
    exit;
  end;

  { ok to go }
  ModalResult := mrOk;
end;

procedure Tform_new_project.button_project_directory_browseClick(
  Sender: TObject);
begin
  { tell the browse folder form what directory we want to start at }
  if ( edit_project_directory.text = '' ) then
    form_folder_select.Directory:=form_main.tribes_directory
  else
    form_folder_select.Directory:=edit_project_directory.text;

  if ( form_folder_select.ShowModal = mrOk ) then
  begin
    { set edit to what user specified }
    edit_project_directory.text:=form_folder_select.Directory;
  end;
end;

end.
