unit unit_form_main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ComCtrls, ExtCtrls, ElTree, ToolWin, ActnList, registry, shlobj,
  commctrl,
  inifiles,
  SynEdit,
  SynEditPrint,
  SynEditHighlighter,
  SynEditSearch,
  DcjTribes2Syn,
  unit_editorlist,
  unit_projectlist, unit_watch_list,
  unit_function_list,
  unit_debugger_list,
  unit_form_dock,
  ImgList, StdCtrls, Buttons, FindFile, RegControls,
  WSocket, TB2Item, TB2Dock, TB2Toolbar, TBX, TBXMDI,
  TBXOfficeXPTheme,TBXStripesTheme,TBXSwitcher, TB2MRU, TBXExtItems,
  ThemeMgr;

const
  { used for detecting completion of console compile and execs }
  MSG_COMPILATION_COMPLETE = 'Compilation Complete';
  MSG_EXEC_COMPLETE        = 'Exec Complete';

  { used for registry key }
  ApplicationName          = 'Tribal IDE';
  { Used in about box }
  ApplicationVersion       = 'Beta 3.8OS';

type
  PAppComms = ^TAppComms;
  TAppComms = packed record
    HandleData : THandle;
    MainFormHandle : THandle;
  end;

  Tform_main = class(TForm)
    actionlist_main: TActionList;
    action_new_script: TAction;
    action_new_project: TAction;
    action_open: TAction;
    action_open_project: TAction;
    action_reopen: TAction;
    action_save: TAction;
    action_save_as: TAction;
    action_save_project_as: TAction;
    action_save_all: TAction;
    action_close: TAction;
    action_close_all: TAction;
    action_print: TAction;
    action_exit: TAction;
    action_undo: TAction;
    action_redo: TAction;
    action_cut: TAction;
    action_copy: TAction;
    action_paste: TAction;
    action_select_all: TAction;
    action_about: TAction;
    action_run: TAction;
    action_pause: TAction;
    action_step_over: TAction;
    action_trace_into: TAction;
    action_toggle_breakpoint: TAction;
    opendialog_open_file: TOpenDialog;
    syntribes2syn_main: TSynTribes2Syn;
    action_preferences: TAction;
    imagelist_main: TImageList;
    popupmenu_project: TTBXPopupMenu;
    action_add_file_to_project: TAction;
    action_remove_file_from_project: TAction;
    action_open_project_file: TAction;
    opendialog_open_project: TOpenDialog;
    savedialog_save_project: TSaveDialog;
    action_step_out: TAction;
    savedialog_save_file: TSaveDialog;
    action_find: TAction;
    action_find_in_files: TAction;
    action_replace: TAction;
    action_search_again: TAction;
    action_go_to_line_number: TAction;
    action_quick_find: TAction;
    action_quick_find_in_files: TAction;
    imagelist_editor: TImageList;
    popupmenu_watches: TTBXPopupMenu;
    action_remove_watch: TAction;
    action_add_watch: TAction;
    action_stop: TAction;
    action_project_options: TAction;
    action_add_watch_at_cursor: TAction;
    popupmenu_editor: TTBXPopupMenu;
    menuitem_popup_cut: TTBXItem;
    menuitem_popup_copy: TTBXItem;
    menuitem_popup_paste: TTBXItem;
    menuitem_seperator_13: TTBXSeparatorItem;
    menuitem_seperator_12: TTBXSeparatorItem;
    menuitem_popup_close: TTBXItem;
    action_status_panel_update: TAction;
    findfile_add_project_files: TFindFile;
    action_compile_and_exec: TAction;
    SynEditPrint_main: TSynEditPrint;
    PrintDialog: TPrintDialog;
    action_change_value: TAction;
    panel_bottom: TPanel;
    popupmenu_breakpoints: TTBXPopupMenu;
    action_breakpoints_toggle_status: TAction;
    menuitem_toggle_breakpoint_status: TTBXItem;
    menuitem_seperator_14: TTBXSeparatorItem;
    action_breakpoints_propertires: TAction;
    menuitem_breakpoint_properties: TTBXItem;
    action_breakpoints_delete: TAction;
    menuitem_breakpoint_delete: TTBXItem;
    action_breakpoints_delete_all: TAction;
    action_breakpoints_disable_all: TAction;
    action_breakpoints_enable_all: TAction;
    menuitem_breakpoints_disable_all: TTBXItem;
    menuitem_breakpoints_enable_all: TTBXItem;
    menuitem_breakpoints_delete_all: TTBXItem;
    action_breakpoints_add: TAction;
    menuitem_add_breakpoint: TTBXItem;
    menuitem_seperator_15: TTBXItem;
    menuitem_enable_group: TTBXItem;
    menuitem_disable_group: TTBXItem;
    menuitem_seperator_16: TTBXItem;
    statusbar_main: TStatusBar;
    panel_main: TPanel;
    splitter_vertical: TSplitter;
    splitter_horizontal: TSplitter;
    pagecontrol_source: TPageControl;
    action_compile_selected: TAction;
    opendialog_add_project_file: TOpenDialog;
    clientsocket_debug: TWSocket;
    timer_end_watches_update: TTimer;
    tbdock_top: TTBDock;
    tbxtoolbar_menu: TTBXToolbar;
    menuitem_file: TTBXSubmenuItem;
    menuitem_new_script: TTBXItem;
    menuitem_new_project: TTBXItem;
    menuitem_seperator_1: TTBXSeparatorItem;
    menuitem_open: TTBXItem;
    menuitem_open_project: TTBXItem;
    menuitem_seperator_2: TTBXSeparatorItem;
    menuitem_save: TTBXItem;
    menuitem_save_as: TTBXItem;
    menuitem_save_project_as: TTBXItem;
    menuitem_save_all: TTBXItem;
    menuitem_close: TTBXItem;
    menuitem_close_all: TTBXItem;
    menuitem_seperator_3: TTBXSeparatorItem;
    menuitem_print: TTBXItem;
    menuitem_seperator_4: TTBXSeparatorItem;
    menuitem_exit: TTBXItem;
    menuitem_edit: TTBXSubmenuItem;
    menuitem_undo: TTBXItem;
    menuitem_redo: TTBXItem;
    menuitem_seperator_5: TTBXSeparatorItem;
    menuitem_cut: TTBXItem;
    menuitem_copy: TTBXItem;
    menuitem_paste: TTBXItem;
    menuitem_seperator_6: TTBXSeparatorItem;
    menuitem_select_all: TTBXItem;
    menuitem_seperator_9: TTBXSeparatorItem;
    menuitem_preferences: TTBXItem;
    menuitem_search: TTBXSubmenuItem;
    menitem_find: TTBXItem;
    menuitem_find_in_files: TTBXItem;
    menuitem_replace: TTBXItem;
    menuitem_search_again: TTBXItem;
    menuitem_seperator_10: TTBXSeparatorItem;
    menuitem_go_to_line_number: TTBXItem;
    menuitem_project: TTBXSubmenuItem;
    menuitem_add_to_project: TTBXItem;
    menuitem_remove_from_project: TTBXItem;
    menuitem_open_project_file: TTBXItem;
    menuitem_seperator_11: TTBXSeparatorItem;
    menuitem_project_options: TTBXItem;
    menuitem_debug: TTBXSubmenuItem;
    menuitem_run: TTBXItem;
    menuitem_compile_and_action: TTBXItem;
    menuitem_seperator_7: TTBXSeparatorItem;
    menuitem_step_over: TTBXItem;
    menuitem_trace_into: TTBXItem;
    menuitem_step_out: TTBXItem;
    menuitem_pause: TTBXItem;
    menuitem_seperator_8: TTBXSeparatorItem;
    menuitem_toggle_breakpoint: TTBXItem;
    menuitem_help: TTBXSubmenuItem;
    menuitem_about: TTBXItem;
    tbxtoolbar_main: TTBXToolbar;
    TBX_new_project: TTBXItem;
    TBX_new_script: TTBXItem;
    TBX_open_file: TTBXItem;
    TBX_save_file: TTBXItem;
    TBXSeparatorItem1: TTBXSeparatorItem;
    TBX_save_all: TTBXItem;
    TBX_open_project: TTBXItem;
    TBXSeparatorItem2: TTBXSeparatorItem;
    TBX_add_files_to_project: TTBXItem;
    TBX_remove_files_from_project: TTBXItem;
    tbxtoolbar_debug: TTBXToolbar;
    tbx_run: TTBXItem;
    tbx_pause: TTBXItem;
    TBXSeparatorItem3: TTBXSeparatorItem;
    tbx_trace_into: TTBXItem;
    tbx_step_over: TTBXSubmenuItem;
    tbx_step_out: TTBXItem;
    tbx_compile_and_exec: TTBXItem;
    tbxtoolbar_find: TTBXToolbar;
    TBControlItem1: TTBControlItem;
    combobox_quick_find: TRegComboBox;
    TBXSeparatorItem4: TTBXSeparatorItem;
    tbx_quick_find: TTBXItem;
    tbx_quick_find_in_files: TTBXItem;
    TBXSeparatorItem5: TTBXSeparatorItem;
    tbx_search_again: TTBXItem;
    tbdock_bottom: TTBDock;
    tbdock_left: TTBDock;
    tbdock_right: TTBDock;
    tbxswitcher_main: TTBXSwitcher;
    menuitem_add_to_project_popup: TTBXItem;
    menuitem_remove_from_project_popup: TTBXItem;
    menuitem_open_project_file_popup: TTBXItem;
    menuitem_compile_selected: TTBXItem;
    menuitem_remove_watch: TTBXItem;
    menuitem_change_watch_value: TTBXItem;
    menuitem_goto_definition: TTBXSubmenuItem;
    thememanager_main: TThemeManager;
    menuitem_reopen_menu: TTBXSubmenuItem;
    TBXMRUListItem1: TTBXMRUListItem;
    mrufilelist_main: TTBXMRUList;
    pagecontrol_bottom: TPageControl;
    tabsheet_messages: TTabSheet;
    tabsheet_breakpoints: TTabSheet;
    tabsheet_watches: TTabSheet;
    tabsheet_console: TTabSheet;
    tabsheet_callstack: TTabSheet;
    pagecontrol_left: TPageControl;
    tabsheet_project: TTabSheet;
    tabsheet_functions: TTabSheet;
    tabsheet_current_functions: TTabSheet;
    procedure FormCreate(Sender: TObject);
    procedure action_openExecute(Sender: TObject);
    procedure action_preferencesExecute(Sender: TObject);
    procedure actionlist_mainUpdate(Action: TBasicAction;
      var Handled: Boolean);
    procedure action_open_project_fileExecute(Sender: TObject);
    procedure action_add_file_to_projectExecute(Sender: TObject);
    procedure action_remove_file_from_projectExecute(Sender: TObject);
    procedure action_save_project_asExecute(Sender: TObject);
    procedure action_open_projectExecute(Sender: TObject);
    procedure action_select_allExecute(Sender: TObject);
    procedure action_copyExecute(Sender: TObject);
    procedure action_cutExecute(Sender: TObject);
    procedure action_pasteExecute(Sender: TObject);
    procedure action_runExecute(Sender: TObject);
    procedure action_pauseUpdate(Sender: TObject);
    procedure action_step_overUpdate(Sender: TObject);
    procedure action_trace_intoUpdate(Sender: TObject);
    procedure action_runUpdate(Sender: TObject);
    procedure action_step_overExecute(Sender: TObject);
    procedure action_trace_intoExecute(Sender: TObject);
    procedure action_step_outExecute(Sender: TObject);
    procedure action_step_outUpdate(Sender: TObject);
    procedure edit_consoleKeyPress(Sender: TObject; var Key: Char);
    procedure action_saveExecute(Sender: TObject);
    procedure action_save_asExecute(Sender: TObject);
    procedure action_saveUpdate(Sender: TObject);
    procedure action_save_asUpdate(Sender: TObject);
    procedure action_new_scriptExecute(Sender: TObject);
    procedure action_closeExecute(Sender: TObject);
    procedure action_closeUpdate(Sender: TObject);
    procedure action_close_allExecute(Sender: TObject);
    procedure action_close_allUpdate(Sender: TObject);
    procedure action_aboutExecute(Sender: TObject);
    procedure action_save_allExecute(Sender: TObject);
    procedure action_save_allUpdate(Sender: TObject);
    procedure action_new_projectExecute(Sender: TObject);
    procedure action_findExecute(Sender: TObject);
    procedure action_search_againExecute(Sender: TObject);
    procedure action_search_againUpdate(Sender: TObject);
    procedure action_findUpdate(Sender: TObject);
    procedure action_replaceExecute(Sender: TObject);
    procedure action_quick_findExecute(Sender: TObject);
    procedure combobox_quick_findKeyPress(Sender: TObject; var Key: Char);
    procedure action_quick_findUpdate(Sender: TObject);
    procedure action_quick_find_in_filesUpdate(Sender: TObject);
    procedure action_replaceUpdate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure action_toggle_breakpointExecute(Sender: TObject);
    procedure action_find_in_filesExecute(Sender: TObject);
    procedure eltree_messagesDblClick(Sender: TObject);
    procedure action_quick_find_in_filesExecute(Sender: TObject);
    procedure eltree_project_filesCompareItems(Sender: TObject; Item1,
      Item2: TElTreeItem; var res: Integer);
    procedure action_find_in_filesUpdate(Sender: TObject);
    procedure action_add_watchUpdate(Sender: TObject);
    procedure action_pauseExecute(Sender: TObject);
    procedure action_stopExecute(Sender: TObject);
    procedure action_stopUpdate(Sender: TObject);
    procedure action_add_watchExecute(Sender: TObject);
    procedure action_add_file_to_projectUpdate(Sender: TObject);
    procedure action_remove_file_from_projectUpdate(Sender: TObject);
    procedure action_project_optionsUpdate(Sender: TObject);
    procedure action_project_optionsExecute(Sender: TObject);
    procedure action_exitExecute(Sender: TObject);
    procedure action_remove_watchExecute(Sender: TObject);
    procedure action_remove_watchUpdate(Sender: TObject);
    procedure text_watchKeyPress(Sender: TObject; var Key: Char);
    procedure action_add_watch_at_cursorExecute(Sender: TObject);
    procedure action_add_watch_at_cursorUpdate(Sender: TObject);
    procedure eltree_watchesKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure action_go_to_line_numberExecute(Sender: TObject);
    procedure action_go_to_line_numberUpdate(Sender: TObject);
    procedure listview_functionsData(Sender: TObject; Item: TListItem);
    procedure listview_functionsDblClick(Sender: TObject);
    procedure listview_functionsColumnClick(Sender: TObject;
      Column: TListColumn);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure findfile_add_project_filesFound(Sender: TObject; Folder: String;
      var FileInfo: TSearchRec);
    procedure findfile_add_project_filesComplete(Sender: TObject);
    procedure action_compile_and_execExecute(Sender: TObject);
    procedure action_compile_and_execUpdate(Sender: TObject);
    procedure action_toggle_breakpointUpdate(Sender: TObject);
    procedure findfile_add_project_filesNewFolder(Sender: TObject;
      Folder: String; var IgnoreFolder: Boolean);
    procedure mrufilelist_mainMRUItemClick(Sender: TObject;
      AFilename: String);
    procedure FormShow(Sender: TObject);
    procedure action_printExecute(Sender: TObject);
    procedure action_printUpdate(Sender: TObject);
    procedure eltree_watchesDblClick(Sender: TObject);
    procedure action_change_valueUpdate(Sender: TObject);
    procedure action_change_valueExecute(Sender: TObject);
    procedure eltree_breakpointsDblClick(Sender: TObject);
    procedure action_breakpoints_toggle_statusExecute(Sender: TObject);
    procedure action_breakpoints_propertiresExecute(Sender: TObject);
    procedure action_breakpoints_toggle_statusUpdate(Sender: TObject);
    procedure action_breakpoints_deleteUpdate(Sender: TObject);
    procedure action_breakpoints_disable_allUpdate(Sender: TObject);
    procedure action_breakpoints_propertiresUpdate(Sender: TObject);
    procedure action_breakpoints_enable_allUpdate(Sender: TObject);
    procedure action_breakpoints_delete_allUpdate(Sender: TObject);
    procedure action_breakpoints_deleteExecute(Sender: TObject);
    procedure action_breakpoints_disable_allExecute(Sender: TObject);
    procedure action_breakpoints_enable_allExecute(Sender: TObject);
    procedure action_breakpoints_delete_allExecute(Sender: TObject);
    procedure action_breakpoints_addExecute(Sender: TObject);
    procedure action_breakpoints_addUpdate(Sender: TObject);
    procedure eltree_breakpointsKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure listview_current_file_functionsData(Sender: TObject;
      Item: TListItem);
    procedure listview_current_file_functionsDblClick(Sender: TObject);
    procedure listview_current_file_functionsColumnClick(Sender: TObject;
      Column: TListColumn);
    procedure popupmenu_breakpointsPopup(Sender: TObject);
    procedure combobox_quick_findChange(Sender: TObject);
    procedure action_compile_selectedExecute(Sender: TObject);
    procedure action_compile_selectedUpdate(Sender: TObject);
    procedure popupmenu_editorPopup(Sender: TObject);
    procedure clientsocket_debugDataAvailable(Sender: TObject;
      Error: Word);
    procedure clientsocket_debugChangeState(Sender: TObject; OldState,
      NewState: TSocketState);
    procedure clientsocket_debugSessionClosed(Sender: TObject;
      Error: Word);
    procedure clientsocket_debugSessionConnected(Sender: TObject;
      Error: Word);
    procedure eltree_watchesItemExpanding(Sender: TObject;
      Item: TElTreeItem; var CanProcess: Boolean);
    procedure timer_end_watches_updateTimer(Sender: TObject);
  private
    { Private declarations }
    system_expand             : boolean;
    
    { list of synedit objects}
    editor_list               : TEditorList;
    project_list              : TProjectList;
    debug_file_list           : TStringList;
    watch_list                : TWatchList;
    function_list             : TfunctionList;
    debugger_list             : TDebuggerList;
    current_function_list     : TfunctionList;
    group_list                : TStringList;
    Fxp_style                 : boolean;

    procedure SaveToRegistry;
    procedure LoadFromRegistry;
    procedure SendPacket( packet : string );
    procedure SendCommand ( command : string );
    procedure AddCallStack( the_message : string );
    procedure AddMessage( the_message : string );
    procedure AddConsole( the_message : string );
    procedure ShowFindForm( editor : TSynEdit; replace_mode, infiles_mode : boolean );
    procedure DoSearchReplaceText(AReplace: boolean; ABackwards: boolean);
    procedure FindInFiles ( SearchCaseSensitive, SearchWholeWords : boolean; SearchText : string);
    procedure GetWatches;
    procedure ProcessPacket ( inPacket : string );
    function CloseProject : boolean;
    procedure CompileChangedFiles;
    procedure ExecCompiledFiles;
    procedure OpenProject( FileName : string );
    procedure RegisterFileType( cMyExt, cMyFileType, cMyDescription : string );
    function GetVariableAt( editor : TSynEdit; X, Y : integer ) : string;
    procedure enable_group ( Sender : TObject ) ;
    procedure disable_group ( Sender : TObject ) ;
    procedure setxp_style( value : boolean );
  public
    { Public declarations }

    application_path          : string;

    main_uistyle              : string;

    { debugging server details }
    server_address            : string;
    server_port               : integer;
    server_debug_password     : string;
    { location of tribes 2 on this pc }
    tribes_directory          : string;

    { do we ask whether we want to save project file }
    auto_save_project         : boolean;
    { do we mainting the function list ? }
    function_browser          : boolean;

    { wait for #13+#10 packet }
    inc_packet                : string;

    { are we debugging at the moment ? }
    server_debugging          : boolean;
    debugging_step            : boolean;
    doing_compile             : boolean;
    current_file_compiling    : string;
    fSearchFromCaret          : boolean;

    { file associations }
    associate_asked          : boolean;
    do_associate             : boolean;

    { printing preferences }
    print_line_numbers        : boolean;
    print_highlight           : boolean;
    print_colors              : boolean;
    printer_font              : string;
    printer_font_size         : integer;

    { search globals }
    main_search_backwards: boolean;
    main_search_case_sensitive: boolean;
    main_search_from_cursor: boolean;
    main_search_selected_only: boolean;
    main_search_text_at_cursor: boolean;
    main_search_whole_words: boolean;

    main_search_text: string;
    main_replace_text: string;

    not_compiled : integer;
    been_compiled : integer;
    last_variable : string;

    read_only_files : integer;

    procedure SynEditorReplaceText(Sender: TObject;
      const ASearch, AReplace: String; Line, Column: Integer;
      var Action: TSynReplaceAction);
    procedure SetBreakPoint( Sender : TObject; inFilename : string;
              line_number : integer; breakpoint_status : boolean );
    procedure OnActiveChange ( editor_index :  integer );
    procedure OnFileSave ( Sender : TObject; filename : string );
    procedure OnFileRemove ( Sender : TObject; index : integer; filename : string );
    procedure ApplicationActivate(Sender: TObject);
    procedure WMCopyData(Var msg: TWMCopyData); message WM_COPYDATA;
    procedure EditorMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure update_current_functions;
    procedure function_menuitem_click( Sender : TObject );

    property xp_style : boolean read Fxp_style write setxp_style;
  end;

var
  form_main: Tform_main;
  PAppCommsData : PAppComms;

implementation

uses unit_form_preferences, unit_form_about, unit_form_find,
  unit_form_confirm_replace, unit_editor_utils, unit_form_new_project,
  unit_form_goto_line, unit_form_watch_value,
  unit_form_breakpoint_properties,
  unit_form_breakpoints,
  unit_form_callstack,
  unit_form_messages,
  unit_form_watches, unit_form_console, unit_form_project, unit_form_functions,
  unit_form_current_file_functions;

{$R *.DFM}



procedure Tform_main.FormCreate(Sender: TObject);
begin
  try
    application_path := IncludeTrailingBackslash(ExtractFilePath(Application.ExeName));

    { create the dockable windows }
    form_watches := TForm_watches.Create ( self );
    form_messages := Tform_messages.Create ( self );
    form_breakpoints := Tform_breakpoints.Create ( self );
    form_callstack := Tform_callstack.Create ( self );
    form_console := Tform_console.Create ( self );
    form_project_files := Tform_project_files.Create ( self );
    form_functions := Tform_functions.Create( self );
    form_current_file_functions := Tform_current_file_functions.Create ( self );

    { embed into tabsheet - as I cant use commericial docking components anymore }
    form_watches.parent := tabsheet_watches ;
    form_messages.parent := tabsheet_messages ;
    form_breakpoints.parent := tabsheet_breakpoints ;
    form_callstack.parent := tabsheet_callstack ;
    form_console.parent := tabsheet_console ;
    form_project_files.parent := tabsheet_project ;
    form_functions.parent := tabsheet_functions ;
    form_current_file_functions.parent := tabsheet_current_functions ;

    { create the stringlist holding the script files on debug server }
    debug_file_list := TStringList.Create;

    { store for groups in breakpoints }
    group_list := TStringList.Create;
    { create the list used for debugging }
    debugger_list := TDebuggerList.Create;
    { link to event generated when a breakpoint is toggled }
    debugger_list.OnSetBreakPoint := SetBreakPoint;
    { link debugger to tree }
    debugger_list.ElTree := form_breakpoints.eltree_breakpoints;

    { create the list that holds the editor objects }
    editor_list := TEditorList.Create;
    { link the list to the page control }
    editor_list.pageControl:=pagecontrol_source;
    { link the editor highlighter to the list }
    editor_list.Highlighter:=syntribes2syn_main;
    { link the replace text event }
    editor_list.OnReplaceText := SynEditorReplaceText;
    { link the editor_list to the save_file dialog }
    editor_list.savedialog_save_file := savedialog_save_file;
    { link the editor list to the editor images }
    editor_list.Images := imagelist_editor;
    { whenever the active window changes we see if we need breakpoints }
    editor_list.OnActiveChange := OnActiveChange;
    { link to on save event }
    editor_list.OnFileSave := OnFileSave;
    { link to mouse move event }
    editor_list.OnMouseMove := EditorMouseMove;
    { link editor to its popup }
    editor_list.PopUpMenu := popupmenu_editor;
    { link the debugger list to the breakpoint list }
    editor_list.DebuggerList := debugger_list;

    { link the tabsheet change event to currentactive }
    pagecontrol_source.OnChange := editor_list.PageControlChange;
    
    { create the project list }
    project_list := TProjectList.Create;
    { link the project list to the editor list }
    project_list.EditorList := editor_list;
    { link the treeview to the project list }
    project_list.ElTree:=form_project_files.eltree_project_files;
    { link to the files that are debuggable }
    project_list.DebugFileList := debug_file_list;
    { link to remove event }
    project_list.OnFileRemove := OnFileRemove;

    { create the function list }
    function_list := TFunctionList.Create;
    { link the project list to the function list }
    function_list.ProjectList := project_list;
    { link the listview to the function list }
    function_list.ListView := form_functions.listview_functions;

    { tempory function list for current active file }
    current_function_list := TfunctionList.Create;
    { link the project list to the function list }
    current_function_list.ProjectList := project_list;
    { link the listview to the function list }
    current_function_list.ListView := form_current_file_functions.listview_current_file_functions;

    { set the imageindexes }
    project_list.ProjectImageIndex := 26;
    project_list.FileImageIndex := 8;
    project_list.ZipImageIndex := 39;
    project_list.DebugFileImageIndex := 40;


    { list for holding debug watches }
    watch_list := TWatchList.Create;

    { link to eltree watch }
    watch_list.ElTree:=form_watches.eltree_watches;

    { create the headers }
    watch_list.Clear;
    debugger_list.Clear;

    { link to project }
    project_list.WatchList := watch_list;

    { currently not debugging on start }
    server_debugging := False;

    opendialog_open_project.InitialDir := tribes_directory;
    
    form_functions.listview_functions.doubleBuffered := True;

  finally
    { load application details }
    LoadFromRegistry;
  end;
end;

procedure Tform_main.action_openExecute(Sender: TObject);
var
  i : integer;
begin
  { set initial dir to project base path }
  opendialog_open_file.InitialDir := project_list.BasePath;
  { set title }
  opendialog_open_file.Title := 'Open Tribes 2 Script';
  { show dialog for opening a non project file }
  if opendialog_open_file.execute then
  begin
    { add the file(s) }
    for i := 0 to opendialog_open_file.Files.Count -1 do
      editor_list.OpenFile(opendialog_open_file.files[i],False);
  end;
end;

procedure Tform_main.action_preferencesExecute(Sender: TObject);
var
  form_preferences : Tform_preferences;
begin
  form_preferences := Tform_preferences.Create(Self);

  try
    with form_preferences do
    begin
      { copy variables into edit box values }
      edit_server_address.text := server_address ;
      edit_server_port.text := IntToStr(server_port);
      edit_server_debug_password.text := server_debug_password;
      edit_tribes_directory.text:=tribes_directory;
      checkbox_auto_save_project.checked := auto_save_project;
      checkbox_function_browser.checked := function_browser;

      { printing preferences }
      checkbox_print_line_numbers.checked := print_line_numbers;
      checkbox_print_hightlight.checked := print_highlight;
      checkbox_print_colors.checked := print_colors;
      combobox_printer_font.FontName := printer_font;
      combobox_printer_font_size.Text := IntToStr(printer_font_size);

      { file association }
      checkbox_assoiciate.checked := do_associate;

      { editor prefereces }
      with editor_list do
      begin
        checkbox_auto_indent.checked:=AutoIndent;
        checkbox_insert_mode.checked:=InsertMode;
        checkbox_use_tab_character.checked:=UseTabCharacter;
        checkbox_smart_tab.checked:=SmartTabs;
        checkbox_cursor_beyond_eof.checked:=CursorBeyondEOF;
        checkbox_cursor_beyond_eol.checked:=CursorBeyondEOL;
        checkbox_show_scroll_hint.checked:=ShowScrollHint;
        checkbox_trim_trailing_spaces.checked:=TrimTrailingSpaces;
        checkbox_show_line_numbers.checked:=ShowLineNumbers;
        edit_tab_stops.text:=IntToStr(TabStops);
        combobox_editor_font.FontName := EditorFont;
        combobox_font_size.Text := IntToStr(FontSize);
      end;

      { copy the highlighting options to prefernce highlighter }
      syntribes2syn_preferences.Assign(syntribes2syn_main);

      UIStyle := main_uistyle ;
      XPStyle := xp_style ;
    end;


    { show preferences form }
    if ( form_preferences.showModal = mrOk ) then
    begin
      with form_preferences do
      begin
        main_uistyle :=UIStyle;
        xp_style := XPStyle;

        { copy edit box values into variables }
        server_address := edit_server_address.text;

        try
          server_port := StrToInt(edit_server_port.text);
        except
          server_port := 0;
        end;

        { debugging }
        server_debug_password := edit_server_debug_password.text;
        tribes_directory := edit_tribes_directory.text;
        auto_save_project := checkbox_auto_save_project.checked;
        function_browser := checkbox_function_browser.checked;

        function_list.enabled := function_browser;

        { file association }
        do_associate:=checkbox_assoiciate.checked;

        if ( do_associate ) then
        begin
          RegisterFileType('.cs','tribesScript.FileType','Tribes Script File');
          RegisterFileType('.gui','tribesGui.FileType','Tribes Gui File');
        end;

        { printing preferences }
        print_line_numbers:=checkbox_print_line_numbers.checked;
        print_highlight:=checkbox_print_hightlight.checked;
        print_colors:=checkbox_print_colors.checked;
        printer_font:=combobox_printer_font.FontName;
        printer_font_size:=PrinterFontSizeValue;

        { editor options }
        with editor_list do
        begin
          AutoIndent:=checkbox_auto_indent.checked;
          InsertMode:=checkbox_insert_mode.checked;
          UseTabCharacter:=checkbox_use_tab_character.checked;
          SmartTabs:=checkbox_smart_tab.checked;
          CursorBeyondEOF:=checkbox_cursor_beyond_eof.checked;
          CursorBeyondEOL:=checkbox_cursor_beyond_eol.checked;
          ShowScrollHint:=checkbox_show_scroll_hint.checked;
          TrimTrailingSpaces:=checkbox_trim_trailing_spaces.checked;
          ShowLineNumbers:=checkbox_show_line_numbers.checked;

          TabStops:=TabStopsValue;

          EditorFont := combobox_editor_font.FontName ;
          FontSize := FontSizeValue;

          { tell open editors new settings }
          SetDefaults;
        end;

        { update highlighting }
        syntribes2syn_main.Assign(syntribes2syn_preferences);

        { save variables to registry }
        SaveToRegistry;

        TBXSetTheme( main_uistyle );
      end;
    end;
  finally
    form_preferences.free;
  end;
end;

procedure Tform_main.setxp_style( value : boolean );
begin
  FXp_style := value;
  { xp style toolbars }
  tbxswitcher_main.EnableXPStyles := value;
  { xp style controls }
  if ( value ) then
    thememanager_main.Options := DefaultThemeOptions
  else
    { disbale xp style for other controls }
    thememanager_main.Options := DefaultThemeOptions - [toAllowControls, toAllowNonClientArea];
end;

procedure Tform_main.actionlist_mainUpdate(Action: TBasicAction;
  var Handled: Boolean);
var
  select_all            : boolean;
  sel_avail             : boolean;
  can_undo              : boolean;
  can_redo              : boolean;
  can_paste             : boolean;
begin
  { can we open the selected file(s)}
  action_open_project_file.enabled:=project_list.IsProjectFilesSelected;

  if ( editor_list.CurrentActive <> -1 ) then
  begin
    with editor_list[editor_list.CurrentActive] do
    begin
      if ( editor.CaretY <> LastY ) or
         ( editor.CaretX <> LastX ) then
      begin
        LastX := editor.CaretX ;
        LastY := editor.CaretY ;
        FoundLine := -1;
      end;

      statusbar_main.panels[0].Text := Format('%5d:%5d  ',[editor.CaretY,editor.CaretX]);

      { text modified or not ? }
      if ( Editor.Modified )  then
        statusbar_main.Panels[1].Text := 'Modified'
      else
        statusbar_main.Panels[1].Text := '';

      { text modified or not ? }
      if ( Editor.InsertMode ) then
        statusbar_main.Panels[2].Text := 'Insert'
      else
        statusbar_main.Panels[2].Text := 'Overwrite';
    end;
  end;

  { set flags all to false }
  select_all := False;
  sel_avail  := False;
  can_undo := False;
  can_redo := False;
  can_paste := False;

  { editor currently available }
  if ( editor_list.CurrentActive <> -1 ) then
  begin
    { has the active editor focus }
    with editor_list do
    begin
      if ( editors[CurrentActive].editor.Focused ) then
      begin
        select_all := true;
        sel_avail := editors[CurrentActive].editor.SelAvail;
        can_paste := editors[CurrentActive].editor.CanPaste;
        can_undo := editors[CurrentActive].editor.CanUndo;
        can_redo := editors[CurrentActive].editor.CanRedo;
      end;
    end;
  end;

  action_cut.enabled := sel_avail;
  action_copy.enabled := sel_avail;
  action_paste.enabled := can_paste;
  action_undo.enabled := can_undo;
  action_redo.enabled := can_redo;

  action_select_all.enabled := select_all;
end;

procedure Tform_main.action_open_project_fileExecute(Sender: TObject);
begin
  { open all the selected files }
  project_list.OpenSelected;
end;

procedure Tform_main.action_add_file_to_projectExecute(Sender: TObject);
var
  i : integer;
  project_index : integer;
begin
  { set initial dir to project base path }
  opendialog_add_project_file.InitialDir := project_list.BasePath;
  opendialog_add_project_file.Title := 'Add Tribes 2 Script(s) or VL2(s) to project';

  { show dialog for adding a project file }
  if opendialog_add_project_file.execute then
  begin
    try
      { tell the tree to not redraw }
      form_project_files.eltree_project_files.items.BeginUpdate;
      { add the file(s) }
      for i := 0 to opendialog_add_project_file.Files.Count -1 do
      begin
        project_index := project_list.AddFile(opendialog_add_project_file.files[i]);
        if ( project_index <> -1 ) then
          function_list.ScanByIndex( project_index );
      end;
    finally
      { tell tree we are done }
      form_project_files.eltree_project_files.items.EndUpdate;
    end;

  end;
end;

procedure Tform_main.action_remove_file_from_projectExecute(
  Sender: TObject);
begin
  if MessageDlg('Remove selected files from project?',
     mtConfirmation, [mbYes, mbNo], 0) = mrYes then
  begin
    { remove all the selected files from the project }
    project_list.RemoveSelected;
  end;
end;

procedure Tform_main.action_save_project_asExecute(Sender: TObject);
begin
  { show save project dialog }
  if savedialog_save_project.execute then
  begin
    project_list.ProjectFileName := savedialog_save_project.filename;
    project_list.SaveToFile( savedialog_save_project.filename );
    function_list.SaveToFile(project_list.BasePath, ChangeFileExt( savedialog_save_project.filename, '.tsb'));
  end;
end;

procedure Tform_main.OpenProject( FileName : string );
var
  reginifile_mru : TRegIniFile;
begin
  if ( mrufilelist_main.items.IndexOf(filename) = -1 ) then
    mrufilelist_main.items.Add( filename );

  reginifile_mru := TRegIniFile.Create( Format('Software\%s\',[ApplicationName]));
  try
    mrufilelist_main.SaveToRegIni( reginifile_mru, 'MRU' );
  finally
    reginifile_mru.free;
  end;

  { stop debugger first }
  action_stop.Execute;

  { load project files }
  project_list.LoadFromFile( filename );

  { setup new breakpoint list }
  debugger_list.BasePath := project_list.BasePath;
  
  { look for functions }
  if ( FileExists(ChangeFileExt( filename, '.tsb')) ) then
  begin
    { found so load }
    function_list.LoadFromFile(ChangeFileExt( filename, '.tsb'));
    { update any external changes }
    function_list.ScanFileAges( False );
  end
  else { recreate }
  begin
    function_list.Clear;
    function_list.ScanFileAges( True );
  end;
  
  { set list view size }
  form_functions.listview_functions.items.Count := function_list.Count;

  { update initial open file }
  update_current_functions;

  { resort function list }
  function_list.DoSort;
end;

procedure Tform_main.action_open_projectExecute(Sender: TObject);
begin
  { show save project dialog }
  if opendialog_open_project.execute then
  begin
    OpenProject( opendialog_open_project.filename );
  end;
end;

procedure Tform_main.action_select_allExecute(Sender: TObject);
begin
  { editor active ? }
  if ( editor_list.CurrentActive <> -1 ) then
  begin
    { select all }
    with editor_list do
      editors[CurrentActive].editor.SelectAll;
  end;
end;

procedure Tform_main.action_copyExecute(Sender: TObject);
begin
  { editor active ? }
  if ( editor_list.CurrentActive <> -1 ) then
  begin
    { copy }
    with editor_list do
      editors[CurrentActive].editor.CopyToClipboard;
  end;
end;

procedure Tform_main.action_cutExecute(Sender: TObject);
begin
  { editor active ? }
  if ( editor_list.CurrentActive <> -1 ) then
  begin
    { cut }
    with editor_list do
      editors[CurrentActive].editor.CutToClipboard;
  end;
end;

procedure Tform_main.action_pasteExecute(Sender: TObject);
begin
  { editor active ? }
  if ( editor_list.CurrentActive <> -1 ) then
  begin
    { paste }
    with editor_list do
      editors[CurrentActive].editor.PasteFromClipboard;
  end;
end;

{ save settings to windows registry }
procedure Tform_main.SaveToRegistry;
var
  registry_editor : TRegistryIniFile;
  i : integer;
  group_name : string;
begin
  registry_editor := TRegistryIniFile.Create(Format('Software\%s\',[ApplicationName]));

  try
    registry_editor.WriteBool('Preferences','main_xpstyle', xp_style);
    registry_editor.WriteString('Preferences','main_uistyle', main_uistyle);
    registry_editor.WriteString('Preferences','server_address', server_address);
    registry_editor.WriteInteger('Preferences','server_port', server_port);
    registry_editor.WriteString('Preferences','server_debug_password', server_debug_password);
    registry_editor.WriteString('Preferences','tribes_directory', tribes_directory);
    registry_editor.WriteBool('Preferences','auto_save_project', auto_save_project);
    registry_editor.WriteBool('Preferences','function_browser', function_browser);
    registry_editor.WriteInteger('Positions','listview_functions.column[0].width', form_functions.listview_functions.column[0].width);
    registry_editor.WriteInteger('Positions','listview_functions.column[1].width', form_functions.listview_functions.column[1].width);
    registry_editor.WriteBool('File Association','associate_asked', associate_asked);
    registry_editor.WriteBool('File Association','do_associate', do_associate);


    case WindowState of
      wsNormal :
      begin
        registry_editor.WriteString('Positions','form_main.WindowState', 'wsNormal');
        registry_editor.WriteInteger('Positions','top', top);
        registry_editor.WriteInteger('Positions','left', left);
        registry_editor.WriteInteger('Positions','width', width);
        registry_editor.WriteInteger('Positions','height', height);
      end;
      wsMaximized : registry_editor.WriteString('Positions','form_main.WindowState', 'wsMaximized');
    end;

    { printing prefereces }
    registry_editor.WriteBool('PrinterPreferences','print_line_numbers', print_line_numbers);
    registry_editor.WriteBool('PrinterPreferences','print_highlight', print_highlight);
    registry_editor.WriteBool('PrinterPreferences','print_colors', print_colors);
    registry_editor.WriteString('PrinterPreferences','printer_font', printer_font);
    registry_editor.WriteInteger('PrinterPreferences','printer_font_size', printer_font_size);

    { save editor preferences }
    with editor_list do
    begin
      registry_editor.WriteBool('EditorPreferences','AutoIndent', AutoIndent);
      registry_editor.WriteBool('EditorPreferences','InsertMode', InsertMode);
      registry_editor.WriteBool('EditorPreferences','UseTabCharacter', UseTabCharacter);
      registry_editor.WriteBool('EditorPreferences','SmartTabs', SmartTabs);
      registry_editor.WriteBool('EditorPreferences','CursorBeyondEOF', CursorBeyondEOF);
      registry_editor.WriteBool('EditorPreferences','CursorBeyondEOL', CursorBeyondEOL);
      registry_editor.WriteBool('EditorPreferences','ShowScrollHint', ShowScrollHint);
      registry_editor.WriteBool('EditorPreferences','TrimTrailingSpaces', TrimTrailingSpaces);
      registry_editor.WriteBool('EditorPreferences','ShowLineNumbers', ShowLineNumbers);
      registry_editor.WriteInteger('EditorPreferences','TabStops', TabStops);
      registry_editor.WriteString('EditorPreferences','EditorFont', EditorFont);
      registry_editor.WriteInteger('EditorPreferences','FontSize', FontSize);;
    end;

    { save highlighter colors and styles }
    for i := 0 to syntribes2syn_main.AttrCount-1 do
    begin
      with syntribes2syn_main.Attribute[i] do
      begin
        group_name := Format('EditorPreferences\Attributes\%s', [Name]);
        registry_editor.WriteInteger(group_name,'Foreground',Foreground);
        registry_editor.WriteInteger(group_name,'Background',Background);
        registry_editor.WriteBool(group_name,'Bold',(fsBold in Style));
        registry_editor.WriteBool(group_name,'Italic',(fsItalic in Style));
        registry_editor.WriteBool(group_name,'Underline',(fsUnderline in Style));
        registry_editor.WriteBool(group_name,'Strikeout',(fsStrikeOut in Style));
      end;
    end;

  finally
    registry_editor.Free;
  end;
end;

{ load settings from windows registry }
procedure Tform_main.LoadFromRegistry;
var
  registry_tribes_directory : TRegistry;
  registry_editor : TRegistryIniFile;
  i : integer;
  group_name : string;
  tempStyle : TFontStyles;
  default_directory : string;

begin
  registry_tribes_directory :=  TRegistry.Create;
  try
    registry_tribes_directory.RootKey := HKEY_LOCAL_MACHINE;
    if registry_tribes_directory.OpenKey('\Software\Sierra OnLine\Setup\Tribes2\', True) then
      default_directory:=registry_tribes_directory.ReadString('directory');
  finally
    registry_tribes_directory.CloseKey;
    registry_tribes_directory.Free;

  end;

  registry_editor := TRegistryIniFile.Create(Format('Software\%s\',[ApplicationName]));

  try
    { read general info }
    xp_style := registry_editor.ReadBool('Preferences','main_xpstyle', True);
    main_uistyle := registry_editor.ReadString('Preferences','main_uistyle','Default');
    server_address:=registry_editor.ReadString('Preferences','server_address', '');
    server_port:=registry_editor.ReadInteger('Preferences','server_port', 0);
    server_debug_password:=registry_editor.ReadString('Preferences','server_debug_password', '');
    tribes_directory:=registry_editor.ReadString('Preferences','tribes_directory', default_directory);
    { read window positions }
    form_functions.listview_functions.column[0].width := registry_editor.ReadInteger('Positions','listview_functions.column[0].width', 150);
    form_functions.listview_functions.column[1].width := registry_editor.ReadInteger('Positions','listview_functions.column[1].width', 150);
    auto_save_project:=registry_editor.ReadBool('Preferences','auto_save_project', True);
    function_browser:=registry_editor.ReadBool('Preferences','function_browser', True);

    associate_asked:=registry_editor.ReadBool('File Association','associate_asked', false);
    do_associate:=registry_editor.ReadBool('File Association','do_associate', false);

    if ( registry_editor.ReadString('Positions','form_main.WindowState', '') = 'wsMaximized' ) then
    begin
      WindowState := wsMaximized;
    end
    else
    if ( registry_editor.ReadString('Positions','form_main.WindowState', '') = 'wsNormal' ) then
    begin
      top := registry_editor.ReadInteger('Positions','top', Screen.Width div 4);
      left := registry_editor.ReadInteger('Positions','left', Screen.Width div 4);
      width := registry_editor.ReadInteger('Positions','width', Screen.Width div 2);
      height := registry_editor.ReadInteger('Positions','height', Screen.Height div 2 );

      Position := poDesigned;
    end;

    function_list.enabled := function_browser;

    { printing prefereces }
    print_line_numbers:=registry_editor.ReadBool('PrinterPreferences','print_line_numbers', false);
    print_highlight:=registry_editor.ReadBool('PrinterPreferences','print_highlight', true);
    print_colors:=registry_editor.ReadBool('PrinterPreferences','print_colors', false);
    printer_font:=registry_editor.ReadString('PrinterPreferences','printer_font', 'Courier New');
    printer_font_size:=registry_editor.ReadInteger('PrinterPreferences','printer_font_size', 8);

    { read editor options }
    with editor_list do
    begin
      AutoIndent:=registry_editor.ReadBool('EditorPreferences','AutoIndent', True);
      InsertMode:=registry_editor.ReadBool('EditorPreferences','InsertMode', True);
      UseTabCharacter:=registry_editor.ReadBool('EditorPreferences','UseTabCharacter', False);
      SmartTabs:=registry_editor.ReadBool('EditorPreferences','SmartTabs', True);
      CursorBeyondEOF:=registry_editor.ReadBool('EditorPreferences','CursorBeyondEOF', False);
      CursorBeyondEOL:=registry_editor.ReadBool('EditorPreferences','CursorBeyondEOL', True);
      ShowScrollHint:=registry_editor.ReadBool('EditorPreferences','ShowScrollHint', True);
      TrimTrailingSpaces:=registry_editor.ReadBool('EditorPreferences','TrimTrailingSpaces', True);
      ShowLineNumbers:=registry_editor.ReadBool('EditorPreferences','ShowLineNumbers', True);
      TabStops:=registry_editor.ReadInteger('EditorPreferences','TabStops', 4);
      EditorFont:=registry_editor.ReadString('EditorPreferences','EditorFont', 'Courier New');
      FontSize:=registry_editor.ReadInteger('EditorPreferences','FontSize', 10);
      SetDefaults;
    end;

    { read highlighter colors and styles }
    for i := 0 to syntribes2syn_main.AttrCount-1 do
    begin
      with syntribes2syn_main.Attribute[i] do
      begin
        group_name := Format('EditorPreferences\Attributes\%s', [Name]);
        if ( registry_editor.ReadInteger(group_name,'Foreground',-MAXLONGINT) <> -MAXLONGINT ) then
        begin
          { colors }
          Foreground:=TColor(registry_editor.ReadInteger(group_name,'Foreground',clBlack));
          Background:=TColor(registry_editor.ReadInteger(group_name,'Background',clWhite));

          { styles }
          tempStyle:=[];

          if ( registry_editor.ReadBool(group_name,'Bold',False) ) then
            Include(tempStyle,fsBold);
          if ( registry_editor.ReadBool(group_name,'Italic',False) ) then
            Include(tempStyle,fsItalic);
          if ( registry_editor.ReadBool(group_name,'Underline',False) ) then
            Include(tempStyle,fsUnderline);
          if ( registry_editor.ReadBool(group_name,'Strikeout',False) ) then
            Include(tempStyle,fsStrikeout);

          Style := tempStyle;
        end;
      end;
    end;

    mrufilelist_main.LoadFromRegIni( registry_editor.reginifile, 'MRU' );

  finally
    registry_editor.Free;
  end;


end;

procedure Tform_main.action_runExecute(Sender: TObject);
begin
  { reset stepping cursor }
  debugger_list.SteppingAtLine := -1 ;
  debugger_list.SteppingAtFile := '';
  debugger_list.Enabled := True;

  { are we connected or not ? }
  if ( not server_debugging ) then
  begin
    { connect to debugging server }
    clientsocket_debug.Addr := server_address;
    clientsocket_debug.Port := IntToStr(server_port);

    project_list.ClearBreakpointsGot;

    { open the communications }
    clientsocket_debug.Connect;
  end
  else
  begin
    SendPacket('CONTINUE');
  end;
end;


{ process the packet }
procedure Tform_main.ProcessPacket ( inPacket : string );
var
  clean_packet : string;
  i            : integer;
  editor_index : integer;
  project_index : integer;
  line_number  : integer;
  original_packet : string;
  watch_id  : integer;
  watch_index : integer;
  compile_end : string;
  breakpoint_index : integer;
  call_stack_count : integer;
  filename : string;
begin
  original_packet := Trim( inPacket );
  clean_packet := StringReplace( original_packet, '/','\', [rfIgnoreCase, rfReplaceAll]);

  //AddMessage('!'+clean_packet+'!');

  { password authenticated ----------------------------------------------------}
  if ( PacketParamStr(' ',0, clean_packet) = 'PASS' ) then
  begin
    if ( PacketRestStr(' ',1, clean_packet) = 'WrongPassword.' ) then
    begin
      { bad password }
      AddMessage('Invalid Password');
    end
    else if ( PacketRestStr(' ',1, clean_packet) = 'Connected.' ) then
    begin
      { set the fact we are now debuging }
      server_debugging := True;
      { as we have just connected, we are not stepping through code }
      debugging_step := False;
      { password ok }
      AddMessage('Password Accepted');
      AddMessage('Requesting Server Script List');
      { request list of the scripts on server }
      SendPacket('FILELIST');
    end;
  end
  { Received Filelist ---------------------------------------------------------}
  else if ( PacketParamStr(' ',0, clean_packet) = 'FILELISTOUT' ) then
  begin
    debug_file_list.clear;
    { add files to string list }
    for i :=1 to PacketParamCount(' ',clean_packet)-1 do
    begin
      debug_file_list.Add(PacketParamStr(' ',i-1, clean_packet));
    end;

    project_list.UpdateIcons;

    { get breakpoint for current active }
    OnActiveChange ( editor_list.CurrentActive );
  end
  { we have hit a breakpoint --------------------------------------------------}
  else if ( PacketParamStr(' ',0, clean_packet) = 'BREAK' ) then
  begin
    { can now step through code }
    debugging_step := True;

    { clear hover watch }
    last_variable := '';

    { get all the set watches }
    GetWatches;

    { fill callstack }
    call_stack_count := (PacketParamCount(' ', clean_packet)-1) div 4;

    form_callstack.eltree_callstack.items.Clear;

    for i := 0 to call_stack_count-1 do
    begin
      AddCallStack (Format('%s (%s): %s',[
      PacketParamStr(' ', (i*3)+1, clean_packet),
      PacketParamStr(' ', (i*3)+2, clean_packet),
      PacketParamStr(' ', (i*3)+3, clean_packet)]));
    end;
    
    { open the file were stopped in }
    editor_index := project_list.OpenRelativeFilename ( PacketParamStr(' ',1, clean_packet) );

    if ( editor_index <> -1 ) then
    begin
      { get line number }
      line_number := StrToInt(PacketParamStr(' ',2, clean_packet));

      { set stepping cursor }
      debugger_list.SteppingAtLine := line_number ;
      debugger_list.SteppingAtFile := editor_list.editors[editor_index].filename;

      { goto correct line number }
      with editor_list[editor_index] do
      begin
        GotoLine( line_number );
      end;

      { was this a breakpoint ? }
      breakpoint_index := debugger_list.FindBreakPoint(
                          editor_list.editors[editor_index].filename,
                          line_number);

      if ( breakpoint_index <> -1 ) then
      begin
        { if this was a clear after hit then clear it }
        if ( debugger_list[breakpoint_index].DisableAfterHit ) and
           ( debugger_list[breakpoint_index].Enabled ) and
           ( debugger_list[breakpoint_index].Active ) then
        begin
          debugger_list[breakpoint_index].Enabled := False;
        end;
      end;

      filename := ExtractUnixRelativePath(project_list.BasePath, editor_list.editors[editor_index].filename);

      SendPacket(Format('BREAKLIST %s',[filename]));

      Application.BringToFront;
    end;
  end
  { we started the process again ----------------------------------------------}
  else if ( PacketParamStr(' ',0, clean_packet) = 'RUNNING' ) then
  begin
    { can now not step through code }
    debugging_step := False;
    { clear cursor watch }
    statusbar_main.Panels[3].Text := '';
  end
  { output from console -------------------------------------------------------}
  else if ( PacketParamStr(' ',0, clean_packet) = 'COUT' ) then
  begin
    AddConsole(PacketRestStr(' ',1, clean_packet));

    { we are compiling arent we? }
    if ( doing_compile ) then
    begin
      { finished so exec }
      if ( PacketRestStr(' ',1, clean_packet) = MSG_COMPILATION_COMPLETE ) then
      begin
        doing_compile := false;
        ExecCompiledFiles;
      end
      else
      { compiling a file }
      if ( PacketParamStr(' ',1, clean_packet) = 'Compiling' ) then
      begin
        compile_end := PacketRestStr(' ',2, clean_packet);
        { remove the ... }
        compile_end := Copy(compile_end, 1, length(compile_end)-3);
        current_file_compiling := compile_end;
      end
      else
        { one of the errors starts with exec: }
        if ( PacketParamStr(' ',1, clean_packet) = 'exec:') then
        begin
          { invalid script file }
          AddMessage(PacketRestStr(' ',2, clean_packet));
        end
        else
        begin
          { syntax error  format of filename Line: 000 - Syntax error
          we convert it to filename (000): Syntax error }
          AddMessage(ConvertError(PacketRestStr(' ',1, clean_packet)));
        end;
    end;

    { all files have been executed }
    if ( PacketRestStr(' ',1, clean_packet) = MSG_EXEC_COMPLETE ) then
    begin
        SendPacket('FILELIST');
        { show failed compiled message if any .dso files not there or
        still same date }
        if ( not_compiled > 0 ) then
          MessageDlg(Format('%d file(s) have failed to compile - %d file(s) have been compiled and executed',[not_compiled,been_compiled]), mtError, [mbOk], 0)
        else
          MessageDlg(Format('All %d files have compiled and executed successful',[been_compiled]), mtInformation, [mbOk], 0);
    end;

  end
  { breakpoint list }
  else if ( PacketParamStr(' ',0, clean_packet) = 'BREAKLISTOUT' ) then
  begin
    { find file }
    project_index := project_list.HasRelativeFilename (  PacketParamStr(' ',1, clean_packet) );
    if ( project_index <> -1 ) then
    begin
      if ( not project_list[project_index].BreakpointsGot ) and
         ( editor_list.IsOpen( project_list[project_index].filename ) <> -1 ) then
      begin
        { we have the breakpoints for this file }
        project_list[project_index].BreakpointsGot := True;
        debugger_list.DeleteFilesNonSetBreakpoints( project_list[project_index].filename );
        { set break points }
        debugger_list.SetBreakPoints( project_list[project_index].filename, PacketRestStr(' ',2, clean_packet));
        { this might be an update to an already open file so resend our valid breakpoints }
        debugger_list.ResendBreakPoints ( project_list[project_index].filename, false );
        { only allow incoming breakpoints on open files  }
        { open the file were stopped in }
        editor_index := project_list.OpenRelativeFilename ( PacketParamStr(' ',1, clean_packet) );
        { update editor }
        if ( editor_index <> -1 ) then
          editor_list[editor_index].Editor.Invalidate;
      end;
    end;
  end
  { A watch value  ------------------------------------------------------------}
  else if ( PacketParamStr(' ',0, clean_packet) = 'EVALOUT' ) then
  begin
    watch_id := strtoint(PacketParamStr(' ',1, clean_packet));
    if ( watch_id <> -1 ) then
    begin
      { now find this watch }
      watch_index := watch_list.FindwatchViaID( watch_id );
      if ( watch_index <> -1 ) and ( watch_list[watch_index].Parent = nil ) then
      begin
        watch_list[watch_index].value :=PacketRestStr(' ',2, clean_packet)
      end;
    end
    else
    begin
      if ( timer_end_watches_update.enabled ) then
      begin
        timer_end_watches_update.enabled := false;
        form_watches.eltree_watches.items.EndUpdate;
      end;

      statusbar_main.Panels[3].Text := last_variable +' = '+PacketRestStr(' ',2, clean_packet);
    end;
  end
  { A list of watch sub items  ------------------------------------------------}
  else if ( PacketParamStr(' ',0, clean_packet) = 'OBJTAGLISTOUT' ) then
  begin
    watch_id := strtoint(PacketParamStr(' ',1, clean_packet));
    if ( watch_id <> -1 ) then
    begin
      { now find this watch }
      watch_index := watch_list.FindwatchViaID( watch_id );
      if ( watch_index <> -1 ) then
      begin
        watch_list.AddSubWatches( watch_list[watch_index], PacketRestStr(' ',2, clean_packet) );

        system_expand := True;
        try
          watch_list[watch_index].ELTreeItem.Expanded := True;
        finally
          system_expand := False;
        end;
        
      end;
    end;
  end;
end;

{ wrapper for send info to debug server - adds on carriage return and new line}
procedure Tform_main.SendPacket( packet : string );
begin
  if ( clientsocket_debug.State = wsConnected ) then
    clientsocket_debug.SendStr( packet+#13+#10 );
end;

{ add CEVAL to start of command }
procedure Tform_main.SendCommand ( command : string );
begin
  AddConsole('==>'+command);
  SendPacket(Format('CEVAL %s',[command]));
end;



procedure Tform_main.action_pauseUpdate(Sender: TObject);
begin
  action_pause.enabled:= ( server_debugging ) and ( not debugging_step );
end;

procedure Tform_main.action_step_overUpdate(Sender: TObject);
begin
  action_step_over.enabled:=( server_debugging ) and ( debugging_step );
end;

procedure Tform_main.action_trace_intoUpdate(Sender: TObject);
begin
  action_trace_into.enabled:=( server_debugging ) and ( debugging_step );
end;

procedure Tform_main.action_runUpdate(Sender: TObject);
begin
  action_run.enabled:=( not server_debugging ) or ( debugging_step );
end;

{ add a message to the message window }
procedure Tform_main.AddMessage( the_message : string );
begin
  form_messages.eltree_messages.TopItem := form_messages.eltree_messages.items.Add( nil, the_message );
end;

{ add a message to the console window }
procedure Tform_main.AddConsole( the_message : string );
begin
  form_console.eltree_console.TopItem := form_console.eltree_console.items.Add( nil, the_message );
end;

{ add a function to the callstack window }
procedure Tform_main.AddCallStack( the_message : string );
begin
  form_callstack.eltree_callstack.TopItem := form_callstack.eltree_callstack.items.Add( nil, the_message );
end;

procedure Tform_main.action_step_overExecute(Sender: TObject);
begin
    SendPacket('STEPOVER');
end;

procedure Tform_main.action_trace_intoExecute(Sender: TObject);
begin
    SendPacket('STEPIN');
end;

procedure Tform_main.action_step_outExecute(Sender: TObject);
begin
    SendPacket('STEPOUT');
end;

procedure Tform_main.action_step_outUpdate(Sender: TObject);
begin
  action_step_out.enabled:=( server_debugging ) and ( debugging_step );
end;

procedure Tform_main.edit_consoleKeyPress(Sender: TObject; var Key: Char);
begin
  { hit return key ? }
  if ( key = #13 ) then
  begin
    SendCommand(form_console.edit_console.text);
    { clear edit box }
    form_console.edit_console.text := '';
  end;
end;

procedure Tform_main.action_saveExecute(Sender: TObject);
begin
  if ( editor_list.CurrentActive <> -1 ) then
  begin
    editor_list[ editor_list.CurrentActive ].Save ( False );
  end;
end;

procedure Tform_main.action_save_asExecute(Sender: TObject);
begin
  if ( editor_list.CurrentActive <> -1 ) then
  begin
      editor_list[ editor_list.CurrentActive ].SaveRequest;
  end;
end;

procedure Tform_main.action_saveUpdate(Sender: TObject);
begin
  if ( editor_list.CurrentActive <> -1 ) then
    action_save.enabled := editor_list[editor_list.CurrentActive].editor.modified
  else
    action_save.enabled := false;
end;

procedure Tform_main.action_save_asUpdate(Sender: TObject);
begin
  action_save_as.enabled := editor_list.CurrentActive <> -1;
end;

procedure Tform_main.action_new_scriptExecute(Sender: TObject);
begin
  editor_list.NewFile;
end;

procedure Tform_main.action_closeExecute(Sender: TObject);
begin
  if ( editor_list.CurrentActive <> -1 ) then
    editor_list.Close(editor_list.CurrentActive);
end;

procedure Tform_main.action_closeUpdate(Sender: TObject);
begin
  action_close.enabled := editor_list.CurrentActive <> -1;
end;

procedure Tform_main.action_close_allExecute(Sender: TObject);
begin
  CloseProject;
end;

procedure Tform_main.action_close_allUpdate(Sender: TObject);
begin
  action_close_all.enabled := editor_list.count > 0;
end;

procedure Tform_main.action_aboutExecute(Sender: TObject);
begin
  form_about.ShowModal;
end;

procedure Tform_main.action_save_allExecute(Sender: TObject);
var
  i : integer;
begin
  { were doing this here, instead of inside the editorlist class,
  as we need to show dialog if file is new }

  { go through all files }
  for i:=0 to editor_list.Count-1 do
  begin
    { try and just save it }
    if ( not editor_list.editors[i].Save( False ) ) then
    begin
        break; { we stop the loop if they cancel on a save as }
    end;
  end;

end;

procedure Tform_main.action_save_allUpdate(Sender: TObject);
begin
  action_save_all.enabled:=editor_list.anyModified;
end;

procedure Tform_main.action_new_projectExecute(Sender: TObject);
var
  form_new_project : Tform_new_project;

begin
  form_new_project := Tform_new_project.Create(Self);

  try
    { set form up as create project }
    form_new_project.NewProject := True;

    { show form }
    if ( form_new_project.ShowModal = mrOk ) then
    begin
      { try and close the project }
      if ( CloseProject ) then
      begin
        { setup new list }
        project_list.ProjectName := form_new_project.edit_project_name.text;
        project_list.BasePath := IncludeTrailingBackslash(form_new_project.edit_project_directory.text);
        project_list.ProjectFileName := '';
        project_list.Modified := False;

        { setup dialogs }
        opendialog_open_file.InitialDir := project_list.BasePath;
        opendialog_open_project.InitialDir := project_list.BasePath;
        savedialog_save_file.InitialDir := project_list.BasePath;
        savedialog_save_project.InitialDir := project_list.BasePath;

        { ask whether we want to add files }
        if MessageDlg('Add all scripts found in and below project directory?',
         mtConfirmation, [mbYes, mbNo], 0) = mrYes then
        begin
          form_project_files.eltree_project_files.items.BeginUpdate;
          { set total of read only files to 0 }
          read_only_files := 0;
          { do a search for script files }
          findfile_add_project_files.Location:=project_list.BasePath;
          findfile_add_project_files.execute;
        end;

        { repopulate tree }
        project_list.PopulateTreeView;
      end;
    end;
  finally
    form_new_project.free;
  end;
end;

{ show search/replace form }
procedure Tform_main.ShowFindForm( editor : TSynEdit; replace_mode, infiles_mode : boolean );
begin
  form_find.Replace := replace_mode;
  form_find.InFiles := infiles_mode;

  with form_find do
  begin
    { assign search options }
    SearchBackwards := main_search_backwards;
    SearchCaseSensitive := main_search_case_sensitive;
    SearchFromCursor := main_search_from_cursor;
    SearchInSelectionOnly := main_search_selected_only;
    { start with last search text }
    SearchText := main_search_text;
    if main_search_text_at_cursor then
    begin
      if ( editor <> nil ) then
      begin
        { if something is selected search for that text }
        if editor.SelAvail and (editor.BlockBegin.Y = editor.BlockEnd.Y) then
          SearchText := editor.SelText
        else
          SearchText := editor.GetWordAtRowCol(editor.CaretXY);
      end;
    end;

    { replacing text ? }
    if replace_mode then
    begin
      { then copy global string to dialog text  }
      with form_find do
      begin
        ReplaceText := main_replace_text;
      end;
    end;

    SearchWholeWords := main_search_whole_words;
    { show dialog }
    if ShowModal = mrOK then
    begin
      { copy dialog strings to global }
      main_search_backwards := SearchBackwards;
      main_search_case_sensitive := SearchCaseSensitive;
      main_search_from_cursor := SearchFromCursor;
      main_search_selected_only := SearchInSelectionOnly;
      main_search_whole_words := SearchWholeWords;
      main_search_text := SearchText;

      if replace_mode then
      begin
        with form_find  do
        begin
          main_replace_text := ReplaceText;
        end;
      end;

      { search from where they wanted to }
      fSearchFromCaret := main_search_from_cursor;
      if main_search_text <> '' then
      begin
        { start the search }
        DoSearchReplaceText(replace_mode, main_search_backwards);
        { next search from cursor }
        fSearchFromCaret := TRUE;
      end;
    end;
  end;
end;

{ continue with search }
procedure Tform_main.DoSearchReplaceText(AReplace: boolean; ABackwards: boolean);
var
  Options: TSynSearchOptions;
begin
  if ( editor_list.CurrentActive <> -1 ) then
  begin
    if AReplace then
      Options := [ssoPrompt, ssoReplace, ssoReplaceAll]
    else
      Options := [];
    { setup the set }
    if ABackwards then
      Include(Options, ssoBackwards);
    if main_search_case_sensitive then
      Include(Options, ssoMatchCase);
    if not fSearchFromCaret then
      Include(Options, ssoEntireScope);
    if main_search_selected_only then
      Include(Options, ssoSelectedOnly);
    if main_search_whole_words then
      Include(Options, ssoWholeWord);

    with editor_list[editor_list.CurrentActive]do
    begin
      { do the search }
      if editor.SearchReplace(main_search_text, main_replace_text, Options) = 0 then
      begin
        MessageBeep(MB_ICONASTERISK);
        if ssoBackwards in Options then
          editor.BlockEnd := editor.BlockBegin
        else
          editor.BlockBegin := editor.BlockEnd;
        editor.CaretXY := editor.BlockBegin;
      end;
    end;

    if form_confirm_replace <> nil then
      form_confirm_replace.Free;
  end;
end;

{ replace text event }
procedure Tform_main.SynEditorReplaceText(Sender: TObject;
  const ASearch, AReplace: String; Line, Column: Integer;
  var Action: TSynReplaceAction);
var
  APos: TPoint;
  EditRect: TRect;

begin
  { show the confirmation dialog at a location which will
  still show the text}
  if ASearch = AReplace then
    Action := raSkip
  else
  begin
    APos := Point(Column, Line);
    APos := ( Sender as TSynEdit ).ClientToScreen(( Sender as TSynEdit ).RowColumnToPixels(APos));
    EditRect := ClientRect;
    EditRect.TopLeft := ClientToScreen(EditRect.TopLeft);
    EditRect.BottomRight := ClientToScreen(EditRect.BottomRight);

    if form_confirm_replace = nil then
      form_confirm_replace := Tform_confirm_replace.Create(Self);

    form_confirm_replace.PrepareShow(EditRect, APos.X, APos.Y,
    APos.Y + ( Sender as TSynEdit ).LineHeight, ASearch);

    case form_confirm_replace.ShowModal of
      mrYes: Action := raReplace;
      mrYesToAll: Action := raReplaceAll;
      mrNo: Action := raSkip;
      else Action := raCancel;
    end;

  end;
end;



procedure Tform_main.action_findExecute(Sender: TObject);
begin
  { show find form with just search options }
  with editor_list do
    if ( CurrentActive <> -1 ) then
      ShowFindForm( editor_list [ CurrentActive ].editor, false, false );
end;

procedure Tform_main.action_search_againExecute(Sender: TObject);
begin
    { execute the search function }
    DoSearchReplaceText(FALSE, FALSE);
end;

procedure Tform_main.action_search_againUpdate(Sender: TObject);
begin
  { allow search again if there is a active search }
  action_search_again.enabled := main_search_text <> '';
end;

procedure Tform_main.action_findUpdate(Sender: TObject);
begin
  { editor active ? }
  action_find.enabled := editor_list.CurrentActive <> -1;
end;

procedure Tform_main.action_replaceExecute(Sender: TObject);
begin
  { open find form for text replace }
  with editor_list do
    if ( CurrentActive <> -1 ) then
      ShowFindForm( editor_list [ CurrentActive ].editor, true, false );
end;

procedure Tform_main.action_quick_findExecute(Sender: TObject);
begin
  if ( combobox_quick_find.text <> '' ) then
  begin
    combobox_quick_find.Save;
    
    { default quick find globals }
    main_search_backwards := False;
    main_search_case_sensitive := False;
    main_search_from_cursor := False;
    main_search_selected_only := False;
    main_search_whole_words := False;
    main_search_text := combobox_quick_find.text;

    { search from document start }
    fSearchFromCaret := main_search_from_cursor;
    DoSearchReplaceText(false, main_search_backwards);
    { next search search from cursor }
    fSearchFromCaret := TRUE;
  end;
end;

procedure Tform_main.combobox_quick_findKeyPress(Sender: TObject; var Key: Char);
begin
  if ( key = #13 ) then
  begin
    if ( main_search_text = '' ) then
    begin
      { start quick find }
      if ( action_quick_find.enabled ) then
        action_quick_find.execute
      else if ( action_quick_find_in_files.enabled ) then
        action_quick_find_in_files.execute
    end
    else
    begin
      { search again }
      action_search_again.execute;
    end;

    key := #0;
  end;
end;

procedure Tform_main.action_quick_findUpdate(Sender: TObject);
begin
  { allow quick find if there is text in combo box and an active editor}
  action_quick_find.enabled := ( combobox_quick_find.text <> '' ) and ( editor_list.CurrentActive <> -1 );
end;

procedure Tform_main.action_quick_find_in_filesUpdate(Sender: TObject);
begin
    { allow quick find in files if there is text in combo box }
    action_quick_find_in_files.enabled := ( combobox_quick_find.text <> '' ) and ( project_list.count > 0 );
end;

procedure Tform_main.action_replaceUpdate(Sender: TObject);
begin
  { editor active ? }
  action_replace.enabled := editor_list.CurrentActive <> -1;
end;

procedure Tform_main.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CanClose := CloseProject ;
end;

procedure Tform_main.action_toggle_breakpointExecute(Sender: TObject);
begin
  with editor_list do
  begin
    { any editor active ? }
    if ( CurrentActive <> -1 ) then
    begin
      { toggle the breakpoint on the current cursor line }
      debugger_list.ToggleBreakPoint( editors[CurrentActive].filename, editors[CurrentActive].editor.CaretY );
    end;
  end;
end;

procedure Tform_main.action_find_in_filesExecute(Sender: TObject);
begin
  with form_find do
  begin
    { assign search options }
    SearchCaseSensitive := main_search_case_sensitive;
    SearchWholeWords := main_search_whole_words;
    SearchText := main_search_text;

    InFiles := True;
    Replace := False;

    { show dialog }
    if ShowModal = mrOK then
    begin
      FindInFiles ( SearchCaseSensitive, SearchWholeWords, SearchText );
    end;
  end;
end;

{ find specified search text in project files }
procedure Tform_main.FindInFiles ( SearchCaseSensitive, SearchWholeWords : boolean; SearchText : string);
var
  TempStringList : TStringList;
  i              : integer;
  lineCount      : integer;
  MySearch       : TSynEditSearch;
begin
  { create search object }
  MySearch:=TSynEditSearch.Create;
  { create stringlist for file }
  TempStringList:=TStringList.Create;

  try
    { setup search parameters }
    MySearch.Sensitive:=SearchCaseSensitive;
    MySearch.Whole:=SearchWholeWords;
    MySearch.Pattern:=SearchText;

    statusbar_main.SimpleText := '';

    form_messages.eltree_messages.items.Clear;
    form_messages.eltree_messages.items.BeginUpdate;
    for i:=0 to project_list.Count-1 do
    begin
        statusbar_main.SimpleText := 'Searching '+project_list.files[i].filename;
        Application.ProcessMessages;

        { clear stringlist }
        TempStringList.Clear;
        { does file exists ? }
        if ( project_list.GetContents(i, TempStringList ) ) then
        begin
            { search though every line }
            for linecount:=0 to TempStringList.Count-1 do
            begin
                { search this line for match }
                if MySearch.FindAll(TempStringList[linecount])>0 then
                begin
                    { remove tabs }
                    TempStringList[linecount]:=StringReplace(TempStringList[linecount], #9, ' ', [rfReplaceAll, rfIgnoreCase]);
                    { add to messages }
                    AddMessage(project_list.files[i].relativefilename+' ('+IntToStr(linecount+1)+'): '+TempStringList[linecount]);
                end;
            end;
        end
    end;
  finally
    { completed add }
    form_messages.eltree_messages.items.EndUpdate;

    { set to end }
    if ( form_messages.eltree_messages.items.Count > 0 ) then
      form_messages.eltree_messages.TopItem := form_messages.eltree_messages.items[form_messages.eltree_messages.items.Count-1];

    TempStringList.Free;
    MySearch.Free;

    statusbar_main.SimpleText := 'Search Complete';
  end;
end;

procedure Tform_main.eltree_messagesDblClick(Sender: TObject);
var
  in_string : string;
  line_number : string;
  line_real_number : integer;
  editor_index : integer;
  file_string : string;
  project_index : integer;

begin
  if ( (Sender As TElTree).selected = nil ) then
    exit;

  { get the path and line number }
  in_string := (Sender As TElTree).selected.text;
  line_number := PacketParamStr(')', 0, PacketParamStr('(', 1, in_string));
  file_string := Trim(PacketParamStr('(', 0, in_string));

  { any line number ? }
  if ( line_number <> '' ) then
  begin
    { see if its a number }
    try
      line_real_number := StrToInt(line_number)
    except
      exit;
    end;

    project_index := project_list.HasRelativeFilename(file_string);

    if ( project_index <> -1 ) then
    begin
      { open the file }
      editor_index := project_list.OpenFileByIndex( project_index );

      { goto line if open was ok }
      if ( editor_index <> -1 ) then
      begin
        editor_list[editor_index].FindGotoLine( line_real_number );
      end;
    end;
  end;
end;

procedure Tform_main.action_quick_find_in_filesExecute(Sender: TObject);
begin
  if ( combobox_quick_find.text <> '' ) then
  begin
    combobox_quick_find.Save;
    FindInFiles ( False, False, combobox_quick_find.text );
  end;
end;

procedure Tform_main.eltree_project_filesCompareItems(Sender: TObject;
  Item1, Item2: TElTreeItem; var res: Integer);
begin
  with form_project_files.eltree_project_files do
  begin
    if ( SortSection = -1 ) or ( SortSection = 0 ) then
      res := AnsiCompareText(lowercase(item1.text), lowercase(item2.text))
    else
      res := AnsiCompareText(lowercase(item1.Columntext.text)+lowercase(item1.text), lowercase(item2.Columntext.text)+lowercase(item2.text))
  end;
end;

procedure Tform_main.action_find_in_filesUpdate(Sender: TObject);
begin
    { allow quick find in files if there is text in combo box }
    action_find_in_files.enabled := ( project_list.count > 0 );
end;

{ called when a breakpoint is set on any editor }
procedure Tform_main.SetBreakPoint( Sender : TObject; inFilename : string; line_number : integer; breakpoint_status : boolean );
var
  send_condition : string;

begin
  { convert actual file name to unix relative }
  inFilename := ExtractUnixRelativePath(project_list.BasePath, inFilename);

  if ( breakpoint_status ) and ( TDebuggerObject(Sender).Enabled ) then
  begin
    with TDebuggerObject(Sender) do
    begin
      if ( Condition = '' ) then
        send_condition := '1' { convert '' to true }
      else
        send_condition := condition;

      { send the packet to the debugger }
      SendPacket(Format('BRKSET %s %d 0 %d %s',[inFilename, line_number, PassCount, send_condition]));
    end;
  end
  else
  begin
    { send the packet to the debugger }
    SendPacket(Format('BRKCLR %s %d',[inFilename, line_number]));
  end
end;

procedure Tform_main.action_add_watchUpdate(Sender: TObject);
begin
  action_add_watch.enabled := ( form_watches.text_watch.text <> '' ) and ( server_debugging ) and ( debugging_step );
end;

procedure Tform_main.action_pauseExecute(Sender: TObject);
begin
  SendPacket('STEPIN');
end;

{ retrieve all the watches }
procedure Tform_main.GetWatches;
var
  i : integer;
begin
  form_watches.eltree_watches.items.BeginUpdate;
  { endupdate after timeout }
  timer_end_watches_update.enabled := True;

  { loop through every watch }
  for i:=0 to watch_list.Count-1 do
  begin
    { send get watch to debugger }
    with watch_list.watches[i] do
    begin
      if ( Parent = nil ) then
        SendPacket(Format('EVAL %d 0 %s', [ID, FullVariable]));
    end;
  end;

  for i:=0 to watch_list.Count-1 do
  begin
    with watch_list.watches[i] do
    begin
      if ( ELTreeItem.Expanded ) then
      begin
        SendPacket(Format('OBJTAGLIST %d 0 %s',[ID,FullVariable]));
      end;
    end;
  end;

  { used as a trigger to update watch list }
  SendPacket('EVAL -1 0 %null');
end;

procedure Tform_main.OnActiveChange ( editor_index :  integer );
var
   filename : string;
   non_unix_filename : string;
   project_index : integer;
begin
  update_current_functions;

  if ( server_debugging ) and ( editor_index <> -1 ) then
  begin
    { convert actual file name to unix relative }
    filename := ExtractUnixRelativePath(project_list.BasePath, editor_list.editors[editor_index].filename);
    non_unix_filename := ExtractRelativePath(project_list.BasePath, editor_list.editors[editor_index].filename);

    { get breakpoints }
    if ( debug_file_list.indexof(non_unix_filename) <> -1 ) then
    begin
      project_index := project_list.HasRelativeFilename (  non_unix_filename );
      if ( project_index <> -1 ) and ( not project_list[project_index].BreakpointsGot )then
      begin
        SendPacket(Format('BREAKLIST %s',[filename]));
      end;
    end;
  end;
end;

procedure Tform_main.action_stopExecute(Sender: TObject);
begin
  clientsocket_debug.close;
  { reset stepping cursor }
  debugger_list.SteppingAtLine := -1 ;
  debugger_list.SteppingAtFile := '';
  debugger_list.Enabled := False;
end;

procedure Tform_main.action_stopUpdate(Sender: TObject);
begin
  action_stop.enabled := server_debugging;
end;

procedure Tform_main.action_add_watchExecute(Sender: TObject);
var
  watch_index : integer;
begin
  { add the watch }
  watch_index := watch_list.AddWatch ( nil, form_watches.text_watch.text, '' );
  { clear edit }
  form_watches.text_watch.text := '';
  { added ok ? }
  if ( watch_index <> -1 ) then
  begin
    { send get watch to debugger }
    with watch_list.watches[watch_index] do
      SendPacket(Format('EVAL %d 0 %s', [ID, FullVariable]));
  end;
end;

procedure Tform_main.action_add_file_to_projectUpdate(Sender: TObject);
begin
  action_add_file_to_project.enabled := project_list.ProjectName <> '';
end;

procedure Tform_main.action_remove_file_from_projectUpdate(
  Sender: TObject);
begin
  action_remove_file_from_project.enabled :=
  ( project_list.ProjectName <> '') and ( form_project_files.eltree_project_files.selectedcount > 0);
end;

procedure Tform_main.action_project_optionsUpdate(Sender: TObject);
begin
  action_project_options.enabled := project_list.ProjectName <> '';
end;

procedure Tform_main.action_project_optionsExecute(Sender: TObject);
var
  form_new_project : Tform_new_project;
begin
  form_new_project := Tform_new_project.Create(Self);

  try
    { show the new project form, but with new project options }
    form_new_project.NewProject := False;
    { fill in the edit boxes }
    form_new_project.edit_project_name.text := project_list.ProjectName;
    form_new_project.edit_project_directory.text := project_list.BasePath;

    if ( form_new_project.ShowModal = mrOk ) then
    begin
      { change the project propertys }
      project_list.ProjectName := form_new_project.edit_project_name.text;
      project_list.BasePath := IncludeTrailingBackslash(form_new_project.edit_project_directory.text);
    end;
  finally
    form_new_project.Free;
  end;
end;

procedure Tform_main.action_exitExecute(Sender: TObject);
begin
  Close;
end;

{ trigged when editor saves file }
procedure Tform_main.OnFileSave ( Sender : TObject; filename : string );
var
   project_index : integer;
begin
  project_index := project_list.HaveFile ( filename );

  if ( project_index <> -1 ) then
  begin
    { check for new functions }
    function_list.DeleteFilesFunctionsByIndex( project_index );
    function_list.ScanByIndex( project_index );
  end;

  function_list.DoSort;

  update_current_functions;
end;

{ trigged when file is removed from project }
procedure Tform_main.OnFileRemove ( Sender : TObject; index : integer; filename : string );
begin
  { check for new functions }
  function_list.DeleteFilesFunctionsByIndex( index );
  function_list.DoSort;

  update_current_functions;
end;

procedure Tform_main.action_remove_watchExecute(Sender: TObject);
begin
  watch_list.RemoveSelected;
end;

procedure Tform_main.action_remove_watchUpdate(Sender: TObject);
begin
  action_remove_watch.enabled := form_watches.eltree_watches.SelectedCount > 0;
end;

procedure Tform_main.text_watchKeyPress(Sender: TObject; var Key: Char);
begin
  if ( key = #13 ) then
    if ( action_add_watch.enabled ) then
      action_add_watch.execute;
end;

function Tform_main.GetVariableAt( editor : TSynEdit; X, Y : integer ) : string;
var
  cursor_line  : string;
  i            : integer;
  start_pos    : integer;
begin
  with editor do
  begin
    cursor_line := Lines[Y-1];

    i := X;

    Result := '';

    { track back until hit an invalid char}
    if ( i > 1 ) then
    begin
      while ( i > 1 ) and ( i < Length(cursor_line) ) do
      begin
        case cursor_line[i-1] of
          ',',
          '.',
          '[',
          ']',
          '(',
          ')',
          ' ',
          '!',
          '='
          : break;
        else
          dec ( i );
        end;
      end;
    end;

    start_pos := i;

    { track forward until hit an invalid char}
    while ( i < Length(cursor_line) ) do
    begin
      case cursor_line[i] of
        ',',
        '.',
        '[',
        ']',
        '(',
        ')',
        ' ',
        '!',
        '='
        : break;

        '$',
        '%' : if ( i <> start_pos ) then break;
      end;

      { add valid char }
      Result := Result + cursor_line[i];
      inc ( i );
    end;
  end;
end;

procedure Tform_main.action_add_watch_at_cursorExecute(Sender: TObject);
begin
  if ( editor_list.CurrentActive <> -1 ) and ( action_add_watch_at_cursor.enabled ) then
  begin
    { have we any text selected ? }
    if editor_list[editor_list.CurrentActive].editor.SelText <> '' then
    begin
      form_watches.text_watch.text := editor_list[editor_list.CurrentActive].editor.SelText;
    end
    else
    begin
      { try and work out variable at cursor }
      with editor_list[editor_list.CurrentActive].editor do
        form_watches.text_watch.text := GetVariableAt( editor_list[editor_list.CurrentActive].editor, CaretX, CaretY );
    end;

    { have we got anything? }
    if ( form_watches.text_watch.text <> '' ) then
      action_add_watch.execute;
  end;
end;

procedure Tform_main.action_add_watch_at_cursorUpdate(Sender: TObject);
begin
  action_add_watch_at_cursor.enabled := ( server_debugging ) and ( debugging_step );
end;

procedure Tform_main.eltree_watchesKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if ( Key = VK_DELETE ) then
  begin
    { if delete key is pressed delete selected watches }
    watch_list.RemoveSelected;
  end;
end;

procedure Tform_main.action_go_to_line_numberExecute(Sender: TObject);
begin
  if ( editor_list.CurrentActive <> -1 ) then
  begin
    { ask user for line number value }
    if ( form_goto_line.ShowModal = mrOk ) then
    begin
      { goto line without highlighting }
      with editor_list[editor_list.CurrentActive] do
      begin
        editor_list[editor_list.CurrentActive].GotoLine(form_goto_line.LineNumber);
      end;
    end;
  end;
end;

procedure Tform_main.action_go_to_line_numberUpdate(Sender: TObject);
begin
  action_go_to_line_number.enabled := editor_list.CurrentActive <> -1;
end;

procedure Tform_main.listview_functionsData(Sender: TObject;
  Item: TListItem);
begin
  Item.Caption := function_list[Item.Index].FunctionName;
  Item.SubItems.Add( function_list[Item.Index].FunctionClassName );
end;

procedure Tform_main.listview_functionsDblClick(Sender: TObject);
var
  editor_index : integer;
begin
  if ( form_functions.listview_functions.selected = nil ) then
    exit;

  { open file in which function is in }
  editor_index := project_list.OpenRelativeFilename(function_list[form_functions.listview_functions.selected.index].filename);

  { open ok ? }
  if ( editor_index <> -1 ) then
  begin
    { no go to function line }
    editor_list[editor_index].FindGotoLine(function_list[form_functions.listview_functions.selected.index].LineNumber);
  end;
end;

procedure Tform_main.listview_functionsColumnClick(Sender: TObject;
  Column: TListColumn);
begin
  case Column.Index of
    0 : function_list.CurrentSort := csFunction;
    1 : function_list.CurrentSort := csClass;
  end;

  function_list.DoSort;

  ( Sender as TListView).Invalidate;
end;

procedure Tform_main.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  { save any layout changes }
  SaveToRegistry;

  { free the watch list }
  watch_list.Free;
  { free the file list }
  debug_file_list.Free;
  { tell the current function list just to remove the pointers from the list }
  current_function_list.RemoveAllItems;
  { destroy temporary function list }
  current_function_list.Free;
  { destroy the function list }
  function_list.Free;
  { destroy the project list }
  project_list.Free;
  { destroy the editor list }
  editor_list.Free;
  { destroy the debugger }
  debugger_list.free;
  { free the group list }
  group_list.Free;

  { free the docked forms }
  form_watches.Close;
  form_messages.Close;
  form_breakpoints.Close;
  form_callstack.Close;
  form_console.Close;
  form_project_files.Close;
end;

procedure Tform_main.findfile_add_project_filesFound(Sender: TObject; Folder: String;
  var FileInfo: TSearchRec);
begin
  { found match - add to project }
  project_list.AddFile(IncludeTrailingBackslash(Folder) + FileInfo.Name);

  if ( (FileInfo.Attr and faReadOnly) = faReadOnly ) then
  begin
    inc ( read_only_files );
  end;
end;

procedure Tform_main.findfile_add_project_filesComplete(Sender: TObject);
var
  i : integer;
  Attrs : integer;
begin
  { completed find in files so show the files }
  form_project_files.eltree_project_files.items.EndUpdate;

  statusbar_main.panels[3].Text := 'Complete.';

  if ( read_only_files > 0 ) then
  begin
    if ( MessageDlg(Format('%d file(s) have their read only attribute set, Do you want '+#13+
    'Tribal IDE to make these files writeable?',[read_only_files]), mtConfirmation, [mbYes, mbNo], 0) = mrYes ) then
    begin
      for i := 0 to project_list.Count-1 do
      begin
        { get current attributes }
        Attrs := FileGetAttr(project_list[i].Filename);
        { clear read only flag }
        Attrs := Attrs and not ( faReadOnly );
        { set the new attribute }
        FileSetAttr(project_list[i].Filename, Attrs);
      end;
    end;
  end;

  { scan new file editions }
  function_list.ScanFileAges( True );
end;

function Tform_main.CloseProject : boolean;
var
  project_save : WORD;
begin
  { any project defined }
  if ( project_list.ProjectName <> '' ) then
  begin
    { ask question only if not auto save, or not saved before }
    if ( not auto_save_project ) or ( project_list.ProjectFilename = '' ) then
    begin
      { ask question }
      project_save := MessageDlg('Save changes to project file?',
      mtConfirmation, [mbYes, mbNo, mbCancel], 0)
    end
    else
    begin
      { assume yes }
      project_save := mrYes;
    end;

    { try and save the file }
    if ( project_save = mrYes ) then
    begin
      { try and save project file - have we a filename ?}
      if ( project_list.ProjectFilename <> '' ) then
      begin
          { yes we have so save both project and function list }
          project_list.SaveToFile( project_list.ProjectFilename );
          function_list.SaveToFile( project_list.BasePath, ChangeFileExt( project_list.ProjectFilename, '.tsb'));
      end
      else
      begin
        { no filename definded ask for name }
        action_save_project_as.Execute;
        { file been saved ? }
        Result := project_list.ProjectFileName <> '';
        { exit if not }
        if ( not Result ) then
          exit;
      end;
    end
    else
    { cancel close ? }
    if ( project_save = mrCancel ) then
    begin
      { ack abort abort! }
      Result := False;
      exit;
    end;
  end;

  { close editor files }
  if ( editor_list.Count > 0 ) then
    while ( editor_list.Count > 0 ) and ( editor_list.Close ( 0 ) ) do;

  { have we closed them all ? }
  if ( editor_list.Count = 0 ) then
  begin
    { remove files from project}
    project_list.Clear;
    project_list.PopulateTreeView;

    { check if we saved project }
    Result := True;
  end
  else
  begin
    { still some open }
    Result := False;
  end;
end;

procedure Tform_main.CompileChangedFiles;
var
  i : integer;
  current_dso_fileage : integer;
  to_compile : integer;
begin
  doing_compile := True;
  current_file_compiling := '';
  form_messages.eltree_messages.items.Clear;
  form_console.eltree_console.items.Clear;

  to_compile := 0;

  for i:=0 to project_list.Count-1 do
  begin
    current_dso_fileage := 0;

    { dont compile files in vl2 files }
    if ( Assigned(project_list[i].InZip) ) then
      continue;

    { dont compile actual vl2 file }
    if ( lowercase(ExtractFileExt( project_list[i].filename )) = '.vl2' ) then
      continue;

    { .dso file there? }
    if ( FileExists( project_list[i].Filename +'.dso' ) ) then
      current_dso_fileage := FileAge( project_list[i].Filename +'.dso' );

    if (( project_list[i].FileAge <> project_list[i].FileAgeAtCompile ) or
       ( current_dso_fileage <>  project_list[i].DSOFileAge ) ) and
       ( current_dso_fileage <> 0 ) then
    begin
      { clear flag }
      project_list[i].JustCompiled := True;
      { get breakpoints }
      project_list[i].BreakPointsGot := False;
      { Send T2 compile command }
      SendCommand(Format('compile("%s");',[ExtractUnixRelativePath(project_list.BasePath, project_list[i].Filename)]));

      inc ( to_compile );
    end;
  end;

  if ( to_compile > 0 ) then
    SendCommand(Format('echo("%s");',[MSG_COMPILATION_COMPLETE]))
  else
  begin
    doing_compile := false;
    MessageDlg('No files that need compiling',mtInformation, [mbOk], 0);
  end;
end;

procedure Tform_main.ExecCompiledFiles;
var
  i : integer;
  filename : string;
  editor_index : integer;
begin
  not_compiled := 0;
  been_compiled := 0;
  { go through project and see if any of the
  files have not changed or are not there }
  for i:=0 to project_list.Count-1 do
  begin
    { this one we just sent compile command ? }
    if ( project_list[i].JustCompiled ) then
    begin
      { is there a compiled file ? }
      if ( FileExists(project_list[i].Filename +'.dso') ) then
      begin
        { .dso file not changed }
        if ( project_list[i].DSOFileAge = FileAge( project_list[i].Filename +'.dso' ) ) then
        begin
          { clear flag }
          project_list[i].JustCompiled := False;
          { =( not compiled }
          AddMessage(Format('%s: Compilation Failed',[project_list[i].RelativeFileName]));

          inc(not_compiled);
        end
        else
          inc ( been_compiled );
      end
      else
      begin
        { clear flag }
        project_list[i].JustCompiled := False;

        { =( its not there }
        AddMessage(Format('%s: Compilation Failed',[project_list[i].RelativeFileName]));

        inc(not_compiled);
      end;
    end
  end;

  { now exec the successful ones }
  for i:=0 to project_list.Count-1 do
  begin
    if ( project_list[i].JustCompiled ) and
       ( FileExists(project_list[i].Filename +'.dso') ) then
    begin
      { clear compiled flag }
      project_list[i].JustCompiled := False;
      { project list has been modified }
      project_list.Modified := True;

      { change compiled date and dso file date }
      project_list[i].DSOFileAge := FileAge( project_list[i].Filename +'.dso' );
      project_list[i].FileAgeAtCompile := project_list[i].FileAge;

      { get unix style filename }
      filename := ExtractUnixRelativePath(project_list.BasePath, project_list[i].Filename);

      editor_index:=editor_list.isOpen ( project_list[i].filename );

      { clear current breakpoints }
      if ( editor_index <> -1 ) then
        debugger_list.ResendBreakPoints ( editor_list[editor_index].filename, true );

      { tell T2 to exec script }
      SendCommand(Format('exec("%s");',[filename]));

      if ( editor_index <> -1 ) then
        SendPacket(Format('BREAKLIST %s',[filename]));

    end;
  end;


  { compilation complete }
  SendCommand(Format('echo("%s");',[MSG_EXEC_COMPLETE]));
end;

procedure Tform_main.action_compile_and_execExecute(Sender: TObject);
begin
  { check we have saved }
  if ( editor_list.anyModified ) then
  begin
    case MessageDlg('Save changes to current files?', mtConfirmation,
         [mbYes, mbNo, mbCancel], 0)  of
      { ---------------}
      mrYes :
      begin
        { save all files open in editor }
        action_save_all.execute;

        { we have some still modified files }
        if ( editor_list.anyModified ) then
          exit;
      end;
      { ---------------}
      mrCancel :
      begin
        exit;
      end;

      { mrNo we just carry on and compile regardless }
    end;
  end;


  { go ahead and compile }
  CompileChangedFiles;
end;

procedure Tform_main.ApplicationActivate(Sender: TObject);
begin
  { remove T2's mouse bounds limiting }
  ClipCursor( nil );
end;

procedure Tform_main.action_compile_and_execUpdate(Sender: TObject);
begin
  action_compile_and_exec.enabled := (server_debugging) and ( project_list.count > 0);
end;


procedure Tform_main.action_toggle_breakpointUpdate(Sender: TObject);
begin
  action_toggle_breakpoint.enabled:= ( server_debugging ) and
                         ( editor_list.CurrentActive <> -1 );
end;

procedure Tform_main.findfile_add_project_filesNewFolder(Sender: TObject;
  Folder: String; var IgnoreFolder: Boolean);
begin
  statusbar_main.panels[3].Text := 'Searching... '+Folder;
end;

procedure Tform_main.mrufilelist_mainMRUItemClick(Sender: TObject;
  AFilename: String);
begin
  { is it a project ? }
  if ( ExtractFileExt(AFileName) = '.tsw' ) then
    OpenProject( AFileName)
  else
    editor_list.OpenFile(AFileName,False);
end;

procedure Tform_main.RegisterFileType( cMyExt, cMyFileType, cMyDescription : string );
var
  Reg: TRegistry;
begin
  Reg := TRegistry.Create;
  try
    { Set the root key to HKEY_CLASSES_ROOT }
    Reg.RootKey := HKEY_CLASSES_ROOT;

    Reg.OpenKey(cMyFileType + '\Shell\Open\Command', False);
    if ( Reg.ReadString('') = '"' + Application.ExeName + '" "%1"' ) then
    begin
      Reg.CloseKey;
      exit;
    end;
    Reg.CloseKey;

    { Now open the key, with the possibility to create
     the key if it doesn't exist. }
    Reg.OpenKey(cMyExt, True);
    { Write my file type to it.
     This adds HKEY_CLASSES_ROOT\.abc\(Default) = 'Project1.FileType' }
    Reg.WriteString('', cMyFileType);
    Reg.CloseKey;
    { Now create an association for that file type }
    Reg.OpenKey(cMyFileType, True);
    { This adds HKEY_CLASSES_ROOT\Project1.FileType\(Default)
       = 'Project1 File'
     This is what you see in the file type description for
     the a file's properties. }
    Reg.WriteString('', cMyDescription);
    Reg.CloseKey;
    { Now write the default icon for my file type
     This adds HKEY_CLASSES_ROOT\Project1.FileType\DefaultIcon
      \(Default) = 'Application Dir\Project1.exe,0' }
    Reg.OpenKey(cMyFileType + '\DefaultIcon', True);
    Reg.WriteString('', Application.ExeName + ',0');
    Reg.CloseKey;
    { Now write the open action in explorer }
    Reg.OpenKey(cMyFileType + '\Shell\Open', True);
    Reg.WriteString('', '&Open');
    Reg.CloseKey;
    { Write what application to open it with
     This adds HKEY_CLASSES_ROOT\Project1.FileType\Shell\Open\Command
      (Default) = '"Application Dir\Project1.exe" "%1"'
     Your application must scan the command line parameters
     to see what file was passed to it. }
    Reg.OpenKey(cMyFileType + '\Shell\Open\Command', True);
    Reg.WriteString('', '"' + Application.ExeName + '" "%1"');
    Reg.CloseKey;
    { Finally, we want the Windows Explorer to realize we added
     our file type by using the SHChangeNotify API. }
    SHChangeNotify(SHCNE_ASSOCCHANGED, SHCNF_IDLIST, nil, nil);
  finally
    Reg.Free;

    SetForegroundWindow(PAppCommsData^.HandleData);
  end;
end;




procedure Tform_main.FormShow(Sender: TObject);
begin
  { command line check }
  if ParamCount > 0 then
  begin
    if FileExists(ParamStr(1)) then
    begin
      if ( ExtractFileExt(ParamStr(1)) = '.tsw' ) then
        OpenProject( ParamStr(1) )
      else
        editor_list.OpenFile(ParamStr(1),False);
    end;
  end;

  { register the .tsw file type }
  RegisterFileType('.tsw','tribalIDE.FileType','Tribal IDE Project File');

  if ( not associate_asked ) then
  begin
    associate_asked := True;

    if MessageDlg('Associate .cs and .gui files to Tribal IDE?',
      mtConfirmation, [mbYes, mbNo], 0) = mrYes then
      do_associate := true;

    SaveToRegistry;
  end;


  if ( do_associate ) then
  begin
    RegisterFileType('.cs','tribesScript.FileType','Tribes Script File');
    RegisterFileType('.gui','tribesGui.FileType','Tribes Gui File');
  end;
  
  TBXSetTheme( main_uistyle );

  { show them all }
  form_messages.Show;
  form_watches.Show;
  form_breakpoints.Show;
  form_callstack.Show;
  form_console.Show;
  form_project_files.Show;
  form_functions.Show;
  form_current_file_functions.Show;

  Application.OnActivate := ApplicationActivate;
end;

procedure Tform_main.WMCopyData(Var msg: TWMCopyData);
Var
  filename : string;
Begin
  { convert to pascal strings }
  filename := StrPas(msg.CopyDataStruct^.lpData);

  { open file }
  if ( FileExists(filename) ) then
  begin
      { project file ? }
      if ( ExtractFileExt(filename) = '.tsw' ) then
        OpenProject( filename )
      else
      { normal file ? }
        editor_list.OpenFile(FileName,False);
  end;
end;


procedure Tform_main.action_printExecute(Sender: TObject);
var
  AFont: TFont;
begin
  if ( editor_list.CurrentActive = -1 ) then
    exit;


  AFont := TFont.Create;
  with SynEditPrint_main.Header do
  begin
      {First line, default font, left aligned}
    Add('Project : '+project_list.ProjectName, nil, taLeftJustify, 1);
      {First line, default font, right aligned}
    Add('Page: $PAGENUM$ of $PAGECOUNT$', nil, taRightJustify, 1);
      {Second line, default font, left aligned}
    Add('$TITLE$', nil, taLeftJustify, 2);
    AFont.Assign(DefaultFont);
    AFont.Size := 6;
      {Second line, small font, right aligned - note that lines can have different fonts}
    Add('Print Date: $DATE$. Time: $TIME$', AFont, taRightJustify, 2);
  end;

  with SynEditPrint_main.Footer do
  begin
    AFont.Assign(DefaultFont);
    Add('$PAGENUM$/$PAGECOUNT$', nil, taRightJustify, 1);
  end;
  AFont.Free;

  if PrintDialog.Execute then
  begin
    SynEditPrint_main.SynEdit := editor_list[editor_list.CurrentActive].editor;

    with SynEditPrint_main do
    begin
      LineNumbers := print_line_numbers;
      Highlight := print_highlight;
      Colors := print_colors;
      Font.Name := printer_font;
      Font.Size := printer_font_size;
    end;


    SynEditPrint_main.Title := ExtractRelativePath(project_list.BasePath, editor_list[editor_list.CurrentActive].FileName);
    SynEditPrint_main.Print;
  end;

end;

procedure Tform_main.action_printUpdate(Sender: TObject);
begin
  action_print.enabled := editor_list.CurrentActive <> -1;
end;


procedure Tform_main.EditorMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
var
  CursorLocation : TPoint;
  CaretLocation : TPoint;
  Token: string;
  Attri: TSynHighlighterAttributes;
begin
  if ( not debugging_step ) then
  begin
    exit;
  end;
  
  CursorLocation.X := X;
  CursorLocation.Y := Y;
  CaretLocation := (Sender as TSynEdit).PixelsToRowColumn( CursorLocation );

  if not (Sender as TSynEdit).GetHighlighterAttriAtRowCol(CaretLocation, Token, Attri) then
    Attri := (Sender as TSynEdit).Highlighter.WhitespaceAttribute;

  if Assigned(Attri) then
  begin
    if ( Attri.Name = 'Global Variable' ) or
       ( Attri.Name = 'Local Variable' ) then
    begin
      token := Trim(token);

      if ( token <> '' ) and ( token  <> last_variable ) then
      begin
        last_variable := token ;
        SendPacket(Format('EVAL -1 0 %s', [token]));
      end;
    end;
  end;
end;

procedure Tform_main.eltree_watchesDblClick(Sender: TObject);
var
  watch_index : integer;
  i : integer;
begin
  { single watch selected ? }
  if ( (Sender As TElTree).selected = nil ) and
     ( (Sender As TElTree).SelectedCount <> 1 ) then
    exit;

  { find the watch item that is linked to this }
  watch_index := watch_list.FindWatchViaTree((Sender As TElTree).selected);
  { found one ? }
  if ( watch_index <> -1 ) then
  begin
    { set the values to the form }
    form_watch_value.Watch := watch_list[watch_index].FullVariable;
    form_watch_value.WatchValue := watch_list[watch_index].Value;

    { show the form }
    if ( form_watch_value.ShowModal = mrOk ) then
    begin
      { send change in value for this index }
      SendPacket(Format('EVAL %d 0 %s=%s',
      [watch_list[watch_index].ID, form_watch_value.Watch,form_watch_value.WatchValue]));

      GetWatches;
    end;
  end;
end;

procedure Tform_main.action_change_valueUpdate(Sender: TObject);
begin
  action_change_value.enabled := ( form_watches.eltree_watches.selected <> nil ) and
     ( form_watches.eltree_watches.SelectedCount = 1 );
end;

procedure Tform_main.action_change_valueExecute(Sender: TObject);
begin
  eltree_watchesDblClick(form_watches.eltree_watches);
end;

procedure Tform_main.eltree_breakpointsDblClick(Sender: TObject);
var
  editor_index : integer;
begin
  { single watch selected ? }
  if ( (Sender As TElTree).selected = nil ) and
     ( (Sender As TElTree).SelectedCount <> 1 ) then
    exit;

  { find the breakpoint item that is linked to this }
  with TDebuggerObject((Sender As TElTree).selected.Data) do
  begin
    { open the file }
    editor_index := project_list.OpenRelativeFilename(Filename);

    { goto line if open was ok }
    if ( editor_index <> -1 ) then
    begin
      editor_list[editor_index].GotoLine( BreakPointLine );
    end;
  end;
end;

procedure Tform_main.action_breakpoints_toggle_statusExecute( Sender: TObject);
begin
  { single watch selected ? }
  if ( form_breakpoints.eltree_breakpoints.selected = nil ) then
    exit;

  { find the breakpoint item that is linked to this }
  with TDebuggerObject(form_breakpoints.eltree_breakpoints.selected.Data) do
  begin
    Enabled := not Enabled;
  end;
end;

procedure Tform_main.action_breakpoints_propertiresExecute(Sender: TObject);
var
  form_breakpoint_properties: Tform_breakpoint_properties;
  editor_index : integer;
begin
  if ( form_breakpoints.eltree_breakpoints.selected = nil ) then
    exit;

  form_breakpoint_properties := Tform_breakpoint_properties.Create ( Self );

  try
    with form_breakpoint_properties, TDebuggerObject(form_breakpoints.eltree_breakpoints.selected.Data) do
    begin
      combobox_filename.text := ExtractRelativePath(BasePath, Filename);
      combobox_line_number.text := IntToStr(BreakPointLine);
      combobox_condition.text := Condition;
      combobox_pass_count.text := IntToStr(PassCount);
      combobox_group.text := Group;
      checkbox_disable_after_hit.checked:=DisableAfterHit;

      if ( ShowModal = mrOk ) then
      begin
        { change to base path }
        ChDir( BasePath );

        { changed file ? }
        if ( lowercase(combobox_filename.text) <> lowercase(ExtractRelativePath(BasePath, Filename)) ) then
        begin
          { create full filename }
          Filename := ExpandFileName( combobox_filename.text );

          { this file currently open ? }
          editor_index := editor_list.isOpen ( Filename );

          { tell this debugging object where it is }
          if ( editor_index <> -1 ) then
            Editor := editor_list[editor_index].editor
          else
            Editor := nil

        end;


        Condition := combobox_condition.text ;
        PassCount := StrToInt( combobox_pass_count.text );
        Group := combobox_group.text ;
        BreakPointLine := StrToInt(combobox_line_number.text);
        DisableAfterHit := checkbox_disable_after_hit.checked;

        Active := True;
      end;
    end;
  finally
    form_breakpoint_properties.Free;
  end;
end;

procedure Tform_main.action_breakpoints_toggle_statusUpdate(
  Sender: TObject);
begin
  action_breakpoints_toggle_status.enabled := form_breakpoints.eltree_breakpoints.selected <> nil;

  if ( form_breakpoints.eltree_breakpoints.selected <> nil ) then
  begin
    with TDebuggerObject(form_breakpoints.eltree_breakpoints.selected.Data) do
      action_breakpoints_toggle_status.checked := Enabled;
  end;
end;

procedure Tform_main.action_breakpoints_deleteUpdate(Sender: TObject);
begin
  action_breakpoints_delete.enabled := form_breakpoints.eltree_breakpoints.selected <> nil;
end;

procedure Tform_main.action_breakpoints_disable_allUpdate(Sender: TObject);
begin
  action_breakpoints_disable_all.enabled := ( debugger_list.Count > 0 ) and
                                            ( form_breakpoints.eltree_breakpoints.selected = nil );
end;

procedure Tform_main.action_breakpoints_propertiresUpdate(Sender: TObject);
begin
  action_breakpoints_propertires.enabled := (form_breakpoints.eltree_breakpoints.selected <> nil);
end;

procedure Tform_main.action_breakpoints_enable_allUpdate(Sender: TObject);
begin
  action_breakpoints_enable_all.enabled := ( debugger_list.Count > 0 ) and
                                           ( form_breakpoints.eltree_breakpoints.selected = nil );
end;

procedure Tform_main.action_breakpoints_delete_allUpdate(Sender: TObject);
begin
  action_breakpoints_delete_all.enabled := ( debugger_list.Count > 0 ) and
                                           ( form_breakpoints.eltree_breakpoints.selected = nil );
end;

procedure Tform_main.action_breakpoints_deleteExecute(Sender: TObject);
var
  debugger_index : integer;
begin
  if ( form_breakpoints.eltree_breakpoints.selected = nil ) then
    exit;

  debugger_index := debugger_list.indexof(form_breakpoints.eltree_breakpoints.selected.Data);

  if ( debugger_index <> -1 ) then
  begin
      debugger_list.Delete( debugger_index );
  end;
end;

procedure Tform_main.action_breakpoints_disable_allExecute(
  Sender: TObject);
var
  i : integer;
begin
  for i := 0 to debugger_list.Count -1 do
  begin
    if ( debugger_list[i].Active ) then
      debugger_list[i].Enabled := False;
  end;
end;

procedure Tform_main.action_breakpoints_enable_allExecute(Sender: TObject);
var
  i : integer;
begin
  for i := 0 to debugger_list.Count -1 do
  begin
    if ( debugger_list[i].Active ) then
        debugger_list[i].Enabled := True;
  end;
end;

procedure Tform_main.action_breakpoints_delete_allExecute(Sender: TObject);
var
  i : integer;
begin
  if MessageDlg('Delete all breakpoints?',
     mtConfirmation, [mbYes, mbNo], 0) = mrYes then
  begin
    for i := 0 to debugger_list.Count -1 do
    begin
      if ( debugger_list[i].Active ) then
          debugger_list[i].Active := False;
    end;
  end;
end;

procedure Tform_main.action_breakpoints_addExecute(Sender: TObject);
var
  form_breakpoint_properties: Tform_breakpoint_properties;
  editor_index : integer;
  breakpoint_index : integer;
begin
  form_breakpoint_properties := Tform_breakpoint_properties.Create ( Self );

  try
    with form_breakpoint_properties do
    begin
      if ( editor_list.CurrentActive <> -1 ) then
      begin
        combobox_line_number.text := IntToStr( editor_list[editor_list.CurrentActive].Editor.CaretY );
        combobox_filename.text := ExtractRelativePath(project_list.BasePath, editor_list[editor_list.CurrentActive].Filename);
      end;

      combobox_condition.text := '';
      combobox_pass_count.text := '0';
      combobox_group.text := '';
      checkbox_disable_after_hit.checked := false;
      
      if ( ShowModal = mrOk ) then
      begin
        { change to base path - expandfilename works off current directory}
        ChDir( project_list.BasePath );

        { get breakpoint }
        breakpoint_index := debugger_list.AddBreakPoint(
                            ExpandFileName( combobox_filename.text ),
                            StrToInt(combobox_line_number.text),
                            combobox_condition.text,
                            StrToInt( combobox_pass_count.text ),
                            combobox_group.text );

        { created ok ? }
        if ( breakpoint_index <> -1 ) then
        begin
          { this file currently open ? }
          editor_index := editor_list.isOpen ( debugger_list[breakpoint_index].Filename );

          { tell this debugging object where it is }
          if ( editor_index <> -1 ) then
            debugger_list[breakpoint_index].Editor := editor_list[editor_index].editor
          else
            debugger_list[breakpoint_index].Editor := nil;

          debugger_list[breakpoint_index].DisableAfterHit := checkbox_disable_after_hit.checked;

          debugger_list[breakpoint_index].Active := True;
        end;

      end;
    end;
  finally
    form_breakpoint_properties.Free;
  end;
end;

procedure Tform_main.action_breakpoints_addUpdate(Sender: TObject);
begin
  action_breakpoints_add.enabled := ( editor_list.CurrentActive <> -1 );
end;

procedure Tform_main.eltree_breakpointsKeyUp(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  if ( Key = VK_DELETE ) then
  begin
    { if delete key is pressed delete selected watches }
    action_breakpoints_delete.execute;
  end;
end;

procedure Tform_main.update_current_functions;
var
  i : integer;
  search_filename : string;
begin
  current_function_list.RemoveAllItems;

  if ( editor_list.CurrentActive = -1 ) then
    exit;

  if ( editor_list[editor_list.CurrentActive].ZipFileName <> '' ) then
    search_filename := editor_list[editor_list.CurrentActive].Filename
  else
    search_filename := ExtractRelativePath(project_list.BasePath, editor_list[editor_list.CurrentActive].Filename);

  for i := 0 to function_list.Count-1 do
  begin
    if ( lowercase(function_list[i].filename) =
         lowercase(search_filename) ) then
    begin
    { add the object }
      current_function_list.Add( function_list[i] );
    end;
  end;

  current_function_list.DoSort;

  form_current_file_functions.listview_current_file_functions.items.Count := current_function_list.Count;
end;


procedure Tform_main.listview_current_file_functionsData(Sender: TObject;
  Item: TListItem);
begin
  if ( Item.Index < current_function_list.Count ) then
  begin
    Item.Caption := current_function_list[Item.Index].FunctionName;
    Item.SubItems.Add( current_function_list[Item.Index].FunctionClassName );
  end
  else
  begin
    Item.Caption := '';
    Item.SubItems.Text := '';
  end;
end;

procedure Tform_main.listview_current_file_functionsDblClick(
  Sender: TObject);
var
  editor_index : integer;
begin
  if ( form_current_file_functions.listview_current_file_functions.selected = nil ) then
    exit;

  { open file in which function is in }
  editor_index := project_list.OpenRelativeFilename(current_function_list[form_current_file_functions.listview_current_file_functions.selected.index].filename);

  { open ok ? }
  if ( editor_index <> -1 ) then
  begin
    { no go to function line }
    editor_list[editor_index].FindGotoLine(current_function_list[form_current_file_functions.listview_current_file_functions.selected.index].LineNumber);
  end;
end;

procedure Tform_main.listview_current_file_functionsColumnClick(
  Sender: TObject; Column: TListColumn);
begin
  case Column.Index of
    0 : current_function_list.CurrentSort := csFunction;
    1 : current_function_list.CurrentSort := csClass;
  end;

  current_function_list.DoSort;

  ( Sender as TListView ).Invalidate;
end;

procedure Tform_main.popupmenu_breakpointsPopup(Sender: TObject);
var
  i : integer;
  sub_menuitem : TTBXItem;
begin
  group_list.Clear;

  debugger_list.GetGroups( group_list );

  menuitem_enable_group.Clear;
  menuitem_disable_group.Clear;

  if ( group_list.Count > 0 ) then
  begin
    menuitem_enable_group.enabled := True;
    menuitem_disable_group.enabled := True;

    { create enable/disable group submenu items }
    for i := 0 to group_list.Count-1 do
    begin
      { add to enable }
      sub_menuitem := TTBXItem.Create( Self );
      sub_menuitem.Caption := group_list[i];
      sub_menuitem.Tag := i ;
      sub_menuitem.OnClick := enable_group;
      menuitem_enable_group.Add( sub_menuitem );


      { add to disable }
      sub_menuitem := TTBXItem.Create( Self );
      sub_menuitem.Caption := group_list[i];
      sub_menuitem.Tag := i ;
      sub_menuitem.OnClick := disable_group;
      menuitem_disable_group.Add( sub_menuitem );
    end;
  end
  else
  begin
    menuitem_enable_group.enabled := False;
    menuitem_disable_group.enabled := False;
  end;
end;

procedure Tform_main.enable_group ( Sender : TObject ) ;
begin
  debugger_List.ChangeGroupEnableState ( group_list[TTBXItem(Sender).tag], True );
end;

procedure Tform_main.disable_group ( Sender : TObject ) ;
begin
  debugger_List.ChangeGroupEnableState ( group_list[TTBXItem(Sender).tag], False );
end;

procedure Tform_main.combobox_quick_findChange(Sender: TObject);
begin
  main_search_text := '';  
end;

procedure Tform_main.action_compile_selectedExecute(Sender: TObject);
var
  i : integer;

begin
  { check we have saved }
  if ( editor_list.anyModified ) then
  begin
    case MessageDlg('Save changes to current files?', mtConfirmation,
         [mbYes, mbNo, mbCancel], 0)  of
      { ---------------}
      mrYes :
      begin
        { save all files open in editor }
        action_save_all.execute;

        { we have some still modified files }
        if ( editor_list.anyModified ) then
          exit;
      end;
      { ---------------}
      mrCancel :
      begin
        exit;
      end;

      { mrNo we just carry on and compile regardless }
    end;
  end;

    doing_compile := True;

    { find item index }
    for i := form_project_files.eltree_project_files.Items.Count-1 downto 0 do
    begin
      if ( form_project_files.eltree_project_files.items[i].Selected ) then
      begin  { Send T2 compile command }
        TProjectObject(form_project_files.eltree_project_files.items[i].Data).
        JustCompiled := True;

        SendCommand(Format('compile("%s");',[
        ExtractUnixRelativePath(project_list.BasePath,
        TProjectObject(form_project_files.eltree_project_files.items[i].Data).Filename
        )]));
      end;
    end;

    SendCommand(Format('echo("%s");',[MSG_COMPILATION_COMPLETE]));
end;



procedure Tform_main.action_compile_selectedUpdate(Sender: TObject);
begin
  action_compile_selected.enabled :=
  ( project_list.ProjectName <> '') and ( form_project_files.eltree_project_files.selectedcount > 0);
end;

procedure Tform_main.popupmenu_editorPopup(Sender: TObject);
var
  function_name : string;
  current_function_index : integer;
  menuitem_temp : TTBXItem;
begin
  if ( editor_list.CurrentActive <> -1 ) then
  begin
    { have we any text selected ? }
    if editor_list[editor_list.CurrentActive].editor.SelText <> '' then
    begin
      function_name := editor_list[editor_list.CurrentActive].editor.SelText;
    end
    else
    begin
      { try and work out function at cursor }
      with editor_list[editor_list.CurrentActive].editor do
        function_name := GetVariableAt( editor_list[editor_list.CurrentActive].editor, CaretX, CaretY );
    end;

    menuitem_goto_definition.Clear;

    { loop through the list finding matching functions }
    current_function_index:=0;
    repeat
      { find the next function that matches this }
      current_function_index := function_list.FindNextFunction( current_function_index, function_name );
      { found one ? }
      if ( current_function_index <> -1 ) then
      begin
        menuitem_temp := TTBXItem.Create(menuitem_goto_definition);
        menuitem_temp.OnClick := function_menuitem_click;
        with menuitem_temp do
        begin
          caption := caption + Format('[%s]  -  ',[function_list[current_function_index].filename]);

          if ( function_list[current_function_index].FunctionClassName <> '' ) then
            caption := caption + function_list[current_function_index].FunctionClassName+'::';

          caption := caption + function_list[current_function_index].functionName;


          tag := current_function_index;
        end;

        menuitem_goto_definition.Add(menuitem_temp);

        inc(current_function_index);
      end;
    until ( current_function_index = -1 ) ;

    menuitem_goto_definition.enabled := menuitem_goto_definition.Count > 0;
  end;
end;

procedure Tform_main.function_menuitem_click( Sender : TObject );
var
  editor_index : integer;
begin
  { open file in which function is in }
  editor_index := project_list.OpenRelativeFilename(function_list[TTBXItem(Sender).Tag].filename);

  { goto line if open was ok }
  if ( editor_index <> -1 ) then
  begin
    editor_list[editor_index].FindGotoLine( function_list[TTBXItem(Sender).Tag].LineNumber );
  end;
end;


procedure Tform_main.clientsocket_debugDataAvailable(Sender: TObject;
  Error: Word);
var
  sub_packet : string;
  in_string : string;
begin
  in_string := clientsocket_debug.receiveStr;
  inc_packet := inc_packet + in_string;

  { any data ? }
  if ( Length(inc_packet) = 0)  then
    exit;

  while ( Pos(#10, inc_packet) <> 0 ) do
  begin
    sub_packet := Copy(inc_packet, 1, Pos(#10, inc_packet));
    Delete(inc_packet, 1, Pos(#10, inc_packet));

    ProcessPacket(sub_packet);
  end;
end;

procedure Tform_main.clientsocket_debugChangeState(Sender: TObject;
  OldState, NewState: TSocketState);
begin
  case NewState of
    { ------------------------------------------------------------------------ }
    wsConnecting :
    begin
        { tell user we are connecting to debugging server }
        AddMessage('Connecting to debug server');
    end;

    { ------------------------------------------------------------------------ }
    wsConnected :
    begin

    end;
  end;
end;

procedure Tform_main.clientsocket_debugSessionClosed(Sender: TObject;
  Error: Word);
begin
  { no longer debugging }
  server_debugging := False;
  AddMessage('Disconnected from Debug Server');

  debug_file_list.clear;
  project_list.updateicons;
end;

procedure Tform_main.clientsocket_debugSessionConnected(Sender: TObject;
  Error: Word);
begin
  if ( Error = 0 ) then
  begin
    inc_packet := '';

    { tell user we have connected to debugging server }
    AddMessage('Connected to debug server');
    { now send password }
    AddMessage('Sending Password');
    SendPacket(server_debug_password);
  end
  else
    { tell the user connection has failed }
    AddMessage('Connection Error');
end;

procedure Tform_main.eltree_watchesItemExpanding(Sender: TObject;
  Item: TElTreeItem; var CanProcess: Boolean);
var
  i : integer;
begin
  inherited;


  if ( not system_expand ) then
  begin
    if ( debugging_step ) then
    begin
      for i := watch_list.Count-1 downto 0 do
        if ( watch_list[i].Parent = TWatchObject( Item.Data ) ) then
          watch_list.Delete( i );

      CanProcess := True;

      with TWatchObject( Item.Data ) do
      begin
        SendPacket(Format('OBJTAGLIST %d 0 %s',[ID,FullVariable]));
      end;
    end
    else
      CanProcess := False;

  end;
end;

procedure Tform_main.timer_end_watches_updateTimer(Sender: TObject);
begin
  timer_end_watches_update.enabled := False;

  form_watches.eltree_watches.items.EndUpdate;
end;

end.



