unit unit_form_goto_line;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  Tform_goto_line = class(TForm)
    button_ok: TButton;
    button_cancel: TButton;
    panel_line_number: TPanel;
    edit_line_number: TEdit;
    label_line_number: TLabel;
    procedure button_okClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    FLineNumber : integer;

    procedure SetLineNumber ( value : integer );
  public
    { Public declarations }
    property LineNumber : integer read FLineNumber write SetLineNumber;
  end;

var
  form_goto_line: Tform_goto_line;

implementation

{$R *.DFM}

procedure Tform_goto_line.button_okClick(Sender: TObject);
begin
  try
    FLineNumber := StrToInt( edit_line_number.text );
  except
    MessageDlg('Must enter a number', mtError, [mbOk], 0);
    exit;
  end;

  ModalResult := mrOk;
end;

procedure Tform_goto_line.SetLineNumber ( value : integer );
begin
  FLineNumber := value;

  edit_line_number.text := IntToStr(FLineNumber);
end;

procedure Tform_goto_line.FormShow(Sender: TObject);
begin
  edit_line_number.SelectAll;
  edit_line_number.SetFocus;
end;

end.
