unit unit_form_folder_select;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, StdCtrls, SystemTreeView;

type
  Tform_folder_select = class(TForm)
    button_ok: TButton;
    button_cancel: TButton;
    systemtreeview_main: TSystemTreeView;
    label_path: TLabel;
    procedure systemtreeview_mainChange(Sender: TObject; Node: TTreeNode);
    procedure button_okClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }

    FDirectory : string;

  public
    { Public declarations }

    property Directory : string read FDirectory write FDirectory;
  end;

var
  form_folder_select: Tform_folder_select;

implementation

{$R *.DFM}

procedure Tform_folder_select.systemtreeview_mainChange(Sender: TObject;
  Node: TTreeNode);
begin
  label_path.caption:=systemtreeview_main.Directory;
end;

procedure Tform_folder_select.button_okClick(Sender: TObject);
begin
  Directory:=IncludeTrailingBackslash(systemtreeview_main.Directory);
end;

procedure Tform_folder_select.FormShow(Sender: TObject);
begin
  try
    { try setting the directory of the tree to the one passed }
    systemtreeview_main.Directory:=Directory;
  except
  end;

  systemtreeview_main.SetFocus;
end;

procedure Tform_folder_select.FormCreate(Sender: TObject);
begin
  Directory := '';
end;

end.
