unit unit_form_find;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, RegControls;

type
  Tform_find = class(TForm)
    panel_find: TPanel;
    combobox_find: TRegComboBox;
    label_find: TLabel;
    button_ok: TButton;
    button_cancel: TButton;
    label_replace_with: TLabel;
    combobox_replace: TRegComboBox;
    radiogroup_search_direction: TRadioGroup;
    groupbox_checkboxes: TGroupBox;
    checkbox_case_sensitive: TCheckBox;
    checkbox_whole_words_only: TCheckBox;
    checkbox_from_cursor: TCheckBox;
    checkbox_search_selected: TCheckBox;
    procedure button_okClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    FReplace          : boolean;
    FInFiles          : boolean;

    procedure SetReplace ( value : boolean );
    procedure SetInFiles ( value : boolean );

    function GetSearchBackwards: boolean;
    function GetSearchCaseSensitive: boolean;
    function GetSearchFromCursor: boolean;
    function GetSearchInSelection: boolean;
    function GetSearchText: string;
    function GetSearchWholeWords: boolean;
    function GetReplaceText : string;
    procedure SetSearchBackwards( value : boolean );
    procedure SetSearchCaseSensitive( value : boolean );
    procedure SetSearchFromCursor( value : boolean );
    procedure SetSearchInSelection( value : boolean );
    procedure SetSearchText( value : string );
    procedure SetSearchWholeWords( value : boolean );
    procedure SetReplaceText ( value : string );

  public
    { Public declarations }
    property Replace : boolean read FReplace write SetReplace;
    property InFiles : boolean read FInFiles write SetInFiles;

    property SearchBackwards: boolean read GetSearchBackwards write SetSearchBackwards;
    property SearchCaseSensitive: boolean read GetSearchCaseSensitive write SetSearchCaseSensitive;
    property SearchFromCursor: boolean read GetSearchFromCursor write SetSearchFromCursor;
    property SearchInSelectionOnly: boolean read GetSearchInSelection write SetSearchInSelection;
    property SearchText: string read GetSearchText write SetSearchText;
    property ReplaceText: string read GetReplaceText write SetReplaceText;
    property SearchWholeWords: boolean read GetSearchWholeWords write SetSearchWholeWords;
  end;

var
  form_find: Tform_find;

implementation

{$R *.DFM}

procedure Tform_find.SetReplace ( value : boolean );
begin
  FReplace := value;

  label_replace_with.visible := value;
  combobox_replace.visible := value;
end;

procedure Tform_find.SetInFiles ( value : boolean );
begin
  FInFiles := value;
  
  radiogroup_search_direction.visible := not value;
  checkbox_search_selected.visible := not value;
  checkbox_from_cursor.visible := not value;
end;

function Tform_find.GetSearchBackwards: boolean;
begin
  Result := radiogroup_search_direction.ItemIndex = 1;
end;

function Tform_find.GetSearchCaseSensitive: boolean;
begin
  Result := checkbox_case_sensitive.Checked;
end;

function Tform_find.GetSearchFromCursor: boolean;
begin
  Result := checkbox_from_cursor.Checked;
end;

function Tform_find.GetSearchInSelection: boolean;
begin
  Result := checkbox_search_selected.Checked;
end;

function Tform_find.GetSearchText: string;
begin
  Result := combobox_find.Text;
end;

function Tform_find.GetReplaceText: string;
begin
  Result := combobox_replace.Text;
end;

function Tform_find.GetSearchWholeWords: boolean;
begin
  Result := checkbox_whole_words_only.Checked;
end;

procedure Tform_find.SetSearchBackwards( value : boolean );
begin
  radiogroup_search_direction.ItemIndex := Ord(Value);
end;

procedure Tform_find.SetSearchCaseSensitive( value : boolean );
begin
  checkbox_case_sensitive.Checked := Value;
end;

procedure Tform_find.SetSearchFromCursor( value : boolean );
begin
  checkbox_from_cursor.Checked := Value;
end;

procedure Tform_find.SetSearchInSelection( value : boolean );
begin
  checkbox_search_selected.Checked := Value;
end;   

procedure Tform_find.SetSearchText( value : string );
begin
  combobox_find.Text := Value;
end;

procedure Tform_find.SetReplaceText( value : string );
begin
  combobox_replace.Text := Value;
end;

procedure Tform_find.SetSearchWholeWords( value : boolean );
begin
  checkbox_whole_words_only.Checked := Value;
end;

procedure Tform_find.button_okClick(Sender: TObject);
begin
  { add find text to history }
  if ( combobox_find.text <> '' ) then
    if ( combobox_find.items.indexof ( combobox_find.text ) = -1 ) then
      combobox_find.Save;

  { add replace text to history }
  if ( combobox_replace.text <> '' ) then
    if ( combobox_replace.items.indexof ( combobox_replace.text ) = -1 ) then
      combobox_replace.Save;
end;

procedure Tform_find.FormShow(Sender: TObject);
begin
  combobox_find.SetFocus;

  if ( Replace ) then
    caption := 'Replace Text'
  else
  if ( InFiles ) then
    caption := 'Find Text in Files'
  else
    caption := 'Find Text'
end;

end.
