unit unit_form_conjoinhost;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, unit_form_dock,
  extctrls;

type
  Tform_conjoinhost = class(TForm)
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDockDrop(Sender: TObject; Source: TDragDockObject; X,
      Y: Integer);
    procedure FormUnDock(Sender: TObject; Client: TControl;
      NewTarget: TWinControl; var Allow: Boolean);
    procedure FormDockOver(Sender: TObject; Source: TDragDockObject; X,
      Y: Integer; State: TDragState; var Accept: Boolean);
    procedure FormGetSiteInfo(Sender: TObject; DockClient: TControl;
      var InfluenceRect: TRect; MousePos: TPoint; var CanDock: Boolean);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    procedure DoFloat(AControl: TControl);
  public
    procedure UpdateCaption(Exclude: TControl);
    function SubFormNames : string;
  end;

var
  form_conjoinhost: Tform_conjoinhost;

implementation

{$R *.DFM}

procedure Tform_conjoinhost.DoFloat(AControl: TControl);
var
  ARect: TRect;
begin
  //float the control with its original size.
  ARect.TopLeft := AControl.ClientToScreen(Point(0, 0));
  ARect.BottomRight := AControl.ClientToScreen(Point(AControl.UndockWidth,
                       AControl.UndockHeight));
  AControl.ManualFloat(ARect);
end;

procedure Tform_conjoinhost.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  if DockClientCount = 1 then
  begin
      if (HostDockSite is TPanel) then
        DockClients[0].ManualDock(Self.HostDockSite, nil, alClient)
      else
        DoFloat(DockClients[0]);

    Action := caFree;
  end else
    Action := caHide;
end;

procedure Tform_conjoinhost.UpdateCaption(Exclude: TControl);
var
  I: Integer;
begin
  //if a dockable form is undocking, it will pass itself in as Exclude
  //because even it hasn't actually been taken out of the DockClient array
  //at this point.
  Caption := '';
  for I := 0 to DockClientCount-1 do
    if DockClients[I].Visible and (DockClients[I] <> Exclude) then
    begin
      if ( Caption <> '' ) then
        Caption := Caption +', ';

      Caption := Caption + Tform_dock(DockClients[I]).Caption;
    end;
end;

procedure Tform_conjoinhost.FormDockDrop(Sender: TObject;
  Source: TDragDockObject; X, Y: Integer);
begin
  UpdateCaption(nil);
  DockManager.ResetBounds(True);
  //Force DockManager to redraw it's clients.
end;

procedure Tform_conjoinhost.FormUnDock(Sender: TObject; Client: TControl;
  NewTarget: TWinControl; var Allow: Boolean);
begin
  //only 2 dock clients means the host must be destroyed and
  //the remaining window undocked to its old position and size.
  //(Recall that OnUnDock gets called before the undocking actually occurs)
  if Client is Tform_dock then
  begin
    Tform_dock(Client).Caption := Tform_dock(Client).form_caption;
    Tform_dock(Client).DockSite := True;
  end;

  if (DockClientCount = 2) and (NewTarget <> Self) then
    PostMessage(Self.Handle, WM_CLOSE, 0, 0);
  UpdateCaption(Client);
end;

procedure Tform_conjoinhost.FormDockOver(Sender: TObject;
  Source: TDragDockObject; X, Y: Integer; State: TDragState;
  var Accept: Boolean);
begin
  Accept := Source.Control is Tform_dock;
end;

procedure Tform_conjoinhost.FormGetSiteInfo(Sender: TObject;
  DockClient: TControl; var InfluenceRect: TRect; MousePos: TPoint;
  var CanDock: Boolean);
begin
  CanDock := DockClient is Tform_dock;
end;

procedure Tform_conjoinhost.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CanClose := DockClientCount = 1;
end;

function Tform_conjoinhost.SubFormNames : string;
var
  I: Integer;
begin
  Result := '';
  for I := 0 to DockClientCount-1 do
    if DockClients[I].Visible  then
    begin
      if ( Result <> '' ) then
      begin
        Result:=Result+',';
      end;

      Result := Result + Tform_dock(DockClients[I]).Name;
    end;
end;


end.

