unit unit_form_confirm_replace;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  Tform_confirm_replace = class(TForm)
    button_replace: TButton;
    label_confirmation: TLabel;
    button_no: TButton;
    button_cancel: TButton;
    button_yes_to_all: TButton;
    image_icon: TImage;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  public
    procedure PrepareShow(AEditorRect: TRect; X, Y1, Y2: integer;
      AReplaceText: string);
  end;

var
  form_confirm_replace: Tform_confirm_replace;

implementation

{$R *.DFM}


procedure Tform_confirm_replace.FormCreate(Sender: TObject);
begin
  image_icon.Picture.Icon.Handle := LoadIcon(0, IDI_QUESTION);
end;

procedure Tform_confirm_replace.PrepareShow(AEditorRect: TRect;
  X, Y1, Y2: integer; AReplaceText: string);
var
  nW, nH: integer;
begin
  { calculate where we can show the form }
  label_confirmation.Caption := Format('Replace this occurence of "%s"?', [AReplaceText]);
  nW := AEditorRect.Right - AEditorRect.Left;
  nH := AEditorRect.Bottom - AEditorRect.Top;

  if nW <= Width then
    X := AEditorRect.Left - (Width - nW) div 2
  else
  begin
    if X + Width > AEditorRect.Right then
      X := AEditorRect.Right - Width;
  end;
  if Y2 > AEditorRect.Top + MulDiv(nH, 2, 3) then
    Y2 := Y1 - Height - 4
  else
    Inc(Y2, 4);
  SetBounds(X, Y2, Width, Height);
end;

procedure Tform_confirm_replace.FormDestroy(Sender: TObject);
begin
  { nil it }
  form_confirm_replace := nil;
end;

end.

