unit unit_form_breakpoint_properties;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, RegControls;

type
  Tform_breakpoint_properties = class(TForm)
    panel_breakpoint_properties: TPanel;
    label_filename: TLabel;
    label_line_number: TLabel;
    combobox_filename: TRegComboBox;
    combobox_line_number: TRegComboBox;
    label_condition: TLabel;
    combobox_condition: TRegComboBox;
    label_pass_count: TLabel;
    combobox_pass_count: TRegComboBox;
    label_group: TLabel;
    combobox_group: TRegComboBox;
    button_ok: TButton;
    button_cancel: TButton;
    checkbox_disable_after_hit: TCheckBox;
    procedure button_okClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;


implementation

{$R *.DFM}

procedure Tform_breakpoint_properties.button_okClick(Sender: TObject);
begin


  { check line number is numeric }
  try
    if ( StrToInt(combobox_line_number.text) <= 0 ) then
      raise Exception.Create('Line number less than 0');
  except
    MessageDlg('Line number must be an integer greater than 0', mtError, [mbOk], 0);
    exit;
  end;

  { check pass count is numeric }
  try
    StrToInt(combobox_pass_count.text);
  except
    MessageDlg('Pass count must be an integer greater than or equal to 0', mtError, [mbOk], 0);
    exit;
  end;

  combobox_filename.Save;
  combobox_line_number.Save;
  combobox_condition.Save;
  combobox_pass_count.Save;
  combobox_group.Save;
  
  ModalResult := mrOk;
end;

end.
