unit unit_editor_utils;

interface

uses classes, windows, controls;

function PacketParamCount( delim : char ; packet : string ) : integer;
function PacketParamStr( delim : char ; index : integer; packet : string ) : string;
function PacketRestStr( delim : char ; index : integer; packet : string ) : string;
function ExtractUnixRelativePath(const BaseName, DestName: string): string;
function ConvertError ( in_string : string ) : string;
function ComputeDockingRect(Sender : TWinControl; var DockRect: TRect; MousePos: TPoint): TAlign;

implementation

uses sysutils;

{ how many delim delimited arguments have we? }
function PacketParamCount(delim : char ;  packet : string ) : integer;
var
  i : integer;
  in_quotes : boolean;
begin
  Result := 0;

  in_quotes := false;
  packet := packet +delim;
  for i:=1 to Length(packet) do
  begin
    if ( packet[i] = delim ) and ( not in_quotes ) then
    begin
      inc ( Result );
    end
    else
    if ( packet[i] = '"' ) then
      in_quotes := not in_quotes;
  end;
end;

{ find specified space delimited index'th argument from passed string }
function PacketParamStr(delim : char ; index : integer; packet : string ) : string;
var
  i            : integer;
  last_space   : integer;
  packet_index : integer;
  in_quotes : boolean;
begin
  packet_index := 0;
  last_space := 0;
  Result := '';
  packet := packet +delim;

  in_quotes := false;

  { go through character by character }
  for i:=1 to Length(packet) do
  begin
    { found a space ? }
    if ( packet[i] = delim ) and ( not in_quotes ) then
    begin
      { is this the one we want ? }
      if ( packet_index = index ) then
      begin
        { copy from last space we had to this one }
        Result := Copy(packet, last_space+1, (i-last_space)-1);
        exit;
      end;

      { continue }
      last_space := i;
      inc ( packet_index );
    end
    else
    if ( packet[i] = '"' ) then
      in_quotes := not in_quotes;
  end;
end;

{ find specified space delimited and all after that index }
function PacketRestStr( delim : char ; index : integer; packet : string ) : string;
var
  i            : integer;
  last_space   : integer;
  packet_index : integer;
begin
  packet_index := 0;
  last_space := 0;
  Result := '';
  packet := packet +delim;
  { go through character by character }
  for i:=1 to Length(packet) do
  begin
    { found a space ? }
    if ( packet[i] = delim ) then
    begin
      { is this the one we want ? }
      if ( packet_index = index ) then
      begin
        { copy from last space we had to this one }
        Result := Copy(packet, last_space+1, Length(packet) - ( last_space+1 ) );
        exit;
      end;

      { continue }
      last_space := i;
      inc ( packet_index );
    end;
  end;
end;

{ extract relative path, and convert \ into / }
function ExtractUnixRelativePath(const BaseName, DestName: string): string;
begin
  Result := ExtractRelativePath(BaseName, DestName);
  Result := StringReplace( Result, '\','/', [rfIgnoreCase, rfReplaceAll]);
end;

{ converts debugger Line : X - syntax error type messages to same
format as IDE uses }
function ConvertError ( in_string : string ) : string;
var
  line_number : string;
  file_string : string;
  error_string : string;
  i : integer;
  line_pos :integer;
begin
  Result := '';

  line_pos := Pos('Line: ', in_string);
  if ( line_pos <> 0 ) then
  begin
    i := line_pos+6;

    while ( i < length(in_string) ) do
    begin
      if ( in_string[i] = ' ' ) then
        break;

      line_number := line_number + in_string[i];

      inc(i);
    end;

    file_string := Copy(in_string, 1, line_pos-1);
    error_string := Copy(in_string, i+3, Length(in_string)-i);
  end;

  Result := Format('%s (%s): %s',[file_string,line_number,error_string]);
end;

{ calculate what the preview docking rectangle should look like }
function ComputeDockingRect(Sender : TWinControl; var DockRect: TRect; MousePos: TPoint): TAlign;
var
  DockTopRect,
  DockLeftRect,
  DockBottomRect,
  DockRightRect,
  DockCenterRect: TRect;
begin
  with Sender do
  begin
    Result := alNone;
    //divide form up into docking "Zones"
    DockLeftRect.TopLeft := Point(0, 0);
    DockLeftRect.BottomRight := Point(ClientWidth div 5, ClientHeight);

    DockTopRect.TopLeft := Point(ClientWidth div 5, 0);
    DockTopRect.BottomRight := Point(ClientWidth div 5 * 4, ClientHeight div 5);

    DockRightRect.TopLeft := Point(ClientWidth div 5 * 4, 0);
    DockRightRect.BottomRight := Point(ClientWidth, ClientHeight);

    DockBottomRect.TopLeft := Point(ClientWidth div 5, ClientHeight div 5 * 4);
    DockBottomRect.BottomRight := Point(ClientWidth div 5 * 4, ClientHeight);

    DockCenterRect.TopLeft := Point(ClientWidth div 5, ClientHeight div 5);
    DockCenterRect.BottomRight := Point(ClientWidth div 5 * 4, ClientHeight div 5 * 4);

    //Find out where the mouse cursor is, to decide where to draw dock preview.
    if PtInRect(DockLeftRect, MousePos) then
      begin
        Result := alLeft;
        DockRect := DockLeftRect;
        DockRect.Right := ClientWidth div 2;
      end
    else
      if PtInRect(DockTopRect, MousePos) then
        begin
          Result := alTop;
          DockRect := DockTopRect;
          DockRect.Left := 0;
          DockRect.Right := ClientWidth;
          DockRect.Bottom := ClientHeight div 2;
        end
      else
        if PtInRect(DockRightRect, MousePos) then
          begin
            Result := alRight;
            DockRect := DockRightRect;
            DockRect.Left := ClientWidth div 2;
          end
        else
          if PtInRect(DockBottomRect, MousePos) then
            begin
              Result := alBottom;
              DockRect := DockBottomRect;
              DockRect.Left := 0;
              DockRect.Right := ClientWidth;
              DockRect.Top := ClientHeight div 2;
           end
          else
            if PtInRect(DockCenterRect, MousePos) then
            begin
              Result := alClient;
              DockRect := DockCenterRect;
            end;
    if Result = alNone then Exit;

    //DockRect is in screen coordinates.
    DockRect.TopLeft := ClientToScreen(DockRect.TopLeft);
    DockRect.BottomRight := ClientToScreen(DockRect.BottomRight);
  end;
end;


end.
