program Tribal;

uses
  Forms,
  Windows,
  Messages,
  SysUtils,
  unit_form_main in 'unit_form_main.pas' {form_main},
  unit_function_list in 'unit_function_list.pas',
  unit_form_preferences in 'unit_form_preferences.pas' {form_preferences},
  unit_form_folder_select in 'unit_form_folder_select.pas' {form_folder_select},
  unit_editorlist in 'unit_editorlist.pas',
  unit_form_about in 'unit_form_about.pas' {form_about},
  unit_form_find in 'unit_form_find.pas' {form_find},
  unit_form_confirm_replace in 'unit_form_confirm_replace.pas' {form_confirm_replace},
  unit_editor_utils in 'unit_editor_utils.pas',
  unit_projectlist in 'unit_projectlist.pas',
  unit_debugger_list in 'unit_debugger_list.pas',
  unit_form_new_project in 'unit_form_new_project.pas' {form_new_project},
  unit_watch_list in 'unit_watch_list.pas',
  unit_form_watch_value in 'unit_form_watch_value.pas' {form_watch_value},
  unit_form_goto_line in 'unit_form_goto_line.pas' {form_goto_line},
  unit_form_breakpoint_properties in 'unit_form_breakpoint_properties.pas' {form_breakpoint_properties},
  unit_form_dock in 'unit_form_dock.pas' {form_dock},
  unit_form_console in 'unit_form_console.pas' {form_console},
  unit_form_messages in 'unit_form_messages.pas' {form_messages},
  unit_form_watches in 'unit_form_watches.pas' {form_watches},
  unit_form_breakpoints in 'unit_form_breakpoints.pas' {form_breakpoints},
  unit_form_callstack in 'unit_form_callstack.pas' {form_callstack},
  unit_form_project in 'unit_form_project.pas' {form_project_files},
  unit_form_functions in 'unit_form_functions.pas' {form_functions},
  unit_form_current_file_functions in 'unit_form_current_file_functions.pas' {form_current_file_functions};

{$R *.RES}


var
  hMap : THandle;
  copydata: TCopyDataStruct;
  param_buffer : HGLOBAL;

begin
  hMap := CreateFileMapping(DWord(-1), nil, PAGE_READWRITE, 0, SizeOf(TAppComms), 'Tribal IDE');

  if GetLastError = ERROR_ALREADY_EXISTS then
  begin
    hMap := OpenFileMapping(FILE_MAP_READ, false, 'Tribal IDE');
    if hMap <> 0 then
    begin
      PAppCommsData := MapViewOfFile(hMap, FILE_MAP_READ, 0, 0, SizeOf(TAppComms));
      if IsIconic(PAppCommsData^.HandleData) then
        ShowWindow(PAppCommsData^.HandleData, sw_restore);

      If (ParamCount > 0) Then
      Begin
        param_buffer := GlobalAlloc(GMEM_DDESHARE	, Length(ParamStr(1)) + 1);
        strpcopy(PCHAR(param_buffer), ParamStr(1));
        With copydata Do
        Begin
          dwData := 0;
          {Need to transfer terminating #0 as well}
          cbData := Length(ParamStr(1))+1;
          lpData := PChar(param_buffer);
        End;
        SendMessage(PAppCommsData^.MainFormHandle, WM_COPYDATA, 0, LPARAM( @copydata ));
      End;

      SetForegroundWindow(PAppCommsData^.HandleData);
    end
  end
  else
  begin
    if hMap = 0 then
      RaiseLastWin32Error;

    PAppCommsData := MapViewOfFile(hMap, FILE_MAP_ALL_ACCESS, 0, 0, SizeOf(THandle));
    PAppCommsData^.HandleData := Application.Handle;

    Application.Initialize;
    Application.Title := 'Tribal IDE';
    Application.CreateForm(Tform_main, form_main);
  Application.CreateForm(Tform_about, form_about);
  Application.CreateForm(Tform_find, form_find);
  Application.CreateForm(Tform_watch_value, form_watch_value);
  Application.CreateForm(Tform_goto_line, form_goto_line);
  Application.CreateForm(Tform_folder_select, form_folder_select);
  PAppCommsData^.MainFormHandle := form_main.Handle;

    Application.Run;
  end;
  UnmapViewOfFile(PAppCommsData);
  CloseHandle(hMap);
end.
