// #autoload
// #name = Chat Link Enabler
// #version = 0.0.1
// #status = release
// #date = 6-16-2002
// #description = This script makes you able to make links to normal chatrooms.
// #author = BartWare
// #warrior = BartWare
// #email = vanderburgt@planet.nl
// #web = http://bartware.s5.com

package LinkEnabler{

function GuiMLTextCtrl::onURL(%this, %url)
{
   %i = 0;
   while((%fld[%i] = getField(%url, %i)) !$= "")
      %i++;

   %tribe = %fld[1];
   %warrior = %fld[2];
   switch$(%fld[0])
   {
      case "player":
         LinkBrowser( %fld[1] , "Warrior");
      case "tribe":
         LinkBrowser( %fld[1], "Tribe" );
      case "forumlink":
         LinkForum(%fld[1], %fld[3]);
      case "wwwlink":
         LinkWeb( %fld[1] );
      case "cancelinvite":
         %tribe = %fld[1];
         %warrior = %fld[2];
         MessageBoxYesNo("CONFIRM", "Are you sure you wish to cancel the invitation for " @ %fld[1] @ " to join Tribe " @ %fld[2] @ "?",
         "LinkInvitation(\"cancel\"," @ %tribe @ "," @ %player @ ",\" TribePane \");","");
      case "acceptinvite":
         LinkInvitation("accept",%tribe,%warrior,PlayerPane);
      case "rejectinvite":
         LinkInvitation("reject",%tribe,%warrior,PlayerPane);
      case "email":
         LinkEMail(%fld[1]);
      case "massmail":
         LinkEMailTribe(%tribe);

      case "editwarrior":
         LinkEditWarrior();
      case "editdescription":
         if(%fld[1])
            TWBText.editType = "warrior";
         LinkEditWarriorDesc(%fld[1],PlayerPane,"editWarriorDescription");
      case "editmember":
         LinkEditMember(%fld[1],%fld[2],%fld[3],%fld[4],TribeAdminMemberDlg);
      case "kickwarrior":
         MessageBoxYesNo("CONFIRM", "Are you sure you wish to kick " @ %fld[1] @ " from Tribe " @ %fld[2] @ "?",
                                       "LinkKickMember(" @ %fld[1] @ "," @ %fld[2] @ "," @ TribePane @ ");", "");
      case "makeprimarytribe":
         %this.tribe = %fld[1];
         MessageBoxYesNo("CONFIRM", "Are you sure you wish to make Tribe " @ %this.tribe @ " your primary tribe?",
                           "LinkMakePrimary(\"setPrimaryTribe\",\"" @ %this.tribe @ "\"," @ PlayerPane @ ",);","");
      case "noprimarytribe":
         %this.tribe = %fld[1];
         MessageBoxYesNo("CONFIRM", "Are you sure you wish to have no primary tribe?",
                           "LinkMakePrimary(\"setNoPrimaryTribe\",\"NONE\"," @ PlayerPane @ ",);","");
      case "leavetribe":
         %this.tribe = %fld[1];
         MessageBoxYesNo("CONFIRM", "Are you sure you wish to leave Tribe " @ %this.tribe @ "?",
                                          "LinkLeaveTribe(" @ %this.tribe @ ",\"playerPane \");","");

      case "changerecruiting":
         LinkTribeToggle("Recruiting", %fld[2] TAB %fld[1], %this, "togglerecruiting");
      case "changeappending":
         LinkTribeToggle("Appending", %fld[2] TAB %fld[1], %this, "toggleappending");
      case "invite":
         %this.tribe = %fld[2];
         %this.warrior = %fld[1];
         MessageBoxYesNo("CONFIRM", "Invite " @ %this.warrior @ " to join " @ %this.tribe @ "?",
                           "LinkInvitePlayer(\"" @ %this.tribe @ "\",\"" @ %this.warrior @ "\"," @ PlayerPane @ ",\"inviteWarrior\");","");

      case "changetribename":
         MessageBoxOK("INFORMATION","You are not allowed to change tribe names, you must instead disband your tribe and create another.");

      case "changetribetag":
         LinkTribeTag(%this);

      case "addBuddy":
         LinkAddBuddy(%fld[1],TWBText,"addBuddy");
      case "requestlink":
         TribePane.key = LaunchGui.key++;
         TribePane.state = "requestInvite";
         DatabaseQuery(34,TProfileHdr.tribename,TribePane,TribePane.key);

      case "gamelink":
         commandToServer('ProcessGameLink', %fld[1], %fld[2], %fld[3], %fld[4], %fld[5]);
// THESE ARE EMAIL RELATED MODERATOR LINKS
     case "moderatorTopicKill":
            TopicsPopupDlg.key = LaunchGui.key++;
            TopicsPopupDlg.state = "adminRemoveTopic";
            databaseQuery(62, 0 TAB getField(%url,1) TAB getField(%url,2), TopicsPopupDlg, TopicsPopupDlg.key);
     case "moderatorTopicWarn":
            TopicsPopupDlg.key = LaunchGui.key++;
            TopicsPopupDlg.state = "adminRemoveTopicPlus";
            //error("MTW: " @ %url);
            databaseQuery(62, 1 TAB getField(%url,1) TAB getField(%url,2), TopicsPopupDlg, TopicsPopupDlg.key);
     case "moderatorTopicBan24":
            TopicsPopupDlg.key = LaunchGui.key++;
            TopicsPopupDlg.state = "adminRemoveTopicPlus";
            //error("MTB24: " @ %url);
            databaseQuery(62, 2 TAB getField(%url,1) TAB getField(%url,2), TopicsPopupDlg, TopicsPopupDlg.key);
     case "moderatorTopicBan48":
            TopicsPopupDlg.key = LaunchGui.key++;
            TopicsPopupDlg.state = "adminRemoveTopicPlus";
            databaseQuery(62, 3 TAB getField(%url,1) TAB getField(%url,2), TopicsPopupDlg, TopicsPopupDlg.key);
     case "moderatorTopicBan72":
            TopicsPopupDlg.key = LaunchGui.key++;
            TopicsPopupDlg.state = "adminRemoveTopicPlus";
            databaseQuery(62, 4 TAB getField(%url,1) TAB getField(%url,2), TopicsPopupDlg, TopicsPopupDlg.key);
     case "moderatorTopicBan7Days":
            TopicsPopupDlg.key = LaunchGui.key++;
            TopicsPopupDlg.state = "adminRemoveTopicPlus";
            databaseQuery(62, 5 TAB getField(%url,1) TAB getField(%url,2), TopicsPopupDlg, TopicsPopupDlg.key);
     case "moderatorTopicBan30Days":
            TopicsPopupDlg.key = LaunchGui.key++;
            TopicsPopupDlg.state = "adminRemoveTopicPlus";
            databaseQuery(62, 6 TAB getField(%url,1) TAB getField(%url,2), TopicsPopupDlg, TopicsPopupDlg.key);
     case "moderatorTopicBanForever":
            TopicsPopupDlg.key = LaunchGui.key++;
            TopicsPopupDlg.state = "adminRemoveTopicPlus";
            databaseQuery(62, 7 TAB getField(%url,1) TAB getField(%url,2), TopicsPopupDlg, TopicsPopupDlg.key);

     case "moderatorPostKill":
            PostsPopupDlg.key = LaunchGui.key++;
            PostsPopupDlg.state = "adminRemovePost";
            databaseQuery(63, 0 TAB getFields(%url,1), PostsPopupDlg, PostsPopupDlg.key);
     case "moderatorPostWarn":
            PostsPopupDlg.key = LaunchGui.key++;
            PostsPopupDlg.state = "adminRemovePostPlus";
            databaseQuery(63, 1 TAB getFields(%url,1), PostsPopupDlg, PostsPopupDlg.key);
     case "moderatorPostBan24":
            PostsPopupDlg.key = LaunchGui.key++;
            PostsPopupDlg.state = "adminRemovePostPlus";
            databaseQuery(63, 2 TAB getFields(%url,1), PostsPopupDlg, PostsPopupDlg.key);
     case "moderatorPostBan48":
            PostsPopupDlg.key = LaunchGui.key++;
            PostsPopupDlg.state = "adminRemovePostPlus";
            databaseQuery(63, 3 TAB getFields(%url,1), PostsPopupDlg, PostsPopupDlg.key);
     case "moderatorPostBan72":
            PostsPopupDlg.key = LaunchGui.key++;
            PostsPopupDlg.state = "adminRemovePostPlus";
            databaseQuery(63, 4 TAB getFields(%url,1), PostsPopupDlg, PostsPopupDlg.key);
     case "moderatorPostBan7Days":
            PostsPopupDlg.key = LaunchGui.key++;
            PostsPopupDlg.state = "adminRemovePostPlus";
            databaseQuery(63, 5 TAB getFields(%url,1), PostsPopupDlg, PostsPopupDlg.key);
     case "moderatorPostBan30Days":
            PostsPopupDlg.key = LaunchGui.key++;
            PostsPopupDlg.state = "adminRemovePostPlus";
            databaseQuery(63, 6 TAB getFields(%url,1), PostsPopupDlg, PostsPopupDlg.key);
     case "moderatorPostBanForever":
            PostsPopupDlg.key = LaunchGui.key++;
            PostsPopupDlg.state = "adminRemovePostPlus";
            databaseQuery(63, 7 TAB getFields(%url,1), PostsPopupDlg, PostsPopupDlg.key);
     case "joinPublicChat":
         joinPublicTribeChannel(getField(%url,1));
     case "joinPrivateChat":
         joinPrivateTribeChannel(getField(%url,1));
     case "joinChat":
         JoinTribeChannel(getField(%url,1));
      //if there is an unknown URL type, treat it as a weblink..
      default:
      LinkWeb( %fld[0] );
   }
}

function JoinTribeChannel(%tribe)
{
   IRCClient::join(IRCClient::channelName(%tribe));
   LaunchTabView.viewTab("CHAT",ChatGui,0);
}

};
activatePackage(LinkEnabler);
