// (c) 2001 David Gausebeck
// gausebec@paypal.com

package KerbZoom {

function DispatchLaunchMode() {
	parent::DispatchLaunchMode();

	if(!$kZoom::disable)
		$pref::player::currentFOV = $pref::player::defaultFOV/2;
}

//-----------------------------------------------------------------------------

function toggleZoom(%keydown, %forceUnzoom)
{
	if($kZoom::zoomToggle && !%keydown)
		return;
	if($ZoomOn)
		%keydown = 0;
	if(%keydown && $kZoom::resetFOV)
		$pref::player::currentFOV = $kZoom::resetFOV;

	parent::toggleZoom(%keydown);

	// rebind stuff
	for(%i = 0;%i < $kZoom::numBinds; %i++)
		kZoomApplyBind(%i);
}

//-----------------------------------------------------------------------------

function clientCmdSetDefaultVehicleKeys(%inVehicle)
{
	parent::clientCmdSetDefaultVehicleKeys(%inVehicle);

	$kZoom::inVehicle = %inVehicle;

	// make sure zoom axis bind gets propagated for gunners
	if(%inVehicle)
		passengerKeys.copyBind(moveMap, "kZoomAxis");
}

//-----------------------------------------------------------------------------

function clientCmdSetHudMode(%mode, %type, %node)
{
	parent::clientCmdSetHudMode(%mode, %type, %node);
	
	if($HudMode $= "Standard")
		// in order to guarantee that you end up at defaultFOV instead of 90 when
		// you spawn, you have to unzoom a few frames later.  This checks back
		// every 10ms until you pass 3 frames, then unzooms
		schedule(10, 0, kZoomUnzoomAtFrame, $TSControl::frameCount+3);
}

};

activatePackage(KerbZoom);

//-----------------------------------------------------------------------------

function kZoomUnzoomAtFrame(%frameCount)
{
	if($TSControl::frameCount >= %frameCount) {
		setFOV($pref::player::defaultFOV);
		$ZoomOn = 0;
	} else
		schedule(10, 0, kZoomUnzoomAtFrame, %frameCount);
}

//-----------------------------------------------------------------------------

function kZoomAxis(%inc)
{
	// assume mousewheel with increments of 120
	%inc = mCeil(%inc / 120);
	for(%i = 0; %i < %inc; %i++)
		$pref::player::currentFOV /= $kZoom:zoomFactor;
	for(%i = 0; %i > %inc; %i--)
		$pref::player::currentFOV *= $kZoom:zoomFactor;

	// cap it
	if($pref::player::currentFOV > $pref::player::defaultFOV/2)
		$pref::player::currentFOV = $pref::player::defaultFOV/2;
	else if($pref::player::currentFOV < 5)
		$pref::player::currentFOV = 5;

	// set new fov if zoomed
	if($ZoomOn) {
		setFOV($pref::player::currentFOV);

		// support spiffy reticles
		kReticleOnChangeFOV();
	}
}

//-----------------------------------------------------------------------------

function kZoomMapVehicleCommand(%command)
{
	switch$(%command) {
	case "cycleWeaponAxis":
		return "cycleVehicleWeapon";
	case "cycleNextWeaponOnly":
		return "cycleNextVehicleWeaponOnly";
	case "nextWeapon":
		return "nextVehicleWeapon";
	case "prevWeapon":
		return "prevVehicleWeapon";
	default:
		return %command;
	}
}

//-----------------------------------------------------------------------------

function kZoomApplyBind(%index)
{
	%zoomedCommand = $kZoom::zoomedCommand[%index];
	%unzoomedCommand = $kZoom::unzoomedCommand[%index];

	%command = $ZoomOn?%zoomedCommand:%unzoomedCommand;

	// always bind for moveMap even if in vehicle, because moveMap is still used
	// for passengers
	moveMap.bind($kZoom::device[%index], $kZoom::action[%index], %command);

	if($kZoom::inVehicle) {
		// don't overwrite a bind that's alread being set in passengerKeys
		switch$(passengerKeys.getCommand($kZoom::device[%index], $kZoom::action[%index])) {
		case "":
		case %zoomedCommand:
		case %unzoomedCommand:
		case kZoomMapVehicleCommand(%zoomedCommand):
		case kZoomMapVehicleCommand(%unzoomedCommand):
		default:
			// it's bound to something else, so leave it alone
			return;
		}

		passengerKeys.bind($kZoom::device[%index], $kZoom::action[%index], kZoomMapVehicleCommand(%command));
	}
}

//-----------------------------------------------------------------------------

function kZoomBind(%device, %action, %zoomedCommand, %unzoomedCommand)
{
	$kZoom::device[$kZoom::numBinds] = %device;
	$kZoom::action[$kZoom::numBinds] = %action;
	$kZoom::zoomedCommand[$kZoom::numBinds] = %zoomedCommand;
	$kZoom::unzoomedCommand[$kZoom::numBinds] = %unzoomedCommand;

	kZoomApplyBind($kZoom::numBinds);
	$kZoom::numBinds++;
}

