// (c) 2001 David Gausebeck
// gausebec@paypal.com

$kZoom::numBinds = 0;

//-----------------------------------------------------------------------------

package KerbWeapon {

function clientCmdSetWeaponsHudActive(%slot)
{
	parent::clientCmdSetWeaponsHudActive(%slot);

	if(%slot >= 0 && $WeaponNames[%slot] !$= $kWeapon::currentWeapon) {
		$kWeapon::lastWeapon = $kWeapon::currentWeapon;
		$kWeapon::currentWeapon = $WeaponNames[%slot];
	}
}

//-----------------------------------------------------------------------------

function clientCmdSetWeaponsHudAmmo(%slot, %ammoAmount)
{
	parent::clientCmdSetWeaponsHudAmmo(%slot, %ammoAmount);

	switch$($WeaponNames[%slot]) {
	case "Mortar":
		$kWeapon::mortarEmpty = !%ammoAmount;
	case "GrenadeLauncher":
		$kWeapon::grenadeLauncherEmpty = !%ammoAmount;
	}
}

};

activatePackage(KerbWeapon);

//-----------------------------------------------------------------------------

function kWeaponLastWeapon(%keydown)
{
	if(%keydown)
		use($kWeapon::lastWeapon);
}

//-----------------------------------------------------------------------------

function kWeaponMortarPrep(%keydown)
{
	if(%keydown) {
		useTargetingLaser(1);
		$mvTriggerCount0++;
		schedule(1000, 0, kWeaponMortarPrep2);
	}
}

//-----------------------------------------------------------------------------

function kWeaponMortarPrep2()
{
	if($ZoomOn) {
		// try to unzoom
		toggleZoom(0);
		if($ZoomOn)
			// looks like the player has a zoom toggle, so try again
			toggleZoom(1);
	}
	$mvTriggerCount0++;
	
	// activate weapons in order of ascending preference, so the best option
	// is the final command
	kWeaponLastWeapon(1);
	if(!$kWeapon::grenadeLauncherEmpty)
		useGrenadeLauncher(1);
	if(!$kWeapon::mortarEmpty)
		useMortar(1);
}
