// (c) 2001 David Gausebeck
// gausebec@paypal.com

package KerbVehicleJoy {

function clientCmdSetDefaultVehicleKeys(%inVehicle)
{
	parent::clientCmdSetDefaultVehicleKeys(%inVehicle);

	if(%inVehicle) {
		$kVehicleJoy::jetting = 0;
		$kVehicleJoy::firing = 0;
	} else {
		if($kVehicleJoy::jetting) {
			$kVehicleJoy::jetting = 0;
			$mvTriggerCount3++;
		}

		if($kVehicleJoy::firing) {
			$kVehicleJoy::firing = 0;
			$mvTriggerCount0++;
		}
	}
}

//-----------------------------------------------------------------------------

function clientCmdVehicleDismount()
{
	parent::clientCmdVehicleDismount();

	if($kVehicleJoy::disable)
		return;

	if($kVehicleJoy::disableJoystickOutsideVehicle)
		disableJoystick();

	$mvFreeLook = 0;
	$mvForwardAction = 0;
	$mvBackwardAction = 0;
	$mvLeftAction = 0;
	$mvRightAction = 0;
}

//-----------------------------------------------------------------------------

function clientCmdSetPilotVehicleKeys()
{
	parent::clientCmdSetPilotVehicleKeys();

	if($kVehicleJoy::disable)
		return;

	enableJoystick();
	
	passengerKeys.bind(mouse0, "xaxis", S, moveMap.getScale(mouse0, "xaxis"), kVehicleJoyLookYaw);
	passengerKeys.bind(mouse0, "yaxis", moveMap.isInverted(mouse0, "yaxis")?"SI":"S", moveMap.getScale(mouse0, "yaxis"), kVehicleJoyLookPitch);
	passengerKeys.bind(joystick0, "xaxis", SD, "-0.1 0.1", 1, kVehicleJoyYaw);
	passengerKeys.bind(joystick0, "yaxis", SDI, "-0.1 0.1", 1, kVehicleJoyPitch);

	$mvForwardAction = 0;
	$mvBackwardAction = 0;
	$mvLeftAction = 0;
	$mvRightAction = 0;
	$targetYaw = 0;
	$targetPitch = 0;
	$targetBankPitch = 0;
	$currentYaw = 0;
	$currentRoll = 0;
}

//-----------------------------------------------------------------------------

function ClientCmdSetHudMode(%mode, %type, %node)
{
	parent::clientCmdSetHudMode(%mode, %type, %node);

	if($HudMode $= "Pilot") {
		switch$($HudModeType) {
		case "Shrike":
			$kVehicleJoy::autoStabilizeSpeed = 15;
			$kVehicleJoy::maxSteeringAngle = 2.5;
			$kVehicleJoy::yawPitchFactor = 0.75;
			$kVehicleJoy::rollPitchFactor = 0.25;
			$kVehicleJoy::aircraft = 1;
		case "Bomber":
			$kVehicleJoy::autoStabilizeSpeed = 15;
			$kVehicleJoy::maxSteeringAngle = 2.5;
			$kVehicleJoy::yawPitchFactor = 0.2;
			$kVehicleJoy::rollPitchFactor = 0.5;
			$aircraft = 1;
		case "HAPC":
			$kVehicleJoy::autoStabilizeSpeed = 10;
			$kVehicleJoy::maxSteeringAngle = 3;
			$kVehicleJoy::yawPitchFactor = 0.3;
			$kVehicleJoy::rollPitchFactor = 0.4;
			$aircraft = 1;
		default:
			$kVehicleJoy::autoStabilizeSpeed = 0;
			$kVehicleJoy::maxSteeringAngle = 0.77;
			$kVehicleJoy::aircraft = 0;
		}
	}
}

};

activatePackage(KerbVehicleJoy);

//-----------------------------------------------------------------------------

function kVehicleJoyYaw(%val)
{
	// account for the input damping of aircraft at slow speeds
	if(getControlObjectSpeed() < $kVehicleJoy::autoStabilizeSpeed)
		$kVehicleJoy::targetYaw *= 0.95;

	// set any high value to exactly 1, to make the scoop wider
	// for cleaning out accumulated errors below.
	if(%val > 0.9)
		%val = 1;
	if(%val < -0.9)
		%val = -1;

	// actual yaw tries to catch up to the target
	$kVehicleJoy::currentYaw += ($kVehicleJoy::targetYaw - $kVehicleJoy::currentYaw) * 0.1;

	// figure the new target yaw  
	%newTargetYaw = %val * $kVehicleJoy::maxSteeringAngle;

	if($kVehicleJoy::aircraft) {
		// actual roll follows actual yaw
		$kVehicleJoy::currentRoll *= 0.975;
		$kVehicleJoy::currentRoll += $kVehicleJoy::currentYaw/$kVehicleJoy::maxSteeringAngle * 0.025;

		// compensate for banking
		%rollPower = (%val - $kVehicleJoy::currentRoll) * $kVehicleJoy::maxSteeringAngle;
		if((($kVehicleJoy::currentYaw * %rollPower<0) && abs(%rollPower)>($kVehicleJoy::maxSteeringAngle*0.1))
		 || abs(%rollPower) < abs($kVehicleJoy::currentYaw))
			// base it on roll if we're rolling in the opposite direction we're yawing,
			// or if the vehicle is rolling harder than it's yawing.
			%newTargetBankPitch = -%rollPower * $kVehicleJoy::rollPitchFactor;
		else
			// otherwise base it on yaw
			%newTargetBankPitch = -$kVehicleJoy::currentYaw * $kVehicleJoy::yawPitchFactor;

		// scale and choose sign based on current roll angle
		%newTargetBankPitch *= $kVehicleJoy::currentRoll;

		// make sure we don't exceed the pitch the vehicle can handle
		if($kVehicleJoy::targetPitch + %newTargetBankPitch > $kVehicleJoy::maxSteeringAngle)
			%newTargetBankPitch = $kVehicleJoy::maxSteeringAngle - $kVehicleJoy::targetPitch;
		if($kVehicleJoy::targetPitch + %newTargetBankPitch < -$kVehicleJoy::maxSteeringAngle)
			%newTargetBankPitch = -$kVehicleJoy::maxSteeringAngle - $kVehicleJoy::targetPitch;
	}

	else
		$kVehicleJoy::targetBankPitch = %newTargetBankPitch = 0;

	if(abs(%newTargetYaw - $kVehicleJoy::targetYaw)/$kVehicleJoy::maxSteeringAngle > 0.01
	 || abs(%newTargetBankPitch - $kVehicleJoy::targetBankPitch)/$kVehicleJoy::maxSteeringAngle > 0.1)
	{
		// play nice with lookyaw/lookpitch and don't apply control unless
		// it's necessary
		$mvFreeLook = 0;

		// move yaw from old target to new target
		$mvYaw += %newTargetYaw - $kVehicleJoy::targetYaw;
		$kVehicleJoy::targetYaw = %newTargetYaw;
		
		// if we're supposed to be at max yaw, make sure we are.
		// this brushes away any accumulated errors during hard turns
		if(abs(%val) == 1)
			$mvYaw += (%val>0)?0.1:-0.1;

		// apply banking correction
		$mvPitch += %newTargetBankPitch - $kVehicleJoy::targetBankPitch;
		$kVehicleJoy::targetBankPitch = %newTargetBankPitch;
	}
}

//-----------------------------------------------------------------------------

function kVehicleJoyPitch(%val)
{
	// account for the input damping of aircraft at slow speeds
	if(getControlObjectSpeed() < $kVehicleJoy::autoStabilizeSpeed)
		$kVehicleJoy::targetPitch *= 0.95;

	// set any high value to exactly 1, to make the scoop wider
	// for cleaning out accumulated errors below.
	if(%val > 0.9)
		%val = 1;
	if(%val < -0.9)
		%val = -1;

	// figure the new target Pitch  
	%newTargetPitch = %val * $kVehicleJoy::maxSteeringAngle;

	if(abs(%newTargetPitch - $kVehicleJoy::targetPitch)/$kVehicleJoy::maxSteeringAngle > 0.01) {
		// play nice with lookyaw/lookpitch and don't apply control unless
		// it's necessary
		$mvFreeLook = 0;

		// move pitch from old target to new target
		$mvPitch += %newTargetPitch - $kVehicleJoy::targetPitch;
		$kVehicleJoy::targetPitch = %newTargetPitch;
	
		// if we're supposed to be at max pitch, make sure we are.
		// this brushes away any accumulated errors during hard turns
		if(abs(%val) == 1)
			$mvPitch += (%val>0)?0.1:-0.1;
	}
}

//-----------------------------------------------------------------------------

function kVehicleJoyLookYaw(%val)
{
	// don't try to freelook when the vehicle is turning
	if(%val && abs($kVehicleJoy::targetPitch)/$kVehicleJoy::maxSteeringAngle < 0.1
		&& abs($kVehicleJoy::targetYaw)/$kVehicleJoy::maxSteeringAngle < 0.1
		&& abs($kVehicleJoy::targetBankPitch)/$kVehicleJoy::maxSteeringAngle < 0.1)
	{
		$mvFreeLook = 1;
		$mvYaw += getMouseAdjustAmount(%val);
	}
}

//-----------------------------------------------------------------------------

function kVehicleJoyLookPitch(%val)
{
	// don't try to freelook when the vehicle is turning
	if(%val && abs($kVehicleJoy::targetPitch)/$kVehicleJoy::maxSteeringAngle < 0.1
		&& abs($kVehicleJoy::targetYaw)/$kVehicleJoy::maxSteeringAngle < 0.1
		&& abs($kVehicleJoy::targetBankPitch)/$kVehicleJoy::maxSteeringAngle < 0.1)
	{
		$mvFreeLook = 1;
		$mvPitch += getMouseAdjustAmount(%val);
	}
}

//-----------------------------------------------------------------------------

function kVehicleJoyJet(%keydown)
{
	if(%keydown ^ $kVehicleJoy::jetting) {
		$kVehicleJoy::jetting ^= 1;
		$mvTriggerCount3++;
	}
}

//-----------------------------------------------------------------------------

function kVehicleJoyFire(%keydown)
{
	if(%keydown ^ $kVehicleJoy::firing) {
		$kVehicleJoy::firing ^= 1;
		$mvTriggerCount0++;
	}
}