// (c) 2001 David Gausebeck
// gausebec@paypal.com

$kReticle::mortarTangent[0] = 0.1227;
$kReticle::mortarTangent[1] = 0.1547;
$kReticle::mortarTangent[2] = 0.1877;
$kReticle::mortarTangent[3] = 0.2220;
$kReticle::mortarTangent[4] = 0.2578;
$kReticle::mortarTangent[5] = 0.2958;
$kReticle::mortarTangent[6] = 0.3364;
$kReticle::mortarTangent[7] = 0.3806;
$kReticle::mortarTangent[8] = 0.4296;
$kReticle::mortarTangent[9] = 0.4854;
$kReticle::mortarTangent[10] = 0.5520;
$kReticle::mortarTangent[11] = 0.6376;
$kReticle::mortarTangent[12] = 0.7708;

$kReticle::tankMortarTangent[0] = 0.1177;
$kReticle::tankMortarTangent[1] = 0.1483;
$kReticle::tankMortarTangent[2] = 0.1798;
$kReticle::tankMortarTangent[3] = 0.2123;
$kReticle::tankMortarTangent[4] = 0.2463;
$kReticle::tankMortarTangent[5] = 0.2820;
$kReticle::tankMortarTangent[6] = 0.3199;
$kReticle::tankMortarTangent[7] = 0.3608;
$kReticle::tankMortarTangent[8] = 0.4056;
$kReticle::tankMortarTangent[9] = 0.4556;
$kReticle::tankMortarTangent[10] = 0.5135;
$kReticle::tankMortarTangent[11] = 0.5837;
$kReticle::tankMortarTangent[12] = 0.6776;
$kReticle::tankMortarTangent[13] = 0.8493;

$kReticle::grenadeLauncherTangent[0] = 0.1124;
$kReticle::grenadeLauncherTangent[1] = 0.1714;
$kReticle::grenadeLauncherTangent[2] = 0.2342;
$kReticle::grenadeLauncherTangent[3] = 0.3030;
$kReticle::grenadeLauncherTangent[4] = 0.3816;
$kReticle::grenadeLauncherTangent[5] = 0.4770;
$kReticle::grenadeLauncherTangent[6] = 0.6086;
$kReticle::grenadeLauncherTangent[7] = 0.9610;

//-----------------------------------------------------------------------------

package KerbReticle {

function DispatchLaunchMode() {
	parent::DispatchLaunchMode();

	playgui.add(kMortarReticle);
	playgui.add(kGrenadeLauncherReticle);
}

//-----------------------------------------------------------------------------

function ClientCmdSetHudMode(%mode, %type, %node)
{
	parent::clientCmdSetHudMode(%mode, %type, %node);

	switch$($HudMode) {
	case "Standard":
		if($kReticle::blocked && $kReticle::mortarActive)
			kReticleShowMortar(1);
		if($kReticle::blocked && $kReticle::grenadeLauncherActive)
			kReticleShowGrenadeLauncher(1);
		$kReticle::blocked = 0;
	case "Pilot":
		if($kReticle::blocked && $kReticle::mortarActive)
			kReticleShowMortar(1);
		$kReticle::blocked = 0;
	default:
		kReticleShowMortar(0);
		kReticleShowGrenadeLauncher(0);
		$kReticle::blocked = 1;
	}
}

//-----------------------------------------------------------------------------

function clientCmdSetWeaponsHudActive(%slot)
{
	parent::clientCmdSetWeaponsHudActive(%slot);

	if(%slot == -1)
		kReticleDeactivate();
	else
		switch$($WeaponNames[%slot]) {
		case "GrenadeLauncher":
			kReticleActivateGrenadeLauncher();
		case "Mortar":
			kReticleActivateMortar(1);
		}
}

//-----------------------------------------------------------------------------

function clientCmdSetVWeaponsHudActive(%num, %vType)
{
	parent::clientCmdSetVWeaponsHudActive(%num, %vType);

	if(%vType $= "AssaultVehicle") {
		if(%num == 2)
			kReticleActivateMortar(2);
		else
			kReticleDeactivate();
	}
}

//-----------------------------------------------------------------------------

function clientCmdSetDefaultVehicleKeys(%inVehicle)
{
	parent::clientCmdSetDefaultVehicleKeys(%inVehicle);

	if(!%inVehicle && $kReticle::tankMortar)
		kReticleDeactivate();
}

//-----------------------------------------------------------------------------

function toggleZoom(%keydown)
{
	parent::toggleZoom(%keydown);

	kReticleOnChangeFOV();
}

//-----------------------------------------------------------------------------

function setZoomFOV(%keydown)
{
	parent::setZoomFOV(%keydown);
	
	if($ZoomOn)
		kReticleOnChangeFOV();
}

};

activatePackage(KerbReticle);

//-----------------------------------------------------------------------------

function kReticleOnChangeFOV()
{
	if($kReticle::mortarActive)
		kReticleActivateMortar();
	if($kReticle::grenadeLauncherActive)
		kReticleActivateGrenadeLauncher();
}

//-----------------------------------------------------------------------------

function kReticleShowMortar(%on)
{
	reticleHud.setVisible(!%on);
	reticleFrameHud.setVisible(!%on);
	kMortarReticle.setVisible(%on);
}

//-----------------------------------------------------------------------------

function kReticleActivateMortar(%mortarType)
{
	kMortarReticle.position = getword($pref::Video::resolution, 0)/2-50 @ " " @ getword($pref::Video::resolution, 1)/2-1;
	kMortarReticle.extent = "100 " @ getword($pref::Video::resolution, 1)/2+1;

	switch(%mortarType) {
	case 1:
		$kReticle::tankMortar = 0;
	case 2:
		$kReticle::tankMortar = 1;
	}
	
	%scaleFactor = 0.5 * getword($pref::Video::resolution, 0) /
	 mTan(($ZoomOn?$pref::player::currentFOV:$pref::player::defaultFOV) * 0.0087266);
	
	%currentY = mFloor(($kReticle::tankMortar?$kReticle::tankMortarTangent[0]:$kReticle::mortarTangent[0]) * %scaleFactor + 0.5);
	kMortarLine0.extent = "2 " @ %currentY-17;
	kMortarRange0.position = "34 " @ %currentY-5;

	for(%i = 1; %i < ($kReticle::tankMortar?14:13); %i++) {
		%lastY = %currentY;
		%currentY = mFloor(($kReticle::tankMortar?$kReticle::tankMortarTangent[%i]:$kReticle::mortarTangent[%i]) * %scaleFactor + 0.5);
		(kMortarLine @ %i).position = "49 " @ %lastY+3;
		(kMortarLine @ %i).extent = "2 " @ %currentY-%lastY-7;
		(kMortarRange @ %i).position = "34 " @ %currentY-5;
	}

	kMortarLine13.setVisible($kReticle::tankMortar);
	kMortarRange13.setVisible($kReticle::tankMortar);

	%lastY = %currentY;
	kMortarLine14.position = "49 " @ %lastY+3;

	$kReticle::mortarActive = 1;
	if(!$kReticle::blocked)
		kReticleShowMortar(1);
}

//-----------------------------------------------------------------------------

function kReticleShowGrenadeLauncher(%on)
{
	reticleHud.setVisible(!%on);
	reticleFrameHud.setVisible(!%on);
	kGrenadeLauncherReticle.setVisible(%on);
}

//-----------------------------------------------------------------------------

function kReticleActivateGrenadeLauncher()
{
	kGrenadeLauncherReticle.position = getword($pref::Video::resolution, 0)/2-50 @ " " @ getword($pref::Video::resolution, 1)/2-1;
	kGrenadeLauncherReticle.extent = "100 " @ getword($pref::Video::resolution, 1)/2+1;

	%scaleFactor = 0.5 * getword($pref::Video::resolution, 0) /
	 mTan(($ZoomOn?$pref::player::currentFOV:$pref::player::defaultFOV) * 0.0087266);
	
	%currentY = mFloor($kReticle::grenadeLauncherTangent[0] * %scaleFactor + 0.5);
	kGrenadeLauncherLine0.extent = "2 " @ %currentY-17;
	kGrenadeLauncherRange0.position = "34 " @ %currentY-5;

	for(%i = 1; %i < 8; %i++) {
		%lastY = %currentY;
		%currentY = mFloor($kReticle::grenadeLauncherTangent[%i] * %scaleFactor + 0.5);
		(kGrenadeLauncherLine @ %i).position = "49 " @ %lastY+3;
		(kGrenadeLauncherLine @ %i).extent = "2 " @ %currentY-%lastY-7;
		(kGrenadeLauncherRange @ %i).position = "34 " @ %currentY-5;
	}
	
	%lastY = %currentY;
	kGrenadeLauncherLine8.position = "49 " @ %lastY+3;

	reticleHud.setVisible(0);
	reticleFrameHud.setVisible(0);
	$kReticle::grenadeLauncherActive = 1;
	if(!$kReticle::blocked)
		kReticleShowGrenadeLauncher(1);
}

//-----------------------------------------------------------------------------

function kReticleDeactivate()
{
	kReticleShowMortar(0);
	kReticleShowGrenadeLauncher(0);
	$kReticle::mortarActive = 0;
	$kReticle::grenadeLauncherActive = 0;
}

//-----------------------------------------------------------------------------

new ShellFieldCtrl(kMortarReticle) {
	profile = "GuiDefaultProfile";
	visible = "0";

	new GuiBitmapCtrl(kMortarTop) {
		profile = "GuiDefaultProfile";
		position = "33 0";
		visible = "1";
		extent = "34 13";
		opacity = "0.5";
		bitmap = "gui/kRET_mortarTop.png";
	};

	new GuiBitmapCtrl(kMortarLine0) {
		profile = "GuiDefaultProfile";
		position = "49 13";
		visible = "1";
		bitmap = "gui/kRET_mortarLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kMortarRange0) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		opacity = "0.5";
		bitmap = "gui/kRET_mortar100.png";
	};

	new GuiBitmapCtrl(kMortarLine1) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_mortarLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kMortarRange1) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_mortar125.png";
	};

	new GuiBitmapCtrl(kMortarLine2) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_mortarLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kMortarRange2) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_mortar150.png";
	};

	new GuiBitmapCtrl(kMortarLine3) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_mortarLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kMortarRange3) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_mortar175.png";
	};

	new GuiBitmapCtrl(kMortarLine4) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_mortarLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kMortarRange4) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_mortar200.png";
	};

	new GuiBitmapCtrl(kMortarLine5) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_mortarLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kMortarRange5) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_mortar225.png";
	};

	new GuiBitmapCtrl(kMortarLine6) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_mortarLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kMortarRange6) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_mortar250.png";
	};

	new GuiBitmapCtrl(kMortarLine7) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_mortarLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kMortarRange7) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_mortar275.png";
	};

	new GuiBitmapCtrl(kMortarLine8) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_mortarLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kMortarRange8) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_mortar300.png";
	};

	new GuiBitmapCtrl(kMortarLine9) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_mortarLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kMortarRange9) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_mortar325.png";
	};

	new GuiBitmapCtrl(kMortarLine10) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_mortarLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kMortarRange10) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_mortar350.png";
	};

	new GuiBitmapCtrl(kMortarLine11) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_mortarLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kMortarRange11) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_mortar375.png";
	};

	new GuiBitmapCtrl(kMortarLine12) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_mortarLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kMortarRange12) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_mortar400.png";
	};

	new GuiBitmapCtrl(kMortarLine13) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_mortarLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kMortarRange13) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_mortar425.png";
	};

	new GuiBitmapCtrl(kMortarLine14) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "2 1000";
		minExtent = "2 1000";
		bitmap = "gui/kRET_mortarLine.png";
		autoResize = "1";
	};
};

//-----------------------------------------------------------------------------

new ShellFieldCtrl(kGrenadeLauncherReticle) {
	profile = "GuiDefaultProfile";
	visible = "0";

	new GuiBitmapCtrl(kGrenadeLauncherTop) {
		profile = "GuiDefaultProfile";
		position = "33 0";
		visible = "1";
		extent = "34 13";
		opacity = "0.5";
		bitmap = "gui/kRET_grenadeTop.png";
	};

	new GuiBitmapCtrl(kGrenadeLauncherLine0) {
		profile = "GuiDefaultProfile";
		position = "49 13";
		visible = "1";
		bitmap = "gui/kRET_grenadeLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kGrenadeLauncherRange0) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_grenade50.png";
	};

	new GuiBitmapCtrl(kGrenadeLauncherLine1) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_grenadeLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kGrenadeLauncherRange1) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_grenade75.png";
	};

	new GuiBitmapCtrl(kGrenadeLauncherLine2) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_grenadeLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kGrenadeLauncherRange2) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		opacity = "0.5";
		bitmap = "gui/kRET_grenade100.png";
	};

	new GuiBitmapCtrl(kGrenadeLauncherLine3) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_grenadeLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kGrenadeLauncherRange3) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_grenade125.png";
	};

	new GuiBitmapCtrl(kGrenadeLauncherLine4) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_grenadeLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kGrenadeLauncherRange4) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_grenade150.png";
	};

	new GuiBitmapCtrl(kGrenadeLauncherLine5) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_grenadeLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kGrenadeLauncherRange5) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_grenade175.png";
	};

	new GuiBitmapCtrl(kGrenadeLauncherLine6) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_grenadeLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kGrenadeLauncherRange6) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_grenade200.png";
	};

	new GuiBitmapCtrl(kGrenadeLauncherLine7) {
		profile = "GuiDefaultProfile";
		visible = "1";
		bitmap = "gui/kRET_grenadeLine.png";
		autoResize = "1";
	};

	new GuiBitmapCtrl(kGrenadeLauncherRange7) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "62 9";
		bitmap = "gui/kRET_grenade225.png";
	};

	new GuiBitmapCtrl(kGrenadeLauncherLine8) {
		profile = "GuiDefaultProfile";
		visible = "1";
		extent = "2 1000";
		minExtent = "2 1000";
		bitmap = "gui/kRET_grenadeLine.png";
		autoResize = "1";
	};
};
