// (c) 2001 David Gausebeck
// gausebec@paypal.com

package KerbJump {

function ClientCmdSetHudMode(%mode, %type, %node)
{
	parent::clientCmdSetHudMode(%mode, %type, %node);

	if($HudMode $= "Pilot")
		$kJump::piloting = 1;
	else
		$kJump::piloting = 0;

	if($kJump::skiing)
		kJumpSkiToggle(1);
}

//-----------------------------------------------------------------------------

function clientCmdSetDefaultVehicleKeys(%inVehicle)
{
	parent::clientCmdSetDefaultVehicleKeys(%inVehicle);

	passengerKeys.copyBind(moveMap, kJumpSkiToggle);
}

//-----------------------------------------------------------------------------

function mouseJet(%keydown)
{
	if($kJump::disableJumpJet) {
		parent::mouseJet(%keydown);
		return;
	}

	$mvTriggerCount3++;
	if(%keydown && !$kJump::piloting) {
		jump(1);
		schedule(100, 0, jump, 0);
	}
}

};

activatePackage(KerbJump);

//-----------------------------------------------------------------------------

function kJumpSkiToggle(%keydown)
{
	if(%keydown) {
		$kJump::skiing ^= 1;
		$mvTriggerCount2++;
		if($kJump::skiing)
			clientCmdBottomPrint("AutoSki ON", 0, 1);
		else
			clientCmdBottomPrint("AutoSki OFF", 1, 1);
	}
}
