// (c) 2001 David Gausebeck
// gausebec@paypal.com

package KerbGrenade {

function DispatchLaunchMode() {
	parent::DispatchLaunchMode();

	kGrenadePrime();
}

//-----------------------------------------------------------------------------

function clientCmdSetInventoryHudAmount(%slot, %amount)
{
	parent::clientCmdSetInventoryHudAmount(%slot, %amount);

	if(%slot == 0)
		kGrenadePrime();
}

//-----------------------------------------------------------------------------

function throwGrenade(%keydown)
{
	if($kGrenade::disable)
		parent::throwGrenade(%keydown);
	else if(%keydown && !$kGrenade::blocked) {
		commandToServer('endThrowCount');
		$mvTriggerCount4++;
		// don't allow another throw for .8 seconds, because it wouldn't go off
		// anyway and it will mess up the priming
		$kGrenade::blocked = 1;
		schedule(800, 0, kGrenadeUnblock);
	}
}

};

activatePackage(KerbGrenade);

//-----------------------------------------------------------------------------

function kGrenadeUnblock()
{
	$kGrenade::blocked = 0;
}

//-----------------------------------------------------------------------------

function kGrenadePrime()
{
	if($kGrenade::disable)
		return;

	commandToServer('startThrowCount');
	if(!($mvTriggerCount4 & 1))
		$mvTriggerCount4++;
}
