// (c) 2001 David Gausebeck
// gausebec@paypal.com

// edit this file to configure all the kXXX.cs scripts

// set this to 1 if you don't have a joystick or don't want to
// use joystick for vehicle control
$kVehicleJoy::disable = 0;

// set this if you want your joystick to only work for vehicle
// control and to be disabled at other times
$kVehicleJoy::disableJoystickOutsideVehicle = 0;

// set this to 1 if you don't want to use the kGrenadeThrow
// script for max range hand grenades and you don't want it
// messing up your normal grenade throws
$kGrenade::disable = 0;

// set this to 1 if you don't want kJump to replace your mouseJet
// function with one that jumps first
$kJump::disableJumpJet = 0;

// set this to 1 if you want toggleZoom to only toggle zoom
// on/off when you press the key, rather than the default behavior
// of zooming on keypress, unzooming on release
$kZoom::zoomToggle = 0;

// change this value if you want to change the speed at which
// your zoom level changes.  smaller numbers mean smoother changes,
// down to 1 which means no change.
$kZoom:zoomFactor = 2;

// set this to a particular FOV (e.g. 30) if you want your zoom
// level reset to that FOV each time you zoom in.  0 (the default)
// means don't reset FOV, just use whatever you were last zoomed
// to.
$kZoom::resetFOV = 0;

// this is a list of bindings to various script commands.
// uncomment any of the ones you want to use and change the
// bindings appropriately.  the format for a bind command
// is (device, action, command), where device is keyboard0,
// mouse0, or joystick0, and action is the name of an action
// on that device.  Keyboard actions are the name of the key
// like "shift k" or "tab".  Mouse and joystick buttons start
// at "button0" and count upwards.  Joystick hat controls
// are "upov", "dpov", "rpov", and "lpov".

// change zoom level with mousewheel
//moveMap.bind(mouse0, "zaxis", kZoomAxis);

// toggle skiing
//moveMap.bind(keyboard0, "space", kJumpSkiToggle);

// prep for a mortar shot (see kReadme.txt for details)
//moveMap.bind(keyboard0, "l", kWeaponMortarPrep);

package KerbConfig {

function DispatchLaunchMode()
{
	parent::DispatchLaunchMode();

	// kZoomBind calls have to go here, because this location
	// guarantees they'll get executed after kZoom.cs has been
	// run.  For example:

	// this will bind your mousewheel to change weapons when
	// unzoomed, or change zoom levels when zoomed
	//kZoomBind(mouse0, "zaxis", kZoomAxis, cycleWeaponAxis);
}

function clientCmdSetPilotVehicleKeys()
{
	parent::clientCmdSetPilotVehicleKeys();

	// add or change bindings here if you want different keys bound
	// when you're piloting a vehicle.  note that all the binds
	// here have to be done on the object passengerKeys instead of
	// the normal moveMap.

	// the defaults here bind the first and second joystick
	// buttons to fire and jet respectively, but they do so using
	// special functions from kVehicleJoy.cs which make sure your
	// trigger(s) won't get stuck when you leave the vehicle.

	passengerKeys.bind(joystick0, "button0", kVehicleJoyFire);
	passengerKeys.bind(joystick0, "button1", kVehicleJoyJet);
}

};

activatePackage(KerbConfig);
