// #autoload
// #name = Incoming
// #version = 1.4...late alpha
// #status = release
// #author = Matt Menegay
// #warrior = xpdnc
// #credit = Not incredibly streamlined, but it's my first attempt at coding in T2++.

// #include = support/menu_system.cs

if(!isObject(incomingMenu))
{
	new ScriptObject(incomingMenu)
	{
		class = incomingMenu;

		keyList = false;
	};
}

package incomingMenuPackage
   {
	function DispatchLaunchMode()
	{
		parent::DispatchLaunchMode();
	
		incomingMenu.setup();
	}
	
	function incomingMenu::setup()
	{
		MS::NewMenu("Incoming:Choose Type");
		MS::AddChoice("Incoming:Choose Type", "numpad4", "Capper", "incomingMenu.selectCapper();");
		MS::AddChoice("Incoming:Choose Type", "numpad5", "Heavy Offense", "incomingMenu.selectHO();");
		MS::AddChoice("Incoming:Choose Type", "numpad6", "Shrike", "incomingMenu.selectShrike();");
		MS::AddChoice("Incoming:Choose Type", "numpad8", "Bomber", "incomingMenu.selectBomber();");
		
	}		

	function incomingMenuOpen(%val)
	{
		if(%val)
			MS::Display("Incoming:Choose Type");
	}
	
	function OptionsDlg::onWake(%this)
	{
		if(!incomingMenu.keyList)
		{
			$RemapName[$RemapCount]="\c5incomingMenu";
			$RemapCmd[$RemapCount]="incomingMenuOpen";
			$RemapCount++;	
			
			incomingMenu.keyList = true;
		}
		
		parent::onWake(%this);
	}
	
	function incomingMenu::selectCapper()
	{
	%showType = "capper(s)";
	incomingMenu.displayNumber();
	}
	
	function incomingMenu::selectHO()
	{
	%showType = "HO";
	incomingMenu.displayNumber();
	}
	
	function incomingMenu::selectShrike()
	{
	%showType = "shrike(s)";
	incomingMenu.displayNumber();
	}
	
	function incomingMenu::selectBomber()
	{
	%showType = "bomber(s)";
	incomingMenu.displayNumber();
	}
	
	function incomingMenu::displayNumber()
	{
	MS::NewMenu("Incoming:Choose Number");
	MS::AddChoice("Incoming:Choose Number", "numpad1", "1", "incomingMenu.selectOne();");
	MS::AddChoice("Incoming:Choose Number", "numpad2", "2", "incomingMenu.selectTwo();");
	MS::AddChoice("Incoming:Choose Number", "numpad3", "3", "incomingMenu.selectThree();");
	MS::AddChoice("Incoming:Choose Number", "numpad4", "4", "incomingMenu.selectFour();");
	MS::AddChoice("Incoming:Choose Number", "numpad5", "5", "incomingMenu.selectFive();");
	MS::Display("Incoming:Choose Number");	
	}

	function incomingMenu::selectOne()
	{
	%showNumber = "1";
	incomingMenu.displayDirection();
	}
	
	function incomingMenu::selectTwo()
	{
	%showNumber = "2";
	incomingMenu.displayDirection();
	}
	
	function incomingMenu::selectThree()
	{
	%showNumber = "3";
	incomingMenu.displayDirection();
	}
	
	function incomingMenu::selectFour()
	{
	%showNumber = "4";
	incomingMenu.displayDirection();
	}

	function incomingMenu::selectFive()
	{
	%shownumber = "5";
	incomingMenu.displayDirection();
	}
	
	function incomingMenu::displayDirection()
	{

	MS::NewMenu("Incoming:Choose Direction");
	MS::AddChoice("Incoming:Choose Direction", "numpad8", "North", "incomingMenu.selectN();");
	MS::AddChoice("Incoming:Choose Direction", "numpad2", "South", "incomingMenu.selectS();");
	MS::AddChoice("Incoming:Choose Direction", "numpad6", "East", "incomingMenu.selectE();");
	MS::AddChoice("Incoming:Choose Direction", "numpad4", "West", "incomingMenu.selectW();");
	MS::AddChoice("Incoming:Choose Direction", "numpad7", "North West", "incomingMenu.selectNW();");
	MS::AddChoice("Incoming:Choose Direction", "numpad9", "North East", "incomingMenu.selectNE();");
	MS::AddChoice("Incoming:Choose Direction", "numpad1", "South West", "incomingMenu.selectSW();");
	MS::AddChoice("Incoming:Choose Direction", "numpad3", "South East", "incomingMenu.selectSE();");
	MS::Display("Incoming:Choose Direction");
	
	}	
	
	function incomingMenu::selectN()
	{
	%showDir = "North!";
	incomingMenu.displayMessage();
	}
	
	function incomingMenu::selectS()
	{
	%showDir = "South!";
	incomingMenu.displayMessage();
	}

	function incomingMenu::selectE()
	{
	%showDir = "East!";
	incomingMenu.displayMessage();
	}
	
	function incomingMenu::selectW()
	%showDir = "West!";
	incomingMenu.displayMessage();
	}

	function incomingMenu::selectNW()
	{
	%showDir = "North West!";
	incomingMenu.displayMessage();
	}
	
	function incomingMenu::selectNE()
	{
	%showDir = "North East!";
	incomingMenu.displayMessage();
	}

	function incomingMenu::selectSW()
	{
	%showDir = "South West!";
	incomingMenu.displayMessage();
	}

	function incomingMenu::selectSE()
	{
	%showDir = "South East!";
	incomingMenu.displayMessage();
	}

	function incomingMenu::displayMessage()
	{
	%message = "" @ %showNumber @ " incoming " @ %showType @ ": " @ %showDir @ "~wwrn.enemy";
	commandToServer('TeamMessageSent', %message);
	}
   }
}; // end package
activatePackage(incomingMenuPackage);
