// Copyright 2001 by Dave Rickey, aka Abuse Magnet.  Use of this script is
// at your own risk, no warranty is offered or implied.  This script may be freely
// used in association with playing Tribes 2, and modified as need for that purpose
// for personal use.  All other use or modification (for example, as part of another
// script) is prohibited.  It may be freely duplicated and distributed, as long as this
// disclaimer remains included.

// This script is intended as a work-around for some of the problems T2 has
// with Joystick control.  T2 movement control has only two states, on and off.
// For certain functions, this is completely inadequate, especially for flight.
// This "time shares" full on movement, making things like airborne "loitering"
// on bombing runs possible.

function abThrottle(%val) {

//    To make this work with a standard joystick and Kerberos's kVehicleJoy, put 
// passengerKeys.bind(joystick0, "zaxis", SD, "-0.2 0.2", 1, abThrottle); 
// in your kConfig.cs or MyConfig.cs
echo(%val);

if ($abForwardTrack > 5) $abForwardTrack = 1;	 // if it's greater than 5, reset)
if ($abBackwardTrack > 5) $abBackwardTrack = 1;

if ( %val == 0.0 ) 
{
	$abMoveForward = 6;
	$abMoveBackward = 6;	 // we're in the dead zone, so set them both to 6
}

if ( %val <= -0.9 ) 
{
	$abMoveForward = 0;
	$abMoveBackward = 6; 	// full out forward
}

if ( %val >= 0.9 ) 
{
	$abMoveForward = 6;
	$abMoveBackward = 0;	 // full out backward
}


// There's probably a much cleaner way to write these. They essentially
// just check for a state of %val and set how much of the time we'll spend 
// moving accordingly. More resolution would be nice, but it's
// an improvement and odd things happen when longer cycles are used.


if ( (%val >= 0.75) && (%val < 0.9) ) 
{
	$abMoveForward = 6;
	$abMoveBackward = 1; 
}

if ( (%val >= 0.6) && (%val < 0.75) ) 
{
	$abMoveForward = 6; 
	$abMoveBackward = 2;
}

if ( (%val >= 0.45) && (%val < 0.6) ) 
{
	$abMoveForward = 6;
	$abMoveBackward = 3;
}

if ( (%val >= 0.01) && (%val < 0.45) )	// extra to allow for different dead zone settings
{
	$abMoveForward = 6;
	$abMoveBackward = 4;
}

if ( (%val <= -0.75) && (%val > -0.9) ) 
{
	$abMoveForward = 1;
	$abMoveBackward = 6;
}

if ( (%val <= -0.6) && (%val > -0.75) ) 
{
	$abMoveForward = 2;
	$abMoveBackward = 6;
}

if ( (%val <= -0.45) && (%val > -0.6) ) 
{
	$abMoveForward = 3;
	$abMoveBackward = 6;
}

if ( (%val <= -0.01) && (%val > -0.45) )	// extra to allow for different dead zone settings
{
	$abMoveForward = 4;
	$abMoveBackward = 6;
}
echo($abMoveForward);
echo($abMoveBackward);

$mvForwardAction = ( $abForwardTrack > $abMoveForward );
$mvBackwardAction = ( $abBackwardTrack > $abMoveBackward );

$abForwardTrack++;	// since we increment after everything else, these numbers can
$abBackwardTrack++;	// be 6 here. If it is, it will get caught when we enter up top.

}


function abJoystickMoveY(%val) {

//    To make this work with a standard joystick, put 
// moveMap.bind(joystick0, "yaxis", SD, "-0.2 0.2", 1, abJoystickMoveY); 
// in your MyConfig.cs.  This is *only* if you want to use the joystick for
// your normal view navigation control.  This will give you a "slow movement"
// mode of about 1/3 running speed when your stick is less than half over.

if ($abForwardTrack > 5) $abForwardTrack = 1;	 // if it's greater than 5, reset)
if ($abBackwardTrack > 5) $abBackwardTrack = 1;

if ( %val == 0.0 ) 
{
	$abMoveForward = 6;
	$abMoveBackward = 6;	 // we're in the dead zone, so set them both to 6
}


if ( %val < -0.5 ) 
{
	$abMoveForward = 0;
	$abMoveBackward = 6; 	// full out forward

}

if ( %val > 0.5 ) 
{
	$abMoveForward = 6;
	$abMoveBackward = 0;	 // full out backward
}

if ( (%val > 0.01) && (%val < 0.5) ) 
{
	$abMoveForward = 6;
	$abMoveBackward = 3;
}

if ( (%val < -0.01) && (%val > -0.5) ) 
{
	$abMoveForward = 3;
	$abMoveBackward = 6;
}

$mvForwardAction = ( $abForwardTrack >= $abMoveForward );
$mvBackwardAction = ( $abBackwardTrack >= $abMoveBackward );

$abForwardTrack++;	// since we increment after everything else, these numbers can
$abBackwardTrack++;	// be 6 here. If it is, it will get caught when we enter up top.

}

function abJoystickMoveX(%val) {

//    To make this work with a standard joystick, put 
// moveMap.bind(joystick0, "xaxis", SD, "-0.2 0.2", 1, abJoystickMoveX); 
// in your MyConfig.cs.  This is *only* if you want to use the joystick for
// your normal navigation control.  This will give you a "slow movement"
// mode of about 1/3 running speed when your stick is less than half over.

if ($abLeftTrack > 5) $abLeftTrack = 1;	 // if it's greater than 5, reset)
if ($abRightTrack > 5) $abRightTrack = 1;

if ( %val == 0.0 ) 
{
	$abMoveLeft = 6;
	$abMoveRight = 6;	 // we're in the dead zone, so set them both to 6
}


if ( %val < -0.5 ) 
{
	$abMoveLeft = 0;
	$abMoveRight = 6; 	// full out Left

}

if ( %val > 0.5 ) 
{
	$abMoveLeft = 6;
	$abMoveRight = 0; 	 // full out Right
}

if ( (%val > 0.01) && (%val < 0.5) ) 
{
	$abMoveLeft = 6;
	$abMoveRight = 3;
}

if ( (%val < -0.01) && (%val > -0.5) ) 
{
	$abMoveLeft = 3;
	$abMoveRight = 6;
}

$mvLeftAction = ( $abLeftTrack >= $abMoveLeft );
$mvRightAction = ( $abRightTrack >= $abMoveRight );

$abLeftTrack++;		// since we increment after everything else, these numbers can
$abRightTrack++;		// be 6 here. If it is, it will get caught when we enter up top.

}

