// WegBert's Zoom HUD Thingy

// -- Sensitivity to be used when Zoom Hud is displayed
// Set to 0 to disable changing of sensitivity
// This number should (probably?) be from 0 - 2 (It might be able to be higher...)
// If you use a decimal number, MAKE SURE YOU PUT A 0 IN FRONT!
// Default: 0
$WegZoomHud::ZoomSens = 0;

// -- Toggle zoom hud?
// If set to 1, the zoom hud toggle key will turn the hud on and off. If set to 0, holding the key
// down will turn the hud on, letting go will turn it off.
$WegZoomHud::KeyToggle = "true";

// -- Use WegZoom
// If you have WegZoom.cs installed and set this to "true", your mousewheel will be set up to zoom in/out
// WegZoom style. Heavily Recommended.
// Default: "true" (but it shouldn't matter if you don't have the script)
$WegZoomHud::UseWegZoom = "true";

// -- Frame Width/Height Ratio
// This value is multiplied by your current screen width/height to generate the width/height of the Zoom Hud.
// Default: 0.25 (1/4 of the width/height of your screen -> 1/16 of your screen)
$WegZoomHud::FramePercentage = 0.25;


//$WegZoomHud::FrameWidth = 320;
//$WegZoomHud::FrameHeight = 240;

//function WegZoomHudBeginMove(%val) {
//	if (!%val)
//		return;
//
//	$WegZoomHud_MoveHudOn = !$WegZoomHud_MoveHudOn;
//
//	if (!$WegZoomHud_MoveHudOn) // Turning hud on
//	{
//		CursorOn();	
//	}
//	else
//	{
//		CursorOff();
//	}
//}

function WegZoomHudToggle(%val) {
	// Don't let the user toggle the zoom hud when zoomed full-screen...it's silly.
	if ($ZoomOn)
		return;

	if ($WegZoomHud::KeyToggle $= "true")
	{
		if (!%val)
			return;

		$WegZoomHud_On = !$WegZoomHud_On;
	}
	else
	{
		$WegZoomHud_On = %val;
	}

	WegZoomHud.ToggleVisible($WegZoomHud_On);

	if ($WegZoomHud::UseWegZoom $= "true")
	{
		WegPerformMouseWheelRebind(!$ZoomOn && $WegZoomHud_On);
	}
}

function WegChangeSensitivity(%xSens, %ySens)
{
	moveMap.bind( mouse, xaxis, "S", %xSens, "yaw" );
	%yFlags = moveMap.isInverted(mouse, yaxis) ? "SI" : "S";
	moveMap.bind( mouse, yaxis, %yFlags, %ySens, "pitch" );
}

function WegZoomHud::ToggleVisible(%this, %toggle)
{
	%this.setVisible(%toggle);

	if ($WegZoomHud::ZoomSens > 0)
	{
		if (%toggle) // Displaying -> New sens
		{
			$WegZoomHud::PrevSensX = moveMap.getScale(mouse, xaxis);
			$WegZoomHud::PrevSensY = moveMap.getScale(mouse, yaxis);

			WegChangeSensitivity($WegZoomHud::ZoomSens, $WegZoomHud::ZoomSens);
		}
		else
		{
			WegChangeSensitivity($WegZoomHud::PrevSensX, $WegZoomHud::PrevSensY);
		}
	}
}
		

function WegZoomHud::SetZoomLevel(%this, %zlevel)
{
	%ScreenW = getWord($pref::Video::resolution, 0);
	%ScreenH = getWord($pref::Video::resolution, 1);

	WegZoomHudTS.position = ((0-%ScreenW*%zlevel)/2 + (%ScreenW*$WegZoomHud::FramePercentage)/2) SPC ((0-%ScreenH*%zlevel)/2 + (%ScreenH*$WegZoomHud::FramePercentage)/2);
	WegZoomHudTS.extent = (%ScreenW*%zlevel) SPC (%ScreenH*%zlevel);
}

function WegZoomHudUpdateZoom(%msgType, %msgString, %newFOV)
{
	if (!%newFOV)
		return;
	WegZoomHud.SetZoomLevel($pref::player::defaultFov / %newFOV);
}


package WegZoomHUDLoad {

function ClientCmdDisplayHuds() {
	parent::ClientCmdDisplayHuds();

	switch$ ($HudMode) {
		case "Pilot":
			WegZoomHud.setVisible(false);

		case "Passenger":
			WegZoomHud.setVisible(false);

		case "Object":
			WegZoomHud.setVisible($WegZoomHud_On);

		case "Observer":
			WegZoomHud.setVisible(false);

		case "PickTeam":
			WegZoomHud.setVisible(false);

		default:
			WegZoomHud.setVisible($WegZoomHud_On);
	}
}

function LoadingGui::onWake(%this) {
	if (!$WegZoomHud_CreateGUI)
	{
		MakeWegZoomHud();
		addMessageCallback('zoomFovChanged', WegZoomHudUpdateZoom);
		$WegZoomHud_CreateGUI = true;
	}

	Parent::onWake(%this);
}

function PlayGui::onWake(%this) {
	Parent::onWake(%this);

	if (!$WegZoomHud_Resized) {
		schedule(1000, 0, "WegZoomHudResize");
		$WegZoomHud_Resized = true;
	}
}

function WegZoomHudResize() {
	%ScreenW = getWord($pref::Video::resolution, 0);
	%ScreenH = getWord($pref::Video::resolution, 1);

	WegZoomHud.extent = (%ScreenW * $WegZoomHud::FramePercentage) SPC (%ScreenH * $WegZoomHud::FramePercentage);
	WegZoomHud.position = (%ScreenW * (1 - $WegZoomHud::FramePercentage)) SPC (%ScreenH * (1 - $WegZoomHud::FramePercentage));
	WegZoomHud.SetZoomLevel($pref::player::defaultFov / $pref::player::currentFov);
}

function OptionsDlg::onWake(%this) {
	if (!$WegZoomHud_CreateRemap)
	{
		$RemapName[$RemapCount] = "Toggle Zoom Hud";
		$RemapCmd[$RemapCount] = "WegZoomHudToggle";
		$RemapCount++;

		$WegZoomHud_CreateRemap = true;
	}

	parent::onWake(%this);
}

function MakeWegZoomHud() {
	$WegZoomHud = new GuiControl( WegZoomHud ) {
		profile = "GuiDefaultProfile";
		horizSizing = "right";
		vertSizing = "bottom";
		position = "0 0";
		extent = "8 8";
		minExtent = "8 8";
		visible = "0";
	};

	playgui.add($WegZoomHud);

	$WegZoomHudTS = new GameTSCtrl(WegZoomHudTS) {
		profile = "GuiContentProfile";
		horizSizing = "right";
		vertSizing = "bottom";
		position = "0 0";
		extent = "8 8";
		visible = "1";


		new HudCrosshair(WegZoomHudReticleHud) {
			profile = "GuiButtonProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "0 0";
			extent = "256 256";
			minExtent = "8 8";
			visible = "1";
			setFirstResponder = "0";
			modal = "1";
			helpTag = "0";
			fillColor = "0.250000 0.250000 0.250000 0.250000";
			frameColor = "0.000000 1.000000 0.000000 1.000000";
			opacity = "0.5";
			bitmap = "gui/ret_blaster.png";
			autoCenter = "1";
			autoResize = "1";
		};
	};

	WegZoomHud.add($WegZoomHudTS);
}

function toggleZoom(%val) {
	Parent::toggleZoom(%val);

	if ($WegZoomHud && $WegZoomHud_On)
	{
		WegZoomHud.ToggleVisible(!%val);
	}
}

// Override calcZoomFov to add hud size update
function calcZoomFov(%val) {
	Parent::calcZoomFov(%val);
	
	if ($WegZoomHud) {
		WegZoomHUDTS.SetZoomLevel( $pref::player::defaultFov / $pref::player::currentFOV );
	}
}

};

// Do the same for WegCalcZoomFov

activatePackage(WegZoomHudLoad);

$WegZoomHud_CreateGUI = false;
$WegZoomHud_CreateRemap = false;
$WegZoomHud_Resized = false;
$WegZoomHud_On = false;
//$WegZoomHud_MoveHudOn = false;