// WegBert's Zoom Thingy
// Version: 1.1

// See WegZoom.readme.html for information on the variables listed here

// -- Smallest FOV (Maximum Zoom)
$WegZoom::MinFOV = 4;

// -- Zoom Multiplier
$WegZoom::ZoomMult = 2;

// -- Reset Zoom Mode
// 0 - Do not reset
// 1 - Reset on zoom in
// 2 - Reset an amount of time after zooming out
$WegZoom::ResetMode = 2;

// -- Reset delay (for ResetMode = 2)
$WegZoom::ResetDelay = 1500;

// -- Zoom Sensitivity
$WegZoom::ZoomSens = 0;

// -- Toggle Mode
$WegZoom::ToggleMode = 3;

// -- Hold Delay
$WegZoom::HoldDelay = 300;

// -- Zoom Weapon
$WegZoom::SwitchWeaponOnZoom = "";

function WegCalcZoomFOV(%val, %shouldLoop)
{
	$WegZoom::DidFOVChange = true;

	if (%val >= 0)// Wheel Up - Zoom In
	{
		if($pref::player::currentFOV == $pref::player::defaultFov / 2)
		{
			%newFov = $pref::player::defaultFov / 5;
		}
		else if ($pref::player::currentFOV / $WegZoom::ZoomMult < $WegZoom::MinFOV)
		{
			if (%shouldLoop)
				%newFov = $pref::player::defaultFov / 2;
			else
				return;
		}
		else
		{
			%newFov = $pref::player::currentFOV / $WegZoom::ZoomMult;
		}
	}
	else		// Wheel Down - Zoom Out
	{
		if ($pref::player::currentFOV == $pref::player::defaultFov / 5)
			%newFov = $pref::player::defaultFov / 2;
		else if ($pref::player::currentFOV == $pref::player::defaultFov / 2)
			return;
		else
			%newFov = $pref::player::currentFOV * $WegZoom::ZoomMult;
	}
   
	wegChangeFov(%newFov);

   // Built-in WegZoomHud support for now...
   //if ($WegZoomHud)
   //{
   //   WegZoomHUD.SetZoomLevel( $pref::player::defaultFov / $pref::player::currentFOV );
   //}
}

function wegChangeFov(%newFOV, %doNotUpdateZoomHud)
{
	$pref::player::currentFOV = %newFOV;
	
	if (!$ZoomOn)
	{
		if (!%doNotUpdateZoomHud)
		{
			%pos = getZoomCenter($pref::player::defaultFov / $pref::player::currentFOV);
			%extent = getZoomExtent($pref::player::defaultFov / $pref::player::currentFOV);
			ZoomHud.resize(getWord(%pos, 0), getWord(%pos, 1), getWord(%extent, 0), getWord(%extent, 1));
			
			if(ZoomHud.hideThread != 0)
				cancel(ZoomHud.hideThread);	
			ZoomHud.hideThread = schedule(5000, 0, hideZoomHud);
			
			ZoomHud.setVisible(true);
		}
	}
	else
		setFov($pref::player::currentFOV);	

	clientCmdServerMessage('zoomFovChanged', "", $pref::player::currentFOV);
}

function WegPerformMouseWheelRebind(%val)
{
	if (%val)
	{
		%prevBind = moveMap.getCommand(mouse, zaxis);
		if (%prevBind $= "WegCalcZoomFov")
			return;

		$WegZoomPrevWheelMap = %prevBind;
		moveMap.bind(mouse, zaxis, WegCalcZoomFov);
	}
	else
	{
		moveMap.bind(mouse, zaxis, $WegZoomPrevWheelMap);
	}
}

function WegChangeSensitivity(%xSens, %ySens)
{
	moveMap.bind( mouse, xaxis, "S", %xSens, "yaw" );
	%yFlags = moveMap.isInverted(mouse, yaxis) ? "SI" : "S";
	moveMap.bind( mouse, yaxis, %yFlags, %ySens, "pitch" );
}

function WegZoomDisableToggling()
{
	$WegZoom::Toggling = false;
}

function WegResetZoom()
{
	wegChangeFov($pref::player::defaultFov / 2, true);
}

package WegZoomLoad {

function toggleZoom(%val)
{
	if ($WegZoom::ToggleMode == 1)
	{
		if (!%val)
			return;
		if ($ZoomOn)
			%val = 0;
	}
	else if ($WegZoom::ToggleMode == 2)
	{
		if ($ZoomOn)
		{
			if (%val)
			{
				WegPerformMouseWheelRebind(1);
				return;
			}
			else
			{
				if ($WegZoom::DidFOVChange == true || $WegZoom::StartingZoom == true)
				{
					$WegZoom::DidFOVChange = false;
					$WegZoom::StartingZoom = false;
					WegPerformMouseWheelRebind(0);
					return;
				}
			}
		}
		else
		{
			if (%val)
				$WegZoom::StartingZoom = true;
			else
				return;
		}
	}
	else if ($WegZoom::ToggleMode == 3)
	{
		if (%val)
		{
			if (!$ZoomOn)
			{
				$WegZoom::Toggling = true;
				schedule($WegZoom::HoldDelay, 0, "WegZoomDisableToggling");
			}
			else
				%val = 0;
		}
		else
		{
			if ($WegZoom::Toggling)
				return;
		}
	}

	Parent::toggleZoom(%val);

	if ($WegZoom::ResetMode == 1)
	{
		wegChangeFov($pref::player::defaultFov / 2);
	}
	else if ($WegZoom::ResetMode == 2)
	{
		if ($WegZoom::ResetDelaySched !$= "")
		{
			cancel($WegZoom::ResetDelaySched);
			$WegZoom::ResetDelaySched = "";
		}
		
		if (!%val)
			$WegZoom::ResetDelaySched = schedule($WegZoom::ResetDelay, 0, "WegResetZoom");
	}

	if ($WegZoom::SwitchWeaponOnZoom !$= "")
	{
		if (%val && $WegZoom::CurWeapon !$= $WegZoom::SwitchWeaponOnZoom)
		{
			use($WegZoom::SwitchWeaponOnZoom);
		}
		else if ($WegZoom::WeapChanged)
		{
			use($WegZoom::LastWeapon);
		}
	}

	if ($WegZoom::ZoomSens > 0)
	{
		if (%val)
		{
			$WegZoom::PrevSensX = moveMap.getScale(mouse, xaxis);
			$WegZoom::PrevSensY = moveMap.getScale(mouse, yaxis);

			WegChangeSensitivity($WegZoom::ZoomSens, $WegZoom::ZoomSens);
		}
		else
		{
			WegChangeSensitivity($WegZoom::PrevSensX, $WegZoom::PrevSensY);
		}
	}

	WegPerformMouseWheelRebind(%val);
}

function setZoomFOV(%val)
{
	if(%val)
		WegCalcZoomFOV(1, 1);
}

function clientCmdSetWeaponsHudActive(%slot)
{
	Parent::clientCmdSetWeaponsHudActive(%slot);

	if (%slot > -1 && $WeaponNames[%slot] !$= $WegZoom::CurWeapon)
	{
		$WegZoom::LastWeapon = $WegZoom::CurWeapon;
		$WegZoom::CurWeapon = $WeaponNames[%slot];
		
		// The moment the user changes weapons, even if zoomed, no longer
		// revert to original weapon.
		$WegZoom::WeapChanged = $ZoomOn && $WegZoom::CurWeapon $= $WegZoom::SwitchWeaponOnZoom;
	}
}

};

activatePackage(WegZoomLoad);

$WegZoom::Toggling = true;
$WegZoom::WeapChange = false;
$WegZoom::ResetDelaySched = "";
