function MakeTextGui()
{
//--- OBJECT WRITE BEGIN ---
new GuiControl(TextEditorGui) {
	profile = "DlgBackProfile";
	horizSizing = "width";
	vertSizing = "height";
	position = "0 0";
	extent = "640 480";
	minExtent = "8 8";
	visible = "1";
	hideCursor = "0";
	bypassHideCursor = "0";
	helpTag = "0";

	new ShellPaneCtrl(TextEditorPane) {
		profile = "ShellPaneProfile";
		horizSizing = "width";
		vertSizing = "height";
		position = "-1 0";
		extent = "640 480";
		minExtent = "48 92";
		visible = "1";
		hideCursor = "0";
		bypassHideCursor = "0";
		helpTag = "0";
		text = "TribesPad Text Editor";
		maxLength = "255";
		noTitleBar = "0";
	};
	new GuiTextCtrl() {
		profile = "ShellMediumTextProfile";
		horizSizing = "right";
		vertSizing = "bottom";
		position = "14 4";
		extent = "8 22";
		minExtent = "8 8";
		visible = "1";
		hideCursor = "0";
		bypassHideCursor = "0";
		helpTag = "0";
		maxLength = "255";
	};
	new ShellScrollCtrl() {
		profile = "NewScrollCtrlProfile";
		horizSizing = "width";
		vertSizing = "height";
		position = "35 76";
		extent = "568 343";
		minExtent = "24 52";
		visible = "1";
		hideCursor = "0";
		bypassHideCursor = "0";
		helpTag = "0";
		willFirstRespond = "1";
		hScrollBar = "alwaysOff";
		vScrollBar = "alwaysOn";
		constantThumbHeight = "0";
		defaultLineHeight = "15";
		childMargin = "3 3";
		fieldBase = "gui/shll_field";

		new GuiScrollContentCtrl() {
			profile = "GuiDefaultProfile";
			horizSizing = "width";
			vertSizing = "height";
			position = "7 7";
			extent = "538 329";
			minExtent = "8 8";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";

			new GuiMLTextEditCtrl(TextEdit) {
				profile = "ShellMessageTextProfile";
				horizSizing = "width";
				vertSizing = "height";
				position = "0 0";
				extent = "538 329";
				minExtent = "8 8";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				helpTag = "0";
				lineSpacing = "2";
				allowColorChars = "0";
				maxChars = "10000";
				deniedSound = "InputDeniedSound";
			};
		};
	};
	new ShellBitmapButton(TextEditorSaveBtn) {
		profile = "ShellButtonProfile";
		horizSizing = "right";
		vertSizing = "bottom";
		position = "97 31";
		extent = "84 40";
		minExtent = "32 38";
		visible = "1";
		hideCursor = "0";
		bypassHideCursor = "0";
		command = "TextEditorGui.save();";
		helpTag = "0";
		text = "SAVE";
		simpleStyle = "0";
	};
	new ShellBitmapButton(TextEditorLoadBtn) {
		profile = "ShellButtonProfile";
		horizSizing = "right";
		vertSizing = "bottom";
		position = "27 31";
		extent = "85 38";
		minExtent = "32 38";
		visible = "1";
		hideCursor = "0";
		bypassHideCursor = "0";
		command = "TextEditorGui.load();";
		helpTag = "0";
		text = "LOAD";
		simpleStyle = "0";
	};
	new ShellTextEditCtrl() {
		profile = "NewTextEditProfile";
		horizSizing = "right";
		vertSizing = "bottom";
		position = "228 31";
		extent = "389 38";
		minExtent = "32 38";
		visible = "1";
		hideCursor = "0";
		bypassHideCursor = "0";
		variable = "$TextEditorFile";
		helpTag = "0";
		text = "*** Put file name in here ***";
		maxLength = "255";
		historySize = "0";
		password = "0";
		tabComplete = "0";
		deniedSound = "InputDeniedSound";
		glowOffset = "9 9";
	};
	new ShellBitmapButton() {
		profile = "ShellButtonProfile";
		horizSizing = "left";
		vertSizing = "bottom";
		position = "533 -5";
		extent = "98 38";
		minExtent = "32 38";
		visible = "1";
		hideCursor = "0";
		bypassHideCursor = "0";
		command = "Canvas.popDialog(TextEditorGui);";
		helpTag = "0";
		text = "CLOSE EDITOR";
		simpleStyle = "0";
	};
	new ShellBitmapButton() {
		profile = "ShellButtonProfile";
		horizSizing = "right";
		vertSizing = "bottom";
		position = "166 31";
		extent = "77 38";
		minExtent = "32 38";
		visible = "1";
		hideCursor = "0";
		bypassHideCursor = "0";
		command = "exec($TextEditorFile);";
		helpTag = "0";
		text = "EXEC";
		simpleStyle = "0";
	};
};
//--- OBJECT WRITE END ---


}

package TextEditor {

function TextEditorGui::onWake(%gui)
{
	parent::onWake(%this); 
}

function DispatchLaunchMode() {
MakeTextGui();
parent::DispatchLaunchMode();
}
function TextEditorGui::load(%this)
{
        %file = new FileObject();
        TextEdit.setValue( %file.getContents($TextEditorFile));
        %file.close();
        %file.delete();
}

function TextEditorGui::save(%this)
{
        %file = new FileObject();
        %file.write( $TextEditorFile, TextEdit.getValue() );
        %file.close();
        %file.delete();
}

function TribesPad(%this)
{
	Canvas.PushDialog(TextEditorGui);
}
};
activatePackage(TextEditor);
