// #autoload
// #name = Beacon Keys
// #version = 1.0a
// #date = September 7, 2001
// #author = xTempestx
// #warrior = xTempestx
// #email = tempest@tribalwar.com
// #web = http://scripts.tribalwar.com/tempest
// #description = Add binds to automatically place Target/Marker beacons without having to keep your aim.  This script is one of Tempest's tutorials.
// #status = development

//Check to see if the "TempBeacon" object exists.
if(!isObject(TempBeacon))
{
  //if it doesn't, create it.
  new ScriptObject(TempBeacon)
  {
    //Always give a classname (you can make it up)
    class = TempBeacon;
    //This is for internal use only.
    version = "1.0a";
  };
}

//This function will place a Targeting Beacon.
function TempBeaconTarget(%val)
{
  //if %val is valid, (meaning the key was pressed)
  if(%val)
  {
    //Tell the server we used a beacon (1 time = Targeting Beacon);
    use( Beacon); //see controlDefaults.cs line 396
  }
}

//This function will place a Marker Beacon.
function TempBeaconMarker(%val)
{
  //if %val is valid, (meaning the key was pressed)
  if(%val)
  {
    //Tell the server we used a beacon (2 times = Marker Beacon);
    use( Beacon);  //see controlDefaults.cs line 396
    use( Beacon);  //see controlDefaults.cs line 396
  }
}

//start package TempBeacon - to add code to base code.
package TempBeacon
{
  //this function is called when you go into your "Options" screen in the game.
  function OptionsDlg::onWake(%this)
  {
    //make sure that the keys aren't already bound, or they'll be listed 2 times.
    if (!$TempBeaconBound)
    {
      //text to display in the key mapping screen.
      $RemapName[$RemapCount]="Target Beacon";
      //command to bind to that key.
      $RemapCmd[$RemapCount]="TempBeaconTarget";
      //increment $RemapCount so that we can bind the next key.
      $RemapCount++;
      
      //text to display in the key mapping screen.
      $RemapName[$RemapCount]="Marker Beacon";
      //command to bind to that key.
      $RemapCmd[$RemapCount]="TempBeaconMarker";
      //increment $RemapCount so that we can bind the next key.
      $RemapCount++;

      //this will let the script know that the keys are bound the next time the
      //script is executed.
      $TempBeaconBound = true;
    }
    //allow t2 to continue processing the OptionsDlg::onWake method.
    parent::onWake( %this );
  }
};
//end package TempBeacon

//activate the package to include the code inserted into OoptionsDlg::onWake.
activatepackage(TempBeacon);
