// #autoload       
// #name = EiKeDo_TR2FlagAnnouncements
// #author = EiKeDo (Dillon DeLoss)
// #description = Team Rabbit 2 - Helps you and your team keep track of the flag by canned chat messages. And, shows a message under your reticle when you get, or drop, the flag.
        
//------------------------------------------------------------------

package EiKeDo_TR2FlagAnnouncementsHUD {     
        
   function PlayGui::onWake(%this)
   {

      Parent::onWake(%this);

      if(!isObject(PlayGui)) return;

      if(isObject(EiKeDo_TR2FlagAnnouncementsNotifyHUD)) retCenterHud.remove(EiKeDo_TR2FlagAnnouncementsNotifyHUD);

      new GuiTextCtrl(EiKeDo_TR2FlagAnnouncementsNotifyHUD) {
	   profile = "CenterPrintTextProfile";
	   horizSizing = "center";
	   vertSizing = "bottom";
	   position = "0 175";
	   extent = "118 12";
	   minExtent = "8 8";
	   visible = "0";
	   helpTag = "0";
	   text = "CARRYING FLAG";
	   maxLength = "255";
      };

      retCenterHud.add(EiKeDo_TR2FlagAnnouncementsNotifyHUD);
   }

   function EiKeDo_TR2FlagAnnouncementsNotifyHUDRemoval()
   {
      if(isObject(EiKeDo_TR2FlagAnnouncementsNotifyHUD))
         EiKeDo_TR2FlagAnnouncementsNotifyHUD.setVisible(False);
   }

};

activatePackage(EiKeDo_TR2FlagAnnouncementsHUD);

//------------------------------------------------------------------

package EiKeDo_TR2HaveFlag {     
        
function EiKeDo_TR2HaveFlag(%msgType, %msgString, %victimname, %vgen, %vposs, %killername, %kgen, %kposs, %damageType)
{
   %msgString = detag(%msgString);
   if (strStr(%msgString, "You took") > 0)
   {
      commandToServer('CannedChat','ChatFlagGotIt', false);    

      EiKeDo_TR2FlagAnnouncementsNotifyHUD.setText("CARRYING FLAG");
      EiKeDo_TR2FlagAnnouncementsNotifyHUD.setVisible(True);

      cancel(EiKeDo_TR2FlagAnnouncementsNotifyHUD.schedule);
      EiKeDo_TR2FlagAnnouncementsNotifyHUD.schedule = schedule(2000, 0, EiKeDo_TR2FlagAnnouncementsNotifyHUDRemoval);
   }
}

function EiKeDo_TR2HaveFlagCallback()
{
	addMessageCallBack('MsgTR2FlagTaken', EiKeDo_TR2HaveFlag);
}
     
};    
       
activatePackage(EiKeDo_TR2HaveFlag);
EiKeDo_TR2HaveFlagCallback();

//------------------------------------------------------------------

package EiKeDo_TR2DroppedFlag {     
        
function EiKeDo_TR2DroppedFlag(%msgType, %msgString, %victimname, %vgen, %vposs, %killername, %kgen, %kposs, %damageType)
{
   %msgString = detag(%msgString);
   if (strStr(%msgString, "You dropped") > 0)
   {
      commandToServer('CannedChat','ChatCmdAttackChase', false);    

      EiKeDo_TR2FlagAnnouncementsNotifyHUD.setText("DROPPED  FLAG");
      EiKeDo_TR2FlagAnnouncementsNotifyHUD.setVisible(True);

      cancel(EiKeDo_TR2FlagAnnouncementsNotifyHUD.schedule);
      EiKeDo_TR2FlagAnnouncementsNotifyHUD.schedule = schedule(2000, 0, EiKeDo_TR2FlagAnnouncementsNotifyHUDRemoval);
   }
}

function EiKeDo_TR2DroppedFlagCallback()
{
   addMessageCallBack('MsgTR2FlagDropped', EiKeDo_TR2DroppedFlag);
}
     
};    
       
activatePackage(EiKeDo_TR2DroppedFlag);
EiKeDo_TR2DroppedFlagCallback();