// #autoload
// #name = Tribes 2 jumpJetPilot
// #version = 0.9
// #date = November 28, 2000
// #author = Shane Taylor
// #warrior =  Mental Trousers
// #email = mentaltrousers@planetstarsiege.com
// #web = http://www.planetstarsiege.com/mt/
// #description = combines the jump and jet into one key that auto switches to pure jet when piloting vehicles
// #status = beta
// #readme = 

//---------------------------------------------------------------------------------------
// Poker posted a very basic jumpJet script in the Tribes 2 forums. Unfortunately it
// didn't turn off the jump part when you jumped into a vehicle. So, when you pressed
// jet to fire the afterburners, it spat you out instead :o)
//
// This script fixes that. It automatically turns off the jump part when you enter a
// vehicle and then reenables it when you get out.
//---------------------------------------------------------------------------------------

$jumpAndJet=true;

package jumpJetPackage
{
//replace the "Jet" binding in the controls whatsit with "JumpJet"
	function OptionsDlg::onWake( %this )
	{
	parent::onWake( %this );
	$RemapName[9]="JumpJet";
	$RemapCmd[9]="jumpJet";
	}

//rebind the jet key to be a jumpjet.
	function PlayGui::onWake(%this)
	{
	parent::onWake( %this );
	if (!isObject ( jumpJetActionMap ))
		new actionMap ( jumpJetActionMap );

	%keymap=moveMap.getBinding (mouseJet);
	if (%keymap !$= "")
		{
		%dev=getword (%keymap, 0);
		%key=getword (%keymap, 1);
		movemap.unbind (%dev, %key);
		movemap.bind (%dev, %key, jumpJet);
		%xsens = moveMap.getScale (mouse, xaxis)*3;
		%ysens = moveMap.getScale (mouse, yaxis)*3;
	 	jumpJetActionMap.bind( mouse, xaxis, "S", %xsens, "yaw" );
		%yFlags = InvertMouseTgl.getValue() ? "SI" : "S";
	 	jumpJetActionMap.bind( mouse, yaxis, %yFlags, %ysens, "pitch" );
		}

	%keymap=jumpJetActionMap.getBinding (mouseJet);
	if (%keymap $= "")
		{
		%keymap=moveMap.getBinding (jumpJet);
		%dev=getword (%keymap, 0);
		%key=getword (%keymap, 1);
		jumpJetActionMap.bind (%dev, %key, mouseJet);
		}
	}

//I could have used moveMap.bindCmd to bind the jet key, but then
//the binding couldn't be displayed in the controls panel of the
//settings screen.
	function jumpJet ()
	{
	$jumpJetCount++;
	if ($jumpJetCount & 1)
		jumpJetDown ();
	else
		jumpJetUp ();
	}

//if the var $mvTriggerCount2 gets out of sync with the jump button
//(which can happen if we call the jump() function from somewhere else)
//then you end up with strange behaviour ie let go of the jump key and 
//it starts jumping.
	function jumpJetDown ()
	{
	if ($jumpAndJet && (!($mvTriggerCount2 & 1)  && !($jumpCounter & 1)))
		parent::jump();

	mouseJet();
	}

	function jumpJetUp ()
	{
	if (($mvTriggerCount2 & 1) && !($jumpCounter & 1))
		parent::jump();

	mouseJet();
	}

//do some stuff to make sure $mvTriggerCount2 doesn't get out of sync
//with the jump button
	function jump()
	{
	$jumpCounter++;
	if (($mvTriggerCount2 & 1) != ($jumpCounter & 1))
		parent::jump();
	}

//catch the vehicle mount/dismount calls.
	function My_VehicleMount()
	{
	$jumpAndJet=false;
	jumpJetActionMap.push();
	}

	function My_VehicleDismount()
	{
	jumpJetActionMap.pop();
	$jumpAndJet=true;
	}

	function clientCmdVehicleMount()
	{
	parent::clientCmdVehicleMount();
	My_VehicleMount();
	}

	function clientCmdVehicleDismount()
	{
	parent::clientCmdVehicleDismount();
	My_VehicleDismount();
	}
};

//callback.add(OnVehicleMount, My_VehicleMount);
//callback.add(OnVehicleDismount, My_VehicleDismount);

activatePackage (jumpJetPackage);