//---------------------------------------------------------

// #name    = MB_RatesHud
// #vers    = 2.3
// #date    = April 30, 2001
// #auth    = Lance Gharat ([AKA]madBOT)
// #email   = lgharat@lanset.com
// #descr   = Show FPS, Ping, PL like other GUI objects


exec("prefs/MB_ClientPrefs.cs");
exec("scripts/autoexec/madbot/MB_Colors.cs");

//---------------------------------------------------------

$MB_RatesHudBox::GUI  = "false";
$MB_RatesHudBoxPos    = "50% 300";
$MB_ExtRatesHudBoxPos = "50% 300";

$MB_RatesHudBoxExtent    = "63 41";
$MB_ExtRatesHudBoxExtent = "135 53";

$MB_ClientId      = 0;
$MB_ClientName    = "";

$MB_FPSRestart = true;
$MB_PPLRestart = true;

$MB_FpsMin = 0;
$MB_FpsMax = 0;
$MB_FpsAvg = 0;
$MB_FpsCnt = 0;
$MB_FpsTot = 0;

$MB_PingMin = 0;
$MB_PingMax = 0;
$MB_PingAvg = 0;
$MB_PingCnt = 0;
$MB_PingTot = 0;

$MB_PlossMin = 0;
$MB_PlossMax = 0;
$MB_PlossAvg = 0;
$MB_PlossCnt = 0;
$MB_PlossTot = 0;

$MB_PPL = false;
if ( $MB_Pref::EnablePingPl $= "1" )
{
    $MB_PPL = true;
}
else
{
    $MB_RatesHudBoxExtent    = "63 17";
    $MB_ExtRatesHudBoxExtent = "135 29";
}

$MB_ExtInfo = false;
if ( $MB_Pref::ExtendedInfo $= "1" )
{
    $MB_ExtInfo = true;
}

//---------------------------------------------------------

new GuiControlProfile ("MB_RatesHudProfile")
{
	fontType  = "Univers Condensed";
	fontSize  = 16;
	fontColor = "255 255 255";
	
	autoSizeWidth  = true;
	autoSizeHeight = true;
};

//---------------------------------------------------------

function MB_CheckForPJTimeHud()
{
    %isPresent = false;
    %file = new FileObject();
    %fname = "panamajack/PJTimeHud.cs";
    
    if ( %file.openForRead("scripts/autoexec/" @ %fname) )
    {
        %file.close();
        
        exec("prefs/PJScripts.cs");

        if ( $PJEnable::TimeHud $= "1" )
        {
            %isPresent = true;
        }
	}
	
	if ( %isPresent == true )
	{
	    echo("MB_RatesHud: PJTimeHud present");
	}
	else
	{
        echo("MB_RatesHud: PJTimeHud not present");
	}
    
    return(%isPresent);
}

//---------------------------------------------------------

function MB_RoundInt( %num )
{
    %tmp = %num * 1000000;
    %val = (%tmp - (%tmp % 1000000)) / 1000000;
    
    return(%val);
}

//---------------------------------------------------------

function MB_SetExtRatesLabels()
{
    MB_ExtRatesHudCellMinLabel.setVisible(true);
    MB_ExtRatesHudCellMaxLabel.setVisible(true);
    MB_ExtRatesHudCellAvgLabel.setVisible(true);
    MB_ExtRatesHudCellFpsLabel.setVisible(true);
    
    MB_ExtRatesHudCellMinLabel.setValue("<just:left><color:"@ $MB_LabelColor @">  Min");
    MB_ExtRatesHudCellMaxLabel.setValue("<just:left><color:"@ $MB_LabelColor @">  Max");
    MB_ExtRatesHudCellAvgLabel.setValue("<just:left><color:"@ $MB_LabelColor @">  Avg");
    MB_ExtRatesHudCellFpsLabel.setValue("<just:left><color:"@ $MB_LabelColor @">  FPS:");

    if ( $MB_PPL )
    {
        MB_ExtRatesHudCellPingLabel.setVisible(true);
        MB_ExtRatesHudCellPlossLabel.setVisible(true);

        MB_ExtRatesHudCellPingLabel.setValue("<just:left><color:"@ $MB_LabelColor @">  Ping:");
        MB_ExtRatesHudCellPlossLabel.setValue("<just:left><color:"@ $MB_LabelColor @">  PL%:");
    }
}

//---------------------------------------------------------

function MB_HideExtRatesValues()
{
    MB_ExtRatesHudCellPingMin.setVisible(false);
    MB_ExtRatesHudCellPingMax.setVisible(false);
    MB_ExtRatesHudCellPingAvg.setVisible(false);
    MB_ExtRatesHudCellPlossMin.setVisible(false);
    MB_ExtRatesHudCellPlossMax.setVisible(false);
    MB_ExtRatesHudCellPlossAvg.setVisible(false);
}

//---------------------------------------------------------

function MB_ShowExtRatesValues()
{
    MB_ExtRatesHudCellPingMin.setVisible(true);
    MB_ExtRatesHudCellPingMax.setVisible(true);
    MB_ExtRatesHudCellPingAvg.setVisible(true);
    MB_ExtRatesHudCellPlossMin.setVisible(true);
    MB_ExtRatesHudCellPlossMax.setVisible(true);
    MB_ExtRatesHudCellPlossAvg.setVisible(true);
}

//---------------------------------------------------------

function MB_RatesHudPosition1()
{
	%x = getword($pref::Video::resolution, 0) - 150;
	%y = getword(hudClusterBack.position, 1) + getword(hudClusterBack.extent, 1) - 42;

	$MB_RatesHudBoxPos = %x @ " " @ %y;
	MB_RatesHudBox.position = $MB_RatesHudBoxPos;
}

//---------------------------------------------------------

function MB_ExtRatesHudPosition1()
{
    if ( $MB_PJTimeHud == true )
    {
	    %x = getword($pref::Video::resolution, 0) - 135;
	    %y = getword(hudClusterBack.position, 1) + getword(hudClusterBack.extent, 1) + 28;
	}
	else
	{
	    %x = getword($pref::Video::resolution, 0) - 135;
	    %y = getword(hudClusterBack.position, 1) + getword(hudClusterBack.extent, 1);
    }

	$MB_ExtRatesHudBoxPos = %x @ " " @ %y;
	MB_ExtRatesHudBox.position = $MB_ExtRatesHudBoxPos;
}

//---------------------------------------------------------

function MB_RatesHudPosition2()
{
    %x = getword($pref::Video::resolution, 0);
	%y = getword($pref::Video::resolution, 1);
	%xmulti = %x / 640;
	%ymulti = %y / 480;

	%x1 = getword($MB_RatesHudBoxPos, 0);
	%y1 = getword($MB_RatesHudBoxPos, 1);

	if(%x1 $= "50%")
	{
	    %x1 = mfloor(%x / 2) - 90;
		%xmulti = 1;
	}

	$MB_RatesHudBoxPos = mfloor(%x1 * %xmulti) @ " " @ mfloor(%y1 * %ymulti);
	MB_RatesHudPosition1();
	
	if ( $MB_Pref::ExtendedInfo $= "1" )
	{
	    $MB_ExtRatesHudBoxPos = mfloor(%x1 * %xmulti) @ " " @ mfloor(%y1 * %ymulti);
	    MB_ExtRatesHudPosition1();
	}
}

//---------------------------------------------------------

function MB_HandleClientJoin(%msgType, %msgString, %clientName, %clientId, %targetId, %isAI, %isAdmin, %isSuperAdmin, %isSmurf, %guid)
{
	if(StrStr(%msgString, "Welcome to Tribes") != -1)
	{
		$MB_ClientId   = %clientId;
		$MB_ClientName = detag(%clientName);
	}
}

//---------------------------------------------------------

function MB_ResetExtendedInfo()
{
    $MB_FPSRestart = true;
    $MB_PPLRestart = true;
    
    $MB_FpsMin = 9999;
    $MB_FpsMax = 0;
    $MB_FpsAvg = 0;
    $MB_FpsTot = 0;
    $MB_FpsCnt = 0;

    $MB_PingMin = 9999;
    $MB_PingMax = 0;
    $MB_PingAvg = 0;
    $MB_PingTot = 0;
    $MB_PingCnt = 0;

    $MB_PlossMin = 9999;
    $MB_PlossMax = 0;
    $MB_PlossAvg = 0;
    $MB_PlossTot = 0;
    $MB_PlossCnt = 0;
}

//---------------------------------------------------------

function MB_FpsHudUpdate()
{
   if ( ! $InLobby )  // $InLobby is already loaded by lobbyGui.cs
   {
        MB_RatesHudBox.setVisible(true);

        //- - - - - - - - - - - - - - - - -
        // FPS current
	
	    MB_RatesHudPosition1();
	    MB_RatesHudCellFps.setVisible(false);
	    
	    if ( $MB_PPL == false )
	    {
            MB_RatesHudCellPing.setVisible(false);
            MB_RatesHudCellPloss.setVisible(false);
        }

	    %fpsVal = $fps::real;
	    
	    %fpsColor = $MB_ColorRGB[$MB_Pref::FpsColor6];

	    if ( %fpsVal >=  20 ) { %fpsColor = $MB_ColorRGB[$MB_Pref::FpsColor5]; }
	    if ( %fpsVal >=  40 ) { %fpsColor = $MB_ColorRGB[$MB_Pref::FpsColor4]; }
	    if ( %fpsVal >=  60 ) { %fpsColor = $MB_ColorRGB[$MB_Pref::FpsColor3]; }
	    if ( %fpsVal >=  80 ) { %fpsColor = $MB_ColorRGB[$MB_Pref::FpsColor2]; }
	    if ( %fpsVal >= 100 ) { %fpsColor = $MB_ColorRGB[$MB_Pref::FpsColor1]; }
	
	    MB_RatesHudCellFps.setValue("<just:left><color:"@ $MB_LabelColor @">  FPS: <color:" @ %fpsColor @ ">" @ %fpsVal);
	    MB_RatesHudCellFps.setVisible(true);
	
        //- - - - - - - - - - - - - - - - -
        // FPS min/max/avg

        if ( $MB_ExtInfo == true )
        {
            MB_ExtRatesHudPosition1();

            MB_ExtRatesHudBox.setVisible(true);
            MB_SetExtRatesLabels();
            MB_ExtRatesHudCellFpsMin.setVisible(false);
            MB_ExtRatesHudCellFpsMax.setVisible(false);
            MB_ExtRatesHudCellFpsAvg.setVisible(false);
            
	        if ( $MB_FPSRestart == true )
	        {
	            $MB_FPSRestart = false;

	            $MB_FpsCnt = 1;
	            $MB_FpsMin = %fpsVal;
	            $MB_FpsMax = %fpsVal;
	            $MB_FpsTot = %fpsVal;
	            $MB_FpsAvg = %fpsVal;
	        }
	        else
	        {
	            $MB_FpsCnt++;
	            if ( %fpsVal < $MB_FpsMin ) { $MB_FpsMin = %fpsVal; }
	            if ( %fpsVal > $MB_FpsMax ) { $MB_FpsMax = %fpsVal; }
	            $MB_FpsTot += %fpsVal;
	            $MB_FpsAvg = MB_RoundInt($MB_FpsTot / $MB_FpsCnt);
	        }

	        MB_ExtRatesHudCellFpsMin.setValue("<just:left><color:d0c07c>" @ $MB_FpsMin);
	        MB_ExtRatesHudCellFpsMax.setValue("<just:left><color:d0c07c>" @ $MB_FpsMax);
	        MB_ExtRatesHudCellFpsAvg.setValue("<just:left><color:d0c07c>" @ $MB_FpsAvg);

            MB_ExtRatesHudCellFpsMin.setVisible(true);
            MB_ExtRatesHudCellFpsMax.setVisible(true);
            MB_ExtRatesHudCellFpsAvg.setVisible(true);
	    }
	
        //- - - - - - - - - - - - - - - - -

	    schedule(1000 * $MB_Pref::PollFpsSecs, 0, MB_FpsHudUpdate);
	}
	else
	{
        MB_RatesHudBox.setVisible(false);

        if ( $MB_ExtInfo == true )
        {
            MB_ExtRatesHudBox.setVisible(false);
        }
    }
}
	
//---------------------------------------------------------

function MB_RatesHudUpdate()
{
   if ( ! $InLobby )  // $InLobby is already loaded by lobbyGui.cs
   {
	    MB_RatesHudPosition1();
	
        MB_RatesHudBox.setVisible(true);
	
	    // Call the already installed lobby gui function.
	    // The function will then store all client info
	    // in a global array: $PlayerList in the client.
	    commandToServer('getScores');
	
	    %player = $PlayerList[$MB_ClientId];
	
        //- - - - - - - - - - - - - - - - -
        // PING current

        MB_RatesHudCellPing.setVisible(false);

	    %pingVal = %player.ping;

	    %pingColor = $MB_ColorRGB[$MB_Pref::PingColor1];

	    if ( %pingVal >=  50 ) { %pingColor = $MB_ColorRGB[$MB_Pref::PingColor2]; }
	    if ( %pingVal >= 100 ) { %pingColor = $MB_ColorRGB[$MB_Pref::PingColor3]; }
	    if ( %pingVal >= 200 ) { %pingColor = $MB_ColorRGB[$MB_Pref::PingColor4]; }
	    if ( %pingVal >= 300 ) { %pingColor = $MB_ColorRGB[$MB_Pref::PingColor5]; }
	    if ( %pingVal >= 400 ) { %pingColor = $MB_ColorRGB[$MB_Pref::PingColor6]; }
	
	    MB_RatesHudCellPing.setValue("<just:left><color:" @ $MB_LabelColor @ ">  Ping: <color:" @ %pingColor @ ">" @ %pingVal);
	    MB_RatesHudCellPing.setVisible(true);

        //- - - - - - - - - - - - - - - - -
        // PACKET LOSS current

	    MB_RatesHudCellPLoss.setVisible(false);

	    %plVal = %player.packetLoss;
	
	    %plColor = $MB_ColorRGB[$MB_Pref::PlossColor1];

	    if ( %plVal >=  1 ) { %plColor = $MB_ColorRGB[$MB_Pref::PlossColor2]; }
	    if ( %plVal >=  2 ) { %plColor = $MB_ColorRGB[$MB_Pref::PlossColor3]; }
	    if ( %plVal >=  4 ) { %plColor = $MB_ColorRGB[$MB_Pref::PlossColor4]; }
	    if ( %plVal >=  8 ) { %plColor = $MB_ColorRGB[$MB_Pref::PlossColor5]; }
	    if ( %plVal >= 16 ) { %plColor = $MB_ColorRGB[$MB_Pref::PlossColor6]; }
	
	    MB_RatesHudCellPLoss.setValue("<just:left><color:" @ $MB_LabelColor @ ">  PL%: <color:" @ %plColor @ ">" @ %plVal);
	    MB_RatesHudCellPLoss.setVisible(true);

        //- - - - - - - - - - - - - - - - -
        // Ping/PL min/max/avg

        if ( $MB_ExtInfo == true )
        {
            MB_ExtRatesHudPosition1();

            MB_ExtRatesHudBox.setVisible(true);
            MB_SetExtRatesLabels();
            MB_HideExtRatesValues();
            
	        if ( $MB_PPLRestart == true )
	        {
	            $MB_PPLRestart = false;

	            $MB_PingCnt = 1;
	            $MB_PingMin = %pingVal;
	            $MB_PingMax = %pingVal;
	            $MB_PingTot = %pingVal;
	            $MB_PingAvg = %pingVal;

	            $MB_PlossCnt = 1;
	            $MB_PlossMin = %plVal;
	            $MB_PlossMax = %plVal;
	            $MB_PlossTot = %plVal;
	            $MB_PlossAvg = %plVal;
	        }
	        else
	        {
	            $MB_PingCnt++;
	            if ( %pingVal < $MB_PingMin ) { $MB_PingMin = %pingVal; }
	            if ( %pingVal > $MB_PingMax ) { $MB_PingMax = %pingVal; }
	            $MB_PingTot += %pingVal;
	            $MB_PingAvg = MB_RoundInt($MB_PingTot / $MB_PingCnt);

	            $MB_PlossCnt++;
	            if ( %plVal < $MB_PlossMin ) { $MB_PlossMin = %plVal; }
	            if ( %plVal > $MB_PlossMax ) { $MB_PlossMax = %plVal; }
	            $MB_PlossTot += %plVal;
	            $MB_PlossAvg = MB_RoundInt($MB_PlossTot / $MB_PlossCnt);
	        }
	        
	        MB_ExtRatesHudCellPingMin.setValue("<just:left><color:d0c07c>" @ $MB_PingMin);
	        MB_ExtRatesHudCellPingMax.setValue("<just:left><color:d0c07c>" @ $MB_PingMax);
	        MB_ExtRatesHudCellPingAvg.setValue("<just:left><color:d0c07c>" @ $MB_PingAvg);

	        MB_ExtRatesHudCellPlossMin.setValue("<just:left><color:d0c07c>" @ $MB_PlossMin);
	        MB_ExtRatesHudCellPlossMax.setValue("<just:left><color:d0c07c>" @ $MB_PlossMax);
	        MB_ExtRatesHudCellPlossAvg.setValue("<just:left><color:d0c07c>" @ $MB_PlossAvg);
            
            MB_ShowExtRatesValues();
	    }
	
        //- - - - - - - - - - - - - - - - -

	    schedule(1000 * $MB_Pref::PollRateSecs, 0, MB_RatesHudUpdate);
	}
	else
	{
	    MB_RatesHudBox.setVisible(false);

        if ( $MB_ExtInfo == true )
        {
            MB_ExtRatesHudBox.setVisible(false);
        }
    }
}

//---------------------------------------------------------

package MB_RatesHudLoad
{
    //- - - - - - - - - - - - - - - - -
    
    function DispatchLaunchMode()
    {
	    addMessageCallback( 'MsgClientJoin',   MB_HandleClientJoin );
	    addMessageCallback( 'MsgMissionStart', MB_ResetExtendedInfo );
	    addMessageCallback( 'MsgMissionStart', MB_FpsHudUpdate );
	    
	    if ( $MB_PPL == true )
	    {
	        addMessageCallback( 'MsgMissionStart', MB_RatesHudUpdate );
	    }
	    
	    parent::DispatchLaunchMode();
    }

    //- - - - - - - - - - - - - - - - -
    
    function PlayGui::onWake(%this)
    {
	    parent::onWake(%this);
	    
	    schedule(1000 * $MB_Pref::PollFpsSecs,  0, "MB_SetFpsHudGui");

	    if ( $MB_PPL == true )
	    {
	        schedule(1000 * $MB_Pref::PollRateSecs, 0, "MB_SetRatesHudGui");
	    }
    }

    //- - - - - - - - - - - - - - - - -
    
    function MB_SetFpsHudGui()
    {
	    MB_RatesHudPosition1();
	    MB_ExtRatesHudPosition1();
	    
	    $MB_HudFpsCount   = schedule(1000 * $MB_Pref::PollFpsSecs,  0, "MB_FpsHudUpdate");
    }

    //- - - - - - - - - - - - - - - - -
    
    function MB_SetRatesHudGui()
    {
	    MB_RatesHudPosition1();
	    MB_ExtRatesHudPosition1();
	    
	    $MB_RatesHudCount = schedule(1000 * $MB_Pref::PollRateSecs, 0, "MB_RatesHudUpdate");
    }

    //- - - - - - - - - - - - - - - - -
    
    function LoadingGui::onWake(%this)
    {
	    parent::onWake(%this);
	    
	    if( $MB_RatesHudBox::GUI $= "false" )
	    {
		    MB_MakeRatesHudBox();
		    
		    if ( $MB_ExtInfo == true )
		    {
		        MB_MakeExtRatesHudBox();
		    }
		    
	        MB_RatesHudPosition2();
	        
		    $MB_RatesHudBox::GUI = "true";
	    }
    }

    //- - - - - - - - - - - - - - - - -
    
    function OptionsDlg::applyGraphicChanges( %this )
    {
	    parent::applyGraphicChanges( %this );

	    MB_RatesHudPosition2();
    }

    //- - - - - - - - - - - - - - - - -
    
    function MB_MakeRatesHudBox()
    {
	    $MB_RatesHudBox = new ShellFieldCtrl(MB_RatesHudBox)
	    {
		    profile     = "GuiChatBackProfile";
		    horizSizing = "left";
		    vertSizing  = "top";
		    position    = "0 0";
		    extent      = $MB_RatesHudBoxExtent;
		    minExtent   = "8 8";
		    visible     = "0";
	
	        new GuiMLTextCtrl(MB_RatesHudCellFps)
	        {
		        profile     = "MB_RatesHudProfile";
		        horizSizing = "left";
		        vertSizing  = "top";
		        position    = "0 -1";
		        extent      = "63 16 ";
		        minExtent   = "8 8";
		        visible     = "0";
			    helpTag     = "0";
			    lineSpacing = "2";
			    allowColorChars = "0";
			    maxChars    = "-1";
	        };
	        
	        new GuiMLTextCtrl(MB_RatesHudCellPing)
	        {
		        profile     = "MB_RatesHudProfile";
		        horizSizing = "left";
		        vertSizing  = "top";
		        position    = "0 11";
		        extent      = "63 16 ";
		        minExtent   = "8 8";
		        visible     = "0";
			    helpTag     = "0";
			    lineSpacing = "2";
			    allowColorChars = "0";
			    maxChars    = "-1";
	        };
	        
	        new GuiMLTextCtrl(MB_RatesHudCellPLoss)
	        {
		        profile     = "MB_RatesHudProfile";
		        horizSizing = "left";
		        vertSizing  = "top";
		        position    = "0 23";
		        extent      = "63 16 ";
		        minExtent   = "8 8";
		        visible     = "0";
			    helpTag     = "0";
			    lineSpacing = "2";
			    allowColorChars = "0";
			    maxChars    = "-1";
	        };
	    };
	
	    playgui.add($MB_RatesHudBox);
    }

    //- - - - - - - - - - - - - - - - -
    
    function MB_MakeExtRatesHudBox()
    {
	    $MB_ExtRatesHudBox = new ShellFieldCtrl(MB_ExtRatesHudBox)
	    {
		    profile     = "GuiChatBackProfile";
		    horizSizing = "left";
		    vertSizing  = "top";
		    position    = "0 0";
		    extent      = $MB_ExtRatesHudBoxExtent;
		    minExtent   = "8 8";
		    visible     = "0";
	
	        new GuiMLTextCtrl(MB_ExtRatesHudCellMinLabel)
	        {
		        profile     = "MB_RatesHudProfile";
		        horizSizing = "left";
		        vertSizing  = "top";
		        position    = "30 -1";
		        extent      = "30 16 ";
		        minExtent   = "8 8";
		        visible     = "0";
			    helpTag     = "0";
			    lineSpacing = "2";
			    allowColorChars = "0";
			    maxChars    = "-1";
	        };
	        
	        new GuiMLTextCtrl(MB_ExtRatesHudCellMaxLabel)
	        {
		        profile     = "MB_RatesHudProfile";
		        horizSizing = "left";
		        vertSizing  = "top";
		        position    = "65 -1";
		        extent      = "30 16 ";
		        minExtent   = "8 8";
		        visible     = "0";
			    helpTag     = "0";
			    lineSpacing = "2";
			    allowColorChars = "0";
			    maxChars    = "-1";
	        };
	        
	        new GuiMLTextCtrl(MB_ExtRatesHudCellAvgLabel)
	        {
		        profile     = "MB_RatesHudProfile";
		        horizSizing = "left";
		        vertSizing  = "top";
		        position    = "100 -1";
		        extent      = "30 16 ";
		        minExtent   = "8 8";
		        visible     = "0";
			    helpTag     = "0";
			    lineSpacing = "2";
			    allowColorChars = "0";
			    maxChars    = "-1";
	        };
	        
	        new GuiMLTextCtrl(MB_ExtRatesHudCellFpsLabel)
	        {
		        profile     = "MB_RatesHudProfile";
		        horizSizing = "left";
		        vertSizing  = "top";
		        position    = "0 11";
		        extent      = "30 16 ";
		        minExtent   = "8 8";
		        visible     = "0";
			    helpTag     = "0";
			    lineSpacing = "2";
			    allowColorChars = "0";
			    maxChars    = "-1";
	        };
	        
	        new GuiMLTextCtrl(MB_ExtRatesHudCellPingLabel)
	        {
		        profile     = "MB_RatesHudProfile";
		        horizSizing = "left";
		        vertSizing  = "top";
		        position    = "0 23";
		        extent      = "30 16 ";
		        minExtent   = "8 8";
		        visible     = "0";
			    helpTag     = "0";
			    lineSpacing = "2";
			    allowColorChars = "0";
			    maxChars    = "-1";
	        };
	        
	        new GuiMLTextCtrl(MB_ExtRatesHudCellPlossLabel)
	        {
		        profile     = "MB_RatesHudProfile";
		        horizSizing = "left";
		        vertSizing  = "top";
		        position    = "0 35";
		        extent      = "30 16 ";
		        minExtent   = "8 8";
		        visible     = "0";
			    helpTag     = "0";
			    lineSpacing = "2";
			    allowColorChars = "0";
			    maxChars    = "-1";
	        };
	        
	        new GuiMLTextCtrl(MB_ExtRatesHudCellFpsMin)
	        {
		        profile     = "MB_RatesHudProfile";
		        horizSizing = "left";
		        vertSizing  = "top";
		        position    = "35 11";
		        extent      = "30 16 ";
		        minExtent   = "8 8";
		        visible     = "0";
			    helpTag     = "0";
			    lineSpacing = "2";
			    allowColorChars = "0";
			    maxChars    = "-1";
	        };
	        
	        new GuiMLTextCtrl(MB_ExtRatesHudCellFpsMax)
	        {
		        profile     = "MB_RatesHudProfile";
		        horizSizing = "left";
		        vertSizing  = "top";
		        position    = "70 11";
		        extent      = "30 16 ";
		        minExtent   = "8 8";
		        visible     = "0";
			    helpTag     = "0";
			    lineSpacing = "2";
			    allowColorChars = "0";
			    maxChars    = "-1";
	        };
	        
	        new GuiMLTextCtrl(MB_ExtRatesHudCellFpsAvg)
	        {
		        profile     = "MB_RatesHudProfile";
		        horizSizing = "left";
		        vertSizing  = "top";
		        position    = "105 11";
		        extent      = "30 16 ";
		        minExtent   = "8 8";
		        visible     = "0";
			    helpTag     = "0";
			    lineSpacing = "2";
			    allowColorChars = "0";
			    maxChars    = "-1";
	        };
	        
	        new GuiMLTextCtrl(MB_ExtRatesHudCellPingMin)
	        {
		        profile     = "MB_RatesHudProfile";
		        horizSizing = "left";
		        vertSizing  = "top";
		        position    = "35 23";
		        extent      = "30 16 ";
		        minExtent   = "8 8";
		        visible     = "0";
			    helpTag     = "0";
			    lineSpacing = "2";
			    allowColorChars = "0";
			    maxChars    = "-1";
	        };
	        
	        new GuiMLTextCtrl(MB_ExtRatesHudCellPingMax)
	        {
		        profile     = "MB_RatesHudProfile";
		        horizSizing = "left";
		        vertSizing  = "top";
		        position    = "70 23";
		        extent      = "30 16 ";
		        minExtent   = "8 8";
		        visible     = "0";
			    helpTag     = "0";
			    lineSpacing = "2";
			    allowColorChars = "0";
			    maxChars    = "-1";
	        };
	        
	        new GuiMLTextCtrl(MB_ExtRatesHudCellPingAvg)
	        {
		        profile     = "MB_RatesHudProfile";
		        horizSizing = "left";
		        vertSizing  = "top";
		        position    = "105 23";
		        extent      = "30 16 ";
		        minExtent   = "8 8";
		        visible     = "0";
			    helpTag     = "0";
			    lineSpacing = "2";
			    allowColorChars = "0";
			    maxChars    = "-1";
	        };
	        
	        new GuiMLTextCtrl(MB_ExtRatesHudCellPlossMin)
	        {
		        profile     = "MB_RatesHudProfile";
		        horizSizing = "left";
		        vertSizing  = "top";
		        position    = "35 35";
		        extent      = "30 16 ";
		        minExtent   = "8 8";
		        visible     = "0";
			    helpTag     = "0";
			    lineSpacing = "2";
			    allowColorChars = "0";
			    maxChars    = "-1";
	        };
	        
	        new GuiMLTextCtrl(MB_ExtRatesHudCellPlossMax)
	        {
		        profile     = "MB_RatesHudProfile";
		        horizSizing = "left";
		        vertSizing  = "top";
		        position    = "70 35";
		        extent      = "30 16 ";
		        minExtent   = "8 8";
		        visible     = "0";
			    helpTag     = "0";
			    lineSpacing = "2";
			    allowColorChars = "0";
			    maxChars    = "-1";
	        };
	        
	        new GuiMLTextCtrl(MB_ExtRatesHudCellPlossAvg)
	        {
		        profile     = "MB_RatesHudProfile";
		        horizSizing = "left";
		        vertSizing  = "top";
		        position    = "105 35";
		        extent      = "30 16 ";
		        minExtent   = "8 8";
		        visible     = "0";
			    helpTag     = "0";
			    lineSpacing = "2";
			    allowColorChars = "0";
			    maxChars    = "-1";
	        };
	        
	    };
	
	    playgui.add($MB_ExtRatesHudBox);
    }

    //- - - - - - - - - - - - - - - - -
    
    function DisconnectedCleanup()
    {
	    parent::DisconnectedCleanup();
    }

};

//---------------------------------------------------------

$MB_PJTimeHud = MB_CheckForPJTimeHud();

activatePackage(MB_RatesHudLoad);

//---------------------------------------------------------

