
// #name    = MB_HudRates Options Screen
// #version = 2.3
// #date    = April 30, 2001
// #author  = Lance Gharat ([AKA]madBOT)
// #email   = madBOT@tribescape.com
// #web     = http://www.tribescape.com
// #description = Change MB_HudRates Options.
// #acknowledgements = Mark Dickenson ([AKA]Panama Jack)
// #status  = work in progress

// defaults in case there is no prefs file
$MB_Pref::EnablePingPl = "0";
$MB_Pref::ExtendedInfo = "0";
$MB_Pref::FpsColor1 = "white";
$MB_Pref::FpsColor2 = "blue";
$MB_Pref::FpsColor3 = "green";
$MB_Pref::FpsColor4 = "yellow";
$MB_Pref::FpsColor5 = "orange";
$MB_Pref::FpsColor6 = "red";
$MB_Pref::PingColor1 = "white";
$MB_Pref::PingColor2 = "blue";
$MB_Pref::PingColor3 = "green";
$MB_Pref::PingColor4 = "yellow";
$MB_Pref::PingColor5 = "orange";
$MB_Pref::PingColor6 = "red";
$MB_Pref::PlossColor1 = "white";
$MB_Pref::PlossColor2 = "blue";
$MB_Pref::PlossColor3 = "green";
$MB_Pref::PlossColor4 = "yellow";
$MB_Pref::PlossColor5 = "orange";
$MB_Pref::PlossColor6 = "red";
$MB_Pref::PollFpsSecs = 1;
$MB_Pref::PollRateSecs = 4;

// load the prefs file
exec("prefs/MB_ClientPrefs.cs");
exec("scripts/autoexec/madbot/MB_Colors.cs");

$PJ_TabId = 69;
$MB_TabId = 99;

$MB_Version = "2.3";

$MB_Header[0] = "FPS Rate";
$MB_Header[1] = "Ping & Packet Loss";
$MB_Header[2] = "Extended Information";

$MB_TextLabel[0] = "FPS Colors";
$MB_TextLabel[1] = "Ping Colors";
$MB_TextLabel[2] = "PL% Colors";

$MB_TextFps[0] = "   100+";
$MB_TextFps[1] = "80 - 99";
$MB_TextFps[2] = "60 - 79";
$MB_TextFps[3] = "40 - 59";
$MB_TextFps[4] = "20 - 39";
$MB_TextFps[5] = "  0 - 19";

$MB_TextPing[0] = "     0 -   49";
$MB_TextPing[1] = "   50 -   99";
$MB_TextPing[2] = "100 - 199";
$MB_TextPing[3] = "200 - 299";
$MB_TextPing[4] = "300 - 399";
$MB_TextPing[5] = "     400+";

$MB_TextPloss[0] = "0";
$MB_TextPloss[1] = "1";
$MB_TextPloss[2] = "2 - 3";
$MB_TextPloss[3] = "4 - 7";
$MB_TextPloss[4] = "8 - 15";
$MB_TextPloss[5] = "16+";

$MB_PaneWidth  = "590";
$MB_PaneHeight = "312";

$MB_CellWidth1 = "135";
$MB_CellWidth2 = "270";

$MB_CellHeight1 = "238";
$MB_CellHeight2 = "70";

$MB_PosX1 = "10";
$MB_PosX2 = "45";
$MB_PosX3 = "10";
$MB_PosX4 = "60";
$MB_PosX5 = "229";
$MB_PosX6 = "143";

$MB_PosY1 = "76";
$MB_PosY2 = "25";

package MB_GameLoad
{
    //----------------------------------------

    function MB_MakeOptions()
    {
        new GuiControlProfile ("MB_OptionMessageTextProfile")
        {
	        fontType = "Univers Condensed";
	        fontSize = 12;
	        fontColor = "66 219 234";
	        fontColorHL = "25 68 56";
	        fillColorHL = "50 233 206";
	        cursorColor = "200 240 240";
	        autoSizeWidth = false;
	        autoSizeHeight = false;
	        tab = true;
	        canKeyFocus = true;
        };

        $MB_Option = new GuiControl(GM_MB_OptionPane)
        {
			profile = "GuiDefaultProfile";
			horizSizing = "width";
			vertSizing = "height";
			position = "32 64";
			extent = $MB_PaneWidth @ " " @ $MB_PaneHeight;
			minExtent = "8 8";
			visible = "0";
			helpTag = "0";

			new GuiControl(GMH_MB_OptionGui) {
				profile = "GuiDefaultProfile";
				horizSizing = "center";
				vertSizing = "center";
				position = "0 0";
				extent = $MB_PaneWidth @ " " @ $MB_PaneHeight;
				minExtent = "8 8";
				visible = "1";
				helpTag = "0";

			    //- - - - - - - - - - - - - -

				new ShellFieldCtrl(GMH_MB_FpsCell) {
					profile = "ShellFieldProfile";
					horizSizing = "width";
					vertSizing = "height";
					position = "0 0";
					extent = $MB_CellWidth1 @ " " @ $MB_CellHeight1;
					minExtent = "16 18";
					visible = "1";
					helpTag = "0";

					//- - - - - - -
					new GuiMLTextCtrl(GMH_MB_FpsHeader) {
						profile = "ShellTextCenterProfile";
						horizSizing = "center";
						vertSizing = "bottom";
						position = "0 5";
						extent = "130 30";
						minExtent = "8 8";
						visible = "1";
						helpTag = "0";
						text = $MB_Header[0];
						maxLength = "255";
					};
					//- - - - - - -
					new GuiTextCtrl(GMH_MB_FpsPollSecsText) {
						profile = "ShellTextCenterProfile";
						horizSizing = "center";
						vertSizing = "bottom";
						position = "0 25";
						extent = "130 30";
						minExtent = "8 8";
						visible = "1";
						helpTag = "0";
						text = "Update Seconds : ";
						maxLength = "255";
						};
					new ShellSliderCtrl(GMH_MB_FpsPollSecsSlider) {
						profile = "ShellSliderProfile";
						horizSizing = "right";
						vertSizing = "bottom";
						position = "3 40";
						extent = "125 24";
						minExtent = "12 24";
						visible = "1";
						variable = "value";
						altCommand = "MB_SetFpsPollSecs();";
						helpTag = "0";
						range = "0.000000 1.000000";
						ticks = "5";
						value = "0";
						usePlusMinus = "1";
					};
					//- - - - - - -
					new GuiMLTextCtrl(GMH_MB_FpsColorsText) {
						profile = "ShellTextCenterProfile";
						horizSizing = "center";
						vertSizing = "bottom";
						position = "0 65";
						extent = "130 30";
						minExtent = "8 8";
						visible = "1";
						helpTag = "0";
						text = $MB_TextLabel[0];
						maxLength = "255";
						};
				    new GuiTextCtrl(GMH_MB_FpsColor1Text) {
					    profile = "ShellTextProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX1 @ " " @ $MB_PosY1 + 11;
					    extent = "60 22";
					    minExtent = "8 8";
					    visible = "1";
					    helpTag = "0";
					    text = $MB_TextFps[0];
					    maxLength = "255";
				    };
				    new ShellPopupMenu(GMH_MB_FpsColorType1) {
					    profile = "ShellPopupProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX2 @ " " @ $MB_PosY1;
					    extent = "90 22";
					    minExtent = "49 36";
					    visible = "1";
					    helpTag = "0";
					    text = "FpsColor1";
					    maxLength = "255";
					    maxPopupHeight = "200";
					    buttonBitmap = "gui/shll_pulldown";
					    rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					    selectedBarBitmap = "gui/shll_pulldownbar_act";
					    noButtonStyle = "0";
				    };
				    new GuiTextCtrl(GMH_MB_FpsColor2Text) {
					    profile = "ShellTextProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX1 @ " " @ $MB_PosY1 + 10 + ($MB_PosY2*1);
					    extent = "60 22";
					    minExtent = "8 8";
					    visible = "1";
					    helpTag = "0";
					    text = $MB_TextFps[1];
					    maxLength = "255";
				    };
				    new ShellPopupMenu(GMH_MB_FpsColorType2) {
					    profile = "ShellPopupProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX2 @ " " @ $MB_PosY1 + ($MB_PosY2*1);
					    extent = "90 22";
					    minExtent = "49 36";
					    visible = "1";
					    helpTag = "0";
					    text = "FpsColor2";
					    maxLength = "255";
					    maxPopupHeight = "200";
					    buttonBitmap = "gui/shll_pulldown";
					    rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					    selectedBarBitmap = "gui/shll_pulldownbar_act";
					    noButtonStyle = "0";
				    };
				    new GuiTextCtrl(GMH_MB_FpsColor3Text) {
					    profile = "ShellTextProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX1 @ " " @ $MB_PosY1 + 10 + ($MB_PosY2*2);
					    extent = "60 22";
					    minExtent = "8 8";
					    visible = "1";
					    helpTag = "0";
					    text = $MB_TextFps[2];
					    maxLength = "255";
				    };
				    new ShellPopupMenu(GMH_MB_FpsColorType3) {
					    profile = "ShellPopupProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX2 @ " " @ $MB_PosY1 + ($MB_PosY2*2);
					    extent = "90 22";
					    minExtent = "49 36";
					    visible = "1";
					    helpTag = "0";
					    text = "FpsColor3";
					    maxLength = "255";
					    maxPopupHeight = "200";
					    buttonBitmap = "gui/shll_pulldown";
					    rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					    selectedBarBitmap = "gui/shll_pulldownbar_act";
					    noButtonStyle = "0";
				    };
				    new GuiTextCtrl(GMH_MB_FpsColor4Text) {
					    profile = "ShellTextProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX1 @ " " @ $MB_PosY1 + 10 + ($MB_PosY2*3);
					    extent = "60 22";
					    minExtent = "8 8";
					    visible = "1";
					    helpTag = "0";
					    text = $MB_TextFps[3];
					    maxLength = "255";
				    };
				    new ShellPopupMenu(GMH_MB_FpsColorType4) {
					    profile = "ShellPopupProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX2 @ " " @ $MB_PosY1 + ($MB_PosY2*3);
					    extent = "90 22";
					    minExtent = "49 36";
					    visible = "1";
					    helpTag = "0";
					    text = "FpsColor4";
					    maxLength = "255";
					    maxPopupHeight = "200";
					    buttonBitmap = "gui/shll_pulldown";
					    rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					    selectedBarBitmap = "gui/shll_pulldownbar_act";
					    noButtonStyle = "0";
				    };
				    new GuiTextCtrl(GMH_MB_FpsColor5Text) {
					    profile = "ShellTextProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX1 @ " " @ $MB_PosY1 + 10 + ($MB_PosY2*4);
					    extent = "60 22";
					    minExtent = "8 8";
					    visible = "1";
					    helpTag = "0";
					    text = $MB_TextFps[4];
					    maxLength = "255";
				    };
				    new ShellPopupMenu(GMH_MB_FpsColorType5) {
					    profile = "ShellPopupProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX2 @ " " @ $MB_PosY1 + ($MB_PosY2*4);
					    extent = "90 22";
					    minExtent = "49 36";
					    visible = "1";
					    helpTag = "0";
					    text = "FpsColor5";
					    maxLength = "255";
					    maxPopupHeight = "200";
					    buttonBitmap = "gui/shll_pulldown";
					    rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					    selectedBarBitmap = "gui/shll_pulldownbar_act";
					    noButtonStyle = "0";
				    };
				    new GuiTextCtrl(GMH_MB_FpsColor6Text) {
					    profile = "ShellTextProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX1 @ " " @ $MB_PosY1 + 10 + ($MB_PosY2*5);
					    extent = "60 22";
					    minExtent = "8 8";
					    visible = "1";
					    helpTag = "0";
					    text = $MB_TextFps[5];
					    maxLength = "255";
				    };
				    new ShellPopupMenu(GMH_MB_FpsColorType6) {
					    profile = "ShellPopupProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX2 @ " " @ $MB_PosY1 + ($MB_PosY2*5);
					    extent = "90 22";
					    minExtent = "49 36";
					    visible = "1";
					    helpTag = "0";
					    text = "FpsColor6";
					    maxLength = "255";
					    maxPopupHeight = "200";
					    buttonBitmap = "gui/shll_pulldown";
					    rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					    selectedBarBitmap = "gui/shll_pulldownbar_act";
					    noButtonStyle = "0";
				    };
					//- - - - - - -
				};

			    //- - - - - - - - - - - - - -

				new ShellFieldCtrl(GMH_MB_AuthorCell) {
					profile = "ShellFieldProfile";
					horizSizing = "width";
					vertSizing = "height";
					position = "0 " @ $MB_CellHeight1;
					extent = $MB_CellWidth1 @ " " @ $MB_CellHeight2;
					minExtent = "16 18";
					visible = "1";
					helpTag = "0";

					new GuiTextCtrl(GMH_MB_AuthorLine1) {
						profile = "ShellTextCenterProfile";
						horizSizing = "left";
						vertSizing = "bottom";
						position = "0 9";
						extent = "135 20";
						minExtent = "8 8";
						visible = "1";
						helpTag = "0";
						text = "madBOT's T2 Scripts";
						maxLength = "255";
					};
					new GuiTextCtrl(GMH_MB_AuthorLine2) {
						profile = "ShellTextCenterProfile";
						horizSizing = "left";
						vertSizing = "bottom";
						position = "0 27";
						extent = "135 20";
						minExtent = "8 8";
						visible = "1";
						helpTag = "0";
						text = "Version " @ $MB_Version;
						maxLength = "255";
					};
					new GuiTextCtrl(GMH_MB_AuthorLine2) {
						profile = "ShellTextCenterProfile";
						horizSizing = "left";
						vertSizing = "bottom";
						position = "0 45";
						extent = "135 20";
						minExtent = "8 8";
						visible = "1";
						helpTag = "0";
						text = "(c) 2001 Lance Gharat";
						maxLength = "255";
					};
				};

			    //- - - - - - - - - - - - - -

				new ShellFieldCtrl(GMH_MB_PPLCell) {
					profile = "ShellFieldProfile";
					horizSizing = "width";
					vertSizing = "height";
					position = $MB_CellWidth1 @ " 0";
					extent = $MB_CellWidth2 @ " " @ $MB_CellHeight1;
					minExtent = "16 18";
					visible = "1";
					helpTag = "0";

					//- - - - - - -
					new GuiMLTextCtrl(GMH_MB_PPLHeader) {
						profile = "ShellTextCenterProfile";
						horizSizing = "center";
						vertSizing = "bottom";
						position = "0 5";
						extent = "145 30";
						minExtent = "8 8";
						visible = "1";
						helpTag = "0";
						text = $MB_Header[1];
						maxLength = "255";
					};
					//- - - - - - -
					new GuiMLTextCtrl(GMH_MB_EnablePPLText) {
						profile = "ShellTextCenterProfile";
						horizSizing = "left";
						vertSizing = "bottom";
						position = "0 25";
						extent = "175 9";
						minExtent = "8 8";
						visible = "1";
						helpTag = "0";
						text = $MB_Header[2];
						maxLength = "255";
					};
					new ShellToggleButton(GMH_MB_EnablePPLTgl) {
						profile = "ShellRadioProfile";
						horizSizing = "left";
						vertSizing = "bottom";
						position = "5 40";
						extent = "120 30";
						minExtent = "26 27";
						visible = "1";
						variable = "$MB_Pref::EnablePingPl";
						helpTag = "0";
						text = "Enable Ping/PL";
						maxLength = "255";
					};
					//- - - - - - -
					new GuiTextCtrl(GMH_MB_RatePollSecsText) {
						profile = "ShellTextCenterProfile";
						horizSizing = "left";
						vertSizing = "bottom";
						position = "135 25";
						extent = "130 30";
						minExtent = "8 8";
						visible = "1";
						helpTag = "0";
						text = "Update Seconds : ";
						maxLength = "255";
						};
					new ShellSliderCtrl(GMH_MB_RatePollSecsSlider) {
						profile = "ShellSliderProfile";
						horizSizing = "left";
						vertSizing = "bottom";
						position = "138 40";
						extent = "125 24";
						minExtent = "12 24";
						visible = "1";
						variable = "value";
						altCommand = "MB_SetRatePollSecs();";
						helpTag = "0";
						range = "0.000000 1.000000";
						ticks = "5";
						value = "0";
						usePlusMinus = "1";
					};
					//- - - - - - -
					new GuiMLTextCtrl(GMH_MB_PingColorsText) {
						profile = "ShellTextCenterProfile";
						horizSizing = "right";
						vertSizing = "bottom";
						position = "0 65";
						extent = "130 30";
						minExtent = "8 8";
						visible = "1";
						helpTag = "0";
						text = $MB_TextLabel[1];
						maxLength = "255";
						};
				    new GuiTextCtrl(GMH_MB_PingColor1Text) {
					    profile = "ShellTextProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX3 @ " " @ $MB_PosY1 + 10 + ($MB_PosY2*0);
					    extent = "60 22";
					    minExtent = "8 8";
					    visible = "1";
					    helpTag = "0";
					    text = $MB_TextPing[0];
					    maxLength = "255";
				    };
				    new ShellPopupMenu(GMH_MB_PingColorType1) {
					    profile = "ShellPopupProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX4 @ " " @ $MB_PosY1 + ($MB_PosY2*0);
					    extent = "90 22";
					    minExtent = "49 36";
					    visible = "1";
					    helpTag = "0";
					    text = "PingColor1";
					    maxLength = "255";
					    maxPopupHeight = "200";
					    buttonBitmap = "gui/shll_pulldown";
					    rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					    selectedBarBitmap = "gui/shll_pulldownbar_act";
					    noButtonStyle = "0";
				    };
				    new GuiTextCtrl(GMH_MB_PingColor2Text) {
					    profile = "ShellTextProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX3 @ " " @ $MB_PosY1 + 10 + ($MB_PosY2*1);
					    extent = "60 22";
					    minExtent = "8 8";
					    visible = "1";
					    helpTag = "0";
					    text = $MB_TextPing[1];
					    maxLength = "255";
				    };
				    new ShellPopupMenu(GMH_MB_PingColorType2) {
					    profile = "ShellPopupProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX4 @ " " @ $MB_PosY1 + ($MB_PosY2*1);
					    extent = "90 22";
					    minExtent = "49 36";
					    visible = "1";
					    helpTag = "0";
					    text = "PingColor2";
					    maxLength = "255";
					    maxPopupHeight = "200";
					    buttonBitmap = "gui/shll_pulldown";
					    rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					    selectedBarBitmap = "gui/shll_pulldownbar_act";
					    noButtonStyle = "0";
				    };
				    new GuiTextCtrl(GMH_MB_PingColor3Text) {
					    profile = "ShellTextProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX3 @ " " @ $MB_PosY1 + 10 + ($MB_PosY2*2);
					    extent = "60 22";
					    minExtent = "8 8";
					    visible = "1";
					    helpTag = "0";
					    text = $MB_TextPing[2];
					    maxLength = "255";
				    };
				    new ShellPopupMenu(GMH_MB_PingColorType3) {
					    profile = "ShellPopupProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX4 @ " " @ $MB_PosY1 + ($MB_PosY2*2);
					    extent = "90 22";
					    minExtent = "49 36";
					    visible = "1";
					    helpTag = "0";
					    text = "PingColor3";
					    maxLength = "255";
					    maxPopupHeight = "200";
					    buttonBitmap = "gui/shll_pulldown";
					    rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					    selectedBarBitmap = "gui/shll_pulldownbar_act";
					    noButtonStyle = "0";
				    };
				    new GuiTextCtrl(GMH_MB_PingColor4Text) {
					    profile = "ShellTextProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX3 @ " " @ $MB_PosY1 + 10 + ($MB_PosY2*3);
					    extent = "60 22";
					    minExtent = "8 8";
					    visible = "1";
					    helpTag = "0";
					    text = $MB_TextPing[3];
					    maxLength = "255";
				    };
				    new ShellPopupMenu(GMH_MB_PingColorType4) {
					    profile = "ShellPopupProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX4 @ " " @ $MB_PosY1 + ($MB_PosY2*3);
					    extent = "90 22";
					    minExtent = "49 36";
					    visible = "1";
					    helpTag = "0";
					    text = "PingColor4";
					    maxLength = "255";
					    maxPopupHeight = "200";
					    buttonBitmap = "gui/shll_pulldown";
					    rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					    selectedBarBitmap = "gui/shll_pulldownbar_act";
					    noButtonStyle = "0";
				    };
				    new GuiTextCtrl(GMH_MB_PingColor5Text) {
					    profile = "ShellTextProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX3 @ " " @ $MB_PosY1 + 10 + ($MB_PosY2*4);
					    extent = "60 22";
					    minExtent = "8 8";
					    visible = "1";
					    helpTag = "0";
					    text = $MB_TextPing[4];
					    maxLength = "255";
				    };
				    new ShellPopupMenu(GMH_MB_PingColorType5) {
					    profile = "ShellPopupProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX4 @ " " @ $MB_PosY1 + ($MB_PosY2*4);
					    extent = "90 22";
					    minExtent = "49 36";
					    visible = "1";
					    helpTag = "0";
					    text = "PingColor5";
					    maxLength = "255";
					    maxPopupHeight = "200";
					    buttonBitmap = "gui/shll_pulldown";
					    rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					    selectedBarBitmap = "gui/shll_pulldownbar_act";
					    noButtonStyle = "0";
				    };
				    new GuiTextCtrl(GMH_MB_PingColor6Text) {
					    profile = "ShellTextProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX3 @ " " @ $MB_PosY1 + 10 + ($MB_PosY2*5);
					    extent = "60 22";
					    minExtent = "8 8";
					    visible = "1";
					    helpTag = "0";
					    text = $MB_TextPing[5];
					    maxLength = "255";
				    };
				    new ShellPopupMenu(GMH_MB_PingColorType6) {
					    profile = "ShellPopupProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX4 @ " " @ $MB_PosY1 + ($MB_PosY2*5);
					    extent = "90 22";
					    minExtent = "49 36";
					    visible = "1";
					    helpTag = "0";
					    text = "PingColor6";
					    maxLength = "255";
					    maxPopupHeight = "200";
					    buttonBitmap = "gui/shll_pulldown";
					    rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					    selectedBarBitmap = "gui/shll_pulldownbar_act";
					    noButtonStyle = "0";
				    };
					//- - - - - - -
					new GuiMLTextCtrl(GMH_MB_PlossColorsText) {
						profile = "ShellTextCenterProfile";
						horizSizing = "right";
						vertSizing = "bottom";
						position = "135 65";
						extent = "130 30";
						minExtent = "8 8";
						visible = "1";
						helpTag = "0";
						text = $MB_TextLabel[2];
						maxLength = "255";
						};
				    new GuiTextCtrl(GMH_MB_PlossColor1Text) {
					    profile = "ShellTextProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX5 @ " " @ $MB_PosY1 + 10 + ($MB_PosY2*0);
					    extent = "60 22";
					    minExtent = "8 8";
					    visible = "1";
					    helpTag = "0";
					    text = $MB_TextPloss[0];
					    maxLength = "255";
				    };
				    new ShellPopupMenu(GMH_MB_PlossColorType1) {
					    profile = "ShellPopupProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX6 @ " " @ $MB_PosY1 + ($MB_PosY2*0);
					    extent = "90 22";
					    minExtent = "49 36";
					    visible = "1";
					    helpTag = "0";
					    text = "PlossColor1";
					    maxLength = "255";
					    maxPopupHeight = "200";
					    buttonBitmap = "gui/shll_pulldown";
					    rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					    selectedBarBitmap = "gui/shll_pulldownbar_act";
					    noButtonStyle = "0";
				    };
				    new GuiTextCtrl(GMH_MB_PlossColor2Text) {
					    profile = "ShellTextProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX5 @ " " @ $MB_PosY1 + 10 + ($MB_PosY2*1);
					    extent = "60 22";
					    minExtent = "8 8";
					    visible = "1";
					    helpTag = "0";
					    text = $MB_TextPloss[1];
					    maxLength = "255";
				    };
				    new ShellPopupMenu(GMH_MB_PlossColorType2) {
					    profile = "ShellPopupProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX6 @ " " @ $MB_PosY1 + ($MB_PosY2*1);
					    extent = "90 22";
					    minExtent = "49 36";
					    visible = "1";
					    helpTag = "0";
					    text = "PlossColor2";
					    maxLength = "255";
					    maxPopupHeight = "200";
					    buttonBitmap = "gui/shll_pulldown";
					    rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					    selectedBarBitmap = "gui/shll_pulldownbar_act";
					    noButtonStyle = "0";
				    };
				    new GuiTextCtrl(GMH_MB_PlossColor3Text) {
					    profile = "ShellTextProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX5 @ " " @ $MB_PosY1 + 10 + ($MB_PosY2*2);
					    extent = "60 22";
					    minExtent = "8 8";
					    visible = "1";
					    helpTag = "0";
					    text = $MB_TextPloss[2];
					    maxLength = "255";
				    };
				    new ShellPopupMenu(GMH_MB_PlossColorType3) {
					    profile = "ShellPopupProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX6 @ " " @ $MB_PosY1 + ($MB_PosY2*2);
					    extent = "90 22";
					    minExtent = "49 36";
					    visible = "1";
					    helpTag = "0";
					    text = "PlossColor3";
					    maxLength = "255";
					    maxPopupHeight = "200";
					    buttonBitmap = "gui/shll_pulldown";
					    rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					    selectedBarBitmap = "gui/shll_pulldownbar_act";
					    noButtonStyle = "0";
				    };
				    new GuiTextCtrl(GMH_MB_PlossColor4Text) {
					    profile = "ShellTextProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX5 @ " " @ $MB_PosY1 + 10 + ($MB_PosY2*3);
					    extent = "60 22";
					    minExtent = "8 8";
					    visible = "1";
					    helpTag = "0";
					    text = $MB_TextPloss[3];
					    maxLength = "255";
				    };
				    new ShellPopupMenu(GMH_MB_PlossColorType4) {
					    profile = "ShellPopupProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX6 @ " " @ $MB_PosY1 + ($MB_PosY2*3);
					    extent = "90 22";
					    minExtent = "49 36";
					    visible = "1";
					    helpTag = "0";
					    text = "PlossColor4";
					    maxLength = "255";
					    maxPopupHeight = "200";
					    buttonBitmap = "gui/shll_pulldown";
					    rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					    selectedBarBitmap = "gui/shll_pulldownbar_act";
					    noButtonStyle = "0";
				    };
				    new GuiTextCtrl(GMH_MB_PlossColor5Text) {
					    profile = "ShellTextProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX5 @ " " @ $MB_PosY1 + 10 + ($MB_PosY2*4);
					    extent = "60 22";
					    minExtent = "8 8";
					    visible = "1";
					    helpTag = "0";
					    text = $MB_TextPloss[4];
					    maxLength = "255";
				    };
				    new ShellPopupMenu(GMH_MB_PlossColorType5) {
					    profile = "ShellPopupProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX6 @ " " @ $MB_PosY1 + ($MB_PosY2*4);
					    extent = "90 22";
					    minExtent = "49 36";
					    visible = "1";
					    helpTag = "0";
					    text = "PlossColor5";
					    maxLength = "255";
					    maxPopupHeight = "200";
					    buttonBitmap = "gui/shll_pulldown";
					    rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					    selectedBarBitmap = "gui/shll_pulldownbar_act";
					    noButtonStyle = "0";
				    };
				    new GuiTextCtrl(GMH_MB_PlossColor6Text) {
					    profile = "ShellTextProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX5 @ " " @ $MB_PosY1 + 10 + ($MB_PosY2*5);
					    extent = "60 22";
					    minExtent = "8 8";
					    visible = "1";
					    helpTag = "0";
					    text = $MB_TextPloss[5];
					    maxLength = "255";
				    };
				    new ShellPopupMenu(GMH_MB_PlossColorType6) {
					    profile = "ShellPopupProfile";
					    horizSizing = "right";
					    vertSizing = "bottom";
					    position = $MB_PosX6 @ " " @ $MB_PosY1 + ($MB_PosY2*5);
					    extent = "90 22";
					    minExtent = "49 36";
					    visible = "1";
					    helpTag = "0";
					    text = "PlossColor6";
					    maxLength = "255";
					    maxPopupHeight = "200";
					    buttonBitmap = "gui/shll_pulldown";
					    rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					    selectedBarBitmap = "gui/shll_pulldownbar_act";
					    noButtonStyle = "0";
				    };
					//- - - - - - -
				};

			    //- - - - - - - - - - - - - -

				new ShellFieldCtrl(MB_ExtendedInfoCell) {
					profile = "ShellFieldProfile";
					horizSizing = "width";
					vertSizing = "height";
					position = $MB_CellWidth1 @ " " @ $MB_CellHeight1;
					extent = $MB_CellWidth2 @ " " @ $MB_CellHeight2;
					minExtent = "16 18";
					visible = "1";
					helpTag = "0";

					new GuiMLTextCtrl(GMH_MB_ExtendedInfoText) {
						profile = "ShellTextCenterProfile";
						horizSizing = "center";
						vertSizing = "bottom";
						position = "0 9";
						extent = "175 9";
						minExtent = "8 8";
						visible = "1";
						helpTag = "0";
						text = $MB_Header[2];
						maxLength = "255";
					};
					new ShellToggleButton(GMH_MB_ExtendedInfoTgl) {
						profile = "ShellRadioProfile";
						horizSizing = "center";
						vertSizing = "bottom";
						position = "5 30";
						extent = "120 30";
						minExtent = "26 27";
						visible = "1";
						variable = "$MB_Pref::ExtendedInfo";
						helpTag = "0";
						text = "Display Min/Max/Avg";
						maxLength = "255";
					};
				};

			    //- - - - - - - - - - - - - -

				new ShellFieldCtrl() {
					profile = "ShellFieldProfile";
					horizSizing = "width";
					vertSizing = "height";
					position = "405 0";
					extent = "153 308";
					minExtent = "16 18";
					visible = "1";
					helpTag = "0";

					new ShellScrollCtrl(MB__MessagePane) {
						profile = "NewScrollCtrlProfile";
						horizSizing = "left";
						vertSizing = "height";
						position = "0 0";
						extent = "153 308";
						minExtent = "24 52";
						visible = "1";
						helpTag = "0";
						willFirstRespond = "1";
						hScrollBar = "alwaysOff";
						vScrollBar = "alwaysOn";
						constantThuMB_Height = "0";
						defaultLineHeight = "15";
						childMargin = "3 3";
						fieldBase = "gui/shll_field";

						new GuiScrollContentCtrl() {
							profile = "GuiDefaultProfile";
							horizSizing = "right";
							vertSizing = "bottom";
							position = "7 7";
							extent = "150 300";
							minExtent = "8 8";
							visible = "1";
							helpTag = "0";

							new GuiMLTextCtrl(MB_OptionBodyText) {
								profile = "MB_OptionMessageTextProfile";
								horizSizing = "width";
								vertSizing = "bottom";
								position = "0 0";
								extent = "123 295";
								minExtent = "8 8";
								visible = "1";
								helpTag = "0";
								lineSpacing = "2";
								allowColorChars = "0";
								maxChars = "-1";
							};
						};
					};
				};
			};
		};
    }

    //----------------------------------------

    function DispatchLaunchMode()
    {
	    MB_MakeOptions();
	    GM_Frame.add($MB_Option);

	    parent::DispatchLaunchMode();
    }

    //----------------------------------------

    function GameGui::onWake( %this )
    {
	    $MB_GameObject = %this.pane;
	    parent::onWake( %this );

	    if ( $MB_GameLoaded != 1 )
	    {
		    $MB_GameLoaded = 1;
		    GM_TabView.addTab( $MB_TabId, "madBOT's RatesHud" , 1);
 	    }

	    switch$ ( $MB_GameObject )
	    {
		    case "MB_Option":
			    GM_TabView.setSelected( $MB_TabId );
	    }
    }

    //----------------------------------------

    function GM_TabView::onSelect( %this, %id, %text )
    {
	    if ( %id != $MB_TabId )
	    {
		    GM_MB_OptionPane.setVisible( %id == $MB_TabId );
		    parent::onSelect( %this, %id, %text );
	    }
	    else
	    {
		    GM_JoinPane.setVisible( %id == 1 );
		    GM_HostPane.setVisible( %id == 2 );
		    GM_WarriorPane.setVisible( %id == 3 );
		    
		    GM_PJOptionPane.setVisible( %id == $PJ_TabId );
		    
		    GM_TabFrame.setAltColor( %this.getTabSet( %id ) != 0 );
		    GM_MB_OptionPane.setVisible( %id == $MB_TabId );

		    %ctrl = "GM_" @ GameGui.pane @ "Pane";

		    if ( isObject( %ctrl ) )
			    %ctrl.onDeactivate();

		    switch ( %id )
		    {
			    case $MB_TabId:  // Options
				    GM_MB_OptionPane.onActivate();
		    }
	    }
    }
};

//------------------------------------------------------------------------------

activatePackage(MB_GameLoad);

//------------------------------------------------------------------------------

function GM_MB_OptionPane::onActivate( %this )
{
	GameGui.pane = "MB_Option";
	
	MB_SetHeaderColors();

    MB_LoadSliders();
    
    MB_LoadPopups();

	if($MB_OptionReadMe $= "")
		MB_LoadReadme();

	MB_OptionBodyText.setValue($MB_OptionReadMe);
	
	MB_GetSelectedColors();
}

//------------------------------------------------------------------------------

function GM_MB_OptionPane::onDeactivate( %this )
{
    GM_MB_SavePrefs();
}

//------------------------------------------------------------------------------

function GM_MB_SavePrefs()
{
    MB_GetSelectedColors();
    
	export("$MB_Pref::*", "prefs/MB_ClientPrefs.cs", false);
	
	echo("Saved madBOT's Prefs");
	
	exec("scripts/autoexec/madbot/MB_RatesHud.cs");
}

//------------------------------------------------------------------------------

function MB_SetFpsPollSecs()
{
	$MB_Pref::PollFpsSecs = mfloor(GMH_MB_FpsPollSecsSlider.getValue() * 4) + 1;
	GMH_MB_FpsPollSecsText.setValue("Update Seconds: " @ $MB_Pref::PollFpsSecs);
}

//------------------------------------------------------------------------------

function MB_SetRatePollSecs()
{
	$MB_Pref::PollRateSecs = mfloor(GMH_MB_RatePollSecsSlider.getValue() * 4) + 1;
	GMH_MB_RatePollSecsText.setValue("Update Seconds: " @ $MB_Pref::PollRateSecs);
}

//------------------------------------------------------------------------------

function MB_LoadReadme() {

	%file = new FileObject();
	
	$MB_OptionReadMe = "";

	if( ! %file.openForRead("scripts/autoexec/madbot/MB_RatesHud.txt") )
	{
		$MB_OptionReadMe = "No Readme";
		%file.close();
		%file.delete();
		return;
	}

	for(%i = 1; !%file.isEOF(); %i++) {
		%string = %string @ %file.readLine() @ "\n";
	}

	%file.close();
	%file.delete();
	
	$MB_OptionReadMe = %string;
}

//------------------------------------------------------------------------------

function MB_SetHeaderColors()
{
    GMH_MB_FpsHeader.setValue("<just:center><color:ffff00>" @ $MB_Header[0]);
    GMH_MB_PPLHeader.setValue("<just:center><color:ffff00>" @ $MB_Header[1]);
    GMH_MB_ExtendedInfoText.setValue("<just:center><color:ffff00>" @ $MB_Header[2]);

    GMH_MB_FpsColorsText.setValue("<just:center><color:06e166>" @ $MB_TextLabel[0]);
    GMH_MB_PingColorsText.setValue("<just:center><color:06e166>" @ $MB_TextLabel[1]);
    GMH_MB_PlossColorsText.setValue("<just:center><color:06e166>" @ $MB_TextLabel[2]);
}

//------------------------------------------------------------------------------

function MB_LoadSliders()
{
	GMH_MB_FpsPollSecsText.setValue("Update Seconds : " @ $MB_Pref::PollFpsSecs);
	%temp = $MB_Pref::PollFpsSecs - 0;
	GMH_MB_FpsPollSecsSlider.setValue( %temp * 0.2); 

	GMH_MB_RatePollSecsText.setValue("Update Seconds : " @ $MB_Pref::PollRateSecs);
	%temp = $MB_Pref::PollRateSecs - 0;
	GMH_MB_RatePollSecsSlider.setValue( %temp * 0.2); 
}

//------------------------------------------------------------------------------

function MB_LoadPopups()
{
    //- - - - - - - - - - - - - - - - - -
    
    MB_BuildColorSelectPopup( GMH_MB_FpsColorType1 );
    GMH_MB_FpsColorType1.setSelected( $MB_ColorIdx[$MB_Pref::FpsColor1] );
    
    MB_BuildColorSelectPopup( GMH_MB_FpsColorType2 );
    GMH_MB_FpsColorType2.setSelected( $MB_ColorIdx[$MB_Pref::FpsColor2] );

    MB_BuildColorSelectPopup( GMH_MB_FpsColorType3 );
    GMH_MB_FpsColorType3.setSelected( $MB_ColorIdx[$MB_Pref::FpsColor3] );

    MB_BuildColorSelectPopup( GMH_MB_FpsColorType4 );
    GMH_MB_FpsColorType4.setSelected( $MB_ColorIdx[$MB_Pref::FpsColor4] );

    MB_BuildColorSelectPopup( GMH_MB_FpsColorType5 );
    GMH_MB_FpsColorType5.setSelected( $MB_ColorIdx[$MB_Pref::FpsColor5] );

    MB_BuildColorSelectPopup( GMH_MB_FpsColorType6 );
    GMH_MB_FpsColorType6.setSelected( $MB_ColorIdx[$MB_Pref::FpsColor6] );
	
    //- - - - - - - - - - - - - - - - - -
    
    MB_BuildColorSelectPopup( GMH_MB_PingColorType1 );
    GMH_MB_PingColorType1.setSelected( $MB_ColorIdx[$MB_Pref::PingColor1] );
    
    MB_BuildColorSelectPopup( GMH_MB_PingColorType2 );
    GMH_MB_PingColorType2.setSelected( $MB_ColorIdx[$MB_Pref::PingColor2] );

    MB_BuildColorSelectPopup( GMH_MB_PingColorType3 );
    GMH_MB_PingColorType3.setSelected( $MB_ColorIdx[$MB_Pref::PingColor3] );

    MB_BuildColorSelectPopup( GMH_MB_PingColorType4 );
    GMH_MB_PingColorType4.setSelected( $MB_ColorIdx[$MB_Pref::PingColor4] );

    MB_BuildColorSelectPopup( GMH_MB_PingColorType5 );
    GMH_MB_PingColorType5.setSelected( $MB_ColorIdx[$MB_Pref::PingColor5] );

    MB_BuildColorSelectPopup( GMH_MB_PingColorType6 );
    GMH_MB_PingColorType6.setSelected( $MB_ColorIdx[$MB_Pref::PingColor6] );
	
    //- - - - - - - - - - - - - - - - - -
    
    MB_BuildColorSelectPopup( GMH_MB_PlossColorType1 );
    GMH_MB_PlossColorType1.setSelected( $MB_ColorIdx[$MB_Pref::PlossColor1] );
    
    MB_BuildColorSelectPopup( GMH_MB_PlossColorType2 );
    GMH_MB_PlossColorType2.setSelected( $MB_ColorIdx[$MB_Pref::PlossColor2] );

    MB_BuildColorSelectPopup( GMH_MB_PlossColorType3 );
    GMH_MB_PlossColorType3.setSelected( $MB_ColorIdx[$MB_Pref::PlossColor3] );

    MB_BuildColorSelectPopup( GMH_MB_PlossColorType4 );
    GMH_MB_PlossColorType4.setSelected( $MB_ColorIdx[$MB_Pref::PlossColor4] );

    MB_BuildColorSelectPopup( GMH_MB_PlossColorType5 );
    GMH_MB_PlossColorType5.setSelected( $MB_ColorIdx[$MB_Pref::PlossColor5] );

    MB_BuildColorSelectPopup( GMH_MB_PlossColorType6 );
    GMH_MB_PlossColorType6.setSelected( $MB_ColorIdx[$MB_Pref::PlossColor6] );
	
    //- - - - - - - - - - - - - - - - - -
}

//------------------------------------------------------------------------------

function MB_BuildColorSelectPopup( %popup )
{
    %popup.clear();
   
    for ( %color = 0; %color < 6; %color++ )
    {
        %popup.add( $MB_Color[%color],  %color );
    }
   
    %popup.setSelected( 0 );
}

//------------------------------------------------------------------------------

function MB_GetSelectedColors()
{
    $MB_Pref::FpsColor1 = $MB_Color[GMH_MB_FpsColorType1.getSelected()];
    $MB_Pref::FpsColor2 = $MB_Color[GMH_MB_FpsColorType2.getSelected()];
    $MB_Pref::FpsColor3 = $MB_Color[GMH_MB_FpsColorType3.getSelected()];
    $MB_Pref::FpsColor4 = $MB_Color[GMH_MB_FpsColorType4.getSelected()];
    $MB_Pref::FpsColor5 = $MB_Color[GMH_MB_FpsColorType5.getSelected()];
    $MB_Pref::FpsColor6 = $MB_Color[GMH_MB_FpsColorType6.getSelected()];

    $MB_Pref::PingColor1 = $MB_Color[GMH_MB_PingColorType1.getSelected()];
    $MB_Pref::PingColor2 = $MB_Color[GMH_MB_PingColorType2.getSelected()];
    $MB_Pref::PingColor3 = $MB_Color[GMH_MB_PingColorType3.getSelected()];
    $MB_Pref::PingColor4 = $MB_Color[GMH_MB_PingColorType4.getSelected()];
    $MB_Pref::PingColor5 = $MB_Color[GMH_MB_PingColorType5.getSelected()];
    $MB_Pref::PingColor6 = $MB_Color[GMH_MB_PingColorType6.getSelected()];

    $MB_Pref::PlossColor1 = $MB_Color[GMH_MB_PlossColorType1.getSelected()];
    $MB_Pref::PlossColor2 = $MB_Color[GMH_MB_PlossColorType2.getSelected()];
    $MB_Pref::PlossColor3 = $MB_Color[GMH_MB_PlossColorType3.getSelected()];
    $MB_Pref::PlossColor4 = $MB_Color[GMH_MB_PlossColorType4.getSelected()];
    $MB_Pref::PlossColor5 = $MB_Color[GMH_MB_PlossColorType5.getSelected()];
    $MB_Pref::PlossColor6 = $MB_Color[GMH_MB_PlossColorType6.getSelected()];
}

//------------------------------------------------------------------------------

