//------------------------------------------------------------------------------
//
// GameGui.cs       Modified by David Roth
//                   Got questions???    -->Email me at davidmroth@hotmail.com
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
function LaunchGame( %pane )
{
   if ( %pane !$= "" )
      GameGui.pane = %pane;

   LaunchTabView.viewTab( "GAME", GameGui, 0 );
}

//------------------------------------------------------------------------------
function GameGui::onWake( %this )
{
   Canvas.pushDialog( LaunchToolbarDlg );

   GM_Frame.setTitle( $PlayingOnline ? "GAME" : "LAN GAME" );

   // This is essentially an "isInitialized" flag...
   if ( GM_TabView.tabCount() == 0 )
   {
      GM_TabView.addTab( 1, "JOIN" );
      GM_TabView.addTab( 2, "HOST" );
      GM_TabView.addTab( 3, "WARRIOR SETUP", 1 );

      queryMasterGameTypes();
   }

   switch$ ( %this.pane )
   {
      case "Join":
         GM_TabView.setSelected( 1 );
      case "Host":
         GM_TabView.setSelected( 2 );
      default: // "Warrior"
         GM_TabView.setSelected( 3 );
   }
}

//------------------------------------------------------------------------------
function GameGui::onSleep( %this )
{
   %ctrl = "GM_" @ %this.pane @ "Pane";
   if ( isObject( %ctrl ) )
      %ctrl.onDeactivate();
      
//   if( isObject( $dummySeq ) )
//   {   
//      $dummySeq.delete();
//   }
         
	Canvas.popDialog(LaunchToolbarDlg);
}

//------------------------------------------------------------------------------
function GameGui::setKey( %this, %key )
{
   // To avoid console error
}

//------------------------------------------------------------------------------
function GameGui::onClose( %this, %key )
{
   // To avoid console error
}

//------------------------------------------------------------------------------
function GM_TabView::onAdd( %this )
{
   %this.addSet( 1, "gui/shll_horztabbuttonB", "5 5 5", "50 50 0", "5 5 5" );
}

//------------------------------------------------------------------------------
function GM_TabView::onSelect( %this, %id, %text )
{
   GM_JoinPane.setVisible( %id == 1 );
   GM_HostPane.setVisible( %id == 2 );
   GM_WarriorPane.setVisible( %id == 3 );
   GM_TabFrame.setAltColor( %this.getTabSet( %id ) != 0 );

   %ctrl = "GM_" @ GameGui.pane @ "Pane";
   if ( isObject( %ctrl ) )
      %ctrl.onDeactivate();

   switch ( %id )
   {
      case 1:  // Join
         GM_JoinPane.onActivate();
      case 2:  // Host
         GM_HostPane.onActivate();
      case 3:  // Warrior Setup
         GM_WarriorPane.onActivate();
   }
}

//------------------------------------------------------------------------------
// Join Game pane:
//------------------------------------------------------------------------------
function GM_JoinPane::onActivate( %this )
{
   GameGui.pane = "Join";

   if ( %this.onceOnly $= "" )
   {
      GM_VersionText.setText( "Version" SPC getT2VersionNumber() );

      %this.onceOnly = 1;
      GMJ_Browser.lastQuery = $PlayingOnline ? "Master" : "LanServers";
      GMJ_Browser.runQuery();
   }

   GM_VersionText.setVisible( true );

   // Use Server Info prefs:
   SI_Window.resize( firstWord( $pref::ServerBrowser::InfoWindowPos ),
         getWord( $pref::ServerBrowser::InfoWindowPos, 1 ),
         firstWord( $pref::ServerBrowser::InfoWindowExtent ),
         getWord( $pref::ServerBrowser::InfoWindowExtent, 1 ) );

   if ( $pref::ServerBrowser::InfoWindowOpen )
      Canvas.pushDialog( ServerInfoDlg );
}

//------------------------------------------------------------------------------
function GM_JoinPane::onDeactivate( %this )
{
   GM_VersionText.setVisible( false );

   // Save off the Server Info Window prefs:
   $pref::ServerBrowser::InfoWindowOpen = GMJ_Browser.infoWindowOpen;
   $pref::ServerBrowser::InfoWindowPos = SI_Window.getPosition();
   $pref::ServerBrowser::InfoWindowExtent = SI_Window.getExtent();
   $pref::ServerBrowser::InfoWindowBarPos = getWord( SI_InfoScroll.getExtent(), 1 );

   if ( GMJ_Browser.infoWindowOpen )
      Canvas.popDialog( ServerInfoDlg );
}

//------------------------------------------------------------------------------
$BrowserColumnCount = 0;
$BrowserColumnName[0] = "Server Name";
$BrowserColumnRange[0] = "25 300";
$BrowserColumnCount++;
$BrowserColumnName[1] = "Status";
$BrowserColumnRange[1] = "25 75";
$BrowserColumnCount++;
$BrowserColumnName[2] = "Favorite";
$BrowserColumnRange[2] = "25 75";
$BrowserColumnCount++;
$BrowserColumnName[3] = "Ping";
$BrowserColumnRange[3] = "25 120";
$BrowserColumnCount++;
$BrowserColumnName[4] = "Game Type";
$BrowserColumnRange[4] = "25 200";
$BrowserColumnCount++;
$BrowserColumnName[5] = "Mission Name";
$BrowserColumnRange[5] = "25 300";
$BrowserColumnCount++;
$BrowserColumnName[6] = "Rules Set";
$BrowserColumnRange[6] = "25 300";
$BrowserColumnCount++;
$BrowserColumnName[7] = "# Players (Bots)";
$BrowserColumnRange[7] = "25 150";
$BrowserColumnCount++;
$BrowserColumnName[8] = "CPU";
$BrowserColumnRange[8] = "25 120";
$BrowserColumnCount++;
$BrowserColumnName[9] = "IP Address";
$BrowserColumnRange[9] = "25 200";
$BrowserColumnCount++;
$BrowserColumnName[10] = "Version";
$BrowserColumnRange[10] = "25 200";
$BrowserColumnCount++;

//------------------------------------------------------------------------------
function GMJ_Browser::onAdd( %this )
{
	// Add the Server Browser columns based on the prefs:
	for ( %i = 0;  %i < $BrowserColumnCount; %i++ )
	{
		%key = firstWord( $pref::ServerBrowser::Column[%i] );
		%width = getWord( $pref::ServerBrowser::Column[%i], 1 );
		%this.addColumn( %key, $BrowserColumnName[%key], %width, firstWord( $BrowserColumnRange[%key] ), getWord( $BrowserColumnRange[%key], 1 ) );
	}
	%this.setSortColumn( $pref::ServerBrowser::SortColumnKey );
	%this.setSortIncreasing( $pref::ServerBrowser::SortInc );
}

//------------------------------------------------------------------------------
function updateServerBrowser()
{
   GMJ_Browser.sort();
   if ( GMJ_Browser.infoWindowOpen )
      ServerInfoDlg.update();
}

//------------------------------------------------------------------------------
function updateServerBrowserStatus( %text, %percentage )
{
   GMJ_StatusText.setValue( %text );
   GMJ_ProgressBar.setValue( %percentage );
}

//------------------------------------------------------------------------------
function GMJ_Browser::runQuery( %this )
{
   GMJ_ProgressBar.setValue( 0 );
   $JoinGameAddress = "";
   GMJ_JoinBtn.setActive( false );
   GMJ_RefreshServerBtn.setActive( false );
   %this.clearList();

   // Clear the Server Info dialog:
   SI_InfoWindow.setText( "No server selected." );
   SI_ContentWindow.setText( "" );

   if ( %this.lastQuery $= "LanServers" )
   {
      GMJ_StatusText.setValue( "Querying LAN servers..." );
      GMJ_FilterBtn.setActive( false );
		GMJ_FilterBtn.setVisible( false );
      GMJ_FilterText.setText( "LAN Servers" );
      queryLanServers( $JoinGamePort );
   }
   else
   {
		GMJ_FilterBtn.setActive( true );
		GMJ_FilterBtn.setVisible( true );

      if ( $pref::ServerBrowser::activeFilter == 0 )
      {
         GMJ_StatusText.setValue( "Querying the master server..." );
         GMJ_FilterText.setText( "All servers" );
         queryMasterServer( $JoinGamePort );
      }
      else if ( $pref::ServerBrowser::activeFilter == 1 )
      {
         // Buddy list query:
         GMJ_StatusText.setValue( "Fetching buddy list..." );
         GMJ_FilterText.setText( "Buddies" );
         %this.key = LaunchGui.key++;
         DatabaseQueryArray( 5, 0, "", %this, %this.key );
      }
      else
      {
         GMJ_StatusText.setValue( "Querying the master server..." );
         %filterIndex = $pref::ServerBrowser::activeFilter - 2;
         if ( $pref::ServerBrowser::Filter[%filterIndex] !$= "" )
         {
            %filter = $pref::ServerBrowser::Filter[%filterIndex];
            GMJ_FilterText.setText( getField( %filter, 0 ) );
            queryMasterServer( 
                  $JoinGamePort, 
                  0,                         // Flags 
                  getField( %filter, 1 ),    // Rules Set 
                  getField( %filter, 2 ),    // Mission Type 
                  getField( %filter, 3 ),    // Min Players 
                  getField( %filter, 4 ),    // Max Players 
                  getField( %filter, 5 ),    // Region Mask 
                  getField( %filter, 6 ) );  // Max Ping
         }
         else
         {
            // Filter is invalid, so fall back to the default:
            $pref::ServerBrowser::activeFilter = 0;
            GMJ_FilterText.setText( "All servers" );
            queryMasterServer( $JoinGamePort );
         }
      }
   }
}

//------------------------------------------------------------------------------
function GMJ_Browser::onDatabaseQueryResult( %this, %status, %resultString, %key )
{
   if ( %this.key != %key )
      return;

   if ( getField( %resultString, 0 ) <= 0 )
   {
      GMJ_StatusText.setValue( "No buddies found." );
      MessageBoxOK( "INVALID FILTER", "You have no buddies in your buddy list!" );
   }
   else  // Prepare for the incoming buddy list:
      %this.buddyList = "";
}

//------------------------------------------------------------------------------
function GMJ_Browser::onDatabaseRow( %this, %row, %isLastRow, %key )
{
   if ( %this.key != %key )
      return;

   %buddyName = getField( %row, 0 );
   %buddyGuid = getField( %row, 3 );
   echo( "Got buddy: \c9\"" @ %buddyName @ "\": " @ %buddyGuid );
   %this.buddyList = %this.buddyList $= "" ? %buddyGuid : %this.buddyList TAB %buddyGuid;

   if ( %isLastRow )
   {
      GMJ_StatusText.setValue( "Querying the master server..." );
      queryMasterServer( $JoinGamePort, 0, "Any", "Any", 0, 255, 0xFFFFFFFF, 0, %this.buddyList );
      %this.buddyList = "";
   }
}

//------------------------------------------------------------------------------
function GMJ_Browser::onSelect( %this, %address )
{
   GMJ_JoinBtn.setActive( true );
   GMJ_RefreshServerBtn.setActive( true );
   $JoinGamePassword = "";
   $JoinGameAddress = %address;

   if ( %this.infoWindowOpen )
      ServerInfoDlg.update();
}

//------------------------------------------------------------------------------
function GMJ_Browser::refreshSelectedServer( %this )
{
   querySingleServer( $JoinGameAddress );
   if ( %this.infoWindowOpen )
      ServerInfoDlg.update();
}

//------------------------------------------------------------------------------
function GMJ_Browser::onSetSortKey( %this, %sortKey, %isIncreasing )
{
   $pref::ServerBrowser::SortColumnKey = %sortKey;
   $pref::ServerBrowser::SortInc = %isIncreasing;
}

//------------------------------------------------------------------------------
function GMJ_Browser::onColumnResize( %this, %column, %newSize, %key )
{
   $pref::ServerBrowser::Column[%column] = %key SPC %newSize;
}

//------------------------------------------------------------------------------
function GMJ_Browser::onColumnRepositioned( %this, %oldColumn, %newColumn )
{
   // Puke em all...
   %count = %this.getNumColumns();
   for ( %col = 0; %col < %count; %col++ )
      $pref::ServerBrowser::Column[%col] = %this.getColumnKey( %col ) SPC %this.getColumnWidth( %col );
}

//------------------------------------------------------------------------------
function GMJ_Browser::addFavorite( %this, %name, %address )
{
   //error( "** addFavorite( \"" @ %name @ "\", " @ %address @ " ) **" );
   $pref::ServerBrowser::Favorite[$pref::ServerBrowser::FavoriteCount] = %name TAB %address;
   $pref::ServerBrowser::FavoriteCount++;
}

//------------------------------------------------------------------------------
function GMJ_Browser::removeFavorite( %this, %address )
{
   //error( "** removeFavorite( " @ %address @ " ) **" );
   %foundIt = false;
   for ( %i = 0; %i < $pref::ServerBrowser::FavoriteCount; %i++ )
   {
      if ( !%foundIt )
      {
         if ( getField( $pref::ServerBrowser::Favorite[%i], 1 ) $= %address )
            %foundIt = true;
      }

      if ( %foundIt )
         $pref::ServerBrowser::Favorite[%i] = $pref::ServerBrowser::Favorite[%i + 1];
   }

   if ( %foundIt )
      $pref::ServerBrowser::FavoriteCount--;
}

//------------------------------------------------------------------------------
function ServerInfoDlg::onAdd( %this )
{
   %this.headerStyle = "<font:" @ $ShellLabelFont @ ":" @ $ShellFontSize @ "><color:00DC00>";
}

//------------------------------------------------------------------------------
function ServerInfoDlg::onWake( %this )
{
   GMJ_Browser.infoWindowOpen = true;
   GMJ_InfoBtn.setActive( false );
   SI_RefreshBtn.setActive( false );
   %this.update();
}

//------------------------------------------------------------------------------
function ServerInfoDlg::update( %this )
{
   %status = GMJ_Browser.getServerStatus();
   if ( %status $= "invalid" )
   {
	   SI_InfoWindow.setText( "No server selected." );
      return;
   }

   %info = GMJ_Browser.getServerInfoString();
   %infoText = "<tab:70><spush>" @ %this.headerStyle @ "NAME:<spop><lmargin:70>" TAB getRecord( %info, 0 )
         NL "<lmargin:0><spush>" @ %this.headerStyle @ "ADDRESS:<spop><lmargin:70>" TAB getRecord( %info, 1 ) @ "<lmargin:0>";

   %refreshable = false;
   if ( %status $= "responded" )
   {
      %temp = getRecord( %info, 2 );
      if ( %temp !$= "" )
         %infoText = %infoText NL "<spush>" @ %this.headerStyle @ "RULES SET:<spop><lmargin:70>" TAB %temp @ "<lmargin:0>";
      %temp = getRecord( %info, 3 );
      if ( %temp $= "" )
         %temp = "None";
      %infoText = %infoText NL "<spush>" @ %this.headerStyle @ "FLAGS:<spop><lmargin:70>" TAB %temp @ "<lmargin:0>";
      %temp = getRecord( %info, 4 );
      if ( %temp !$= "" )
         %infoText = %infoText NL "<spush>" @ %this.headerStyle @ "GAME TYPE:<spop><lmargin:70>" TAB %temp @ "<lmargin:0>";
      %temp = getRecord( %info, 5 );
      if ( %temp !$= "" )
         %infoText = %infoText NL "<spush>" @ %this.headerStyle @ "MAP NAME:<spop><lmargin:70>" TAB %temp @ "<lmargin:0>";
      %temp = getRecord( %info, 6 );
      if ( %temp !$= "" )
         %infoText = %infoText NL "<spush>" @ %this.headerStyle @ "SERVER INFO:<spop><lmargin:10>" TAB %temp @ "<lmargin:0>";

      // Fill in the content window:
      %content = GMJ_Browser.getServerContentString();
      SI_ContentWindow.fill( %content );
      %refreshable = true;
   }
   else
   {
      switch$ ( %status )
      {
         case "new":
            %temp = "<spush><color:DCDC00>Not queried yet.<spop>";
            SI_ContentWindow.setText( "Not available." );
         case "querying":
            %temp = "<spush><color:00DC00>Querying...<spop>";
            SI_ContentWindow.setText( "Not available." );
         case "updating":
            %temp = "<spush><color:00DC00>Updating...<spop>";
         case "timedOut":
            %temp = "<spush><color:DC1A1A>Timed out.<spop>";
            SI_ContentWindow.setText( "Not available." );
            %refreshable = true;
      }
      %infoText = %infoText NL "<lmargin:0><spush>" @ %this.headerStyle @ "STATUS: <spop><lmargin:70>" TAB %temp;
   }

	SI_InfoWindow.setText( %infoText );
   SI_InfoScroll.scrollToTop();
   SI_ContentScroll.scrollToTop();
   SI_RefreshBtn.setActive( %refreshable );
}

//------------------------------------------------------------------------------
function SI_ContentWindow::fill( %this, %content )
{
   if ( getRecordCount( %content ) == 1 )
   {
      %this.setText( "" );
      return;
   }

   %record = 0;
   %teamCount = getRecord( %content, %record );
   %record++;
   if ( %teamCount > 1 )
   {
      %string = "<tab:110,220><spush>" @ ServerInfoDlg.headerStyle @ "TEAMS" TAB "SCORE<spop><tab:5,115,225>";
      for ( %i = 0; %i < %teamCount; %i++ )
      {
         %teamEntry = getRecord( %content, %record );
         %string = %string NL "<clip:110>\t" @ getField( %teamEntry, 0 ) @ "</clip>" TAB getField( %teamEntry, 1 );
         %record++;
      }

      %playerCount = getRecord( %content, %record );
      %record++;
      %string = %string NL "\n<tab:110,220><spush>" @ ServerInfoDlg.headerStyle @ "PLAYERS" TAB "TEAM" TAB "SCORE<spop><tab:5,115,225>";
      for ( %i = 0; %i < %playerCount; %i++ )
      {
         %playerEntry = getRecord( %content, %record ); 
         %string = %string NL "<clip:110>\t" @ getField( %playerEntry, 0 ) @ "</clip>" 
               TAB "<clip:105>" @ getField( %playerEntry, 1 ) @ "</clip>" TAB getField( %playerEntry, 2 );
         %record++;
      }
   }
   else
   {
      %record++;
      %playerCount = getRecord( %content, %record );
      %record++;
      %string = "<tab:150><spush>" @ ServerInfoDlg.headerStyle @ "PLAYERS" TAB "SCORE<spop><tab:5,155>";
      for ( %i = 0; %i < %playerCount; %i++ )
      {
         %playerEntry = getRecord( %content, %record ); 
         %string = %string NL "<clip:150>\t" @ getField( %playerEntry, 0 ) @ "</clip>" TAB getField( %playerEntry, 2 );
         %record++;
      }
   }

   %this.setText( %string );
}

//------------------------------------------------------------------------------
function ServerInfoDlg::onSleep( %this )
{
   GMJ_Browser.infoWindowOpen = false;
   GMJ_InfoBtn.setActive( true );
}

//------------------------------------------------------------------------------
function PasswordDlg::onWake( %this )
{
   $JoinGamePassword = "";
}

//------------------------------------------------------------------------------
function PasswordDlg::accept( %this )
{
   Canvas.popDialog( PasswordDlg );
   JoinSelectedGame();
}

//------------------------------------------------------------------------------
function JoinSelectedGame()
{
   // This stuff must go soon!
   %info = GMJ_Browser.getValue();
   LoadingGui.map = getField( %info, 3 );
   LoadingGui.missionType = getField( %info, 4 );
   //

	%info = GMJ_Browser.getServerInfoString();
	%desc = "a" SPC getField(%info,4) @ "(" @ getField(%info,3) @ ") game on the \"" @ getField(%info,0) @ "\" server.  Click here to follow";   

	IRCClient::onJoinGame($JoinGameAddress,%desc);

	JoinGame($JoinGameAddress);
}

//------------------------------------------------------------------------------
function JoinGame(%address)
{
   MessagePopup( "JOINING SERVER", "CONNECTING" );
	echo("Joining Server " @ %address);
	%playerPref = $pref::Player[$pref::Player::Current];
	%playerName = getField( %playerPref, 0 );
	%playerRaceGender = getField( %playerPref, 1 );
	%playerSkin = getField( %playerPref, 2 );
	%playerVoice = getField( %playerPref, 3 );
	%playerVoicePitch = getField( %playerPref, 4 );
   connect( %address, $JoinGamePassword, %playerName, %playerRaceGender, %playerSkin, %playerVoice, %playerVoicePitch );
}

//------------------------------------------------------------------------------
// Host Game pane:
//------------------------------------------------------------------------------
function GM_HostPane::onActivate( %this )
{
   GameGui.pane = "Host";

   $HostGameType = $PlayingOnline ? "Online" : "LAN";
   
   buildMissionTypePopup( GMH_MissionType );
   GMH_BotMinSlider.setValue( $Host::MinBotDifficulty );
   GMH_BotMaxSlider.setValue( $Host::MaxBotDifficulty );
   GMH_BotsEnabledTgl.setValue( $Host::BotsEnabled );
   GMH_BotsEnabledTgl.onAction();

	//clamp and set the bot count slider
	setBotCountSlider();

   // Select the saved-off prefs:
   if ( $Host::MissionType !$= "" )
   {
      // Find the last selected type:
      for ( %type = 0; %type < $HostTypeCount; %type++ )
      {
         if ( $HostTypeName[%type] $= $Host::MissionType )
            break;
      }

      if ( %type != $HostTypeCount )
      {
         GMH_MissionType.setSelected( %type );
         GMH_MissionType.onSelect( %type, "" );
         if ( $Host::Map !$= "" )
         {
            // Find the last selected mission:
            for ( %index = 0; %index < $HostMissionCount[%type]; %index++ )
            {
               if ( $HostMissionFile[$HostMission[%type, %index]] $= $Host::Map )
                  break;
            }

            if ( %index != $HostMissionCount[%type] )
               GMH_MissionList.setSelectedById( $HostMission[%type, %index] );
         }
      }
   }
   else
   {
      GMH_MissionType.setSelected( 0 );
      GMH_MissionType.onSelect( 0, "" );
   }

	GMH_StartGameBtn.makeFirstResponder( 1 );
}

//------------------------------------------------------------------------------
function GM_HostPane::onDeactivate( %this )
{
}

//------------------------------------------------------------------------------
function buildMissionTypePopup( %popup )
{
   %popup.clear();
   for( %type = 0; %type < $HostTypeCount; %type++ )
      %popup.add( $HostTypeDisplayName[%type], %type );
}

//------------------------------------------------------------------------------
function getMissionTypeDisplayNames()
{
   %file = new FileObject();
   for ( %type = 0; %type < $HostTypeCount; %type++ )
   {
      $HostTypeDisplayName[%type] = $HostTypeName[%type];
      if ( %file.openForRead( "scripts/" @ $HostTypeName[%type] @ "Game.cs" ) )
      {
         while ( !%file.isEOF() )
         {
            %line = %file.readLine();
            if ( getSubStr( %line, 0, 17 ) $= "// DisplayName = " )
            {
               $HostTypeDisplayName[%type] = getSubStr( %line, 17, 1000 );
               break;
            }
         }
      }
   }

   %file.delete();
}

//------------------------------------------------------------------------------
function buildMissionList()
{
   %search = "missions/*.mis";
   %ct = 0;
   
   $HostTypeCount = 0;
   $HostMissionCount = 0;

   %fobject = new FileObject();
   
   for( %file = findFirstFile( %search ); %file !$= ""; %file = findNextFile( %search ) )
   {
      %name = fileBase( %file ); // get the name

      %idx = $HostMissionCount;
      $HostMissionCount++;
      
      $HostMissionFile[%idx] = %name;
      $HostMissionName[%idx] = %name;
      
      if ( !%fobject.openForRead( %file ) )
         continue;

      %typeList = "None";
      
      while ( !%fobject.isEOF() )
      {
         %line = %fobject.readLine();
         if ( getSubStr( %line, 0, 17 ) $= "// DisplayName = " )
         {
            // Override the mission name:
            $HostMissionName[%idx] = getSubStr( %line, 17, 1000 );
         }         
         else if ( getSubStr( %line, 0, 18 ) $= "// MissionTypes = " )
         {
            %typeList = getSubStr( %line, 18, 1000 );
            break;
         }
      }
      %fobject.close();

		// Don't include single player missions:
		if ( strstr( %typeList, "SinglePlayer" ) != -1 )
			continue;

      // Test to see if the mission is bot-enabled:
      %navFile = "terrains/" @ %name @ ".nav";
      $BotEnabled[%idx] = isFile( %navFile );
            
      for( %word = 0; ( %misType = getWord( %typeList, %word ) ) !$= ""; %word++ )
      {
         for ( %i = 0; %i < $HostTypeCount; %i++ )
            if ( $HostTypeName[%i] $= %misType )
               break;
         if ( %i == $HostTypeCount )
         {
            $HostTypeCount++;
            $HostTypeName[%i] = %misType;
            $HostMissionCount[%i] = 0;
         }
         // add the mission to the type
         %ct = $HostMissionCount[%i];
         $HostMission[%i, $HostMissionCount[%i]] = %idx;
         $HostMissionCount[%i]++;
      }
   }

   getMissionTypeDisplayNames();
   
   %fobject.delete();
}

// One time only function call:
buildMissionList();

//------------------------------------------------------------------------------
function validateMissionAndType(%misName, %misType)
{
   for ( %mis = 0; %mis < $HostMissionCount; %mis++ )
      if( $HostMissionFile[%mis] $= %misName )
         break;
   if ( %mis == $HostMissionCount )
      return false;
   for ( %type = 0; %type < $HostTypeCount; %type++ )
      if ( $HostTypeName[%type] $= %misType )
         break;
   if(%type == $hostTypeCount)
      return false;
   $Host::Map = $HostMissionFile[%mis];
   $Host::MissionType = $HostTypeName[%type];

   return true;
}

//------------------------------------------------------------------------------
// This function returns the index of the next mission in the mission list.
//------------------------------------------------------------------------------
function getNextMission( %misName, %misType )
{
   // First find the index of the mission in the master list:
   for ( %mis = 0; %mis < $HostMissionCount; %mis++ )
      if( $HostMissionFile[%mis] $= %misName )
         break;
   if ( %mis == $HostMissionCount )
      return "";

   // Now find the index of the mission type:
   for ( %type = 0; %type < $HostTypeCount; %type++ )
      if ( $HostTypeName[%type] $= %misType )
         break;
   if ( %type == $hostTypeCount )
      return "";
      
   // Now find the mission's index in the mission-type specific sub-list:
   for ( %i = 0; %i < $HostMissionCount[%type]; %i++ )
      if ( $HostMission[%type, %i] == %mis )
         break;

   // Go BACKWARDS, because the missions are in reverse alphabetical order:
   if ( %i == 0 )   
      %i = $HostMissionCount[%type] - 1;
   else
      %i--;

   // If there are bots in the game, don't switch to any maps without
   // a NAV file:
   if ( $HostGameBotCount > 0 )
   {
      for ( %j = 0; %j < $HostMissionCount[%type] - 1; %j++ )
      {
         if ( $BotEnabled[$HostMission[%type, %i]] )
            break;

         if ( %i == 0 )
            %i = $HostMissionCount[%type] - 1;
         else
            %i--;
      }
   }
   
   return $HostMission[%type, %i];
}

//------------------------------------------------------------------------------
function GMH_MissionType::onSelect( %this, %id, %text )
{
   // Fill the mission list:
   GMH_MissionList.clear();
   %lastAdded = 0;
   for ( %i = 0; %i < $HostMissionCount[%id];%i++ )
   {
      %misId = $HostMission[%id,%i];
      GMH_MissionList.addRow( %misId, $HostMissionName[%misId] );
      %lastAdded = %misId;
   }
   GMH_MissionList.sort( 0 );

   // Select the last mission added:
   GMH_MissionList.setSelectedById( %lastAdded );
   $Host::MissionType = $HostTypeName[%id];

   // Disable all non bot-enabled maps if bots are enabled:
   if ( GMH_BotsEnabledTgl.getValue() )
      GMH_BotsEnabledTgl.onAction();
}

//------------------------------------------------------------------------------
function GMH_MissionList::onSelect( %this, %id, %text )
{
   if ( GMH_BotsEnabledTgl.getValue() )
      GMH_StartGameBtn.setActive( $BotEnabled[%id] );
}

//------------------------------------------------------------------------------
function tryToStartHostedGame()
{
   if ( GMH_BotsEnabledTgl.getValue() )
   {
      %selId = GMH_MissionList.getSelectedId();
      if ( !$BotEnabled[%selId] )
         return;
   }

   StartHostedGame();
}

//------------------------------------------------------------------------------
function StartHostedGame()
{
   %selId = GMH_MissionList.getSelectedId();
   %misFile = $HostMissionFile[%selId];

   if ( $Host::BotsEnabled )
	{
		validateMaxPlayers();
      $HostGameBotCount = $Host::BotCount;
	}
   else
      $HostGameBotCount = 0;

   $ServerName = $Host::GameName;
   $Host::Map = %misFile;

   echo( "exporting server prefs..." );
   export( "$Host::*", "prefs/ServerPrefs.cs", false );

   if ( $Host::Dedicated )
   {
      MessageBoxYesNo( "WARNING", 
            "You are about to launch a dedicated server and leave Tribes 2.  Do you want to continue?", 
            "tryToLaunchDedicatedServer();" );
      return;
   }

	IRCClient::onJoinGame("", "");

   MessagePopup( "STARTING SERVER", "Initializing..." );
   Canvas.repaint();

   setNetPort( $Host::Port );
   CreateServer( $Host::Map, $Host::MissionType );
	%playerPref = $pref::Player[$pref::Player::Current];
	%playerName = getField( %playerPref, 0 );
	%playerRaceGender = getField( %playerPref, 1 );
	%playerSkin = getField( %playerPref, 2 );
	%playerVoice = getField( %playerPref, 3 );
	%playerVoicePitch = getField( %playerPref, 4 );
   localConnect( %playerName, %playerRaceGender, %playerSkin, %playerVoice, %playerVoicePitch );
   if(!$RecordDemo)
   {
      // demos are incompatible with local simulated net params
      ServerConnection.setSimulatedNetParams($pref::Net::simPacketLoss, $pref::net::simPing * 0.5);
      LocalClientConnection.setSimulatedNetParams($pref::Net::simPacketLoss, $pref::net::simPing * 0.5);
   }
}

//------------------------------------------------------------------------------
function tryToLaunchDedicatedServer()
{
   %numBots = $Host::BotsEnabled ? $Host::BotCount : 0;
   if ( launchDedicatedServer( $Host::MissionType, $Host::Map, %numBots ) )
      quit();
   else
   {
      error( "Failed to launch the dedicated server." );
      schedule( 0, 0, MessageBoxOK, "FAILED", "Tribes 2 failed to launch the dedicated server." );
   }
}

//------------------------------------------------------------------------------
function GMH_BotsEnabledTgl::onAction( %this )
{
   %count = GMH_MissionList.rowCount();
   if ( %this.getValue() )
   {
      for ( %i = 0; %i < %count; %i++ )
      {
         %id = GMH_MissionList.getRowId( %i );
         GMH_MissionList.setRowActive( %id, $BotEnabled[%id] );
      }
      
      GMH_EnableBotsGroup.setVisible(true);
      %misId = GMH_MissionList.getSelectedId();
      GMH_StartGameBtn.setActive( $BotEnabled[%misId] );
   }
   else
   {
      for ( %i = 0; %i < %count; %i++ )
      {
         %id = GMH_MissionList.getRowId( %i );
         GMH_MissionList.setRowActive( %id, true );
      }

      GMH_EnableBotsGroup.setVisible( false );
      GMH_StartGameBtn.setActive( true );
   }
}

//------------------------------------------------------------------------------
function updateMinBotDifficulty()
{
   %min = GMH_BotMinSlider.getValue();
   $Host::MinBotDifficulty = %min;
   if ( GMH_BotMaxSlider.getValue() < %min )
      GMH_BotMaxSlider.setValue( %min );
}

//------------------------------------------------------------------------------
function updateMaxBotDifficulty()
{
   %max = GMH_BotMaxSlider.getValue();
   $Host::MaxBotDifficulty = %max;
   if ( GMH_BotMinSlider.getValue() > %max )
      GMH_BotMinSlider.setValue( %max );
}

//------------------------------------------------------------------------------
function GMH_BotsEnabledTgl::onAction( %this )
{
   %count = GMH_MissionList.rowCount();
   if ( %this.getValue() )
   {
      for ( %i = 0; %i < %count; %i++ )
      {
         %id = GMH_MissionList.getRowId( %i );
         GMH_MissionList.setRowActive( %id, $BotEnabled[%id] );
      }
      
      GMH_EnableBotsGroup.setVisible(true);
      %misId = GMH_MissionList.getSelectedId();
      GMH_StartGameBtn.setActive( $BotEnabled[%misId] );
   }
   else
   {
      for ( %i = 0; %i < %count; %i++ )
      {
         %id = GMH_MissionList.getRowId( %i );
         GMH_MissionList.setRowActive( %id, true );
      }

      GMH_EnableBotsGroup.setVisible(false);
      GMH_StartGameBtn.setActive( true );
   }
}

//------------------------------------------------------------------------------
function validateMaxPlayers()
{
	%maxPlayers = GMH_MaxPlayersTE.getValue();
	if (%maxPlayers < 1)
		%maxPlayers = 1;

	if (%maxPlayers > 64)
		%maxPlayers = 64;

	//reset the value back into the TE
	GMH_MaxPlayersTE.setValue(%maxPlayers);

	//and make sure the bot sliders reflect the changes..
	setBotCountSlider();
}

function setBotCountSlider()
{
	%maxBots = 15;
	if (%maxBots > $Host::MaxPlayers - 2)
		%maxBots = $Host::MaxPlayers - 2;
	if ($Host::BotCount > %maxBots + 1)
		$Host::BotCount = %maxBots + 1;

	if (%maxBots <= 1)
		%sliderValue = 0.0;
	else
		%sliderValue = ($Host::BotCount - 0.95) / %maxBots;

   GMH_MinCombatantSlider.setValue(%sliderValue);
}

function setMinCombatants()
{
	%maxBots = 16;
	if (%maxBots > $Host::MaxPlayers - 1)
		%maxBots = $Host::MaxPlayers - 1;
	if (%maxBots <= 0)
	   $Host::BotCount = 0;
	else
	   $Host::BotCount = mFloor( GMH_MinCombatantSlider.getValue() * (%maxBots - 1)) + 1;
   GMH_BotCountText.setValue( "(" @ $Host::BotCount @ ")" );
}

//------------------------------------------------------------------------------
function AdvancedHostDlg::onWake( %this )
{
   // Set all of the controls to the current pref states:
   AH_HostPort.setText( $Host::Port );
   AH_DedicatedTgl.setValue( $Host::Dedicated );
   AH_TournamentTgl.setValue( $Host::TournamentMode );
   AH_AdminVoteTgl.setValue( $Host::allowAdminPlayerVotes );
   AH_AllowSmurfTgl.setValue( !$Host::NoSmurfs );
   AH_TimeLimit.setText( $Host::TimeLimit );
   AH_AdminPassword.setText( $Host::AdminPassword );
   AH_ServerInfo.setText( $Host::Info );
   AH_VotePassSlider.setValue( $Host::VotePassPercent );
   AH_VoteTimeSlider.setValue( $Host::VoteTime );
   AH_RespawnSlider.setValue( $Host::PlayerRespawnTimeout );
   AH_WarmupSlider.setValue( $Host::WarmupTime );
}

//------------------------------------------------------------------------------
function AdvancedHostDlg::accept( %this )
{
   // Apply all of the changes:
   $Host::Port = AH_HostPort.getValue();
   $Host::Dedicated = AH_DedicatedTgl.getValue();
   $Host::TournamentMode = AH_TournamentTgl.getValue();
   $Host::allowAdminPlayerVotes = AH_AdminVoteTgl.getValue();
   $Host::NoSmurfs = !AH_AllowSmurfTgl.getValue();
   $Host::TimeLimit = AH_TimeLimit.getValue();
   $Host::AdminPassword = AH_AdminPassword.getValue();
   $Host::Info = AH_ServerInfo.getText();
   $Host::VotePassPercent = mFloor( AH_VotePassSlider.getValue() );
   $Host::VoteTime = mFloor( AH_VoteTimeSlider.getValue() );
   $Host::PlayerRespawnTimeout = mFloor( AH_RespawnSlider.getValue() );
   $Host::WarmupTime = mFloor( AH_WarmupSlider.getValue() );

   // Save off the new prefs:
   export( "$Host::*", "prefs/ServerPrefs.cs", false );

   Canvas.popDialog( AdvancedHostDlg );
}

//------------------------------------------------------------------------------
function AH_VotePassText::update( %this )
{
   %this.setText( mFloor( AH_VotePassSlider.getValue() ) @ "%" );
}

//------------------------------------------------------------------------------
function AH_VoteTimeText::update( %this )
{
   %this.setText( mFloor( AH_VoteTimeSlider.getValue() ) SPC "seconds" );
}

//------------------------------------------------------------------------------
function AH_RespawnText::update( %this )
{
   %this.setText( mFloor( AH_RespawnSlider.getValue() ) SPC "seconds" );
}

//------------------------------------------------------------------------------
function AH_WarmupText::update( %this )
{
   %this.setText( mFloor( AH_WarmupSlider.getValue() ) SPC "seconds" );
}

//------------------------------------------------------------------------------
// Warrior Setup pane:
//------------------------------------------------------------------------------
function GM_WarriorPane::onActivate( %this )
{
   GameGui.pane = "Warrior";
	if ( $pref::Player::Count == 0 )
      %this.createNewAlias();
	else
	{
		// Fill the warrior list:
		GMW_WarriorPopup.clear();
      GMW_LightRdo.setValue( true );

      // First add the warrior corresponding to the player nickname:
      %this.warriorIndex = -1;
      if ( $PlayingOnline )
      {
         %warrior = getField( WONGetAuthInfo(), 0 );
         for ( %i = 0; %i < $pref::Player::Count; %i++ )
         {
            %name = getField( $pref::Player[%i], 0 );
            if ( %name $= %warrior )
            {
               %this.warriorIndex = %i;
				   GMW_WarriorPopup.add( %name, %i, 1 );
               break;
            }
         }
      }

      // Add the rest of the aliases:
		for ( %count = 0; %count < $pref::Player::Count; %count++ )
		{
			if ( $pref::Player[%count] !$= "" && %count != %this.warriorIndex )
			{
				%name = stripTrailingSpaces( strToPlayerName( getField( $pref::Player[%count], 0 ) ) );
				GMW_WarriorPopup.add( %name, %count );
			} 
		}

		// Fill the race/gender list:
		GMW_RaceGenderPopup.fillList();

		// Select the current player:
		GMW_WarriorPopup.setSelected( $pref::Player::Current );
		GMW_WarriorPopup.onSelect( $pref::Player::Current, "" );

		if ( $pref::Player::Count > 1 && $pref::Player::Current != %this.warriorIndex )
			GMW_DeleteWarriorBtn.setActive( true );
		else
			GMW_DeleteWarriorBtn.setActive( false );

      GMW_PlayerPageBtn.setVisible( $PlayingOnline );
	}
}

//------------------------------------------------------------------------------
function GM_WarriorPane::onDeactivate( %this )
{
}

//------------------------------------------------------------------------------
function GM_WarriorPane::createNewAlias( %this )
{
	NW_NameEdit.setValue( "" );
	NW_DoneBtn.setActive( false );
   NW_CancelBtn.setVisible( $pref::Player::Count > 0 );
   Canvas.pushDialog( NewWarriorDlg );
}

//------------------------------------------------------------------------------
function GM_WarriorPane::deleteWarrior( %this )
{
   MessageBoxYesNo( "CONFIRM", "Are you sure you want to delete this alias?", "doDeleteWarrior();", "" );
}

//------------------------------------------------------------------------------
function doDeleteWarrior()
{
   // Make sure we aren't trying to delete the default warrior (should never get this):
   if ( $pref::Player::Current == GM_WarriorPane.warriorIndex )
      return;

	for ( %i = $pref::Player::Current; %i < $pref::Player::Count - 1; %i++ )
		$pref::Player[%i] = $pref::Player[%i + 1];
	$pref::Player[%i] = "";

   if ( GM_WarriorPane.warriorIndex > $pref::Player::Current )
      GM_WarriorPane.warriorIndex--;

	$pref::Player::Count--;
   if ( GM_WarriorPane.warriorIndex != -1 )
      $pref::Player::Current = GM_WarriorPane.warriorIndex;
   else
	   $pref::Player::Current = 0;

   // Update the interface:
   GM_WarriorPane::onActivate();
}

//------------------------------------------------------------------------------
function GM_WarriorPane::gotoPlayerPage( %this )
{
   %warrior = getField( WONGetAuthInfo(), 0 );
   LaunchBrowser( %warrior, "Warrior" );
}

//------------------------------------------------------------------------------
function GMW_PlayerModel::update( %this )
{
   // Get the shape names:
   if ( GMW_HeavyRdo.getValue() )
      %armor = "heavy";
   else if ( GMW_MediumRdo.getValue() )
      %armor = "medium";
   else
      %armor = "light";
      
   switch ( GMW_RaceGenderPopup.getSelected() )
   {
      case 1: 
         if ( %armor $= "heavy" )
            %shape = %armor @ "_male";
         else
            %shape = %armor @ "_female";
      case 2: %shape = "bioderm_" @ %armor;
      default: %shape = %armor @ "_male";
   }
   
	%skin = getField( $pref::Player[$pref::Player::Current], 2 );
   
//   if( isObject( $dummySeq ) )
//   {   
//      $dummySeq.delete();
//   }
//   
//   $dummySeq = new TSShapeConstructor()
//   {
//      baseShape = %shape @ ".dts";
//      sequence0 = %shape @ "_forward.dsq dummyRun";
//   };
   
   %this.setModel( %shape, %skin );
}

//------------------------------------------------------------------------------
function GMW_WarriorPopup::onAdd( %this )
{
   %this.addScheme( 1, "255 255 0", "255 255 128", "128 128 0" );
}

//------------------------------------------------------------------------------
function GMW_WarriorPopup::onSelect( %this, %id, %text )
{
	// Set this as the currently selected player:
	$pref::Player::Current = %id;

	// Select the race/gender:
	%raceGender = getField( $pref::Player[%id], 1 );
	%selId = GMW_RaceGenderPopup.findText( %raceGender );
	if ( %selId == -1 )
		%selId = 0;

	GMW_RaceGenderPopup.setSelected( %selId );
	GMW_SkinPopup.fillList( %selId );
	GMW_VoicePopup.fillList( %selId );

	// Select the skin:
   %skin = getField( $pref::Player[%id], 2 );
   %selId = -1;
   for ( %i = 0; %i < GMW_SkinPopup.size(); %i++ )
   {
      if ( GMW_SkinPopup.realSkin[%i] !$= "" )
      {
         if ( %skin $= GMW_SkinPopup.realSkin[%i] )
         {
            %selId = %i;
            break;
         }
      }
      else if ( %skin $= GMW_SkinPopup.getTextById( %i ) )
      {
         %selId = %i;
         break;
      }
   }
   if ( %selId == -1 )
      %selId = 0;
	GMW_SkinPopup.setSelected( %selId );
   GMW_SkinPopup.onSelect( %selId, GMW_SkinPopup.getTextById( %selId ) );

	// Select the voice:
	%voice = getField( $pref::Player[%id], 3 );
	if ( %voice $= "Bot1" )
		%voiceId = 5;
	else
		%voiceId = getSubStr( %voice, strlen( %voice ) -1, 1000 ) - 1;


	//echo( "Voice = [" @ %voice @ "]  Voice ID = " @ %voiceId);
	

	GMW_VoicePopup.setSelected( %voiceId );
	GMW_VoicePopup.voiceIndex = 0;

   GMW_DeleteWarriorBtn.setActive( $pref::Player::Count > 1 && %id != GM_WarriorPane.warriorIndex );
}

//------------------------------------------------------------------------------
function GMW_RaceGenderPopup::fillList( %this )
{
	%this.clear();
	%this.add( "Human Male", 0 );
	%this.add( "Human Female", 1 );
	%this.add( "Bioderm", 2 );
}

//------------------------------------------------------------------------------
function GMW_RaceGenderPopup::onSelect( %this, %id, %text )
{
	// Update the player pref:
	$pref::Player[$pref::Player::Current] = setField( $pref::Player[$pref::Player::Current], 1, %this.getText() );

	// Fill the skin list:
	%prevSkin = GMW_SkinPopup.getText();
 	GMW_SkinPopup.fillList( %id );
	%selId = GMW_SkinPopup.findText( %prevSkin );
	if ( %selId == -1 )
		%selId = 0;
	GMW_SkinPopup.setSelected( %selId );
   GMW_SkinPopup.onSelect( %selId, GMW_SkinPopup.getTextById( %selId ) );

	// Fill the voice list:
	%prevVoice = GMW_VoicePopup.getText();
	GMW_VoicePopup.fillList( %id );
	%selId = GMW_VoicePopup.findText( %prevVoice );
	if ( %selId == -1 )
		%selId = 0;

	GMW_VoicePopup.setSelected( %selId );
   GMW_VoicePopup.onSelect( %selId, "" );
}

//------------------------------------------------------------------------------
$SkinCount = 0;
$Skin[$SkinCount, name] = "Blood Eagle";
$Skin[$SkinCount, code] = "beagle";
$SkinCount++;
$Skin[$SkinCount, name] = "Diamond Sword";
$Skin[$SkinCount, code] = "dsword";
$SkinCount++;
$Skin[$SkinCount, name] = "Starwolf";
$Skin[$SkinCount, code] = "swolf";
$SkinCount++;
$Skin[$SkinCount, name] = "Phoenix";
$Skin[$SkinCount, code] = "cotp";
$SkinCount++;
$Skin[$SkinCount, name] = "Storm";
$Skin[$SkinCount, code] = "base";
$SkinCount++;
$Skin[$SkinCount, name] = "Inferno";
$Skin[$SkinCount, code] = "baseb";
$SkinCount++;
$Skin[$SkinCount, name] = "Horde";
$Skin[$SkinCount, code] = "horde";
$SkinCount++;

//------------------------------------------------------------------------------
function GMW_SkinPopup::fillList( %this, %raceGender )
{
   for ( %i = 0; %i < %this.size(); %i++ )
      %this.realSkin[%i] = "";

	%this.clear();
   %path = "textures/skins/";
   switch ( %raceGender )
   {
      case 0:  // Human Male
         %pattern = ".lmale.png";
      case 1:  // Human Female
         %pattern = ".lfemale.png";
      case 2:  // Bioderm
         %pattern = ".lbioderm.png";
   }

   %count = 0;
   for ( %file = findFirstFile( %path @ "*" @ %pattern ); %file !$= ""; %file = findNextFile( %path @ "*" @ %pattern ) )
   {
      %skin = getSubStr( %file, strlen( %path ), strlen( %file ) - strlen( %path ) - strlen( %pattern ) );  // strip off the path and postfix

      // Make sure this is not a bot skin:
      if ( %skin !$= "basebot" && %skin !$= "basebbot" )
      {
         // See if this skin has an alias:
         for ( %i = 0; %i < $SkinCount; %i++ )
         {
            if ( %skin $= $Skin[%i, code] ) 
            {
               %skin = $Skin[%i, name];
               %this.realSkin[%count] = $Skin[%i, code];
               break;
            }
         }

         %this.add( %skin, %count );
         %count++;
      }
   }
}

//------------------------------------------------------------------------------
function GMW_SkinPopup::onSelect( %this, %id, %text )
{
	// Update the player pref:
   if ( %this.realSkin[%id] !$= "" )
	   $pref::Player[$pref::Player::Current] = setField( $pref::Player[$pref::Player::Current], 2, %this.realSkin[%id] );
   else
	   $pref::Player[$pref::Player::Current] = setField( $pref::Player[$pref::Player::Current], 2, %text );

	// Update the player model:
   GMW_PlayerModel.update();
}

//------------------------------------------------------------------------------
// TRANSLATE these voice set display names:
$MaleVoiceCount = 0;
$MaleVoiceName[$MaleVoiceCount] = "Hero";
$MaleVoiceCount++;
$MaleVoiceName[$MaleVoiceCount] = "Iceman";
$MaleVoiceCount++;
$MaleVoiceName[$MaleVoiceCount] = "Rogue";
$MaleVoiceCount++;
$MaleVoiceName[$MaleVoiceCount] = "Hardcase";
$MaleVoiceCount++;
$MaleVoiceName[$MaleVoiceCount] = "Psycho";
$MaleVoiceCount++;
$MaleVoiceName[$MaleVoiceCount] = "Bot";
$MaleVoiceCount++;


$FemaleVoiceCount = 0;
$FemaleVoiceName[$FemaleVoiceCount] = "Heroine";
$FemaleVoiceCount++;
$FemaleVoiceName[$FemaleVoiceCount] = "Professional";
$FemaleVoiceCount++;
$FemaleVoiceName[$FemaleVoiceCount] = "Cadet";
$FemaleVoiceCount++;
$FemaleVoiceName[$FemaleVoiceCount] = "Veteran";
$FemaleVoiceCount++;
$FemaleVoiceName[$FemaleVoiceCount] = "Amazon";
$FemaleVoiceCount++;

$DermVoiceCount = 0;
$DermVoiceName[$DermVoiceCount] = "Warrior";
$DermVoiceCount++;
$DermVoiceName[$DermVoiceCount] = "Monster";
$DermVoiceCount++;
$DermVoiceName[$DermVoiceCount] = "Predator";
$DermVoiceCount++;

//------------------------------------------------------------------------------
function GMW_VoicePopup::fillList( %this, %raceGender )
{
	%this.clear();

	switch ( %raceGender )	
	{
		case 0: // Human Male
			for ( %i = 0; %i < $MaleVoiceCount; %i++ )
				%this.add( $MaleVoiceName[%i], %i );

		case 1: // Human Female
			for ( %i = 0; %i < $FemaleVoiceCount; %i++ )
				%this.add( $FemaleVoiceName[%i], %i );

		case 2: // Bioderm
			for ( %i = 0; %i < $DermVoiceCount; %i++ )
				%this.add( $DermVoiceName[%i], %i );
	}
}

//------------------------------------------------------------------------------
function GMW_VoicePopup::onSelect( %this, %id, %text )
{
	// Update the player pref:
	switch ( GMW_RaceGenderPopup.getSelected() )
	{
		case 0: %base = "Male";
		case 1: %base = "Fem";
		case 2: %base = "Derm";
	}
	
	if ( %id == 5 )
		$pref::Player[$pref::Player::Current] = setField( $pref::Player[$pref::Player::Current], 3, "Bot1" );
	else
		$pref::Player[$pref::Player::Current] = setField( $pref::Player[$pref::Player::Current], 3, %base @ ( %id + 1 ) );
	
	//echo("ID = " @ %id @ "   Player Pref = " @ $pref::Player[$pref::Player::Current] );
	
	%this.voiceIndex = 0;
}

//------------------------------------------------------------------------------
function GMW_VoicePitchSlider::setPitch(%this)
{
}

function GMW_VoicePopup::test( %this )
{
	switch ( %this.voiceIndex )
	{
		case 0: %file = "gbl.hi";
		case 1: %file = "gbl.brag";
		case 2: %file = "gbl.woohoo";
		case 3: %file = "gbl.rock";
		case 4: %file = "gbl.obnoxious";
		case 5: %file = "gbl.shazbot";
	}

	switch ( GMW_RaceGenderPopup.getSelected() )
	{
		case 0: %base = "Male";
		case 1: %base = "Fem";
		case 2: %base = "Derm";
	}

   GMW_VoiceTestBtn.setActive( false );
	%voiceId = %this.getSelected() + 1;

	if ( %voiceId == 6 )
		%wav = "voice/" @ "Bot1" @ "/" @ %file @ ".wav";
	else
		%wav = "voice/" @ %base @ %voiceId @ "/" @ %file @ ".wav";

	
	//echo("Test----> " @ %wav);

	%handle = alxCreateSource( AudioGui, %wav );

   //pitch the voice
   //%pitchSliderVal = GMW_VoicePitchSlider.getValue();
   //%pitch = getValidVoicePitch(%voiceId, %pitchSliderVal);
   //if (%pitch != 1.0)
   //   alxSourcef(%handle, "AL_PITCH", %pitch);

   alxPlay( %handle );

   %delay = alxGetWaveLen( %wav );
   schedule( %delay, 0, "restoreVoiceTestButton" );

	if ( %this.voiceIndex == 5 )
		%this.voiceIndex = 0;
	else
		%this.voiceIndex++;
}

//------------------------------------------------------------------------------
function restoreVoiceTestButton()
{
   GMW_VoiceTestBtn.setActive( true );
}

//------------------------------------------------------------------------------
function NewWarriorDlg::createPlayer( %this )
{
	%name = stripTrailingSpaces( NW_NameEdit.getValue() );
	$pref::Player[$pref::Player::Count] = %name @ "\tHuman Male\tbeagle\tMale1";
	$pref::Player::Current = $pref::Player::Count;
	$pref::Player::Count++;
	Canvas.popDialog( NewWarriorDlg );
   GM_WarriorPane.onActivate();  // Refresh the warrior gui
}

//------------------------------------------------------------------------------
function NW_NameEdit::checkValidPlayerName( %this )
{
   %name = %this.getValue();
   %test = strToPlayerName( %name );
   if ( %name !$= %test )
	   %this.setValue( %test );

	NW_DoneBtn.setActive( strlen( stripTrailingSpaces( %test ) ) > 2 );
}

//------------------------------------------------------------------------------
function NW_NameEdit::processEnter( %this )
{
   %this.checkValidPlayerName();
	if ( NW_DoneBtn.isActive() )
      NewWarriorDlg.createPlayer();
}
