// #autoload
// #name = Tink Elf + Disc
// #version = 1.0a
// #date = 1/7/02
// #author = [GC]-Tinker Bear   |  {AiC}Tink
// #warrior = Tinker Bear
// #email = Tinker@gc-bears.net
// #web = http://www.gc-bears.net
// #description = When you use the elf gun, it will switch to the spinfusor for easy kill =]
// #status = Beta
// #category = Tinks-Scripts
// #include = support/callback.cs
// #include = support/key_callbacks.cs
// #include = support/loadout.cs

if(!isObject(ElfSwitch))
{
	new scriptobject (ElfSwitch)
	{
		class = ElfSwitch;
		version = "1.0a";
	};

	// set enabled pref if the var is empty
	if($pref::ElfSwitch::Enabled $= "")
		 $pref::ElfSwitch::Enabled = true;
}

// called when the toggle key is pressed and when it is released
//  %val : true/false (pressed/released)
function ElfSwitchToggle(%val)
{
	// only exec this code on key press, not release
	if(!%val)
		return;

	// toggle the enabled pref
	$pref::ElfSwitch::Enabled = !$pref::ElfSwitch::Enabled;

	// add or delete callbacks as needed
	ElfSwitch.setup($pref::ElfSwitch::Enabled);

	// play a soft beep
	alxPlay(sButtonOver,0,0,0);

	// print some info into the chat hud
	if($pref::ElfSwitch::Enabled)
		addMessageHudLine("\c2Tink-Elf enabled.");
        //$elfswitchtoggle = true;
	else
		addMessageHudLine("\c2Tink-Elf disabled.");
       // $elfswitchtoggle = false;
}

// START package ElfSwitch
package ElfSwitch
{

	// override - allows us to add the toggle key to the controls list
	function OptionsDlg::onWake(%this)
	{
		// check if the bind has already been added
		if (!ElfSwitch.bind)
		{
			$RemapName[$RemapCount]="Tink-Elf Toggle";
			$RemapCmd[$RemapCount]="ElfSwitchToggle";
			$RemapCount++;

			// signify we have added the bind to the list, to avoid adding it multiple times
			ElfSwitch.bind = true;
		}
		parent::onWake( %this );
	}
	
	// add or delete callbacks for mouse fire (writer's support)
	//  %val : true/false (add/delete)
	function ElfSwitch::setup(%this, %val)
	{
		if(%val)
		{
			callback.add(MouseFirePressed, "ElfSwitch.mouseFire");
			callback.add(MouseFireReleased, "ElfSwitch.mouseFire");
		}
		else
		{
			callback.delete(MouseFirePressed, "ElfSwitch.mouseFire");
			callback.delete(MouseFireReleased, "ElfSwitch.mouseFire");
		}
	}

	// handle mouse fire, switches to disc after elf gun is fired
	//  %state : true/false (pressed/released)
	function ElfSwitch::mouseFire(%this, %state)
	{
		if(%state)
			%this.active = loadout.getCurrentWeapon() $= "ELFGun";
		else
		{
			if(%this.active)
				use(disc);
		}
	}

// END package ElfSwitch
};
activatePackage(ElfSwitch);

// add mouse fire callbacks if script is enabled
ElfSwitch.setup($pref::ElfSwitch::Enabled);
