// #autoload
// #name = SS Task Carrier
// #version = 1.0
// #date = July 9, 2003
// #author = Chris Lee
// #warrior = Silverspirit
// #email = uncle_crewcut@hotmail.com
// #web = http://scripts.tribalwar.com/silverspirit
// #description = Makes an escort player task for friendly flag carriers.
// #category = Silverspirit's Scripts
// #status = Release
// #include = support/player_support.cs

if (!isObject(ssTaskCarrier))
	new ScriptObject(ssTaskCarrier) {
		class = ssTaskCarrier;
	};

function ssTaskCarrier::Setup(%this) {
	if (%this.Setup)
		return;
	addMessageCallback('MsgCTFFlagTaken',ssTaskCarrierHandleFlagTaken);
	addMessageCallback('MsgCTFFlagDropped',ssTaskCarrierHandleFlag);
	addMessageCallback('MsgCTFFlagCapped',ssTaskCarrierHandleFlag);
	%this.Setup = true;
}

function ssTaskCarrierHandleFlagTaken(%msgType, %msgString, %clientName, %flagTeam, %flagTeamId, %clientNameBase) {
	%clientName = detag(%clientName);
	if (PlayerList.getTeamByName(%clientName) == ServerConnection.getSensorGroup()) {
		ServerConnection.sendTargetToServer(PlayerList.getTargetIDByName(%clientName));
		commandToServer('BuildClientTask','EscortPlayer',false);
		commandToServer('SendTaskToClientTarget',PlayerList.getTargetIDById(PlayerList.getMyID()));
		schedule(ServerConnection.getPing() * 4,0,clientAcceptCurrentTask);
	}
}

function ssTaskCarrierHandleFlag(%msgType, %msgString, %clientName, %flagTeam, %flagTeamId) {
	if (PlayerList.getTeamByName(detag(%clientName)) == ServerConnection.getSensorGroup())
		clientTaskCompleted();
}

package ssTaskCarrier {	
	function DispatchLaunchMode() {
		parent::DispatchLaunchMode();
		if (!isObject(autoload))
			ssTaskCarrier.Setup();
	}
};
activatePackage(ssTaskCarrier);
if (isObject(autoload))
	ssTaskCarrier.Setup();