// Start Settings
$speedBarWidth = 99;    // Width
$speedBarMax = 400;     // Max Value
// End Settings

package speedBar {
    function NetBarHud::infoUpdate(%this, %ping, %packetLoss, %sendPackets, %sendBytes, %receivePackets, %receiveBytes) {
        parent::infoUpdate(%this, %ping, %packetLoss, %sendPackets, %sendBytes, %receivePackets, %receiveBytes);
        %speed = getControlObjectSpeed() * 3.6;
        if (%speed > $speedBarMax)
            %speed = $speedBarMax;
        speedBarBitmap.setExtent(%speed * $speedBarWidth / $speedBarMax,"8");
    }
    
    function LoadingGui::onWake(%this) {
        parent::onWake(%this);
        if (!isObject(speedBarFrame))
            setupSpeedBar();
    }
};

function setupSpeedBar() {
    new GuiControl(speedBarFrame) {
        profile = "GuiDefaultProfile";
        horizSizing = "left";
        vertSizing = "bottom";
        position = "0 0";
        extent = $speedBarWidth SPC "8";
        minExtent = "8 8";
        visible = "1";
        opacity = "1.0";

        new HudBitmapCtrl(speedBarBitmap) {
            profile = "GuiButtonProfile";
            horizSizing = "left";
            vertSizing = "bottom";
            position = "0 0";
            extent = "0 8";
            minExtent = "0 8";
            visible = "1";
            frameColor = "0 0 0 0";
            opacity = "0.5";
            bitmap = "speedBar.png";
        };
    };
    playgui.add(speedBarFrame);
    if (isObject(HM) && isObject(HudMover))
        hudmover::addhud(speedBarFrame, "Speed Bar");
}

activatePackage(speedBar);
