// Start Settings
$speedBarLargeHeight = 300;          // Height
$speedBarLargeWidth = 20;            // Width
$speedBarLargeMax = 400;             // Max Value
$speedBarLargeIncrement = 25;        // Increment
$speedBarTextColor = "0 0 255";    // Number Color (red green blue [alpha otional]) (decimal 0-255)
$speedBarLineColor = "0 0 0";        // Line Color (reg green blue [alpha optional]) (decimal 0-255)
// End Settings

$speedBarLargeMaxReal = $speedBarLargeMax + $speedBarLargeIncrement;
$speedBarLargeLineText = "";
$speedBarLargeOn = true;

package speedBarLarge {
    function NetBarHud::infoUpdate(%this, %ping, %packetLoss, %sendPackets, %sendBytes, %receivePackets, %receiveBytes) {
        parent::infoUpdate(%this, %ping, %packetLoss, %sendPackets, %sendBytes, %receivePackets, %receiveBytes);
        %speed = getControlObjectspeed() * 3.6;
        if (%speed > $speedBarLargeMax)
            %speed = $speedBarLargeMax;
        speedBarLargeBitmap.setPosition("25",$speedBarLargeHeight - (%speed * $speedBarLargeHeight / $speedBarLargeMaxReal) - 6);
        speedBarLargeBitmap.setExtent($speedBarLargeWidth,%speed * $speedBarLargeHeight / $speedBarLargeMaxReal);
    }
    
    function LoadingGui::onWake(%this) {
        parent::onWake(%this);
        if (!isObject(speedBarLargeFrame))
            setupSpeedBarLarge();
    }
    
    function clientCmdVehicleMount() {
        parent::clientCmdVehicleMount();
        passengerKeys.copyBind(moveMap, speedBarLargeToggle);
    }

    function clientCmdSetWeaponryVehicleKeys() {
        parent::clientCmdSetWeaponryVehicleKeys();
        passengerKeys.copyBind(moveMap, speedBarLargeToggle);
	}
};

function speedBarLargeToggle(%val) {
    if (%val) {
        $speedBarLargeOn = !$speedBarLargeOn;
        if ($speedBarLargeOn)
            addMessageHudLine("\c3Speed Bar: \c0On");
        else
            addMessageHudLine("\c3Speed Bar: \c0Off");
        speedBarLargeFrame.setVisible($speedBarLargeOn);
    }
}

function speedBarLargeReload() {
    exec("scripts/autoexec/speedBarLarge.cs");
    speedBarLargeFrame.delete();
    makeSpeedBarLarge();
    hudmover::sethuds();
}

function makeSpeedBarLarge() {
    new GuiControlProfile("speedBarLargeText") {
        fontType = "Univers Condensed";
        fontSize = 16;
        fontColor = $speedBarTextColor;
        justify = "right";
    };
    
    new GuiControlProfile("speedBarLargeLine") {
        fontType = "Univers Condensed";
        fontSize = 16;
        fontColor = $speedBarLineColor;
        justify = "left";
    };

    new GuiControl(speedBarLargeFrame) {
        profile = "GuiChatBackProfile";
        horizSizing = "left";
        vertSizing = "top";
        position = "0 0";
        extent = 25 + $speedBarLargeWidth SPC $speedBarLargeHeight;
        minExtent = "8 8";
        visible = "1";
        opacity = "1.0";

        new HudBitmapCtrl(speedBarLargeBitmap) {
            profile = "GuiButtonProfile";
            horizSizing = "left";
            vertSizing = "top";
            position = "25" SPC $speedBarLargeHeight;
            extent = $speedBarLargeWidth SPC "0";
            minExtent = "50 0";
            visible = "1";
            frameColor = "0 0 0 0";
            opacity = "0.5";
            bitmap = "speedBar.png";
        };
    };

    for (%i = 0; %i <= $speedBarLargeWidth; %i += 6)
        $speedBarLargeLineText = $speedBarLargeLineText @ "_";

    for (%i = 0; %i <= $speedBarLargeMaxReal; %i += $speedBarLargeIncrement) {
        $speedBarLargeLine[%i] = new GuiTextCtrl() {
            profile = "speedBarLargeLine";
            horizSizing = "right";
            vertSizing = "top";
            position = "25" SPC $speedBarLargeHeight - 22 - (%i / $speedBarLargeMaxReal * $speedBarLargeHeight);
            extent = $speedBarLargeWidth SPC "16";
            visible = "1";
            text = $speedBarLargeLineText;
        };

        $speedBarLargeText[%i] = new GuiTextCtrl() {
            profile = "speedBarLargeText";
            horizSizing = "right";
            vertSizing = "top";
            position = "0" SPC $speedBarLargeHeight - 16 - (%i / $speedBarLargeMaxReal * $speedBarLargeHeight);
            extent = "23 16";
            visible = "1";
            text = %i;
        };

        speedBarLargeFrame.add($speedBarLargeLine[%i]);
        speedBarLargeFrame.add($speedBarLargeText[%i]);
    }
    playgui.add(speedBarLargeFrame);
}

function setupSpeedBarLarge() {
    makeSpeedBarLarge();
    if (isObject(HM) && isObject(HudMover))
        hudmover::addhud(speedBarLargeFrame, "Speed Bar Large");
        
    $RemapName[$RemapCount]="\c5Speed Bar";
    $RemapCmd[$RemapCount]="speedBarLargeToggle";
    $RemapCount++;
}
activatePackage(speedBarLarge);
